/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.inmemory;

import java.io.IOException;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.inmemory.InMemoryFileIO;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestInMemoryFileIO {
    String location = "s3://foo/bar.txt";

    @Test
    public void testBasicEndToEnd() throws IOException {
        InMemoryFileIO fileIO = new InMemoryFileIO();
        Assertions.assertThat((boolean)fileIO.fileExists(this.location)).isFalse();
        PositionOutputStream outputStream = fileIO.newOutputFile(this.location).create();
        byte[] data = "hello world".getBytes();
        outputStream.write(data);
        outputStream.close();
        Assertions.assertThat((boolean)fileIO.fileExists(this.location)).isTrue();
        SeekableInputStream inputStream = fileIO.newInputFile(this.location).newStream();
        byte[] buf = new byte[data.length];
        inputStream.read(buf);
        inputStream.close();
        Assertions.assertThat((String)new String(buf)).isEqualTo("hello world");
        fileIO.deleteFile(this.location);
        Assertions.assertThat((boolean)fileIO.fileExists(this.location)).isFalse();
    }

    @Test
    public void testNewInputFileNotFound() {
        InMemoryFileIO fileIO = new InMemoryFileIO();
        Assertions.assertThatExceptionOfType(NotFoundException.class).isThrownBy(() -> fileIO.newInputFile("s3://nonexistent/file"));
    }

    @Test
    public void testDeleteFileNotFound() {
        InMemoryFileIO fileIO = new InMemoryFileIO();
        Assertions.assertThatExceptionOfType(NotFoundException.class).isThrownBy(() -> fileIO.deleteFile("s3://nonexistent/file"));
    }

    @Test
    public void testCreateNoOverwrite() {
        InMemoryFileIO fileIO = new InMemoryFileIO();
        fileIO.addFile(this.location, "hello world".getBytes());
        Assertions.assertThatExceptionOfType(AlreadyExistsException.class).isThrownBy(() -> fileIO.newOutputFile(this.location).create());
    }

    @Test
    public void testOverwriteBeforeAndAfterClose() throws IOException {
        byte[] oldData = "old data".getBytes();
        byte[] newData = "new data".getBytes();
        InMemoryFileIO fileIO = new InMemoryFileIO();
        PositionOutputStream outputStream = fileIO.newOutputFile(this.location).create();
        outputStream.write(oldData);
        Assertions.assertThat((boolean)fileIO.fileExists(this.location)).isFalse();
        outputStream.close();
        Assertions.assertThat((boolean)fileIO.fileExists(this.location)).isTrue();
        outputStream = fileIO.newOutputFile(this.location).createOrOverwrite();
        outputStream.write(newData);
        SeekableInputStream inputStream = fileIO.newInputFile(this.location).newStream();
        byte[] buf = new byte[oldData.length];
        inputStream.read(buf);
        inputStream.close();
        Assertions.assertThat((String)new String(buf)).isEqualTo("old data");
        outputStream.close();
        inputStream = fileIO.newInputFile(this.location).newStream();
        buf = new byte[newData.length];
        inputStream.read(buf);
        inputStream.close();
        Assertions.assertThat((String)new String(buf)).isEqualTo("new data");
    }
}

