/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.hadoop.HadoopTableTestBase;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestTableSerialization
extends HadoopTableTestBase {
    @Test
    public void testSerializableTable() throws IOException, ClassNotFoundException {
        ((ReplaceSortOrder)this.table.replaceSortOrder().asc("id")).commit();
        this.table.updateProperties().set("k1", "v1").set("k2", "v2").commit();
        this.table.updateSchema().addColumn("new_col", (Type)Types.IntegerType.get()).commit();
        TestHelpers.assertSerializedAndLoadedMetadata((Table)this.table, (Table)((Table)TestHelpers.roundTripSerialize((Object)this.table)));
        Table serializableTable = SerializableTable.copyOf((Table)this.table);
        TestHelpers.assertSerializedAndLoadedMetadata((Table)serializableTable, (Table)((Table)TestHelpers.KryoHelpers.roundTripSerialize((Object)serializableTable)));
    }

    @Test
    public void testSerializableTableWithSnapshot() throws IOException, ClassNotFoundException {
        this.table.newAppend().appendFile(FILE_A).commit();
        TestHelpers.assertSerializedAndLoadedMetadata((Table)this.table, (Table)((Table)TestHelpers.roundTripSerialize((Object)this.table)));
        Table serializableTable = SerializableTable.copyOf((Table)this.table);
        TestHelpers.assertSerializedAndLoadedMetadata((Table)serializableTable, (Table)((Table)TestHelpers.KryoHelpers.roundTripSerialize((Object)serializableTable)));
    }

    @Test
    public void testSerializableTxnTable() throws IOException, ClassNotFoundException {
        ((ReplaceSortOrder)this.table.replaceSortOrder().asc("id")).commit();
        this.table.updateProperties().set("k1", "v1").set("k2", "v2").commit();
        this.table.updateSchema().addColumn("new_col", (Type)Types.IntegerType.get()).commit();
        Transaction txn = this.table.newTransaction();
        txn.updateProperties().set("k3", "v3").commit();
        TestHelpers.assertSerializedMetadata((Table)txn.table(), (Table)((Table)TestHelpers.roundTripSerialize((Object)txn.table())));
    }

    @Test
    public void testSerializableMetadataTable() throws IOException, ClassNotFoundException {
        for (MetadataTableType type : MetadataTableType.values()) {
            Table metadataTable = TestTableSerialization.getMetaDataTable(this.table, type);
            TestHelpers.assertSerializedAndLoadedMetadata((Table)metadataTable, (Table)((Table)TestHelpers.roundTripSerialize((Object)metadataTable)));
            Table serializableTable = SerializableTable.copyOf((Table)metadataTable);
            TestHelpers.assertSerializedAndLoadedMetadata((Table)serializableTable, (Table)((Table)TestHelpers.KryoHelpers.roundTripSerialize((Object)serializableTable)));
        }
    }

    @Test
    public void testSerializableTablePlanning() throws IOException {
        this.table.newAppend().appendFile(FILE_A).commit();
        byte[] serialized = TestTableSerialization.serializeToBytes(this.table);
        Set<CharSequence> expected = TestTableSerialization.getFiles(this.table);
        this.table.newAppend().appendFile(FILE_B).commit();
        Table deserialized = (Table)TestTableSerialization.deserializeFromBytes(serialized);
        Set<CharSequence> deserializedFiles = TestTableSerialization.getFiles(deserialized);
        Assert.assertEquals(expected, deserializedFiles);
        Assert.assertNotEquals(TestTableSerialization.getFiles(this.table), deserializedFiles);
    }

    @Test
    public void testSerializableMetadataTablesPlanning() throws IOException {
        this.table.updateProperties().set("format-version", "2").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        HashMap serialized = Maps.newHashMap();
        HashMap expected = Maps.newHashMap();
        for (MetadataTableType type : MetadataTableType.values()) {
            Table metaTable = TestTableSerialization.getMetaDataTable(this.table, type);
            serialized.put(type, TestTableSerialization.serializeToBytes(metaTable));
            expected.put(type, TestTableSerialization.getFiles(metaTable));
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newRowDelta().addDeletes(FILE_B_DELETES).commit();
        for (MetadataTableType type : MetadataTableType.values()) {
            Set<CharSequence> deserializedFiles = TestTableSerialization.getFiles((Table)TestTableSerialization.deserializeFromBytes((byte[])serialized.get(type)));
            Assert.assertEquals(expected.get(type), deserializedFiles);
            Set<CharSequence> newFiles = TestTableSerialization.getFiles(TestTableSerialization.getMetaDataTable(this.table, type));
            Assert.assertNotEquals(newFiles, deserializedFiles);
        }
    }

    private static Table getMetaDataTable(Table table, MetadataTableType type) {
        return TABLES.load(((HasTableOperations)table).operations().current().metadataFileLocation() + "#" + type);
    }

    private static Set<CharSequence> getFiles(Table table) throws IOException {
        HashSet files = Sets.newHashSet();
        if (table instanceof PositionDeletesTable || table instanceof SerializableTable.SerializableMetadataTable && ((SerializableTable.SerializableMetadataTable)table).type().equals((Object)MetadataTableType.POSITION_DELETES)) {
            try (CloseableIterable tasks = table.newBatchScan().planFiles();){
                for (ScanTask task : tasks) {
                    files.add(((DeleteFile)((PositionDeletesScanTask)task).file()).path());
                }
            }
        }
        try (CloseableIterable tasks = table.newScan().planFiles();){
            for (FileScanTask task : tasks) {
                files.add(((DataFile)task.file()).path());
            }
        }
        return files;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] serializeToBytes(Object obj) {
        try {
            Throwable throwable = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                Throwable throwable2 = null;
                try {
                    oos.writeObject(obj);
                    byArray = baos.toByteArray();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            TestTableSerialization.$closeResource(throwable2, oos);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                TestTableSerialization.$closeResource(throwable2, oos);
                return byArray;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to serialize object", e);
        }
    }

    /*
     * Exception decompiling
     */
    private static <T> T deserializeFromBytes(byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

