/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTableTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Test;

public class TestStaticTable
extends HadoopTableTestBase {
    private Table getStaticTable() {
        return TABLES.load(((HasTableOperations)this.table).operations().current().metadataFileLocation());
    }

    private Table getStaticTable(MetadataTableType type) {
        return TABLES.load(((HasTableOperations)this.table).operations().current().metadataFileLocation() + "#" + type);
    }

    @Test
    public void testLoadFromMetadata() {
        Table staticTable = this.getStaticTable();
        Assert.assertTrue((String)"Loading a metadata file based table should return StaticTableOperations", (boolean)(((HasTableOperations)staticTable).operations() instanceof StaticTableOperations));
    }

    @Test
    public void testCannotBeAddedTo() {
        Table staticTable = this.getStaticTable();
        AssertHelpers.assertThrows((String)"Cannot modify a static table", UnsupportedOperationException.class, () -> staticTable.newOverwrite().addFile(FILE_A).commit());
    }

    @Test
    public void testCannotBeDeletedFrom() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Table staticTable = this.getStaticTable();
        AssertHelpers.assertThrows((String)"Cannot modify a static table", UnsupportedOperationException.class, () -> staticTable.newDelete().deleteFile(FILE_A).commit());
    }

    @Test
    public void testCannotDoIncrementalScanOnMetadataTable() {
        this.table.newAppend().appendFile(FILE_A).commit();
        for (MetadataTableType type : MetadataTableType.values()) {
            Table staticTable = this.getStaticTable(type);
            if (type.equals((Object)MetadataTableType.POSITION_DELETES)) {
                AssertHelpers.assertThrows((String)"POSITION_DELETES table does not support TableScan", UnsupportedOperationException.class, (String)"Cannot create TableScan from table of type POSITION_DELETES", () -> ((Table)staticTable).newScan());
                continue;
            }
            AssertHelpers.assertThrows((String)"Static tables do not support incremental scans", UnsupportedOperationException.class, (String)String.format("Cannot incrementally scan table of type %s", type), () -> staticTable.newScan().appendsAfter(1L));
        }
    }

    @Test
    public void testHasSameProperties() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newOverwrite().deleteFile(FILE_B).addFile(FILE_C).commit();
        Table staticTable = this.getStaticTable();
        Assert.assertTrue((String)"Same history?", (boolean)this.table.history().containsAll(staticTable.history()));
        Assert.assertTrue((String)"Same snapshot?", (this.table.currentSnapshot().snapshotId() == staticTable.currentSnapshot().snapshotId() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Same properties?", (boolean)Maps.difference((Map)this.table.properties(), (Map)staticTable.properties()).areEqual());
    }

    @Test
    public void testImmutable() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Table staticTable = this.getStaticTable();
        long originalSnapshot = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newOverwrite().deleteFile(FILE_B).addFile(FILE_C).commit();
        staticTable.refresh();
        Assert.assertEquals((String)"Snapshot unchanged after table modified", (long)staticTable.currentSnapshot().snapshotId(), (long)originalSnapshot);
    }

    @Test
    public void testMetadataTables() {
        for (MetadataTableType type : MetadataTableType.values()) {
            String enumName = type.name().replace("_", "").toLowerCase();
            Assert.assertTrue((String)("Should be able to get MetadataTable of type : " + type), (boolean)this.getStaticTable(type).getClass().getName().toLowerCase().contains(enumName));
        }
    }
}

