/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestHadoopTables {
    private static final HadoopTables TABLES = new HadoopTables();
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File tableDir = null;

    @Before
    public void setupTableLocation() throws Exception {
        this.tableDir = this.temp.newFolder();
    }

    @Test
    public void testTableExists() {
        Assert.assertFalse((boolean)TABLES.exists(this.tableDir.toURI().toString()));
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
        TABLES.create(SCHEMA, spec, this.tableDir.toURI().toString());
        Assert.assertTrue((boolean)TABLES.exists(this.tableDir.toURI().toString()));
    }

    @Test
    public void testDropTable() {
        TABLES.create(SCHEMA, this.tableDir.toURI().toString());
        TABLES.dropTable(this.tableDir.toURI().toString());
        AssertHelpers.assertThrows((String)"Should complain about missing table", NoSuchTableException.class, (String)"Table does not exist", () -> TABLES.load(this.tableDir.toURI().toString()));
    }

    @Test
    public void testDropTableWithPurge() throws IOException {
        File dataDir = this.temp.newFolder();
        TestHadoopTables.createDummyTable(this.tableDir, dataDir);
        TABLES.dropTable(this.tableDir.toURI().toString(), true);
        AssertHelpers.assertThrows((String)"Should complain about missing table", NoSuchTableException.class, (String)"Table does not exist", () -> TABLES.load(this.tableDir.toURI().toString()));
        Assert.assertEquals((long)0L, (long)dataDir.listFiles().length);
        Assert.assertFalse((boolean)this.tableDir.exists());
        Assert.assertFalse((boolean)TABLES.dropTable(this.tableDir.toURI().toString()));
    }

    @Test
    public void testDropTableWithoutPurge() throws IOException {
        File dataDir = this.temp.newFolder();
        TestHadoopTables.createDummyTable(this.tableDir, dataDir);
        TABLES.dropTable(this.tableDir.toURI().toString(), false);
        AssertHelpers.assertThrows((String)"Should complain about missing table", NoSuchTableException.class, (String)"Table does not exist", () -> TABLES.load(this.tableDir.toURI().toString()));
        Assert.assertEquals((long)1L, (long)dataDir.listFiles().length);
        Assert.assertFalse((boolean)this.tableDir.exists());
        Assert.assertFalse((boolean)TABLES.dropTable(this.tableDir.toURI().toString()));
    }

    @Test
    public void testDefaultSortOrder() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
        Table table = TABLES.create(SCHEMA, spec, this.tableDir.toURI().toString());
        SortOrder sortOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)0L, (long)sortOrder.orderId());
        Assert.assertTrue((String)"Order must unsorted", (boolean)sortOrder.isUnsorted());
    }

    @Test
    public void testCustomSortOrder() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id", NullOrder.NULLS_FIRST)).build();
        Table table = TABLES.create(SCHEMA, spec, order, (Map)Maps.newHashMap(), this.tableDir.toURI().toString());
        SortOrder sortOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)1L, (long)sortOrder.orderId());
        Assert.assertEquals((String)"Order must have 1 field", (long)1L, (long)sortOrder.fields().size());
        Assert.assertEquals((String)"Direction must match ", (Object)SortDirection.ASC, (Object)((SortField)sortOrder.fields().get(0)).direction());
        Assert.assertEquals((String)"Null order must match ", (Object)NullOrder.NULLS_FIRST, (Object)((SortField)sortOrder.fields().get(0)).nullOrder());
        Transform transform = Transforms.identity();
        Assert.assertEquals((String)"Transform must match", (Object)transform, (Object)((SortField)sortOrder.fields().get(0)).transform());
    }

    @Test
    public void testTableName() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
        String location = this.tableDir.toURI().toString();
        TABLES.create(SCHEMA, spec, location);
        Table table = TABLES.load(location);
        Assert.assertEquals((String)"Name must match", (Object)location, (Object)table.name());
        Table snapshotsTable = TABLES.load(location + "#snapshots");
        Assert.assertEquals((String)"Name must match", (Object)(location + "#snapshots"), (Object)snapshotsTable.name());
    }

    private static void createDummyTable(File tableDir, File dataDir) throws IOException {
        Table table = TABLES.create(SCHEMA, tableDir.toURI().toString());
        AppendFiles append = table.newAppend();
        String data = dataDir.getPath() + "/data.parquet";
        Files.write(Paths.get(data, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(data).withFileSizeInBytes(10L).withRecordCount(1L).build();
        append.appendFile(dataFile);
        append.commit();
        Assert.assertEquals((long)1L, (long)dataDir.listFiles().length);
        Assert.assertEquals((long)1L, (long)tableDir.listFiles().length);
    }
}

