/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.hadoop.HadoopTableTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHadoopCommits
extends HadoopTableTestBase {
    @Test
    public void testCreateTable() throws Exception {
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).bucket("data", 16).build();
        Assert.assertEquals((String)"Table schema should match schema with reassigned ids", (Object)TABLE_SCHEMA.asStruct(), (Object)this.table.schema().asStruct());
        Assert.assertEquals((String)"Table partition spec should match with reassigned ids", (Object)expectedSpec, (Object)this.table.spec());
        ArrayList tasks = Lists.newArrayList((Iterable)this.table.newScan().planFiles());
        Assert.assertEquals((String)"Should not create any scan tasks", (long)0L, (long)tasks.size());
        Assert.assertTrue((String)"Table location should exist", (boolean)this.tableDir.exists());
        Assert.assertTrue((String)"Should create metadata folder", (this.metadataDir.exists() && this.metadataDir.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        Assert.assertTrue((String)"Should create version hint file", (boolean)this.versionHintFile.exists());
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)1L, (long)this.readVersionHint());
        List<File> manifests = this.listManifestFiles();
        Assert.assertEquals((String)"Should contain 0 Avro manifest files", (long)0L, (long)manifests.size());
    }

    @Test
    public void testSchemaUpdate() throws Exception {
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        this.table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        Assert.assertTrue((String)"Should create v2 for the update", (this.version(2).exists() && this.version(2).isFile() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)2L, (long)this.readVersionHint());
        Assert.assertEquals((String)"Table schema should match schema with reassigned ids", (Object)UPDATED_SCHEMA.asStruct(), (Object)this.table.schema().asStruct());
        ArrayList tasks = Lists.newArrayList((Iterable)this.table.newScan().planFiles());
        Assert.assertEquals((String)"Should not create any scan tasks", (long)0L, (long)tasks.size());
        List<File> manifests = this.listManifestFiles();
        Assert.assertEquals((String)"Should contain 0 Avro manifest files", (long)0L, (long)manifests.size());
    }

    @Test
    public void testSchemaUpdateComplexType() throws Exception {
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        Types.StructType complexColumn = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"w", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"x", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)3, (String)"z", (Type)Types.MapType.ofOptional((int)0, (int)1, (Type)Types.IntegerType.get(), (Type)Types.StringType.get()))});
        Schema updatedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"complex", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"w", (Type)Types.IntegerType.get()), Types.NestedField.required((int)5, (String)"x", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"y", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)7, (String)"z", (Type)Types.MapType.ofOptional((int)8, (int)9, (Type)Types.IntegerType.get(), (Type)Types.StringType.get()))}))});
        this.table.updateSchema().addColumn("complex", (Type)complexColumn).commit();
        Assert.assertTrue((String)"Should create v2 for the update", (this.version(2).exists() && this.version(2).isFile() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)2L, (long)this.readVersionHint());
        Assert.assertEquals((String)"Table schema should match schema with reassigned ids", (Object)updatedSchema.asStruct(), (Object)this.table.schema().asStruct());
        ArrayList tasks = Lists.newArrayList((Iterable)this.table.newScan().planFiles());
        Assert.assertEquals((String)"Should not create any scan tasks", (long)0L, (long)tasks.size());
        List<File> manifests = this.listManifestFiles();
        Assert.assertEquals((String)"Should contain 0 Avro manifest files", (long)0L, (long)manifests.size());
    }

    @Test
    public void testSchemaUpdateIdentifierFields() throws Exception {
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        Schema updatedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        this.table.updateSchema().setIdentifierFields(new String[]{"id"}).commit();
        Assert.assertTrue((String)"Should create v2 for the update", (this.version(2).exists() && this.version(2).isFile() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)2L, (long)this.readVersionHint());
        Assert.assertEquals((String)"Table schema should match schema with reassigned ids", (Object)updatedSchema.asStruct(), (Object)this.table.schema().asStruct());
        Assert.assertEquals((String)"Identifier fields should match schema with reassigned ids", (Object)updatedSchema.identifierFieldIds(), (Object)this.table.schema().identifierFieldIds());
    }

    @Test
    public void testFailedCommit() throws Exception {
        UpdateSchema update = this.table.updateSchema().addColumn("n", (Type)Types.IntegerType.get());
        update.apply();
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        this.version(2).createNewFile();
        AssertHelpers.assertThrows((String)"Should fail to commit change based on v1 when v2 exists", CommitFailedException.class, (String)"Version 2 already exists", () -> ((UpdateSchema)update).commit());
        List<File> manifests = this.listManifestFiles();
        Assert.assertEquals((String)"Should contain 0 Avro manifest files", (long)0L, (long)manifests.size());
    }

    @Test
    public void testStaleMetadata() throws Exception {
        Table tableCopy = TABLES.load(this.tableLocation);
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        UpdateSchema updateCopy = tableCopy.updateSchema().addColumn("m", (Type)Types.IntegerType.get());
        updateCopy.apply();
        this.table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        Assert.assertTrue((String)"Should create v2 for the update", (this.version(2).exists() && this.version(2).isFile() ? 1 : 0) != 0);
        Assert.assertNotEquals((String)"Unmodified copy should be out of date after update", (Object)this.table.schema().asStruct(), (Object)tableCopy.schema().asStruct());
        tableCopy.refresh();
        Assert.assertEquals((String)"Copy should be back in sync", (Object)this.table.schema().asStruct(), (Object)tableCopy.schema().asStruct());
        AssertHelpers.assertThrows((String)"Should fail with stale base metadata", CommitFailedException.class, (String)"based on stale table metadata", () -> ((UpdateSchema)updateCopy).commit());
        List<File> manifests = this.listManifestFiles();
        Assert.assertEquals((String)"Should contain 0 Avro manifest files", (long)0L, (long)manifests.size());
    }

    @Test
    public void testStaleVersionHint() throws Exception {
        Table stale = TABLES.load(this.tableLocation);
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        this.table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        Assert.assertTrue((String)"Should create v2 for the update", (this.version(2).exists() && this.version(2).isFile() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)2L, (long)this.readVersionHint());
        Assert.assertNotEquals((String)"Stable table schema should not match", (Object)UPDATED_SCHEMA.asStruct(), (Object)stale.schema().asStruct());
        this.replaceVersionHint(1);
        Table reloaded = TABLES.load(this.tableLocation);
        Assert.assertEquals((String)"Updated schema for newly loaded table should match", (Object)UPDATED_SCHEMA.asStruct(), (Object)reloaded.schema().asStruct());
        stale.refresh();
        Assert.assertEquals((String)"Refreshed schema for stale table should match", (Object)UPDATED_SCHEMA.asStruct(), (Object)reloaded.schema().asStruct());
    }

    @Test
    public void testFastAppend() throws Exception {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertTrue((String)"Should create v2 for the update", (this.version(2).exists() && this.version(2).isFile() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)2L, (long)this.readVersionHint());
        ArrayList tasks = Lists.newArrayList((Iterable)this.table.newScan().planFiles());
        Assert.assertEquals((String)"Should scan 1 file", (long)1L, (long)tasks.size());
        List<File> manifests = this.listManifestFiles();
        Assert.assertEquals((String)"Should contain only one Avro manifest file", (long)1L, (long)manifests.size());
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Assert.assertTrue((String)"Should create v3 for the update", (this.version(3).exists() && this.version(3).isFile() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)3L, (long)this.readVersionHint());
        tasks = Lists.newArrayList((Iterable)this.table.newScan().planFiles());
        Assert.assertEquals((String)"Should scan 2 files", (long)2L, (long)tasks.size());
        Assert.assertEquals((String)"Should contain 2 Avro manifest files", (long)2L, (long)this.listManifestFiles().size());
        TableMetadata metadata = this.readMetadataVersion(3);
        Assert.assertEquals((String)"Current snapshot should contain 2 manifests", (long)2L, (long)metadata.currentSnapshot().allManifests(this.table.io()).size());
    }

    @Test
    public void testMergeAppend() throws Exception {
        this.testFastAppend();
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        ArrayList tasks = Lists.newArrayList((Iterable)this.table.newScan().planFiles());
        Assert.assertEquals((String)"Should scan 3 files", (long)3L, (long)tasks.size());
        Assert.assertEquals((String)"Should contain 3 Avro manifest files", (long)3L, (long)this.listManifestFiles().size());
        TableMetadata metadata = this.readMetadataVersion(5);
        Assert.assertEquals((String)"Current snapshot should contain 1 merged manifest", (long)1L, (long)metadata.currentSnapshot().allManifests(this.table.io()).size());
    }

    @Test
    public void testRenameReturnFalse() throws Exception {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.exists((Path)Mockito.any())).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockFs.rename((Path)Mockito.any(), (Path)Mockito.any())).thenReturn((Object)false);
        this.testRenameWithFileSystem(mockFs);
    }

    @Test
    public void testRenameThrow() throws Exception {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.exists((Path)Mockito.any())).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockFs.rename((Path)Mockito.any(), (Path)Mockito.any())).thenThrow(new Throwable[]{new IOException("test injected")});
        this.testRenameWithFileSystem(mockFs);
    }

    private void testRenameWithFileSystem(FileSystem mockFs) throws Exception {
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Should not create v2 or newer versions", (boolean)this.version(2).exists());
        Assert.assertTrue((boolean)(this.table instanceof BaseTable));
        BaseTable baseTable = (BaseTable)this.table;
        TableMetadata meta1 = baseTable.operations().current();
        this.table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        Assert.assertTrue((String)"Should create v2 for the update", (this.version(2).exists() && this.version(2).isFile() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should write the current version to the hint file", (long)2L, (long)this.readVersionHint());
        TableOperations tops = baseTable.operations();
        Assert.assertTrue((boolean)(tops instanceof HadoopTableOperations));
        HadoopTableOperations spyOps = (HadoopTableOperations)Mockito.spy((Object)((HadoopTableOperations)tops));
        ((HadoopTableOperations)Mockito.doReturn((Object)mockFs).when((Object)spyOps)).getFileSystem((Path)Mockito.any(), (Configuration)Mockito.any());
        Assertions.assertThatThrownBy(() -> spyOps.commit(tops.current(), meta1)).isInstanceOf(CommitFailedException.class);
        Set actual = this.listMetadataJsonFiles().stream().map(File::getName).collect(Collectors.toSet());
        HashSet expected = Sets.newHashSet((Object[])new String[]{"v1.metadata.json", "v2.metadata.json"});
        Assert.assertEquals((String)"only v1 and v2 metadata.json should exist.", (Object)expected, actual);
    }

    @Test
    public void testCanReadOldCompressedManifestFiles() throws Exception {
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        this.table.newAppend().appendFile(FILE_A).commit();
        this.rewriteMetadataAsGzipWithOldExtension();
        List<File> metadataFiles = this.listMetadataJsonFiles();
        Assert.assertEquals((String)"Should have two versions", (long)2L, (long)metadataFiles.size());
        Assert.assertTrue((String)"Metadata should be compressed with old format.", (boolean)metadataFiles.stream().allMatch(f -> f.getName().endsWith(".metadata.json.gz")));
        Table reloaded = TABLES.load(this.tableLocation);
        ArrayList tasks = Lists.newArrayList((Iterable)reloaded.newScan().planFiles());
        Assert.assertEquals((String)"Should scan 1 files", (long)1L, (long)tasks.size());
    }

    @Test
    public void testConcurrentFastAppends() throws Exception {
        Assert.assertTrue((String)"Should create v1 metadata", (this.version(1).exists() && this.version(1).isFile() ? 1 : 0) != 0);
        File dir = this.temp.newFolder();
        dir.delete();
        int threadsCount = 5;
        int numberOfCommitedFilesPerThread = 10;
        Table tableWithHighRetries = TABLES.create(SCHEMA, SPEC, (Map)ImmutableMap.of((Object)"commit.retry.num-retries", (Object)String.valueOf(threadsCount)), dir.toURI().toString());
        String fileName = UUID.randomUUID().toString();
        DataFile file = DataFiles.builder((PartitionSpec)tableWithHighRetries.spec()).withPath(FileFormat.PARQUET.addExtension(fileName)).withRecordCount(2L).withFileSizeInBytes(0L).build();
        ExecutorService executorService = Executors.newFixedThreadPool(threadsCount);
        AtomicInteger barrier = new AtomicInteger(0);
        Tasks.range((int)threadsCount).stopOnFailure().throwFailureWhenFinished().executeWith(executorService).run(index -> {
            for (int numCommittedFiles = 0; numCommittedFiles < numberOfCommitedFilesPerThread; ++numCommittedFiles) {
                while (barrier.get() < numCommittedFiles * threadsCount) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                tableWithHighRetries.newFastAppend().appendFile(file).commit();
                barrier.incrementAndGet();
            }
        });
        tableWithHighRetries.refresh();
        Assert.assertEquals((long)(threadsCount * numberOfCommitedFilesPerThread), (long)Lists.newArrayList((Iterable)tableWithHighRetries.snapshots()).size());
    }
}

