/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.hadoop.HadoopTableTestBase;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestHadoopCatalog
extends HadoopTableTestBase {
    private static ImmutableMap<String, String> meta = ImmutableMap.of();

    @Test
    public void testCreateTableBuilder() throws Exception {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        Table table = this.hadoopCatalog().buildTable(tableIdent, SCHEMA).withPartitionSpec(SPEC).withProperties(null).withProperty("key1", "value1").withProperties((Map)ImmutableMap.of((Object)"key2", (Object)"value2")).create();
        Assert.assertEquals((Object)TABLE_SCHEMA.toString(), (Object)table.schema().toString());
        Assert.assertEquals((long)1L, (long)table.spec().fields().size());
        Assert.assertEquals((Object)"value1", table.properties().get("key1"));
        Assert.assertEquals((Object)"value2", table.properties().get("key2"));
    }

    @Test
    public void testCreateTableTxnBuilder() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        Transaction txn = catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(null).createTransaction();
        txn.commitTransaction();
        Table table = catalog.loadTable(tableIdent);
        Assert.assertEquals((Object)TABLE_SCHEMA.toString(), (Object)table.schema().toString());
        Assert.assertTrue((boolean)table.spec().isUnpartitioned());
    }

    @Test
    public void testReplaceTxnBuilder() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        Transaction createTxn = catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(SPEC).withProperty("key1", "value1").createOrReplaceTransaction();
        createTxn.newAppend().appendFile(FILE_A).commit();
        createTxn.commitTransaction();
        Table table = catalog.loadTable(tableIdent);
        Assert.assertNotNull((Object)table.currentSnapshot());
        Transaction replaceTxn = catalog.buildTable(tableIdent, SCHEMA).withProperty("key2", "value2").replaceTransaction();
        replaceTxn.commitTransaction();
        table = catalog.loadTable(tableIdent);
        Assert.assertNull((Object)table.currentSnapshot());
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("data", "data_bucket").withSpecId(1).build();
        Assert.assertEquals((String)"Table should have a spec with one void field", (Object)v1Expected, (Object)table.spec());
        Assert.assertEquals((Object)"value1", table.properties().get("key1"));
        Assert.assertEquals((Object)"value2", table.properties().get("key2"));
    }

    @Test
    public void testTableBuilderWithLocation() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        AssertHelpers.assertThrows((String)"Should reject a custom location", IllegalArgumentException.class, (String)"Cannot set a custom location for a path-based table", () -> catalog.buildTable(tableIdent, SCHEMA).withLocation("custom").create());
        AssertHelpers.assertThrows((String)"Should reject a custom location", IllegalArgumentException.class, (String)"Cannot set a custom location for a path-based table", () -> catalog.buildTable(tableIdent, SCHEMA).withLocation("custom").createTransaction());
        AssertHelpers.assertThrows((String)"Should reject a custom location", IllegalArgumentException.class, (String)"Cannot set a custom location for a path-based table", () -> catalog.buildTable(tableIdent, SCHEMA).withLocation("custom").createOrReplaceTransaction());
    }

    @Test
    public void testCreateTableDefaultSortOrder() throws Exception {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        Table table = this.hadoopCatalog().createTable(tableIdent, SCHEMA, SPEC);
        SortOrder sortOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)0L, (long)sortOrder.orderId());
        Assert.assertTrue((String)"Order must unsorted", (boolean)sortOrder.isUnsorted());
    }

    @Test
    public void testCreateTableCustomSortOrder() throws Exception {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id", NullOrder.NULLS_FIRST)).build();
        Table table = this.hadoopCatalog().buildTable(tableIdent, SCHEMA).withPartitionSpec(SPEC).withSortOrder(order).create();
        SortOrder sortOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)1L, (long)sortOrder.orderId());
        Assert.assertEquals((String)"Order must have 1 field", (long)1L, (long)sortOrder.fields().size());
        Assert.assertEquals((String)"Direction must match ", (Object)SortDirection.ASC, (Object)((SortField)sortOrder.fields().get(0)).direction());
        Assert.assertEquals((String)"Null order must match ", (Object)NullOrder.NULLS_FIRST, (Object)((SortField)sortOrder.fields().get(0)).nullOrder());
        Transform transform = Transforms.identity();
        Assert.assertEquals((String)"Transform must match", (Object)transform, (Object)((SortField)sortOrder.fields().get(0)).transform());
    }

    @Test
    public void testBasicCatalog() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        String metaLocation = catalog.defaultWarehouseLocation(testTable);
        FileSystem fs = Util.getFs((Path)new Path(metaLocation), (Configuration)catalog.getConf());
        Assert.assertTrue((boolean)fs.isDirectory(new Path(metaLocation)));
        catalog.dropTable(testTable);
        Assert.assertFalse((boolean)fs.isDirectory(new Path(metaLocation)));
    }

    @Test
    public void testCreateAndDropTableWithoutNamespace() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"tbl"});
        Table table = catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertEquals((Object)table.schema().toString(), (Object)TABLE_SCHEMA.toString());
        Assert.assertEquals((Object)"hadoop.tbl", (Object)table.name());
        String metaLocation = catalog.defaultWarehouseLocation(testTable);
        FileSystem fs = Util.getFs((Path)new Path(metaLocation), (Configuration)catalog.getConf());
        Assert.assertTrue((boolean)fs.isDirectory(new Path(metaLocation)));
        catalog.dropTable(testTable);
        Assert.assertFalse((boolean)fs.isDirectory(new Path(metaLocation)));
    }

    @Test
    public void testDropTable() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        String metaLocation = catalog.defaultWarehouseLocation(testTable);
        FileSystem fs = Util.getFs((Path)new Path(metaLocation), (Configuration)catalog.getConf());
        Assert.assertTrue((boolean)fs.isDirectory(new Path(metaLocation)));
        catalog.dropTable(testTable);
        Assert.assertFalse((boolean)fs.isDirectory(new Path(metaLocation)));
    }

    @Test
    public void testDropNonIcebergTable() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        String metaLocation = catalog.defaultWarehouseLocation(testTable);
        Assert.assertFalse((boolean)catalog.dropTable(testTable));
        FileSystem fs = Util.getFs((Path)new Path(metaLocation), (Configuration)catalog.getConf());
        fs.mkdirs(new Path(metaLocation));
        Assert.assertTrue((boolean)fs.isDirectory(new Path(metaLocation)));
        Assert.assertFalse((boolean)catalog.dropTable(testTable));
        Assert.assertTrue((boolean)fs.isDirectory(new Path(metaLocation)));
    }

    @Test
    public void testRenameTable() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "tbl1"});
        catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        AssertHelpers.assertThrows((String)"should throw exception", UnsupportedOperationException.class, (String)"Cannot rename Hadoop tables", () -> catalog.renameTable(testTable, TableIdentifier.of((String[])new String[]{"db", "tbl2"})));
    }

    @Test
    public void testListTables() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "tbl1"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns1", "tbl3"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "metadata", "metadata"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        List tbls1 = catalog.listTables(Namespace.of((String[])new String[]{"db"}));
        HashSet tblSet = Sets.newHashSet(tbls1.stream().map(t -> t.name()).iterator());
        Assert.assertEquals((long)2L, (long)tblSet.size());
        Assert.assertTrue((boolean)tblSet.contains("tbl1"));
        Assert.assertTrue((boolean)tblSet.contains("tbl2"));
        List tbls2 = catalog.listTables(Namespace.of((String[])new String[]{"db", "ns1"}));
        Assert.assertEquals((String)"table identifiers", (long)1L, (long)tbls2.size());
        Assert.assertEquals((String)"table name", (Object)"tbl3", (Object)((TableIdentifier)tbls2.get(0)).name());
        AssertHelpers.assertThrows((String)"should throw exception", NoSuchNamespaceException.class, (String)"Namespace does not exist: ", () -> catalog.listTables(Namespace.of((String[])new String[]{"db", "ns1", "ns2"})));
    }

    @Test
    public void testCallingLocationProviderWhenNoCurrentMetadata() throws IOException {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"ns1", "ns2", "table1"});
        Transaction create = catalog.newCreateTableTransaction(tableIdent, SCHEMA);
        create.table().locationProvider();
        create.commitTransaction();
        Assert.assertEquals((String)"1 table expected", (long)1L, (long)catalog.listTables(Namespace.of((String[])new String[]{"ns1", "ns2"})).size());
        catalog.dropTable(tableIdent, true);
    }

    @Test
    public void testCreateNamespace() throws Exception {
        String warehouseLocation = this.temp.newFolder().getAbsolutePath();
        HadoopCatalog catalog = new HadoopCatalog();
        catalog.setConf(new Configuration());
        catalog.initialize("hadoop", (Map)ImmutableMap.of((Object)"warehouse", (Object)warehouseLocation));
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "metadata"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns2", "ns3", "tbl2"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2}).forEach(t -> catalog.createNamespace(t.namespace(), meta));
        String metaLocation1 = warehouseLocation + "/db/ns1/ns2";
        FileSystem fs1 = Util.getFs((Path)new Path(metaLocation1), (Configuration)catalog.getConf());
        Assert.assertTrue((boolean)fs1.isDirectory(new Path(metaLocation1)));
        String metaLocation2 = warehouseLocation + "/db/ns2/ns3";
        FileSystem fs2 = Util.getFs((Path)new Path(metaLocation2), (Configuration)catalog.getConf());
        Assert.assertTrue((boolean)fs2.isDirectory(new Path(metaLocation2)));
        AssertHelpers.assertThrows((String)("Should fail to create when namespace already exist: " + tbl1.namespace()), AlreadyExistsException.class, (String)("Namespace already exists: " + tbl1.namespace()), () -> catalog.createNamespace(tbl1.namespace()));
    }

    @Test
    public void testListNamespace() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "metadata"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns2", "ns3", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns3", "tbl4"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "metadata"});
        TableIdentifier tbl5 = TableIdentifier.of((String[])new String[]{"db2", "metadata"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4, tbl5}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        List nsp1 = catalog.listNamespaces(Namespace.of((String[])new String[]{"db"}));
        HashSet tblSet = Sets.newHashSet(nsp1.stream().map(t -> t.toString()).iterator());
        Assert.assertEquals((long)3L, (long)tblSet.size());
        Assert.assertTrue((boolean)tblSet.contains("db.ns1"));
        Assert.assertTrue((boolean)tblSet.contains("db.ns2"));
        Assert.assertTrue((boolean)tblSet.contains("db.ns3"));
        List nsp2 = catalog.listNamespaces(Namespace.of((String[])new String[]{"db", "ns1"}));
        Assert.assertEquals((long)1L, (long)nsp2.size());
        Assert.assertTrue((boolean)((Namespace)nsp2.get(0)).toString().equals("db.ns1.ns2"));
        List nsp3 = catalog.listNamespaces();
        HashSet tblSet2 = Sets.newHashSet(nsp3.stream().map(t -> t.toString()).iterator());
        Assert.assertEquals((long)2L, (long)tblSet2.size());
        Assert.assertTrue((boolean)tblSet2.contains("db"));
        Assert.assertTrue((boolean)tblSet2.contains("db2"));
        List nsp4 = catalog.listNamespaces();
        HashSet tblSet3 = Sets.newHashSet(nsp4.stream().map(t -> t.toString()).iterator());
        Assert.assertEquals((long)2L, (long)tblSet3.size());
        Assert.assertTrue((boolean)tblSet3.contains("db"));
        Assert.assertTrue((boolean)tblSet3.contains("db2"));
        AssertHelpers.assertThrows((String)"Should fail to list namespace doesn't exist", NoSuchNamespaceException.class, (String)"Namespace does not exist: ", () -> catalog.listNamespaces(Namespace.of((String[])new String[]{"db", "db2", "ns2"})));
    }

    @Test
    public void testLoadNamespaceMeta() throws IOException {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "metadata"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns2", "ns3", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns3", "tbl4"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "metadata"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        catalog.loadNamespaceMetadata(Namespace.of((String[])new String[]{"db"}));
        AssertHelpers.assertThrows((String)"Should fail to load namespace doesn't exist", NoSuchNamespaceException.class, (String)"Namespace does not exist: ", () -> catalog.loadNamespaceMetadata(Namespace.of((String[])new String[]{"db", "db2", "ns2"})));
    }

    @Test
    public void testNamespaceExists() throws IOException {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "metadata"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns2", "ns3", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns3", "tbl4"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "metadata"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        Assert.assertTrue((String)"Should true to namespace exist", (boolean)catalog.namespaceExists(Namespace.of((String[])new String[]{"db", "ns1", "ns2"})));
        Assert.assertTrue((String)"Should false to namespace doesn't exist", (!catalog.namespaceExists(Namespace.of((String[])new String[]{"db", "db2", "ns2"})) ? 1 : 0) != 0);
    }

    @Test
    public void testAlterNamespaceMeta() throws IOException {
        HadoopCatalog catalog = this.hadoopCatalog();
        AssertHelpers.assertThrows((String)"Should fail to change namespace", UnsupportedOperationException.class, (String)"Cannot set namespace properties db.db2.ns2 : setProperties is not supported", () -> catalog.setProperties(Namespace.of((String[])new String[]{"db", "db2", "ns2"}), (Map)ImmutableMap.of((Object)"property", (Object)"test")));
    }

    @Test
    public void testDropNamespace() throws IOException {
        String warehouseLocation = this.temp.newFolder().getAbsolutePath();
        HadoopCatalog catalog = new HadoopCatalog();
        catalog.setConf(new Configuration());
        catalog.initialize("hadoop", (Map)ImmutableMap.of((Object)"warehouse", (Object)warehouseLocation));
        Namespace namespace1 = Namespace.of((String[])new String[]{"db"});
        Namespace namespace2 = Namespace.of((String[])new String[]{"db", "ns1"});
        TableIdentifier tbl1 = TableIdentifier.of((Namespace)namespace1, (String)"tbl1");
        TableIdentifier tbl2 = TableIdentifier.of((Namespace)namespace2, (String)"tbl1");
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        AssertHelpers.assertThrows((String)("Should fail to drop namespace is not empty " + namespace1), NamespaceNotEmptyException.class, (String)("Namespace " + namespace1 + " is not empty."), () -> catalog.dropNamespace(Namespace.of((String[])new String[]{"db"})));
        Assert.assertFalse((String)"Should fail to drop namespace doesn't exist", (boolean)catalog.dropNamespace(Namespace.of((String[])new String[]{"db2"})));
        Assert.assertTrue((boolean)catalog.dropTable(tbl1));
        Assert.assertTrue((boolean)catalog.dropTable(tbl2));
        Assert.assertTrue((boolean)catalog.dropNamespace(namespace2));
        Assert.assertTrue((boolean)catalog.dropNamespace(namespace1));
        String metaLocation = warehouseLocation + "/db";
        FileSystem fs = Util.getFs((Path)new Path(metaLocation), (Configuration)catalog.getConf());
        Assert.assertFalse((boolean)fs.isDirectory(new Path(metaLocation)));
    }

    @Test
    public void testVersionHintFileErrorWithFile() throws Exception {
        TestHadoopCatalog.addVersionsToTable(this.table);
        HadoopTableOperations tableOperations = (HadoopTableOperations)TABLES.newTableOps(this.tableLocation);
        long secondSnapshotId = this.table.currentSnapshot().snapshotId();
        FileIO io = this.table.io();
        io.deleteFile(this.versionHintFile.getPath());
        try (PositionOutputStream stream = io.newOutputFile(this.versionHintFile.getPath()).create();){
            stream.write("1".getBytes(StandardCharsets.UTF_8));
        }
        Assert.assertEquals((long)1L, (long)tableOperations.findVersion());
        Assert.assertEquals((long)secondSnapshotId, (long)TABLES.load(this.tableLocation).currentSnapshot().snapshotId());
        io.deleteFile(this.versionHintFile.getPath());
        stream = io.newOutputFile(this.versionHintFile.getPath()).create();
        var6_5 = null;
        try {
            stream.write("3".getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                TestHadoopCatalog.$closeResource(var6_5, (AutoCloseable)stream);
            }
        }
        Assert.assertEquals((long)3L, (long)tableOperations.findVersion());
        Assert.assertEquals((long)secondSnapshotId, (long)TABLES.load(this.tableLocation).currentSnapshot().snapshotId());
        io.deleteFile(this.versionHintFile.getPath());
        io.newOutputFile(this.versionHintFile.getPath()).create().close();
        Assert.assertEquals((long)3L, (long)tableOperations.findVersion());
        Assert.assertEquals((long)secondSnapshotId, (long)TABLES.load(this.tableLocation).currentSnapshot().snapshotId());
        io.deleteFile(this.versionHintFile.getPath());
        Assert.assertEquals((long)3L, (long)tableOperations.findVersion());
        Assert.assertEquals((long)secondSnapshotId, (long)TABLES.load(this.tableLocation).currentSnapshot().snapshotId());
    }

    @Test
    public void testVersionHintFileMissingMetadata() throws Exception {
        TestHadoopCatalog.addVersionsToTable(this.table);
        HadoopTableOperations tableOperations = (HadoopTableOperations)TABLES.newTableOps(this.tableLocation);
        long secondSnapshotId = this.table.currentSnapshot().snapshotId();
        FileIO io = this.table.io();
        io.deleteFile(this.versionHintFile.getPath());
        io.deleteFile(tableOperations.getMetadataFile(1).toString());
        Assert.assertEquals((long)3L, (long)tableOperations.findVersion());
        Assert.assertEquals((long)secondSnapshotId, (long)TABLES.load(this.tableLocation).currentSnapshot().snapshotId());
        io.deleteFile(tableOperations.getMetadataFile(2).toString());
        io.deleteFile(tableOperations.getMetadataFile(3).toString());
        Assert.assertEquals((long)0L, (long)tableOperations.findVersion());
        AssertHelpers.assertThrows((String)"Should not be able to find the table", NoSuchTableException.class, (String)"Table does not exist", () -> TABLES.load(this.tableLocation));
    }

    @Test
    public void testTableName() throws Exception {
        HadoopCatalog catalog = this.hadoopCatalog();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(SPEC).create();
        Table table = catalog.loadTable(tableIdent);
        Assert.assertEquals((String)"Name must match", (Object)"hadoop.db.ns1.ns2.tbl", (Object)table.name());
        TableIdentifier snapshotsTableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl", "snapshots"});
        Table snapshotsTable = catalog.loadTable(snapshotsTableIdent);
        Assert.assertEquals((String)"Name must match", (Object)"hadoop.db.ns1.ns2.tbl.snapshots", (Object)snapshotsTable.name());
    }

    private static void addVersionsToTable(Table table) {
        DataFile dataFile1 = DataFiles.builder((PartitionSpec)SPEC).withPath("/a.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
        DataFile dataFile2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/b.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
        table.newAppend().appendFile(dataFile1).commit();
        table.newAppend().appendFile(dataFile2).commit();
    }

    @Test
    public void testTablePropsDefinedAtCatalogLevel() throws IOException {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        ImmutableMap catalogProps = ImmutableMap.of((Object)"table-default.key1", (Object)"catalog-default-key1", (Object)"table-default.key2", (Object)"catalog-default-key2", (Object)"table-default.key3", (Object)"catalog-default-key3", (Object)"table-override.key3", (Object)"catalog-override-key3", (Object)"table-override.key4", (Object)"catalog-override-key4");
        Table table = this.hadoopCatalog((Map<String, String>)catalogProps).buildTable(tableIdent, SCHEMA).withPartitionSpec(SPEC).withProperties(null).withProperty("key2", "table-key2").withProperty("key3", "table-key3").withProperty("key5", "table-key5").create();
        Assert.assertEquals((String)"Table defaults set for the catalog must be added to the table properties.", (Object)"catalog-default-key1", table.properties().get("key1"));
        Assert.assertEquals((String)"Table property must override table default properties set at catalog level.", (Object)"table-key2", table.properties().get("key2"));
        Assert.assertEquals((String)"Table property override set at catalog level must override table default properties set at catalog level and table property specified.", (Object)"catalog-override-key3", table.properties().get("key3"));
        Assert.assertEquals((String)"Table override not in table props or defaults should be added to table properties", (Object)"catalog-override-key4", table.properties().get("key4"));
        Assert.assertEquals((String)"Table properties without any catalog level default or override should be added to table properties.", (Object)"table-key5", table.properties().get("key5"));
    }

    @Test
    public void testRegisterTable() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"a", "t1"});
        TableIdentifier identifier2 = TableIdentifier.of((String[])new String[]{"a", "t2"});
        HadoopCatalog catalog = this.hadoopCatalog();
        catalog.createTable(identifier, SCHEMA);
        Table registeringTable = catalog.loadTable(identifier);
        TableOperations ops = ((HasTableOperations)registeringTable).operations();
        String metadataLocation = ((HadoopTableOperations)ops).current().metadataFileLocation();
        Assertions.assertThat((Object)catalog.registerTable(identifier2, metadataLocation)).isNotNull();
        Assertions.assertThat((Object)catalog.loadTable(identifier2)).isNotNull();
        Assertions.assertThat((boolean)catalog.dropTable(identifier)).isTrue();
        Assertions.assertThat((boolean)catalog.dropTable(identifier2)).isTrue();
    }

    @Test
    public void testRegisterExistingTable() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"a", "t1"});
        HadoopCatalog catalog = this.hadoopCatalog();
        catalog.createTable(identifier, SCHEMA);
        Table registeringTable = catalog.loadTable(identifier);
        TableOperations ops = ((HasTableOperations)registeringTable).operations();
        String metadataLocation = ((HadoopTableOperations)ops).current().metadataFileLocation();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.registerTable(identifier, metadataLocation)).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: a.t1");
        Assertions.assertThat((boolean)catalog.dropTable(identifier)).isTrue();
    }
}

