/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.hadoop.HadoopTableTestBase;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCatalogUtilDropTable
extends HadoopTableTestBase {
    @Test
    public void dropTableDataDeletesExpectedFiles() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        TableMetadata tableMetadata = this.readMetadataVersion(3);
        HashSet snapshotSet = Sets.newHashSet((Iterable)this.table.snapshots());
        Set<String> manifestListLocations = this.manifestListLocations(snapshotSet);
        Set<String> manifestLocations = this.manifestLocations(snapshotSet, this.table.io());
        Set<String> dataLocations = this.dataLocations(snapshotSet, this.table.io());
        Set<String> metadataLocations = this.metadataLocations(tableMetadata);
        Assert.assertEquals((String)"should have 2 manifest lists", (long)2L, (long)manifestListLocations.size());
        Assert.assertEquals((String)"should have 3 metadata locations", (long)3L, (long)metadataLocations.size());
        FileIO fileIO = (FileIO)Mockito.mock(FileIO.class);
        Mockito.when((Object)fileIO.newInputFile(Mockito.anyString())).thenAnswer(invocation -> this.table.io().newInputFile((String)invocation.getArgument(0)));
        Mockito.when((Object)fileIO.newInputFile(Mockito.anyString(), Mockito.anyLong())).thenAnswer(invocation -> this.table.io().newInputFile((String)invocation.getArgument(0), ((Long)invocation.getArgument(1)).longValue()));
        CatalogUtil.dropTableData((FileIO)fileIO, (TableMetadata)tableMetadata);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        ((FileIO)Mockito.verify((Object)fileIO, (VerificationMode)Mockito.times((int)(manifestListLocations.size() + manifestLocations.size() + dataLocations.size() + metadataLocations.size())))).deleteFile((String)argumentCaptor.capture());
        List deletedPaths = argumentCaptor.getAllValues();
        Assert.assertTrue((String)"should contain all created manifest lists", (boolean)deletedPaths.containsAll(manifestListLocations));
        Assert.assertTrue((String)"should contain all created manifests", (boolean)deletedPaths.containsAll(manifestLocations));
        Assert.assertTrue((String)"should contain all created data", (boolean)deletedPaths.containsAll(dataLocations));
        Assert.assertTrue((String)"should contain all created metadata locations", (boolean)deletedPaths.containsAll(metadataLocations));
    }

    @Test
    public void dropTableDataDoNotThrowWhenDeletesFail() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        TableMetadata tableMetadata = this.readMetadataVersion(3);
        HashSet snapshotSet = Sets.newHashSet((Iterable)this.table.snapshots());
        FileIO fileIO = (FileIO)Mockito.mock(FileIO.class);
        Mockito.when((Object)fileIO.newInputFile(Mockito.anyString())).thenAnswer(invocation -> this.table.io().newInputFile((String)invocation.getArgument(0)));
        Mockito.when((Object)fileIO.newInputFile(Mockito.anyString(), Mockito.anyLong())).thenAnswer(invocation -> this.table.io().newInputFile((String)invocation.getArgument(0), ((Long)invocation.getArgument(1)).longValue()));
        ((FileIO)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)fileIO)).deleteFile(ArgumentMatchers.anyString());
        CatalogUtil.dropTableData((FileIO)fileIO, (TableMetadata)tableMetadata);
        ((FileIO)Mockito.verify((Object)fileIO, (VerificationMode)Mockito.times((int)(this.manifestListLocations(snapshotSet).size() + this.manifestLocations(snapshotSet, fileIO).size() + this.dataLocations(snapshotSet, this.table.io()).size() + this.metadataLocations(tableMetadata).size())))).deleteFile(ArgumentMatchers.anyString());
    }

    @Test
    public void shouldNotDropDataFilesIfGcNotEnabled() {
        this.table.updateProperties().set("gc.enabled", "false").commit();
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        TableMetadata tableMetadata = this.readMetadataVersion(4);
        HashSet snapshotSet = Sets.newHashSet((Iterable)this.table.snapshots());
        Set<String> manifestListLocations = this.manifestListLocations(snapshotSet);
        Set<String> manifestLocations = this.manifestLocations(snapshotSet, this.table.io());
        Set<String> metadataLocations = this.metadataLocations(tableMetadata);
        Assert.assertEquals((String)"should have 2 manifest lists", (long)2L, (long)manifestListLocations.size());
        Assert.assertEquals((String)"should have 4 metadata locations", (long)4L, (long)metadataLocations.size());
        FileIO fileIO = (FileIO)Mockito.mock(FileIO.class);
        Mockito.when((Object)fileIO.newInputFile(Mockito.anyString())).thenAnswer(invocation -> this.table.io().newInputFile((String)invocation.getArgument(0)));
        CatalogUtil.dropTableData((FileIO)fileIO, (TableMetadata)tableMetadata);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        ((FileIO)Mockito.verify((Object)fileIO, (VerificationMode)Mockito.times((int)(manifestListLocations.size() + manifestLocations.size() + metadataLocations.size())))).deleteFile((String)argumentCaptor.capture());
        List deletedPaths = argumentCaptor.getAllValues();
        Assert.assertTrue((String)"should contain all created manifest lists", (boolean)deletedPaths.containsAll(manifestListLocations));
        Assert.assertTrue((String)"should contain all created manifests", (boolean)deletedPaths.containsAll(manifestLocations));
        Assert.assertTrue((String)"should contain all created metadata locations", (boolean)deletedPaths.containsAll(metadataLocations));
    }

    private Set<String> manifestListLocations(Set<Snapshot> snapshotSet) {
        return snapshotSet.stream().map(Snapshot::manifestListLocation).collect(Collectors.toSet());
    }

    private Set<String> manifestLocations(Set<Snapshot> snapshotSet, FileIO io) {
        return snapshotSet.stream().flatMap(snapshot -> snapshot.allManifests(io).stream()).map(ManifestFile::path).collect(Collectors.toSet());
    }

    private Set<String> dataLocations(Set<Snapshot> snapshotSet, FileIO io) {
        return snapshotSet.stream().flatMap(snapshot -> StreamSupport.stream(snapshot.addedDataFiles(io).spliterator(), false)).map(dataFile -> dataFile.path().toString()).collect(Collectors.toSet());
    }

    private Set<String> metadataLocations(TableMetadata tableMetadata) {
        Set<String> metadataLocations = tableMetadata.previousFiles().stream().map(TableMetadata.MetadataLogEntry::file).collect(Collectors.toSet());
        metadataLocations.add(tableMetadata.metadataFileLocation());
        return metadataLocations;
    }
}

