/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class HadoopTableTestBase {
    static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    static final Schema TABLE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    static final Schema UPDATED_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"n", (Type)Types.IntegerType.get())});
    static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    static final HadoopTables TABLES = new HadoopTables(new Configuration());
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=0").withRecordCount(2L).build();
    static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=1").withRecordCount(2L).build();
    static final DeleteFile FILE_B_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-b-deletes.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=1").withRecordCount(1L).build();
    static final DataFile FILE_C = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=2").withRecordCount(2L).build();
    static final DataFile FILE_D = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=3").withRecordCount(2L).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    File tableDir = null;
    String tableLocation = null;
    File metadataDir = null;
    File versionHintFile = null;
    Table table = null;

    @Before
    public void setupTable() throws Exception {
        this.tableDir = this.temp.newFolder();
        this.tableDir.delete();
        this.tableLocation = this.tableDir.toURI().toString();
        this.metadataDir = new File(this.tableDir, "metadata");
        this.versionHintFile = new File(this.metadataDir, "version-hint.text");
        this.table = TABLES.create(SCHEMA, SPEC, this.tableLocation);
    }

    List<File> listManifestFiles() {
        return Lists.newArrayList((Object[])this.metadataDir.listFiles((dir, name) -> !name.startsWith("snap") && org.apache.iceberg.relocated.com.google.common.io.Files.getFileExtension((String)name).equalsIgnoreCase("avro")));
    }

    List<File> listMetadataJsonFiles() {
        return Lists.newArrayList((Object[])this.metadataDir.listFiles((dir, name) -> name.endsWith(".metadata.json") || name.endsWith(".metadata.json.gz")));
    }

    File version(int versionNumber) {
        return new File(this.metadataDir, "v" + versionNumber + TableMetadataParser.getFileExtension((TableMetadataParser.Codec)TableMetadataParser.Codec.NONE));
    }

    TableMetadata readMetadataVersion(int version) {
        return TableMetadataParser.read((FileIO)new TestTables.TestTableOperations("table", this.tableDir).io(), (InputFile)Files.localInput((File)this.version(version)));
    }

    int readVersionHint() throws IOException {
        return Integer.parseInt(org.apache.iceberg.relocated.com.google.common.io.Files.readFirstLine((File)this.versionHintFile, (Charset)StandardCharsets.UTF_8));
    }

    void replaceVersionHint(int version) throws IOException {
        new File(this.metadataDir, ".version-hint.text.crc").delete();
        org.apache.iceberg.relocated.com.google.common.io.Files.write((CharSequence)String.valueOf(version), (File)this.versionHintFile, (Charset)StandardCharsets.UTF_8);
    }

    void rewriteMetadataAsGzipWithOldExtension() throws IOException {
        List<File> metadataJsonFiles = this.listMetadataJsonFiles();
        for (File file : metadataJsonFiles) {
            try (FileInputStream input = new FileInputStream(file);
                 GZIPOutputStream gzOutput = new GZIPOutputStream(new FileOutputStream(file.getAbsolutePath() + ".gz"));){
                int bb;
                while ((bb = input.read()) != -1) {
                    gzOutput.write(bb);
                }
            }
            file.delete();
        }
    }

    protected HadoopCatalog hadoopCatalog() throws IOException {
        return this.hadoopCatalog(Collections.emptyMap());
    }

    protected HadoopCatalog hadoopCatalog(Map<String, String> catalogProperties) throws IOException {
        HadoopCatalog hadoopCatalog = new HadoopCatalog();
        hadoopCatalog.setConf(new Configuration());
        hadoopCatalog.initialize("hadoop", (Map)ImmutableMap.builder().putAll(catalogProperties).put((Object)"warehouse", (Object)this.temp.newFolder().getAbsolutePath()).buildOrThrow());
        return hadoopCatalog;
    }
}

