/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class HadoopFileIOTest {
    private final Random random = new Random(1L);
    private FileSystem fs;
    private HadoopFileIO hadoopFileIO;
    @TempDir
    private File tempDir;

    @BeforeEach
    public void before() throws Exception {
        Configuration conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)conf);
        this.hadoopFileIO = new HadoopFileIO(conf);
    }

    @Test
    public void testListPrefix() {
        Path parent = new Path(this.tempDir.toURI());
        ArrayList scaleSizes = Lists.newArrayList((Object[])new Integer[]{1, 1000, 2500});
        scaleSizes.parallelStream().forEach(scale -> {
            Path scalePath = new Path(parent, Integer.toString(scale));
            this.createRandomFiles(scalePath, (int)scale);
            Assertions.assertEquals((long)scale.intValue(), (long)Streams.stream((Iterable)this.hadoopFileIO.listPrefix(scalePath.toUri().toString())).count());
        });
        long totalFiles = scaleSizes.stream().mapToLong(Integer::longValue).sum();
        Assertions.assertEquals((long)totalFiles, (long)Streams.stream((Iterable)this.hadoopFileIO.listPrefix(parent.toUri().toString())).count());
    }

    @Test
    public void testFileExists() throws IOException {
        Path parent = new Path(this.tempDir.toURI());
        Path randomFilePath = new Path(parent, "random-file-" + UUID.randomUUID().toString());
        this.fs.createNewFile(randomFilePath);
        Assert.assertTrue((boolean)this.hadoopFileIO.newInputFile(randomFilePath.toUri().toString()).exists());
        this.fs.delete(randomFilePath, false);
        Assert.assertFalse((boolean)this.hadoopFileIO.newInputFile(randomFilePath.toUri().toString()).exists());
    }

    @Test
    public void testDeletePrefix() {
        Path parent = new Path(this.tempDir.toURI());
        ArrayList scaleSizes = Lists.newArrayList((Object[])new Integer[]{1, 1000, 2500});
        scaleSizes.parallelStream().forEach(scale -> {
            Path scalePath = new Path(parent, Integer.toString(scale));
            this.createRandomFiles(scalePath, (int)scale);
            this.hadoopFileIO.deletePrefix(scalePath.toUri().toString());
            Assertions.assertThrows(UncheckedIOException.class, () -> this.hadoopFileIO.listPrefix(scalePath.toUri().toString()).iterator());
        });
        this.hadoopFileIO.deletePrefix(parent.toUri().toString());
        Assertions.assertThrows(UncheckedIOException.class, () -> this.hadoopFileIO.listPrefix(parent.toUri().toString()).iterator());
    }

    @Test
    public void testDeleteFiles() {
        Path parent = new Path(this.tempDir.toURI());
        List<Path> filesCreated = this.createRandomFiles(parent, 10);
        this.hadoopFileIO.deleteFiles((Iterable)filesCreated.stream().map(Path::toString).collect(Collectors.toList()));
        filesCreated.forEach(file -> Assert.assertFalse((boolean)this.hadoopFileIO.newInputFile(file.toString()).exists()));
    }

    @Test
    public void testDeleteFilesErrorHandling() {
        List filesCreated = this.random.ints(2L).mapToObj(x -> "fakefsnotreal://file-" + x).collect(Collectors.toList());
        Assert.assertThrows((String)"Should throw a BulkDeletionFailure Exceptions when files can't be deleted", BulkDeletionFailureException.class, () -> this.hadoopFileIO.deleteFiles((Iterable)filesCreated));
    }

    @Test
    public void testHadoopFileIOKryoSerialization() throws IOException {
        HadoopFileIO testHadoopFileIO = new HadoopFileIO();
        testHadoopFileIO.initialize((Map)ImmutableMap.of((Object)"k1", (Object)"v1"));
        FileIO roundTripSerializedFileIO = (FileIO)TestHelpers.KryoHelpers.roundTripSerialize((Object)testHadoopFileIO);
        Assert.assertEquals((Object)testHadoopFileIO.properties(), (Object)roundTripSerializedFileIO.properties());
    }

    @Test
    public void testHadoopFileIOJavaSerialization() throws IOException, ClassNotFoundException {
        HadoopFileIO testHadoopFileIO = new HadoopFileIO();
        testHadoopFileIO.initialize((Map)ImmutableMap.of((Object)"k1", (Object)"v1"));
        FileIO roundTripSerializedFileIO = (FileIO)TestHelpers.roundTripSerialize((Object)testHadoopFileIO);
        Assert.assertEquals((Object)testHadoopFileIO.properties(), (Object)roundTripSerializedFileIO.properties());
    }

    private List<Path> createRandomFiles(Path parent, int count) {
        Vector<Path> paths = new Vector<Path>();
        this.random.ints(count).parallel().forEach(i -> {
            try {
                Path path = new Path(parent, "file-" + i);
                paths.add(path);
                this.fs.createNewFile(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return paths;
    }
}

