/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionParser;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestExpressionParser {
    private static final Types.StructType SUPPORTED_PRIMITIVES = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.required((int)111, (String)"uuid", (Type)Types.UUIDType.get()), Types.NestedField.required((int)112, (String)"fixed", (Type)Types.FixedType.ofLength((int)7)), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10)), Types.NestedField.required((int)117, (String)"time", (Type)Types.TimeType.get())});
    private static final Schema SCHEMA = new Schema(SUPPORTED_PRIMITIVES.fields());

    @Test
    public void testSimpleExpressions() {
        Expression[] expressions;
        for (Expression expr : expressions = new Expression[]{Expressions.alwaysFalse(), Expressions.alwaysTrue(), Expressions.equal((String)"id", (Object)100), Expressions.equal((String)"data", (Object)"abcd"), Expressions.equal((String)"b", (Object)false), Expressions.equal((String)"i", (Object)34), Expressions.equal((String)"l", (Object)34L), Expressions.equal((String)"f", (Object)Float.valueOf(100.0f)), Expressions.equal((String)"d", (Object)100.0), Expressions.equal((String)"date", (Object)"2022-08-14"), Expressions.equal((String)"ts", (Object)"2022-08-14T10:00:00.123456"), Expressions.equal((String)"uuid", (Object)UUID.randomUUID()), Expressions.equal((String)"fixed", (Object)new byte[]{1, 2, 3, 4, 5, 6, 7}), Expressions.equal((String)"bytes", (Object)ByteBuffer.wrap(new byte[]{1, 3, 5})), Expressions.equal((String)"dec_11_2", (Object)new BigDecimal("34.56")), Expressions.equal((String)"time", (Object)"23:59:59.654321"), Expressions.lessThan((String)"id", (Object)100), Expressions.lessThanOrEqual((String)"id", (Object)100), Expressions.greaterThan((String)"id", (Object)100), Expressions.greaterThanOrEqual((String)"id", (Object)100), Expressions.isNull((String)"data"), Expressions.notNull((String)"data"), Expressions.isNaN((String)"d"), Expressions.notNaN((String)"f"), Expressions.startsWith((String)"s", (String)"crackle"), Expressions.notStartsWith((String)"s", (String)"tackle"), Expressions.equal((UnboundTerm)Expressions.day((String)"date"), (Object)"2022-08-14"), Expressions.equal((UnboundTerm)Expressions.bucket((String)"id", (int)100), (Object)0), Expressions.and((Expression)Expressions.or((Expression)Expressions.equal((String)"data", (Object)UUID.randomUUID().toString()), (Expression)Expressions.isNull((String)"data")), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)66)), Expressions.or((Expression)Expressions.greaterThan((UnboundTerm)Expressions.day((String)"ts"), (Object)"2022-08-14"), (Expression)Expressions.equal((String)"date", (Object)"2022-08-14")), Expressions.not((Expression)Expressions.in((String)"l", (Object[])new Integer[]{1, 2, 3, 4}))}) {
            Expression bound = Binder.bind((Types.StructType)SUPPORTED_PRIMITIVES, (Expression)expr);
            String boundJson = ExpressionParser.toJson((Expression)bound, (boolean)true);
            String unboundJson = ExpressionParser.toJson((Expression)expr, (boolean)true);
            Assert.assertEquals((String)"Bound and unbound should produce identical json", (Object)boundJson, (Object)unboundJson);
            Expression parsed = ExpressionParser.fromJson((String)boundJson, (Schema)SCHEMA);
            Assert.assertTrue((String)"Round-trip value should be equivalent", (boolean)ExpressionUtil.equivalent((Expression)expr, (Expression)parsed, (Types.StructType)SUPPORTED_PRIMITIVES, (boolean)true));
        }
    }

    @Test
    public void nullExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid expression: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse expression from null object");
    }

    @Test
    public void trueExpression() {
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)Expressions.alwaysTrue(), (boolean)true)).isEqualTo("true");
        Assertions.assertThat((Object)ExpressionParser.fromJson((String)"true")).isEqualTo((Object)Expressions.alwaysTrue());
        String longJson = "{\n  \"type\" : \"literal\",\n  \"value\" : true\n}";
        Assertions.assertThat((Object)ExpressionParser.fromJson((String)longJson)).isEqualTo((Object)Expressions.alwaysTrue());
    }

    @Test
    public void falseExpression() {
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)Expressions.alwaysFalse(), (boolean)true)).isEqualTo("false");
        Assertions.assertThat((Object)ExpressionParser.fromJson((String)"false")).isEqualTo((Object)Expressions.alwaysFalse());
        String longJson = "{\n  \"type\" : \"literal\",\n  \"value\" : false\n}";
        Assertions.assertThat((Object)ExpressionParser.fromJson((String)longJson)).isEqualTo((Object)Expressions.alwaysFalse());
    }

    @Test
    public void eqExpression() {
        String expected = "{\n  \"type\" : \"eq\",\n  \"term\" : \"name\",\n  \"value\" : 25\n}";
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)Expressions.equal((String)"name", (Object)25), (boolean)true)).isEqualTo(expected);
        Expression expression = ExpressionParser.fromJson((String)expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testTransform() {
        String expected = "{\n  \"type\" : \"lt-eq\",\n  \"term\" : {\n    \"type\" : \"transform\",\n    \"transform\" : \"bucket[100]\",\n    \"term\" : \"id\"\n  },\n  \"value\" : 50\n}";
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)Expressions.lessThanOrEqual((UnboundTerm)Expressions.bucket((String)"id", (int)100), (Object)50), (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected, (Schema)SCHEMA), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void extraFields() {
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)"{\n  \"type\" : \"in\",\n  \"term\" : \"column-name\",\n  \"extra-one\" : \"x\",\n  \"extra-twp\" : \"y\",\n  \"values\" : [ 1, 2, 3 ]\n}"), (boolean)true)).isEqualTo("{\n  \"type\" : \"in\",\n  \"term\" : \"column-name\",\n  \"values\" : [ 1, 2, 3 ]\n}");
    }

    @Test
    public void invalidTerm() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"not\",\n  \"child\" : {\n    \"type\" : \"lt\",\n    \"term\" : 23,\n    \"values\" : [ \"a\" ]\n  }\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse reference (requires string or object): 23");
    }

    @Test
    public void invalidValues() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"not-nan\",\n  \"term\" : \"x\",\n  \"value\" : 34.0\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse NOT_NAN predicate: has invalid value field");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"is-nan\",\n  \"term\" : \"x\",\n  \"values\" : [ 34.0, 35.0 ]\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse IS_NAN predicate: has invalid values field");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"lt\",\n  \"term\" : \"x\",\n  \"values\" : [ 1 ]\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse LT predicate: missing value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"lt\",\n  \"term\" : \"x\",\n  \"value\" : 34,\n  \"values\" : [ 1 ]\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse LT predicate: has invalid values field");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"not-in\",\n  \"term\" : \"x\",\n  \"value\" : [ 1, 2 ]\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse NOT_IN predicate: missing values");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"in\",\n  \"term\" : \"x\",\n  \"value\" : \"min\",\n  \"values\" : [ 1, 2 ]\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse IN predicate: has invalid value field");
    }

    @Test
    public void invalidOperationType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"not\",\n  \"child\" : {\n    \"type\" : \"illegal\",\n    \"term\" : \"column-name\",\n    \"values\" : [ \"a\" ]\n  }\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid operation type: illegal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"ILLEGAL\",\n  \"child\" : {\n    \"type\" : \"lt\",\n    \"term\" : \"column-name\",\n    \"values\" : [ \"a\" ]\n  }\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid operation type: ILLEGAL");
    }

    @Test
    public void invalidAnd() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"and\"\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: left");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"and\",\n  \"left\": true}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: right");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExpressionParser.fromJson((String)"{\n  \"type\" : \"and\",\n  \"right\": true}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: left");
    }

    @Test
    public void testPredicate() {
        String expected = "{\n  \"type\" : \"lt-eq\",\n  \"term\" : \"column-name\",\n  \"value\" : 50\n}";
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)Expressions.lessThanOrEqual((String)"column-name", (Object)50), (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testPredicateWithObjectLiteral() {
        String expected = "{\n  \"type\" : \"lt-eq\",\n  \"term\" : \"column-name\",\n  \"value\" : 50\n}";
        String json = "{\n  \"type\" : \"lt-eq\",\n  \"term\" : \"column-name\",\n  \"value\" : {    \"type\" : \"literal\",\n    \"value\" : 50\n  }\n}";
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)json), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testPredicateWithObjectReference() {
        String expected = "{\n  \"type\" : \"lt-eq\",\n  \"term\" : \"column-name\",\n  \"value\" : 50\n}";
        String json = "{\n  \"type\" : \"lt-eq\",\n  \"term\" : {\n    \"type\" : \"reference\",\n    \"term\" : \"column-name\"\n  },\n  \"value\" : 50\n}";
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)json), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testAnd() {
        String expected = "{\n  \"type\" : \"and\",\n  \"left\" : {\n    \"type\" : \"gt-eq\",\n    \"term\" : \"column-name-1\",\n    \"value\" : 50\n  },\n  \"right\" : {\n    \"type\" : \"in\",\n    \"term\" : \"column-name-2\",\n    \"values\" : [ \"one\", \"two\" ]\n  }\n}";
        Expression expression = Expressions.and((Expression)Expressions.greaterThanOrEqual((String)"column-name-1", (Object)50), (Expression)Expressions.in((String)"column-name-2", (Object[])new String[]{"one", "two"}));
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testOr() {
        String expected = "{\n  \"type\" : \"or\",\n  \"left\" : {\n    \"type\" : \"lt\",\n    \"term\" : \"column-name-1\",\n    \"value\" : 50\n  },\n  \"right\" : {\n    \"type\" : \"not-null\",\n    \"term\" : \"column-name-2\"\n  }\n}";
        Expression expression = Expressions.or((Expression)Expressions.lessThan((String)"column-name-1", (Object)50), (Expression)Expressions.notNull((String)"column-name-2"));
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testNot() {
        String expected = "{\n  \"type\" : \"not\",\n  \"child\" : {\n    \"type\" : \"gt-eq\",\n    \"term\" : \"column-name-1\",\n    \"value\" : 50\n  }\n}";
        Expression expression = Expressions.not((Expression)Expressions.greaterThanOrEqual((String)"column-name-1", (Object)50));
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testNestedExpression() {
        String expected = "{\n  \"type\" : \"or\",\n  \"left\" : {\n    \"type\" : \"and\",\n    \"left\" : {\n      \"type\" : \"in\",\n      \"term\" : \"column-name-1\",\n      \"values\" : [ 50, 51, 52 ]\n    },\n    \"right\" : {\n      \"type\" : \"eq\",\n      \"term\" : \"column-name-2\",\n      \"value\" : \"test\"\n    }\n  },\n  \"right\" : {\n    \"type\" : \"is-nan\",\n    \"term\" : \"column-name-3\"\n  }\n}";
        Expression and = Expressions.and((Expression)Expressions.in((String)"column-name-1", (Object[])new Integer[]{50, 51, 52}), (Expression)Expressions.equal((String)"column-name-2", (Object)"test"));
        Expression expression = Expressions.or((Expression)and, (Expression)Expressions.isNaN((String)"column-name-3"));
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testFixedLiteral() {
        String expected = "{\n  \"type\" : \"eq\",\n  \"term\" : \"column-name\",\n  \"value\" : \"010203\"\n}";
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[]{1, 2, 3});
        UnboundPredicate expression = Expressions.equal((String)"column-name", (Object)byteBuffer);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testDecimalLiteral() {
        String expected = "{\n  \"type\" : \"in\",\n  \"term\" : \"column-name\",\n  \"values\" : [ \"3.14\" ]\n}";
        UnboundPredicate expression = Expressions.in((String)"column-name", (Object[])new BigDecimal[]{new BigDecimal("3.14")});
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }

    @Test
    public void testNegativeScaleDecimalLiteral() {
        String expected = "{\n  \"type\" : \"in\",\n  \"term\" : \"column-name\",\n  \"values\" : [ \"3.14E+4\" ]\n}";
        UnboundPredicate expression = Expressions.in((String)"column-name", (Object[])new BigDecimal[]{new BigDecimal("3.14E+4")});
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)expression, (boolean)true)).isEqualTo(expected);
        Assertions.assertThat((String)ExpressionParser.toJson((Expression)ExpressionParser.fromJson((String)expected), (boolean)true)).isEqualTo(expected);
    }
}

