/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.apache.iceberg.encryption.Ciphers;
import org.junit.Assert;
import org.junit.Test;

public class TestCiphers {
    @Test
    public void testBasicEncrypt() {
        this.testEncryptDecrypt(null);
    }

    @Test
    public void testAAD() {
        byte[] aad = "abcd".getBytes(StandardCharsets.UTF_8);
        this.testEncryptDecrypt(aad);
    }

    private void testEncryptDecrypt(byte[] aad) {
        int[] aesKeyLengthArray;
        SecureRandom random = new SecureRandom();
        for (int keyLength : aesKeyLengthArray = new int[]{16, 24, 32}) {
            byte[] key = new byte[keyLength];
            random.nextBytes(key);
            Ciphers.AesGcmEncryptor encryptor = new Ciphers.AesGcmEncryptor(key);
            byte[] plaintext = new byte[16];
            random.nextBytes(plaintext);
            byte[] ciphertext = encryptor.encrypt(plaintext, aad);
            Ciphers.AesGcmDecryptor decryptor = new Ciphers.AesGcmDecryptor(key);
            byte[] decryptedText = decryptor.decrypt(ciphertext, aad);
            Assert.assertArrayEquals((String)("Key length " + keyLength), (byte[])plaintext, (byte[])decryptedText);
        }
    }
}

