/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.encryption.Ciphers;
import org.apache.iceberg.encryption.KeyManagementClient;

public abstract class MemoryMockKMS
implements KeyManagementClient {
    protected Map<String, byte[]> masterKeys;

    public ByteBuffer wrapKey(ByteBuffer key, String wrappingKeyId) {
        byte[] wrappingKey = this.masterKeys.get(wrappingKeyId);
        if (null == wrappingKey) {
            throw new RuntimeException("Cannot wrap, because wrapping key " + wrappingKeyId + " is not found");
        }
        Ciphers.AesGcmEncryptor keyEncryptor = new Ciphers.AesGcmEncryptor(wrappingKey);
        byte[] encryptedKey = keyEncryptor.encrypt(key.array(), null);
        return ByteBuffer.wrap(encryptedKey);
    }

    public ByteBuffer unwrapKey(ByteBuffer wrappedKey, String wrappingKeyId) {
        byte[] wrappingKey = this.masterKeys.get(wrappingKeyId);
        if (null == wrappingKey) {
            throw new RuntimeException("Cannot unwrap, because wrapping key " + wrappingKeyId + " is not found");
        }
        Ciphers.AesGcmDecryptor keyDecryptor = new Ciphers.AesGcmDecryptor(wrappingKey);
        byte[] key = keyDecryptor.decrypt(wrappedKey.array(), null);
        return ByteBuffer.wrap(key);
    }
}

