/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.iceberg.encryption.MemoryMockKMS;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class KeyStoreKmsClient
extends MemoryMockKMS {
    public static final String KEYSTORE_FILE_PATH_PROP = "kms.client.keystore.path";
    public static final String KEYSTORE_PASSWORD_ENV_VAR = "KEYSTORE_PASSWORD";

    @Override
    public ByteBuffer wrapKey(ByteBuffer key, String wrappingKeyId) {
        return super.wrapKey(key, wrappingKeyId.toLowerCase());
    }

    @Override
    public ByteBuffer unwrapKey(ByteBuffer wrappedKey, String wrappingKeyId) {
        return super.unwrapKey(wrappedKey, wrappingKeyId.toLowerCase());
    }

    public void initialize(Map<String, String> properties) {
        Enumeration<String> keyAliases;
        FileInputStream fis;
        KeyStore keyStore;
        String keystorePath = properties.get(KEYSTORE_FILE_PATH_PROP);
        Preconditions.checkNotNull((Object)keystorePath, (Object)"kms.client.keystore.path must be set in hadoop or table properties");
        String keystorePassword = System.getenv(KEYSTORE_PASSWORD_ENV_VAR);
        Preconditions.checkNotNull((Object)keystorePassword, (Object)"KEYSTORE_PASSWORD environment variable must be set");
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failed to init keystore", e);
        }
        char[] pwdArray = keystorePassword.toCharArray();
        try {
            fis = new FileInputStream(keystorePath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to find keystore file " + keystorePath, e);
        }
        try {
            keyStore.load(fis, pwdArray);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Failed to load keystore file " + keystorePath, e);
        }
        try {
            keyAliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failed to get key aliases in keystore file " + keystorePath, e);
        }
        this.masterKeys = Maps.newHashMap();
        while (keyAliases.hasMoreElements()) {
            SecretKey secretKey;
            String keyAlias = keyAliases.nextElement();
            try {
                secretKey = (SecretKey)keyStore.getKey(keyAlias, pwdArray);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new RuntimeException("Failed to get key " + keyAlias, e);
            }
            this.masterKeys.put(keyAlias, secretKey.getEncoded());
        }
        if (this.masterKeys.isEmpty()) {
            throw new RuntimeException("No keys found in " + keystorePath);
        }
    }
}

