/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.deletes.Deletes;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class TestPositionFilter {
    @Test
    public void testPositionFileFilter() {
        ArrayList positionDeletes = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 0L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 3L}), TestHelpers.Row.of((Object[])new Object[]{new Utf8("file_a.avro"), 9L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 22L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 56L}), TestHelpers.Row.of((Object[])new Object[]{new Utf8("file_b.avro"), 16L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 19L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 63L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 70L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 91L})});
        Assert.assertEquals((String)"Should contain only file_a positions", (Object)Lists.newArrayList((Object[])new Long[]{0L, 3L, 9L, 22L, 56L}), (Object)Lists.newArrayList((Iterable)Deletes.deletePositions((CharSequence)"file_a.avro", (CloseableIterable)CloseableIterable.withNoopClose((Iterable)positionDeletes))));
        Assert.assertEquals((String)"Should contain only file_b positions", (Object)Lists.newArrayList((Object[])new Long[]{16L, 19L, 63L, 70L, 91L}), (Object)Lists.newArrayList((Iterable)Deletes.deletePositions((CharSequence)"file_b.avro", (CloseableIterable)CloseableIterable.withNoopClose((Iterable)positionDeletes))));
        Assert.assertEquals((String)"Should contain no positions for file_c", (Object)Lists.newArrayList(), (Object)Lists.newArrayList((Iterable)Deletes.deletePositions((CharSequence)"file_c.avro", (CloseableIterable)CloseableIterable.withNoopClose((Iterable)positionDeletes))));
    }

    @Test
    public void testPositionMerging() {
        ArrayList positionDeletes1 = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 0L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 3L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 9L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 22L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 56L})});
        ArrayList positionDeletes2 = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 16L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 19L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 63L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 70L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 91L})});
        ArrayList positionDeletes3 = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 3L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 19L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 22L})});
        ArrayList deletes = Lists.newArrayList((Object[])new CloseableIterable[]{CloseableIterable.withNoopClose((Iterable)positionDeletes1), CloseableIterable.withNoopClose((Iterable)positionDeletes2), CloseableIterable.withNoopClose((Iterable)positionDeletes3)});
        Assert.assertEquals((String)"Should merge deletes in order, with duplicates", (Object)Lists.newArrayList((Object[])new Long[]{0L, 3L, 3L, 9L, 16L, 19L, 19L, 22L, 22L, 56L, 63L, 70L, 91L}), (Object)Lists.newArrayList((Iterable)Deletes.deletePositions((CharSequence)"file_a.avro", (List)deletes)));
    }

    @Test
    public void testPositionStreamRowFilter() {
        CloseableIterable rows = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c"}), TestHelpers.Row.of((Object[])new Object[]{3L, "d"}), TestHelpers.Row.of((Object[])new Object[]{4L, "e"}), TestHelpers.Row.of((Object[])new Object[]{5L, "f"}), TestHelpers.Row.of((Object[])new Object[]{6L, "g"}), TestHelpers.Row.of((Object[])new Object[]{7L, "h"}), TestHelpers.Row.of((Object[])new Object[]{8L, "i"}), TestHelpers.Row.of((Object[])new Object[]{9L, "j"})}));
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 3L, 4L, 7L, 9L}));
        CloseableIterable actual = Deletes.streamingFilter((CloseableIterable)rows, row -> (Long)row.get(0, Long.class), (CloseableIterable)deletes);
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 5L, 6L, 8L}), (Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)actual, row -> (Long)row.get(0, Long.class))));
    }

    @Test
    public void testPositionStreamRowDeleteMarker() {
        CloseableIterable rows = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a", false}), TestHelpers.Row.of((Object[])new Object[]{1L, "b", false}), TestHelpers.Row.of((Object[])new Object[]{2L, "c", false}), TestHelpers.Row.of((Object[])new Object[]{3L, "d", false}), TestHelpers.Row.of((Object[])new Object[]{4L, "e", false}), TestHelpers.Row.of((Object[])new Object[]{5L, "f", false}), TestHelpers.Row.of((Object[])new Object[]{6L, "g", false}), TestHelpers.Row.of((Object[])new Object[]{7L, "h", false}), TestHelpers.Row.of((Object[])new Object[]{8L, "i", false}), TestHelpers.Row.of((Object[])new Object[]{9L, "j", false})}));
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 3L, 4L, 7L, 9L}));
        CloseableIterable actual = Deletes.streamingMarker((CloseableIterable)rows, row -> (Long)row.get(0, Long.class), (CloseableIterable)deletes, row -> row.set(2, (Object)true));
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)Lists.newArrayList((Object[])new Boolean[]{true, false, false, true, true, false, false, true, false, true}), (Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)actual, row -> (Boolean)row.get(2, Boolean.class))));
    }

    @Test
    public void testPositionStreamRowFilterWithDuplicates() {
        CloseableIterable rows = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c"}), TestHelpers.Row.of((Object[])new Object[]{3L, "d"}), TestHelpers.Row.of((Object[])new Object[]{4L, "e"}), TestHelpers.Row.of((Object[])new Object[]{5L, "f"}), TestHelpers.Row.of((Object[])new Object[]{6L, "g"}), TestHelpers.Row.of((Object[])new Object[]{7L, "h"}), TestHelpers.Row.of((Object[])new Object[]{8L, "i"}), TestHelpers.Row.of((Object[])new Object[]{9L, "j"})}));
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 0L, 0L, 3L, 4L, 7L, 7L, 9L, 9L, 9L}));
        CloseableIterable actual = Deletes.streamingFilter((CloseableIterable)rows, row -> (Long)row.get(0, Long.class), (CloseableIterable)deletes);
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 5L, 6L, 8L}), (Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)actual, row -> (Long)row.get(0, Long.class))));
    }

    @Test
    public void testPositionStreamRowFilterWithRowGaps() {
        CloseableIterable rows = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{2L, "c"}), TestHelpers.Row.of((Object[])new Object[]{3L, "d"}), TestHelpers.Row.of((Object[])new Object[]{5L, "f"}), TestHelpers.Row.of((Object[])new Object[]{6L, "g"})}));
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 2L, 3L, 4L, 7L, 9L}));
        CloseableIterable actual = Deletes.streamingFilter((CloseableIterable)rows, row -> (Long)row.get(0, Long.class), (CloseableIterable)deletes);
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)Lists.newArrayList((Object[])new Long[]{5L, 6L}), (Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)actual, row -> (Long)row.get(0, Long.class))));
    }

    @Test
    public void testCombinedPositionStreamRowFilter() {
        CloseableIterable positionDeletes1 = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 0L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 3L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 9L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 5L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 6L})}));
        CloseableIterable positionDeletes2 = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 3L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 4L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 7L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 2L})}));
        CloseableIterable rows = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c"}), TestHelpers.Row.of((Object[])new Object[]{3L, "d"}), TestHelpers.Row.of((Object[])new Object[]{4L, "e"}), TestHelpers.Row.of((Object[])new Object[]{5L, "f"}), TestHelpers.Row.of((Object[])new Object[]{6L, "g"}), TestHelpers.Row.of((Object[])new Object[]{7L, "h"}), TestHelpers.Row.of((Object[])new Object[]{8L, "i"}), TestHelpers.Row.of((Object[])new Object[]{9L, "j"})}));
        CloseableIterable actual = Deletes.streamingFilter((CloseableIterable)rows, row -> (Long)row.get(0, Long.class), (CloseableIterable)Deletes.deletePositions((CharSequence)"file_a.avro", (List)ImmutableList.of((Object)positionDeletes1, (Object)positionDeletes2)));
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 5L, 6L, 8L}), (Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)actual, row -> (Long)row.get(0, Long.class))));
    }

    @Test
    public void testPositionSetRowFilter() {
        CloseableIterable rows = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c"}), TestHelpers.Row.of((Object[])new Object[]{3L, "d"}), TestHelpers.Row.of((Object[])new Object[]{4L, "e"}), TestHelpers.Row.of((Object[])new Object[]{5L, "f"}), TestHelpers.Row.of((Object[])new Object[]{6L, "g"}), TestHelpers.Row.of((Object[])new Object[]{7L, "h"}), TestHelpers.Row.of((Object[])new Object[]{8L, "i"}), TestHelpers.Row.of((Object[])new Object[]{9L, "j"})}));
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new Long[]{0L, 3L, 4L, 7L, 9L}));
        Predicate<StructLike> shouldKeep = row -> !Deletes.toPositionIndex((CloseableIterable)deletes).isDeleted(((Long)row.get(0, Long.class)).longValue());
        CloseableIterable actual = CloseableIterable.filter((CloseableIterable)rows, shouldKeep);
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 5L, 6L, 8L}), (Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)actual, row -> (Long)row.get(0, Long.class))));
    }

    @Test
    public void testCombinedPositionSetRowFilter() {
        CloseableIterable positionDeletes1 = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 0L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 3L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 9L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 5L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 6L})}));
        CloseableIterable positionDeletes2 = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 3L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 4L}), TestHelpers.Row.of((Object[])new Object[]{"file_a.avro", 7L}), TestHelpers.Row.of((Object[])new Object[]{"file_b.avro", 2L})}));
        CloseableIterable rows = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c"}), TestHelpers.Row.of((Object[])new Object[]{3L, "d"}), TestHelpers.Row.of((Object[])new Object[]{4L, "e"}), TestHelpers.Row.of((Object[])new Object[]{5L, "f"}), TestHelpers.Row.of((Object[])new Object[]{6L, "g"}), TestHelpers.Row.of((Object[])new Object[]{7L, "h"}), TestHelpers.Row.of((Object[])new Object[]{8L, "i"}), TestHelpers.Row.of((Object[])new Object[]{9L, "j"})}));
        Predicate<StructLike> isDeleted = row -> Deletes.toPositionIndex((CharSequence)"file_a.avro", (List)ImmutableList.of((Object)positionDeletes1, (Object)positionDeletes2)).isDeleted(((Long)row.get(0, Long.class)).longValue());
        CloseableIterable actual = CloseableIterable.filter((CloseableIterable)rows, isDeleted.negate());
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 5L, 6L, 8L}), (Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)actual, row -> (Long)row.get(0, Long.class))));
    }
}

