/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.util.ArrayList;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.deletes.Deletes;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.Assert;
import org.junit.Test;

public class TestEqualityFilter {
    private static final Schema ROW_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"name", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"description", (Type)Types.StringType.get())});
    private static final CloseableIterable<StructLike> ROWS = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a", "panda"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b", "koala"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c", new Utf8("kodiak")}), TestHelpers.Row.of((Object[])new Object[]{4L, new Utf8("d"), "gummy"}), TestHelpers.Row.of((Object[])new Object[]{5L, "e", "brown"}), TestHelpers.Row.of((Object[])new Object[]{6L, "f", new Utf8("teddy")}), TestHelpers.Row.of((Object[])new Object[]{7L, "g", "grizzly"}), TestHelpers.Row.of((Object[])new Object[]{8L, "h", null})}));

    @Test
    public void testEqualitySetFilterLongColumn() {
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{4L}), TestHelpers.Row.of((Object[])new Object[]{3L}), TestHelpers.Row.of((Object[])new Object[]{6L})}));
        ArrayList expected = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a", "panda"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b", "koala"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c", new Utf8("kodiak")}), TestHelpers.Row.of((Object[])new Object[]{5L, "e", "brown"}), TestHelpers.Row.of((Object[])new Object[]{7L, "g", "grizzly"}), TestHelpers.Row.of((Object[])new Object[]{8L, "h", null})});
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)expected, (Object)Lists.newArrayList((Iterable)Deletes.filter(ROWS, row -> TestHelpers.Row.of((Object[])new Object[]{row.get(0, Long.class)}), (StructLikeSet)Deletes.toEqualitySet((CloseableIterable)deletes, (Types.StructType)ROW_SCHEMA.select(new String[]{"id"}).asStruct()))));
    }

    @Test
    public void testEqualitySetFilterStringColumn() {
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{"a"}), TestHelpers.Row.of((Object[])new Object[]{"d"}), TestHelpers.Row.of((Object[])new Object[]{"h"})}));
        ArrayList expected = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{1L, "b", "koala"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c", new Utf8("kodiak")}), TestHelpers.Row.of((Object[])new Object[]{5L, "e", "brown"}), TestHelpers.Row.of((Object[])new Object[]{6L, "f", new Utf8("teddy")}), TestHelpers.Row.of((Object[])new Object[]{7L, "g", "grizzly"})});
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)expected, (Object)Lists.newArrayList((Iterable)Deletes.filter(ROWS, row -> TestHelpers.Row.of((Object[])new Object[]{row.get(1, CharSequence.class)}), (StructLikeSet)Deletes.toEqualitySet((CloseableIterable)deletes, (Types.StructType)ROW_SCHEMA.select(new String[]{"name"}).asStruct()))));
    }

    @Test
    public void testEqualitySetFilterStringColumnWithNull() {
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{null})}));
        ArrayList expected = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a", "panda"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b", "koala"}), TestHelpers.Row.of((Object[])new Object[]{2L, "c", new Utf8("kodiak")}), TestHelpers.Row.of((Object[])new Object[]{4L, new Utf8("d"), "gummy"}), TestHelpers.Row.of((Object[])new Object[]{5L, "e", "brown"}), TestHelpers.Row.of((Object[])new Object[]{6L, "f", new Utf8("teddy")}), TestHelpers.Row.of((Object[])new Object[]{7L, "g", "grizzly"})});
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)expected, (Object)Lists.newArrayList((Iterable)Deletes.filter(ROWS, row -> TestHelpers.Row.of((Object[])new Object[]{row.get(2, CharSequence.class)}), (StructLikeSet)Deletes.toEqualitySet((CloseableIterable)deletes, (Types.StructType)ROW_SCHEMA.select(new String[]{"description"}).asStruct()))));
    }

    @Test
    public void testEqualitySetFilterMultipleColumns() {
        CloseableIterable deletes = CloseableIterable.withNoopClose((Iterable)Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{2L, "kodiak"}), TestHelpers.Row.of((Object[])new Object[]{3L, "care"}), TestHelpers.Row.of((Object[])new Object[]{8L, null})}));
        ArrayList expected = Lists.newArrayList((Object[])new StructLike[]{TestHelpers.Row.of((Object[])new Object[]{0L, "a", "panda"}), TestHelpers.Row.of((Object[])new Object[]{1L, "b", "koala"}), TestHelpers.Row.of((Object[])new Object[]{4L, new Utf8("d"), "gummy"}), TestHelpers.Row.of((Object[])new Object[]{5L, "e", "brown"}), TestHelpers.Row.of((Object[])new Object[]{6L, "f", new Utf8("teddy")}), TestHelpers.Row.of((Object[])new Object[]{7L, "g", "grizzly"})});
        Assert.assertEquals((String)"Filter should produce expected rows", (Object)expected, (Object)Lists.newArrayList((Iterable)Deletes.filter(ROWS, row -> TestHelpers.Row.of((Object[])new Object[]{row.get(0, Long.class), row.get(2, CharSequence.class)}), (StructLikeSet)Deletes.toEqualitySet((CloseableIterable)deletes, (Types.StructType)ROW_SCHEMA.select(new String[]{"id", "description"}).asStruct()))));
    }
}

