/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.TableIdentifierParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestTableIdentifierParser {
    @Test
    public void testTableIdentifierToJson() {
        String json = "{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid\"}";
        TableIdentifier identifier = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"accounting", "tax"}), (String)"paid");
        Assert.assertEquals((String)"Should be able to serialize a table identifier with both namespace and name", (Object)json, (Object)TableIdentifierParser.toJson((TableIdentifier)identifier));
        TableIdentifier identifierWithEmptyNamespace = TableIdentifier.of((Namespace)Namespace.empty(), (String)"paid");
        String jsonWithEmptyNamespace = "{\"namespace\":[],\"name\":\"paid\"}";
        Assert.assertEquals((String)"Should be able to serialize a table identifier that uses the empty namespace", (Object)jsonWithEmptyNamespace, (Object)TableIdentifierParser.toJson((TableIdentifier)identifierWithEmptyNamespace));
    }

    @Test
    public void testTableIdentifierFromJson() {
        String json = "{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid\"}";
        TableIdentifier identifier = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"accounting", "tax"}), (String)"paid");
        Assert.assertEquals((String)"Should be able to deserialize a valid table identifier", (Object)identifier, (Object)TableIdentifierParser.fromJson((String)json));
        TableIdentifier identifierWithEmptyNamespace = TableIdentifier.of((Namespace)Namespace.empty(), (String)"paid");
        String jsonWithEmptyNamespace = "{\"namespace\":[],\"name\":\"paid\"}";
        Assert.assertEquals((String)"Should be able to deserialize a valid multi-level table identifier", (Object)identifierWithEmptyNamespace, (Object)TableIdentifierParser.fromJson((String)jsonWithEmptyNamespace));
        String identifierMissingNamespace = "{\"name\":\"paid\"}";
        Assert.assertEquals((String)"Should implicitly convert a missing namespace into the the empty namespace when parsing", (Object)identifierWithEmptyNamespace, (Object)TableIdentifierParser.fromJson((String)identifierMissingNamespace));
    }

    @Test
    public void testFailParsingWhenNullOrEmptyJson() {
        String nullJson = null;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifierParser.fromJson((String)nullJson)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse table identifier from invalid JSON: null");
        String emptyString = "";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifierParser.fromJson((String)emptyString)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse table identifier from invalid JSON: ''");
        String emptyJson = "{}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifierParser.fromJson((String)emptyJson)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: name");
        String emptyJsonArray = "[]";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifierParser.fromJson((String)emptyJsonArray)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing or non-object table identifier: []");
    }

    @Test
    public void testFailParsingWhenMissingRequiredFields() {
        String identifierMissingName = "{\"namespace\":[\"accounting\",\"tax\"]}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifierParser.fromJson((String)identifierMissingName)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: name");
    }

    @Test
    public void testFailWhenFieldsHaveInvalidValues() {
        String invalidNamespace = "{\"namespace\":\"accounting.tax\",\"name\":\"paid\"}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifierParser.fromJson((String)invalidNamespace)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-array value: namespace: \"accounting.tax\"");
        String invalidName = "{\"namespace\":[\"accounting\",\"tax\"],\"name\":1234}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifierParser.fromJson((String)invalidName)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a string value: name: 1234");
    }
}

