/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FilesTable;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class CatalogTests<C extends Catalog & SupportsNamespaces> {
    private static final Namespace NS = Namespace.of((String[])new String[]{"newdb"});
    protected static final TableIdentifier TABLE = TableIdentifier.of((Namespace)NS, (String)"table");
    private static final TableIdentifier RENAMED_TABLE = TableIdentifier.of((Namespace)NS, (String)"table_renamed");
    protected static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    private static final Schema TABLE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final Schema REPLACE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)2, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)3, (String)"data", (Type)Types.StringType.get())});
    private static final Schema OTHER_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"some_id", (Type)Types.IntegerType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("id", 16).build();
    private static final PartitionSpec TABLE_SPEC = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).bucket("id", 16).build();
    private static final PartitionSpec REPLACE_SPEC = PartitionSpec.builderFor((Schema)REPLACE_SCHEMA).bucket("id", 16).withSpecId(1).build();
    static final SortOrder WRITE_ORDER = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).build();
    static final SortOrder TABLE_WRITE_ORDER = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)TABLE_SCHEMA).asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).build();
    static final SortOrder REPLACE_WRITE_ORDER = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)REPLACE_SCHEMA).asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).build();
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("id_bucket=0").withRecordCount(2L).build();
    static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("id_bucket=1").withRecordCount(2L).build();
    static final DataFile FILE_C = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withPartitionPath("id_bucket=2").withRecordCount(2L).build();

    protected abstract C catalog();

    protected boolean supportsNamespaceProperties() {
        return true;
    }

    protected boolean supportsNestedNamespaces() {
        return false;
    }

    protected boolean requiresNamespaceCreate() {
        return false;
    }

    protected boolean supportsServerSideRetry() {
        return false;
    }

    protected boolean overridesRequestedLocation() {
        return false;
    }

    protected boolean supportsNamesWithSlashes() {
        return true;
    }

    @Test
    public void testCreateNamespace() {
        C catalog = this.catalog();
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        ((SupportsNamespaces)catalog).createNamespace(NS);
        Assert.assertTrue((String)"Catalog should have the created namespace", (boolean)((SupportsNamespaces)catalog).listNamespaces().contains(NS));
        Assert.assertTrue((String)"Namespace should exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
    }

    @Test
    public void testCreateExistingNamespace() {
        Object catalog = this.catalog();
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        ((SupportsNamespaces)catalog).createNamespace(NS);
        Assert.assertTrue((String)"Namespace should exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SupportsNamespaces)catalog).createNamespace(NS)).isInstanceOf(AlreadyExistsException.class)).hasMessageContaining("Namespace already exists");
        Assert.assertTrue((String)"Namespace should still exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
    }

    @Test
    public void testCreateNamespaceWithProperties() {
        Assume.assumeTrue((boolean)this.supportsNamespaceProperties());
        C catalog = this.catalog();
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        ImmutableMap createProps = ImmutableMap.of((Object)"prop", (Object)"val");
        ((SupportsNamespaces)catalog).createNamespace(NS, (Map)createProps);
        Assert.assertTrue((String)"Namespace should exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        Map props = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Create properties should be a subset of returned properties", createProps.entrySet(), (Object)Sets.intersection(createProps.entrySet(), props.entrySet()));
    }

    @Test
    public void testLoadNamespaceMetadata() {
        Object catalog = this.catalog();
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS)).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: newdb");
        ((SupportsNamespaces)catalog).createNamespace(NS);
        Assert.assertTrue((String)"Namespace should exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        Map props = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertNotNull((String)"Should return non-null property map", (Object)props);
    }

    @Test
    public void testSetNamespaceProperties() {
        Assume.assumeTrue((boolean)this.supportsNamespaceProperties());
        C catalog = this.catalog();
        ImmutableMap properties = ImmutableMap.of((Object)"owner", (Object)"user", (Object)"created-at", (Object)"sometime");
        ((SupportsNamespaces)catalog).createNamespace(NS);
        ((SupportsNamespaces)catalog).setProperties(NS, (Map)properties);
        Map actualProperties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Set properties should be a subset of returned properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), actualProperties.entrySet()));
    }

    @Test
    public void testUpdateNamespaceProperties() {
        Assume.assumeTrue((boolean)this.supportsNamespaceProperties());
        C catalog = this.catalog();
        ImmutableMap initialProperties = ImmutableMap.of((Object)"owner", (Object)"user");
        ((SupportsNamespaces)catalog).createNamespace(NS);
        ((SupportsNamespaces)catalog).setProperties(NS, (Map)initialProperties);
        Map actualProperties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Set properties should be a subset of returned properties", initialProperties.entrySet(), (Object)Sets.intersection(initialProperties.entrySet(), actualProperties.entrySet()));
        ImmutableMap updatedProperties = ImmutableMap.of((Object)"owner", (Object)"newuser");
        ((SupportsNamespaces)catalog).setProperties(NS, (Map)updatedProperties);
        Map finalProperties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Updated properties should be a subset of returned properties", updatedProperties.entrySet(), (Object)Sets.intersection(updatedProperties.entrySet(), finalProperties.entrySet()));
    }

    @Test
    public void testUpdateAndSetNamespaceProperties() {
        Assume.assumeTrue((boolean)this.supportsNamespaceProperties());
        C catalog = this.catalog();
        ImmutableMap initialProperties = ImmutableMap.of((Object)"owner", (Object)"user");
        ((SupportsNamespaces)catalog).createNamespace(NS);
        ((SupportsNamespaces)catalog).setProperties(NS, (Map)initialProperties);
        Map actualProperties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Set properties should be a subset of returned properties", initialProperties.entrySet(), (Object)Sets.intersection(initialProperties.entrySet(), actualProperties.entrySet()));
        ImmutableMap updatedProperties = ImmutableMap.of((Object)"owner", (Object)"newuser", (Object)"last-modified-at", (Object)"now");
        ((SupportsNamespaces)catalog).setProperties(NS, (Map)updatedProperties);
        Map finalProperties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Updated properties should be a subset of returned properties", updatedProperties.entrySet(), (Object)Sets.intersection(updatedProperties.entrySet(), finalProperties.entrySet()));
    }

    @Test
    public void testSetNamespacePropertiesNamespaceDoesNotExist() {
        Assume.assumeTrue((boolean)this.supportsNamespaceProperties());
        Object catalog = this.catalog();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SupportsNamespaces)catalog).setProperties(NS, (Map)ImmutableMap.of((Object)"test", (Object)"value"))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: newdb");
    }

    @Test
    public void testRemoveNamespaceProperties() {
        Assume.assumeTrue((boolean)this.supportsNamespaceProperties());
        C catalog = this.catalog();
        ImmutableMap properties = ImmutableMap.of((Object)"owner", (Object)"user", (Object)"created-at", (Object)"sometime");
        ((SupportsNamespaces)catalog).createNamespace(NS);
        ((SupportsNamespaces)catalog).setProperties(NS, (Map)properties);
        ((SupportsNamespaces)catalog).removeProperties(NS, (Set)ImmutableSet.of((Object)"created-at"));
        Map actualProperties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(NS);
        Assert.assertFalse((String)"Should not contain deleted property key", (boolean)actualProperties.containsKey("created-at"));
        Assert.assertEquals((String)"Expected properties should be a subset of returned properties", (Object)ImmutableMap.of((Object)"owner", (Object)"user").entrySet(), (Object)Sets.intersection(properties.entrySet(), actualProperties.entrySet()));
    }

    @Test
    public void testRemoveNamespacePropertiesNamespaceDoesNotExist() {
        Assume.assumeTrue((boolean)this.supportsNamespaceProperties());
        Object catalog = this.catalog();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SupportsNamespaces)catalog).removeProperties(NS, (Set)ImmutableSet.of((Object)"a", (Object)"b"))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: newdb");
    }

    @Test
    public void testDropNamespace() {
        C catalog = this.catalog();
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        ((SupportsNamespaces)catalog).createNamespace(NS);
        Assert.assertTrue((String)"Namespace should exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
        Assert.assertTrue((String)"Dropping an existing namespace should return true", (boolean)((SupportsNamespaces)catalog).dropNamespace(NS));
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(NS));
    }

    @Test
    public void testDropNonexistentNamespace() {
        C catalog = this.catalog();
        Assert.assertFalse((String)"Dropping a nonexistent namespace should return false", (boolean)((SupportsNamespaces)catalog).dropNamespace(NS));
    }

    @Test
    public void testListNamespaces() {
        C catalog = this.catalog();
        List starting = ((SupportsNamespaces)catalog).listNamespaces();
        Namespace ns1 = Namespace.of((String[])new String[]{"newdb_1"});
        Namespace ns2 = Namespace.of((String[])new String[]{"newdb_2"});
        ((SupportsNamespaces)catalog).createNamespace(ns1);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces()).withFailMessage("Should include newdb_1", new Object[0])).hasSameElementsAs(this.concat(starting, ns1));
        ((SupportsNamespaces)catalog).createNamespace(ns2);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces()).withFailMessage("Should include newdb_1 and newdb_2", new Object[0])).hasSameElementsAs(this.concat(starting, ns1, ns2));
        ((SupportsNamespaces)catalog).dropNamespace(ns1);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces()).withFailMessage("Should include newdb_2, not newdb_1", new Object[0])).hasSameElementsAs(this.concat(starting, ns2));
        ((SupportsNamespaces)catalog).dropNamespace(ns2);
        Assert.assertTrue((String)"Should include only starting namespaces", (boolean)((SupportsNamespaces)catalog).listNamespaces().containsAll(starting));
    }

    @Test
    public void testListNestedNamespaces() {
        Assume.assumeTrue((String)"Only valid when the catalog supports nested namespaces", (boolean)this.supportsNestedNamespaces());
        C catalog = this.catalog();
        List starting = ((SupportsNamespaces)catalog).listNamespaces();
        Namespace parent = Namespace.of((String[])new String[]{"parent"});
        Namespace child1 = Namespace.of((String[])new String[]{"parent", "child1"});
        Namespace child2 = Namespace.of((String[])new String[]{"parent", "child2"});
        ((SupportsNamespaces)catalog).createNamespace(parent);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces()).withFailMessage("Should include parent", new Object[0])).hasSameElementsAs(this.concat(starting, parent));
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces(parent)).withFailMessage("Should have no children in newly created parent namespace", new Object[0])).isEmpty();
        ((SupportsNamespaces)catalog).createNamespace(child1);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces(parent)).withFailMessage("Should include child1", new Object[0])).hasSameElementsAs((Iterable)ImmutableList.of((Object)child1));
        ((SupportsNamespaces)catalog).createNamespace(child2);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces(parent)).withFailMessage("Should include child1 and child2", new Object[0])).hasSameElementsAs((Iterable)ImmutableList.of((Object)child1, (Object)child2));
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces()).withFailMessage("Should not change listing the root", new Object[0])).hasSameElementsAs(this.concat(starting, parent));
        ((SupportsNamespaces)catalog).dropNamespace(child1);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces(parent)).withFailMessage("Should include only child2", new Object[0])).hasSameElementsAs((Iterable)ImmutableList.of((Object)child2));
        ((SupportsNamespaces)catalog).dropNamespace(child2);
        ((ListAssert)Assertions.assertThat((List)((SupportsNamespaces)catalog).listNamespaces(parent)).withFailMessage("Should be empty", new Object[0])).isEmpty();
    }

    @Test
    public void testNamespaceWithSlash() {
        Assume.assumeTrue((boolean)this.supportsNamesWithSlashes());
        C catalog = this.catalog();
        Namespace withSlash = Namespace.of((String[])new String[]{"new/db"});
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(withSlash));
        ((SupportsNamespaces)catalog).createNamespace(withSlash);
        Assert.assertTrue((String)"Namespace should exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(withSlash));
        Map properties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(withSlash);
        Assert.assertNotNull((String)"Properties should be accessible", (Object)properties);
        Assert.assertTrue((String)"Dropping the namespace should succeed", (boolean)((SupportsNamespaces)catalog).dropNamespace(withSlash));
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(withSlash));
    }

    @Test
    public void testNamespaceWithDot() {
        C catalog = this.catalog();
        Namespace withDot = Namespace.of((String[])new String[]{"new.db"});
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(withDot));
        ((SupportsNamespaces)catalog).createNamespace(withDot);
        Assert.assertTrue((String)"Namespace should exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(withDot));
        Map properties = ((SupportsNamespaces)catalog).loadNamespaceMetadata(withDot);
        Assert.assertNotNull((String)"Properties should be accessible", (Object)properties);
        Assert.assertTrue((String)"Dropping the namespace should succeed", (boolean)((SupportsNamespaces)catalog).dropNamespace(withDot));
        Assert.assertFalse((String)"Namespace should not exist", (boolean)((SupportsNamespaces)catalog).namespaceExists(withDot));
    }

    @Test
    public void testBasicCreateTable() {
        C catalog = this.catalog();
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "table"});
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(ident.namespace());
        }
        Table table = catalog.buildTable(ident, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(ident));
        Assert.assertEquals((String)"Table name should report its full name", (Object)(catalog.name() + "." + ident), (Object)table.name());
        Assert.assertEquals((String)"Schema should match expected ID assignment", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertNotNull((String)"Should have a location", (Object)table.location());
        Assert.assertTrue((String)"Should be unpartitioned", (boolean)table.spec().isUnpartitioned());
        Assert.assertTrue((String)"Should be unsorted", (boolean)table.sortOrder().isUnsorted());
        Assert.assertNotNull((String)"Should have table properties", (Object)table.properties());
    }

    @Test
    public void testTableNameWithSlash() {
        Assume.assumeTrue((boolean)this.supportsNamesWithSlashes());
        C catalog = this.catalog();
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "tab/le"});
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(Namespace.of((String[])new String[]{"ns"}));
        }
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
        catalog.buildTable(ident, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(ident));
        Table loaded = catalog.loadTable(ident);
        Assert.assertEquals((String)"Schema should match expected ID assignment", (Object)TABLE_SCHEMA.asStruct(), (Object)loaded.schema().asStruct());
        catalog.dropTable(ident);
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
    }

    @Test
    public void testTableNameWithDot() {
        C catalog = this.catalog();
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "ta.ble"});
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(Namespace.of((String[])new String[]{"ns"}));
        }
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
        catalog.buildTable(ident, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(ident));
        Table loaded = catalog.loadTable(ident);
        Assert.assertEquals((String)"Schema should match expected ID assignment", (Object)TABLE_SCHEMA.asStruct(), (Object)loaded.schema().asStruct());
        catalog.dropTable(ident);
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
    }

    @Test
    public void testBasicCreateTableThatAlreadyExists() {
        Object catalog = this.catalog();
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "table"});
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(ident.namespace());
        }
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
        catalog.buildTable(ident, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(ident));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.buildTable(ident, OTHER_SCHEMA).create()).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: ns.table");
        Table table = catalog.loadTable(ident);
        Assert.assertEquals((String)"Schema should match original table schema", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
    }

    @Test
    public void testCompleteCreateTable() {
        C catalog = this.catalog();
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "table"});
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(ident.namespace());
        }
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19");
        Table table = catalog.buildTable(ident, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).create();
        Assert.assertEquals((String)"Table name should report its full name", (Object)(catalog.name() + "." + ident), (Object)table.name());
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(ident));
        Assert.assertEquals((String)"Schema should match expected ID assignment", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertNotNull((String)"Should have a location", (Object)table.location());
        Assert.assertEquals((String)"Should use requested partition spec", (Object)TABLE_SPEC, (Object)table.spec());
        Assert.assertEquals((String)"Should use requested write order", (Object)TABLE_WRITE_ORDER, (Object)table.sortOrder());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), table.properties().entrySet()));
    }

    @Test
    public void testLoadTable() {
        C catalog = this.catalog();
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "table"});
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(ident.namespace());
        }
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19");
        catalog.buildTable(ident, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).create();
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(ident));
        Table table = catalog.loadTable(ident);
        Assert.assertEquals((String)"Table name should report its full name", (Object)(catalog.name() + "." + ident), (Object)table.name());
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(ident));
        Assert.assertEquals((String)"Schema should match expected ID assignment", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertNotNull((String)"Should have a location", (Object)table.location());
        Assert.assertEquals((String)"Should use requested partition spec", (Object)TABLE_SPEC, (Object)table.spec());
        Assert.assertEquals((String)"Should use requested write order", (Object)TABLE_WRITE_ORDER, (Object)table.sortOrder());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), table.properties().entrySet()));
    }

    @Test
    public void testLoadMetadataTable() {
        C catalog = this.catalog();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"ns", "table"});
        TableIdentifier metaIdent = TableIdentifier.of((String[])new String[]{"ns", "table", "files"});
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(tableIdent.namespace());
        }
        catalog.buildTable(tableIdent, SCHEMA).create();
        Table table = catalog.loadTable(metaIdent);
        Assertions.assertThat((Object)table).isNotNull();
        Assertions.assertThat((Object)table).isInstanceOf(FilesTable.class);
        table.refresh();
        Assertions.assertThat((String)table.name()).isEqualTo(catalog.name() + "." + metaIdent);
    }

    @Test
    public void testLoadMissingTable() {
        Object catalog = this.catalog();
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "table"});
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(ident));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.loadTable(ident)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: ns.table");
    }

    @Test
    public void testRenameTable() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Assert.assertFalse((String)"Source table should not exist before create", (boolean)catalog.tableExists(TABLE));
        catalog.buildTable(TABLE, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist after create", (boolean)catalog.tableExists(TABLE));
        Assert.assertFalse((String)"Destination table should not exist before rename", (boolean)catalog.tableExists(RENAMED_TABLE));
        catalog.renameTable(TABLE, RENAMED_TABLE);
        Assert.assertTrue((String)"Table should exist with new name", (boolean)catalog.tableExists(RENAMED_TABLE));
        Assert.assertFalse((String)"Original table should no longer exist", (boolean)catalog.tableExists(TABLE));
        catalog.dropTable(RENAMED_TABLE);
        CatalogTests.assertEmpty("Should not contain table after drop", catalog, NS);
    }

    @Test
    public void testRenameTableMissingSourceTable() {
        Object catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Assert.assertFalse((String)"Source table should not exist before rename", (boolean)catalog.tableExists(TABLE));
        Assert.assertFalse((String)"Destination table should not exist before rename", (boolean)catalog.tableExists(RENAMED_TABLE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.renameTable(TABLE, RENAMED_TABLE)).isInstanceOf(NoSuchTableException.class)).hasMessageContaining("Table does not exist");
        Assert.assertFalse((String)"Destination table should not exist after failed rename", (boolean)catalog.tableExists(RENAMED_TABLE));
    }

    @Test
    public void testRenameTableDestinationTableAlreadyExists() {
        Object catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Assert.assertFalse((String)"Source table should not exist before create", (boolean)catalog.tableExists(TABLE));
        catalog.buildTable(TABLE, SCHEMA).create();
        Assert.assertTrue((String)"Source table should exist after create", (boolean)catalog.tableExists(TABLE));
        Assert.assertFalse((String)"Destination table should not exist before create", (boolean)catalog.tableExists(RENAMED_TABLE));
        catalog.buildTable(RENAMED_TABLE, SCHEMA).create();
        Assert.assertTrue((String)"Destination table should exist after create", (boolean)catalog.tableExists(RENAMED_TABLE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.renameTable(TABLE, RENAMED_TABLE)).isInstanceOf(AlreadyExistsException.class)).hasMessageContaining("Table already exists");
        Assert.assertTrue((String)"Source table should still exist after failed rename", (boolean)catalog.tableExists(TABLE));
        Assert.assertTrue((String)"Destination table should still exist after failed rename", (boolean)catalog.tableExists(RENAMED_TABLE));
        String sourceTableUUID = ((HasTableOperations)catalog.loadTable(TABLE)).operations().current().uuid();
        String destinationTableUUID = ((HasTableOperations)catalog.loadTable(RENAMED_TABLE)).operations().current().uuid();
        Assert.assertNotEquals((String)"Source and destination table should remain distinct after failed rename", (Object)sourceTableUUID, (Object)destinationTableUUID);
    }

    @Test
    public void testDropTable() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Assert.assertFalse((String)"Table should not exist before create", (boolean)catalog.tableExists(TABLE));
        catalog.buildTable(TABLE, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist after create", (boolean)catalog.tableExists(TABLE));
        boolean dropped = catalog.dropTable(TABLE);
        Assert.assertTrue((String)"Should drop a table that does exist", (boolean)dropped);
        Assert.assertFalse((String)"Table should not exist after drop", (boolean)catalog.tableExists(TABLE));
    }

    @Test
    public void testDropTableWithPurge() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Assert.assertFalse((String)"Table should not exist before create", (boolean)catalog.tableExists(TABLE));
        catalog.buildTable(TABLE, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist after create", (boolean)catalog.tableExists(TABLE));
        boolean dropped = catalog.dropTable(TABLE, true);
        Assert.assertTrue((String)"Should drop a table that does exist", (boolean)dropped);
        Assert.assertFalse((String)"Table should not exist after drop", (boolean)catalog.tableExists(TABLE));
    }

    @Test
    public void testDropTableWithoutPurge() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Assert.assertFalse((String)"Table should not exist before create", (boolean)catalog.tableExists(TABLE));
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        Assert.assertTrue((String)"Table should exist after create", (boolean)catalog.tableExists(TABLE));
        Set actualMetadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false);
        boolean dropped = catalog.dropTable(TABLE, false);
        Assert.assertTrue((String)"Should drop a table that does exist", (boolean)dropped);
        Assert.assertFalse((String)"Table should not exist after drop", (boolean)catalog.tableExists(TABLE));
        Set expectedMetadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)actualMetadataFileLocations).hasSameElementsAs((Iterable)expectedMetadataFileLocations)).hasSize(1)).as("Should have one metadata file", new Object[0]);
    }

    @Test
    public void testDropMissingTable() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        TableIdentifier noSuchTableIdent = TableIdentifier.of((Namespace)NS, (String)"notable");
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(noSuchTableIdent));
        Assert.assertFalse((String)"Should not drop a table that does not exist", (boolean)catalog.dropTable(noSuchTableIdent));
    }

    @Test
    public void testListTables() {
        C catalog = this.catalog();
        Namespace ns1 = Namespace.of((String[])new String[]{"ns_1"});
        Namespace ns2 = Namespace.of((String[])new String[]{"ns_2"});
        TableIdentifier ns1Table1 = TableIdentifier.of((Namespace)ns1, (String)"table_1");
        TableIdentifier ns1Table2 = TableIdentifier.of((Namespace)ns1, (String)"table_2");
        TableIdentifier ns2Table1 = TableIdentifier.of((Namespace)ns2, (String)"table_1");
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(ns1);
            ((SupportsNamespaces)catalog).createNamespace(ns2);
        }
        CatalogTests.assertEmpty("Should not have tables in a new namespace, ns_1", catalog, ns1);
        CatalogTests.assertEmpty("Should not have tables in a new namespace, ns_2", catalog, ns2);
        catalog.buildTable(ns1Table1, SCHEMA).create();
        Assert.assertEquals((String)"Should contain ns_1.table_1 after create", (Object)ImmutableSet.of((Object)ns1Table1), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns1)));
        catalog.buildTable(ns2Table1, SCHEMA).create();
        Assert.assertEquals((String)"Should contain ns_2.table_1 after create", (Object)ImmutableSet.of((Object)ns2Table1), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns2)));
        Assert.assertEquals((String)"Should not show changes to ns_2 in ns_1", (Object)ImmutableSet.of((Object)ns1Table1), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns1)));
        catalog.buildTable(ns1Table2, SCHEMA).create();
        Assert.assertEquals((String)"Should not show changes to ns_1 in ns_2", (Object)ImmutableSet.of((Object)ns2Table1), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns2)));
        Assert.assertEquals((String)"Should contain ns_1.table_2 after create", (Object)ImmutableSet.of((Object)ns1Table1, (Object)ns1Table2), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns1)));
        catalog.dropTable(ns1Table1);
        Assert.assertEquals((String)"Should not show changes to ns_1 in ns_2", (Object)ImmutableSet.of((Object)ns2Table1), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns2)));
        Assert.assertEquals((String)"Should not contain ns_1.table_1 after drop", (Object)ImmutableSet.of((Object)ns1Table2), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns1)));
        catalog.dropTable(ns1Table2);
        Assert.assertEquals((String)"Should not show changes to ns_1 in ns_2", (Object)ImmutableSet.of((Object)ns2Table1), (Object)Sets.newHashSet((Iterable)catalog.listTables(ns2)));
        CatalogTests.assertEmpty("Should not contain ns_1.table_2 after drop", catalog, ns1);
        catalog.dropTable(ns2Table1);
        CatalogTests.assertEmpty("Should not contain ns_2.table_1 after drop", catalog, ns2);
    }

    @Test
    public void testUpdateTableSchema() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdateSchema update = table.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        Schema expected = (Schema)update.apply();
        update.commit();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected schema", (Object)expected.asStruct(), (Object)loaded.schema().asStruct());
    }

    @Test
    public void testUUIDValidation() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdateSchema update = table.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        Assert.assertTrue((String)"Should successfully drop table", (boolean)catalog.dropTable(TABLE));
        catalog.buildTable(TABLE, OTHER_SCHEMA).create();
        String expectedMessage = this.supportsServerSideRetry() ? "Requirement failed: UUID does not match" : "Cannot commit";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UpdateSchema)update).commit()).isInstanceOf(CommitFailedException.class)).hasMessageContaining(expectedMessage);
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected schema", (Object)OTHER_SCHEMA.asStruct(), (Object)loaded.schema().asStruct());
    }

    @Test
    public void testUpdateTableSchemaServerSideRetry() {
        Assume.assumeTrue((String)"Schema update recovery is only supported with server-side retry", (boolean)this.supportsServerSideRetry());
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdateSchema update = table.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        Schema expected = (Schema)update.apply();
        catalog.loadTable(TABLE).updateSpec().addField("shard", (Term)Expressions.bucket((String)"id", (int)16)).commit();
        update.commit();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected schema", (Object)expected.asStruct(), (Object)loaded.schema().asStruct());
    }

    @Test
    public void testUpdateTableSchemaConflict() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdateSchema update = table.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        UpdateSchema concurrent = catalog.loadTable(TABLE).updateSchema().deleteColumn("data");
        Schema expected = (Schema)concurrent.apply();
        concurrent.commit();
        String expectedMessage = this.supportsServerSideRetry() ? "Requirement failed: current schema changed" : "Cannot commit";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UpdateSchema)update).commit()).isInstanceOf(CommitFailedException.class)).hasMessageContaining(expectedMessage);
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected schema", (Object)expected.asStruct(), (Object)loaded.schema().asStruct());
    }

    @Test
    public void testUpdateTableSchemaAssignmentConflict() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdateSchema update = table.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        UpdateSchema concurrent = catalog.loadTable(TABLE).updateSchema().addColumn("another_col", (Type)Types.StringType.get());
        Schema expected = (Schema)concurrent.apply();
        concurrent.commit();
        String expectedMessage = this.supportsServerSideRetry() ? "Requirement failed: last assigned field id changed" : "Cannot commit";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UpdateSchema)update).commit()).isInstanceOf(CommitFailedException.class)).hasMessageContaining(expectedMessage);
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected schema", (Object)expected.asStruct(), (Object)loaded.schema().asStruct());
    }

    @Test
    public void testUpdateTableSchemaThenRevert() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        table.updateSchema().addColumn("col1", (Type)Types.StringType.get()).addColumn("col2", (Type)Types.StringType.get()).addColumn("col3", (Type)Types.StringType.get()).commit();
        table.updateSchema().deleteColumn("col1").deleteColumn("col2").deleteColumn("col3").commit();
        Assert.assertEquals((String)"Loaded table should have expected schema", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
    }

    @Test
    public void testUpdateTableSpec() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdatePartitionSpec update = table.updateSpec().addField("shard", (Term)Expressions.bucket((String)"id", (int)16));
        PartitionSpec expected = (PartitionSpec)update.apply();
        update.commit();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected spec", (Object)expected.fields(), (Object)loaded.spec().fields());
    }

    @Test
    public void testUpdateTableSpecServerSideRetry() {
        Assume.assumeTrue((String)"Spec update recovery is only supported with server-side retry", (boolean)this.supportsServerSideRetry());
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdatePartitionSpec update = table.updateSpec().addField("shard", (Term)Expressions.bucket((String)"id", (int)16));
        PartitionSpec expected = (PartitionSpec)update.apply();
        catalog.loadTable(TABLE).updateSchema().addColumn("another_col", (Type)Types.StringType.get()).commit();
        update.commit();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected spec", (Object)expected.fields(), (Object)loaded.spec().fields());
    }

    @Test
    public void testUpdateTableSpecConflict() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).create();
        UpdatePartitionSpec update = table.updateSpec().addField("shard", (Term)Expressions.bucket((String)"data", (int)16));
        UpdatePartitionSpec concurrent = catalog.loadTable(TABLE).updateSpec().removeField((Term)Expressions.bucket((String)"id", (int)16));
        PartitionSpec expected = (PartitionSpec)concurrent.apply();
        concurrent.commit();
        String expectedMessage = this.supportsServerSideRetry() ? "Requirement failed: default partition spec changed" : "Cannot commit";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UpdatePartitionSpec)update).commit()).isInstanceOf(CommitFailedException.class)).hasMessageContaining(expectedMessage);
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected spec", (Object)expected.fields(), (Object)loaded.spec().fields());
    }

    @Test
    public void testUpdateTableAssignmentSpecConflict() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        UpdatePartitionSpec update = table.updateSpec().addField("shard", (Term)Expressions.bucket((String)"id", (int)16));
        UpdatePartitionSpec concurrent = catalog.loadTable(TABLE).updateSpec().addField("shard", (Term)Expressions.truncate((String)"id", (int)100));
        PartitionSpec expected = (PartitionSpec)concurrent.apply();
        concurrent.commit();
        String expectedMessage = this.supportsServerSideRetry() ? "Requirement failed: last assigned partition id changed" : "Cannot commit";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UpdatePartitionSpec)update).commit()).isInstanceOf(CommitFailedException.class)).hasMessageContaining(expectedMessage);
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected spec", (Object)expected.fields(), (Object)loaded.spec().fields());
    }

    @Test
    public void testUpdateTableSpecThenRevert() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).withProperty("format-version", "2").create();
        Assert.assertEquals((String)"Should be a v2 table", (long)2L, (long)((BaseTable)table).operations().current().formatVersion());
        table.updateSpec().addField("id").commit();
        table.updateSpec().removeField("id").commit();
        Assert.assertEquals((String)"Loaded table should have expected spec", (Object)TABLE_SPEC, (Object)table.spec());
    }

    @Test
    public void testUpdateTableSortOrder() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        ReplaceSortOrder update = (ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id");
        SortOrder expected = (SortOrder)update.apply();
        update.commit();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected order", (Object)expected.fields(), (Object)loaded.sortOrder().fields());
    }

    @Test
    public void testUpdateTableSortOrderServerSideRetry() {
        Assume.assumeTrue((String)"Sort order update recovery is only supported with server-side retry", (boolean)this.supportsServerSideRetry());
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        ReplaceSortOrder update = (ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id");
        SortOrder expected = (SortOrder)update.apply();
        catalog.loadTable(TABLE).updateSchema().addColumn("another_col", (Type)Types.StringType.get()).commit();
        update.commit();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected order", (Object)expected.fields(), (Object)loaded.sortOrder().fields());
    }

    @Test
    public void testUpdateTableOrderThenRevert() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).withSortOrder(WRITE_ORDER).create();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).commit();
        Assert.assertEquals((String)"Loaded table should have expected order", (Object)TABLE_WRITE_ORDER, (Object)table.sortOrder());
    }

    @Test
    public void testAppend() throws IOException {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).create();
        try (CloseableIterable tasks = table.newScan().planFiles();){
            Assert.assertFalse((String)"Should contain no files", (boolean)tasks.iterator().hasNext());
        }
        table.newFastAppend().appendFile(FILE_A).commit();
        this.assertFiles(table, FILE_A);
    }

    @Test
    public void testConcurrentAppendEmptyTable() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).create();
        this.assertNoFiles(table);
        AppendFiles append = table.newFastAppend().appendFile(FILE_A);
        append.apply();
        catalog.loadTable(TABLE).newFastAppend().appendFile(FILE_B).commit();
        this.assertFiles(catalog.loadTable(TABLE), FILE_B);
        append.commit();
        this.assertFiles(catalog.loadTable(TABLE), FILE_A, FILE_B);
    }

    @Test
    public void testConcurrentAppendNonEmptyTable() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).create();
        this.assertNoFiles(table);
        catalog.loadTable(TABLE).newFastAppend().appendFile(FILE_C).commit();
        AppendFiles append = table.newFastAppend().appendFile(FILE_A);
        append.apply();
        catalog.loadTable(TABLE).newFastAppend().appendFile(FILE_B).commit();
        this.assertFiles(catalog.loadTable(TABLE), FILE_B, FILE_C);
        append.commit();
        this.assertFiles(catalog.loadTable(TABLE), FILE_A, FILE_B, FILE_C);
    }

    @Test
    public void testUpdateTransaction() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        Transaction transaction = table.newTransaction();
        UpdateSchema updateSchema = transaction.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        Schema expectedSchema = (Schema)updateSchema.apply();
        updateSchema.commit();
        UpdatePartitionSpec updateSpec = transaction.updateSpec().addField("shard", (Term)Expressions.bucket((String)"id", (int)16));
        PartitionSpec expectedSpec = (PartitionSpec)updateSpec.apply();
        updateSpec.commit();
        transaction.commitTransaction();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Loaded table should have expected schema", (Object)expectedSchema.asStruct(), (Object)loaded.schema().asStruct());
        Assert.assertEquals((String)"Loaded table should have expected spec", (Object)expectedSpec.fields(), (Object)loaded.spec().fields());
        this.assertPreviousMetadataFileCount(loaded, 1);
    }

    @Test
    public void testCreateTransaction() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction create = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        create.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        create.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        Table table = catalog.loadTable(TABLE);
        this.assertFiles(table, FILE_A);
        this.assertPreviousMetadataFileCount(table, 0);
    }

    @Test
    public void testCompleteCreateTransaction() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19");
        Transaction create = catalog.buildTable(TABLE, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).createTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        create.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        create.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Table should have create partition spec", (Object)TABLE_SPEC.fields(), (Object)table.spec().fields());
        Assert.assertEquals((String)"Table should have create sort order", (Object)TABLE_WRITE_ORDER, (Object)table.sortOrder());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), table.properties().entrySet()));
        if (!this.overridesRequestedLocation()) {
            Assert.assertEquals((String)"Table location should match requested", (Object)"file:/tmp/ns/table", (Object)table.location());
        }
        this.assertFiles(table, FILE_A);
        this.assertFilesPartitionSpec(table);
        this.assertPreviousMetadataFileCount(table, 0);
    }

    @Test
    public void testCompleteCreateTransactionMultipleSchemas() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19");
        Transaction create = catalog.buildTable(TABLE, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).createTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        create.newFastAppend().appendFile(FILE_A).commit();
        UpdateSchema updateSchema = create.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        Schema newSchema = (Schema)updateSchema.apply();
        updateSchema.commit();
        UpdatePartitionSpec updateSpec = create.updateSpec().addField("new_col");
        PartitionSpec newSpec = (PartitionSpec)updateSpec.apply();
        updateSpec.commit();
        ReplaceSortOrder replaceSortOrder = (ReplaceSortOrder)create.replaceSortOrder().asc("new_col");
        SortOrder newSortOrder = (SortOrder)replaceSortOrder.apply();
        replaceSortOrder.commit();
        DataFile anotherFile = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("id_bucket=0/new_col=0").withRecordCount(2L).build();
        create.newFastAppend().appendFile(anotherFile).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        create.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        Table table = catalog.loadTable(TABLE);
        boolean initialSchemaId = false;
        boolean initialSpecId = false;
        boolean initialOrderId = true;
        boolean updateSchemaId = true;
        boolean updateSpecId = true;
        int updateOrderId = 2;
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)newSchema.asStruct(), (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Table schema should match the new schema ID", (long)1L, (long)table.schema().schemaId());
        Assert.assertEquals((String)"Table should have updated partition spec", (Object)newSpec.fields(), (Object)table.spec().fields());
        Assert.assertEquals((String)"Table should have updated partition spec ID", (long)1L, (long)table.spec().specId());
        Assert.assertEquals((String)"Table should have updated sort order", (Object)newSortOrder.fields(), (Object)table.sortOrder().fields());
        Assert.assertEquals((String)"Table should have updated sort order ID", (long)2L, (long)table.sortOrder().orderId());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), table.properties().entrySet()));
        if (!this.overridesRequestedLocation()) {
            Assert.assertEquals((String)"Table location should match requested", (Object)"file:/tmp/ns/table", (Object)table.location());
        }
        this.assertFiles(table, FILE_A, anotherFile);
        this.assertFilePartitionSpec(table, FILE_A, 0);
        this.assertFilePartitionSpec(table, anotherFile, 1);
        this.assertPreviousMetadataFileCount(table, 0);
    }

    @Test
    public void testCompleteCreateTransactionV2() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19", (Object)"format-version", (Object)"2");
        Transaction create = catalog.buildTable(TABLE, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).createTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        create.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        create.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        Table table = catalog.loadTable(TABLE);
        HashMap expectedProps = Maps.newHashMap((Map)properties);
        expectedProps.remove("format-version");
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Table should have create partition spec", (Object)TABLE_SPEC.fields(), (Object)table.spec().fields());
        Assert.assertEquals((String)"Table should have create sort order", (Object)TABLE_WRITE_ORDER, (Object)table.sortOrder());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", expectedProps.entrySet(), (Object)Sets.intersection(properties.entrySet(), table.properties().entrySet()));
        Assert.assertEquals((String)"Sequence number should start at 1 for v2 format", (long)1L, (long)table.currentSnapshot().sequenceNumber());
        if (!this.overridesRequestedLocation()) {
            Assert.assertEquals((String)"Table location should match requested", (Object)"file:/tmp/ns/table", (Object)table.location());
        }
        this.assertFiles(table, FILE_A);
        this.assertFilesPartitionSpec(table);
        this.assertPreviousMetadataFileCount(table, 0);
    }

    @Test
    public void testConcurrentCreateTransaction() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction create = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        create.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        catalog.buildTable(TABLE, OTHER_SCHEMA).create();
        Assertions.setMaxStackTraceElementsDisplayed((int)Integer.MAX_VALUE);
        String expectedMessage = this.supportsServerSideRetry() ? "Requirement failed: table already exists" : "Table already exists";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)create).commitTransaction()).isInstanceOf(AlreadyExistsException.class)).hasMessageStartingWith(expectedMessage);
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match concurrent create", (Object)OTHER_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        this.assertNoFiles(table);
    }

    @Test
    public void testCreateOrReplaceTransactionCreate() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction create = catalog.buildTable(TABLE, SCHEMA).createOrReplaceTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        create.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        create.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        Table table = catalog.loadTable(TABLE);
        this.assertFiles(table, FILE_A);
        this.assertPreviousMetadataFileCount(table, 0);
    }

    @Test
    public void testCompleteCreateOrReplaceTransactionCreate() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19");
        Transaction createOrReplace = catalog.buildTable(TABLE, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).createOrReplaceTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        createOrReplace.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        createOrReplace.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)TABLE_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertEquals((String)"Table should have create partition spec", (Object)TABLE_SPEC.fields(), (Object)table.spec().fields());
        Assert.assertEquals((String)"Table should have create sort order", (Object)TABLE_WRITE_ORDER, (Object)table.sortOrder());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), table.properties().entrySet()));
        if (!this.overridesRequestedLocation()) {
            Assert.assertEquals((String)"Table location should match requested", (Object)"file:/tmp/ns/table", (Object)table.location());
        }
        this.assertFiles(table, FILE_A);
        this.assertFilesPartitionSpec(table);
        this.assertPreviousMetadataFileCount(table, 0);
    }

    @Test
    public void testCreateOrReplaceReplaceTransactionReplace() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table original = catalog.buildTable(TABLE, OTHER_SCHEMA).create();
        Assert.assertTrue((String)"Table should exist before replaceTransaction", (boolean)catalog.tableExists(TABLE));
        Transaction createOrReplace = catalog.buildTable(TABLE, SCHEMA).createOrReplaceTransaction();
        Assert.assertTrue((String)"Table should still exist after replaceTransaction", (boolean)catalog.tableExists(TABLE));
        createOrReplace.newFastAppend().appendFile(FILE_A).commit();
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match concurrent create", (Object)OTHER_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        this.assertUUIDsMatch(original, table);
        this.assertNoFiles(table);
        createOrReplace.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        table.refresh();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)REPLACE_SCHEMA.asStruct(), (Object)loaded.schema().asStruct());
        this.assertUUIDsMatch(original, loaded);
        this.assertFiles(loaded, FILE_A);
        this.assertPreviousMetadataFileCount(loaded, 1);
    }

    @Test
    public void testCompleteCreateOrReplaceTransactionReplace() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table original = catalog.buildTable(TABLE, OTHER_SCHEMA).create();
        Assert.assertTrue((String)"Table should exist before replaceTransaction", (boolean)catalog.tableExists(TABLE));
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19");
        Transaction createOrReplace = catalog.buildTable(TABLE, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).createOrReplaceTransaction();
        Assert.assertTrue((String)"Table should still exist after replaceTransaction", (boolean)catalog.tableExists(TABLE));
        createOrReplace.newFastAppend().appendFile(FILE_A).commit();
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match concurrent create", (Object)OTHER_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertTrue((String)"Table should be unpartitioned", (boolean)table.spec().isUnpartitioned());
        Assert.assertTrue((String)"Table should be unsorted", (boolean)table.sortOrder().isUnsorted());
        Assert.assertNotEquals((String)"Created at should not match", table.properties().get("created-at"), (Object)"2022-02-25T00:38:19");
        this.assertUUIDsMatch(original, table);
        this.assertNoFiles(table);
        createOrReplace.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        table.refresh();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)REPLACE_SCHEMA.asStruct(), (Object)loaded.schema().asStruct());
        Assert.assertEquals((String)"Table should have replace partition spec", (Object)REPLACE_SPEC, (Object)loaded.spec());
        Assert.assertEquals((String)"Table should have replace sort order", (Object)REPLACE_WRITE_ORDER, (Object)loaded.sortOrder());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), loaded.properties().entrySet()));
        if (!this.overridesRequestedLocation()) {
            Assert.assertEquals((String)"Table location should be replaced", (Object)"file:/tmp/ns/table", (Object)table.location());
        }
        this.assertUUIDsMatch(original, loaded);
        this.assertFiles(loaded, FILE_A);
        this.assertPreviousMetadataFileCount(loaded, 1);
    }

    @Test
    public void testCreateOrReplaceTransactionConcurrentCreate() {
        Assume.assumeTrue((String)"Conversion to replace transaction is not supported by REST catalog", (boolean)this.supportsServerSideRetry());
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction createOrReplace = catalog.buildTable(TABLE, SCHEMA).createOrReplaceTransaction();
        Assert.assertFalse((String)"Table should not exist after createTransaction", (boolean)catalog.tableExists(TABLE));
        createOrReplace.newFastAppend().appendFile(FILE_A).commit();
        Assert.assertFalse((String)"Table should not exist after append commit", (boolean)catalog.tableExists(TABLE));
        catalog.buildTable(TABLE, OTHER_SCHEMA).create();
        String expectedMessage = this.supportsServerSideRetry() ? "Requirement failed: table already exists" : "Table already exists";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)createOrReplace).commitTransaction()).isInstanceOf(AlreadyExistsException.class)).hasMessage(expectedMessage);
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match concurrent create", (Object)OTHER_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        this.assertNoFiles(table);
    }

    @Test
    public void testReplaceTransaction() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table original = catalog.buildTable(TABLE, OTHER_SCHEMA).create();
        Assert.assertTrue((String)"Table should exist before replaceTransaction", (boolean)catalog.tableExists(TABLE));
        Transaction replace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        Assert.assertTrue((String)"Table should still exist after replaceTransaction", (boolean)catalog.tableExists(TABLE));
        replace.newFastAppend().appendFile(FILE_A).commit();
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match concurrent create", (Object)OTHER_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        this.assertUUIDsMatch(original, table);
        this.assertNoFiles(table);
        replace.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        table.refresh();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)REPLACE_SCHEMA.asStruct(), (Object)loaded.schema().asStruct());
        this.assertUUIDsMatch(original, loaded);
        this.assertFiles(loaded, FILE_A);
        this.assertPreviousMetadataFileCount(loaded, 1);
    }

    @Test
    public void testCompleteReplaceTransaction() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table original = catalog.buildTable(TABLE, OTHER_SCHEMA).create();
        Assert.assertTrue((String)"Table should exist before replaceTransaction", (boolean)catalog.tableExists(TABLE));
        ImmutableMap properties = ImmutableMap.of((Object)"user", (Object)"someone", (Object)"created-at", (Object)"2022-02-25T00:38:19");
        Transaction replace = catalog.buildTable(TABLE, SCHEMA).withLocation("file:/tmp/ns/table").withPartitionSpec(SPEC).withSortOrder(WRITE_ORDER).withProperties((Map)properties).replaceTransaction();
        Assert.assertTrue((String)"Table should still exist after replaceTransaction", (boolean)catalog.tableExists(TABLE));
        replace.newFastAppend().appendFile(FILE_A).commit();
        Table table = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match concurrent create", (Object)OTHER_SCHEMA.asStruct(), (Object)table.schema().asStruct());
        Assert.assertTrue((String)"Table should be unpartitioned", (boolean)table.spec().isUnpartitioned());
        Assert.assertTrue((String)"Table should be unsorted", (boolean)table.sortOrder().isUnsorted());
        Assert.assertNotEquals((String)"Created at should not match", table.properties().get("created-at"), (Object)"2022-02-25T00:38:19");
        this.assertUUIDsMatch(original, table);
        this.assertNoFiles(table);
        replace.commitTransaction();
        Assert.assertTrue((String)"Table should exist after append commit", (boolean)catalog.tableExists(TABLE));
        table.refresh();
        Table loaded = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)REPLACE_SCHEMA.asStruct(), (Object)loaded.schema().asStruct());
        Assert.assertEquals((String)"Table should have replace partition spec", (Object)REPLACE_SPEC, (Object)loaded.spec());
        Assert.assertEquals((String)"Table should have replace sort order", (Object)REPLACE_WRITE_ORDER, (Object)loaded.sortOrder());
        Assert.assertEquals((String)"Table properties should be a superset of the requested properties", properties.entrySet(), (Object)Sets.intersection(properties.entrySet(), loaded.properties().entrySet()));
        if (!this.overridesRequestedLocation()) {
            Assert.assertEquals((String)"Table location should be replaced", (Object)"file:/tmp/ns/table", (Object)table.location());
        }
        this.assertUUIDsMatch(original, loaded);
        this.assertFiles(loaded, FILE_A);
        this.assertPreviousMetadataFileCount(loaded, 1);
    }

    @Test
    public void testReplaceTransactionRequiresTableExists() {
        Object catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.buildTable(TABLE, SCHEMA).replaceTransaction()).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: newdb.table");
    }

    @Test
    public void testConcurrentReplaceTransactions() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the original schema", (Object)original.schema().asStruct(), (Object)afterFirstReplace.schema().asStruct());
        Assert.assertTrue((String)"Table should be unpartitioned", (boolean)afterFirstReplace.spec().isUnpartitioned());
        Assert.assertTrue((String)"Table should be unsorted", (boolean)afterFirstReplace.sortOrder().isUnsorted());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        secondReplace.commitTransaction();
        Table afterSecondReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the original schema", (Object)original.schema().asStruct(), (Object)afterSecondReplace.schema().asStruct());
        Assert.assertTrue((String)"Table should be unpartitioned", (boolean)afterSecondReplace.spec().isUnpartitioned());
        Assert.assertTrue((String)"Table should be unsorted", (boolean)afterSecondReplace.sortOrder().isUnsorted());
        this.assertUUIDsMatch(original, afterSecondReplace);
        this.assertFiles(afterSecondReplace, FILE_C);
    }

    @Test
    public void testConcurrentReplaceTransactionSchema() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, OTHER_SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, OTHER_SCHEMA).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)REPLACE_SCHEMA.asStruct(), (Object)afterFirstReplace.schema().asStruct());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        secondReplace.commitTransaction();
        Table afterSecondReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the original schema", (Object)original.schema().asStruct(), (Object)afterSecondReplace.schema().asStruct());
        this.assertUUIDsMatch(original, afterSecondReplace);
        this.assertFiles(afterSecondReplace, FILE_C);
    }

    @Test
    public void testConcurrentReplaceTransactionSchema2() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, OTHER_SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, OTHER_SCHEMA).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the original schema", (Object)original.schema().asStruct(), (Object)afterFirstReplace.schema().asStruct());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        secondReplace.commitTransaction();
        Table afterSecondReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the new schema", (Object)REPLACE_SCHEMA.asStruct(), (Object)afterSecondReplace.schema().asStruct());
        this.assertUUIDsMatch(original, afterSecondReplace);
        this.assertFiles(afterSecondReplace, FILE_C);
    }

    @Test
    public void testConcurrentReplaceTransactionSchemaConflict() {
        Assume.assumeTrue((String)"Schema conflicts are detected server-side", (boolean)this.supportsServerSideRetry());
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, OTHER_SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table schema should match the original schema", (Object)REPLACE_SCHEMA.asStruct(), (Object)afterFirstReplace.schema().asStruct());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)secondReplace).commitTransaction()).isInstanceOf(CommitFailedException.class)).hasMessageStartingWith("Commit failed: Requirement failed: last assigned field id changed");
    }

    @Test
    public void testConcurrentReplaceTransactionPartitionSpec() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table spec should match the new spec", (Object)TABLE_SPEC.fields(), (Object)afterFirstReplace.spec().fields());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        secondReplace.commitTransaction();
        Table afterSecondReplace = catalog.loadTable(TABLE);
        Assert.assertTrue((String)"Table should be unpartitioned", (boolean)afterSecondReplace.spec().isUnpartitioned());
        this.assertUUIDsMatch(original, afterSecondReplace);
        this.assertFiles(afterSecondReplace, FILE_C);
    }

    @Test
    public void testConcurrentReplaceTransactionPartitionSpec2() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertTrue((String)"Table should be unpartitioned", (boolean)afterFirstReplace.spec().isUnpartitioned());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        secondReplace.commitTransaction();
        Table afterSecondReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table spec should match the new spec", (Object)TABLE_SPEC.fields(), (Object)afterSecondReplace.spec().fields());
        this.assertUUIDsMatch(original, afterSecondReplace);
        this.assertFiles(afterSecondReplace, FILE_C);
    }

    @Test
    public void testConcurrentReplaceTransactionPartitionSpecConflict() {
        Assume.assumeTrue((String)"Spec conflicts are detected server-side", (boolean)this.supportsServerSideRetry());
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).withPartitionSpec(SPEC).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table spec should match the new spec", (Object)TABLE_SPEC.fields(), (Object)afterFirstReplace.spec().fields());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)secondReplace).commitTransaction()).isInstanceOf(CommitFailedException.class)).hasMessageStartingWith("Commit failed: Requirement failed: last assigned partition id changed");
    }

    @Test
    public void testConcurrentReplaceTransactionSortOrder() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).withSortOrder(WRITE_ORDER).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table order should match the new order", (Object)TABLE_WRITE_ORDER, (Object)afterFirstReplace.sortOrder());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        secondReplace.commitTransaction();
        Table afterSecondReplace = catalog.loadTable(TABLE);
        Assert.assertTrue((String)"Table should be unsorted", (boolean)afterSecondReplace.sortOrder().isUnsorted());
        this.assertUUIDsMatch(original, afterSecondReplace);
        this.assertFiles(afterSecondReplace, FILE_C);
    }

    @Test
    public void testConcurrentReplaceTransactionSortOrderConflict() {
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Transaction transaction = catalog.buildTable(TABLE, SCHEMA).createTransaction();
        transaction.newFastAppend().appendFile(FILE_A).commit();
        transaction.commitTransaction();
        Table original = catalog.loadTable(TABLE);
        this.assertFiles(original, FILE_A);
        Transaction secondReplace = catalog.buildTable(TABLE, SCHEMA).withSortOrder(WRITE_ORDER).replaceTransaction();
        secondReplace.newFastAppend().appendFile(FILE_C).commit();
        Transaction firstReplace = catalog.buildTable(TABLE, SCHEMA).withSortOrder(((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).desc((Term)Expressions.bucket((String)"id", (int)16))).desc("id")).build()).replaceTransaction();
        firstReplace.newFastAppend().appendFile(FILE_B).commit();
        firstReplace.commitTransaction();
        Table afterFirstReplace = catalog.loadTable(TABLE);
        Assert.assertTrue((String)"Table order should be set", (boolean)afterFirstReplace.sortOrder().isSorted());
        this.assertUUIDsMatch(original, afterFirstReplace);
        this.assertFiles(afterFirstReplace, FILE_B);
        secondReplace.commitTransaction();
        Table afterSecondReplace = catalog.loadTable(TABLE);
        Assert.assertEquals((String)"Table order should match the new order", (Object)TABLE_WRITE_ORDER.fields(), (Object)afterSecondReplace.sortOrder().fields());
        this.assertUUIDsMatch(original, afterSecondReplace);
        this.assertFiles(afterSecondReplace, FILE_C);
    }

    @Test
    public void testMetadataFileLocationsRemovalAfterCommit() {
        int i;
        C catalog = this.catalog();
        if (this.requiresNamespaceCreate()) {
            ((SupportsNamespaces)catalog).createNamespace(NS);
        }
        Table table = catalog.buildTable(TABLE, SCHEMA).create();
        table.updateSchema().addColumn("a", (Type)Types.LongType.get()).commit();
        table.updateSchema().addColumn("b", (Type)Types.LongType.get()).commit();
        table.updateSchema().addColumn("c", (Type)Types.LongType.get()).commit();
        Set metadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false);
        Assertions.assertThat((Collection)metadataFileLocations).hasSize(4);
        int maxPreviousVersionsToKeep = 2;
        table.updateProperties().set("write.metadata.delete-after-commit.enabled", "true").set("write.metadata.previous-versions-max", Integer.toString(maxPreviousVersionsToKeep)).commit();
        metadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false);
        Assertions.assertThat((Collection)metadataFileLocations).hasSize(maxPreviousVersionsToKeep + 1);
        for (i = 1; i <= 5; ++i) {
            table.updateSchema().addColumn("d" + i, (Type)Types.LongType.get()).commit();
            metadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false);
            Assertions.assertThat((Collection)metadataFileLocations).hasSize(maxPreviousVersionsToKeep + 1);
        }
        maxPreviousVersionsToKeep = 4;
        table.updateProperties().set("write.metadata.previous-versions-max", Integer.toString(maxPreviousVersionsToKeep)).commit();
        for (i = 1; i <= 10; ++i) {
            table.updateSchema().addColumn("e" + i, (Type)Types.LongType.get()).commit();
            metadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false);
            Assertions.assertThat((Collection)metadataFileLocations).hasSize(maxPreviousVersionsToKeep + 1);
        }
    }

    @Test
    public void tableCreationWithoutNamespace() {
        Assumptions.assumeTrue((boolean)this.requiresNamespaceCreate());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog().buildTable(TableIdentifier.of((String[])new String[]{"non-existing", "table"}), SCHEMA).create()).isInstanceOf(NoSuchNamespaceException.class)).hasMessageEndingWith("Namespace does not exist: non-existing");
    }

    private static void assertEmpty(String context, Catalog catalog, Namespace ns) {
        try {
            Assert.assertEquals((String)context, (long)0L, (long)catalog.listTables(ns).size());
        }
        catch (NoSuchNamespaceException noSuchNamespaceException) {
            // empty catch block
        }
    }

    public void assertUUIDsMatch(Table expected, Table actual) {
        Assert.assertEquals((String)"Table UUID should not change", (Object)((BaseTable)expected).operations().current().uuid(), (Object)((BaseTable)actual).operations().current().uuid());
    }

    public void assertPreviousMetadataFileCount(Table table, int metadataFileCount) {
        TableOperations ops = ((BaseTable)table).operations();
        Assert.assertEquals((String)"Table should have correct number of previous metadata locations", (long)metadataFileCount, (long)ops.current().previousFiles().size());
    }

    public void assertNoFiles(Table table) {
        try (CloseableIterable tasks = table.newScan().planFiles();){
            Assert.assertFalse((String)"Should contain no files", (boolean)tasks.iterator().hasNext());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void assertFiles(Table table, DataFile ... files) {
        try (CloseableIterable tasks = table.newScan().planFiles();){
            List paths = Streams.stream((Iterable)tasks).map(ContentScanTask::file).map(ContentFile::path).collect(Collectors.toList());
            Assert.assertEquals((String)"Should contain expected number of data files", (long)files.length, (long)paths.size());
            Assert.assertEquals((String)"Should contain correct file paths", (Object)CharSequenceSet.of((Iterable)Iterables.transform(Arrays.asList(files), ContentFile::path)), (Object)CharSequenceSet.of(paths));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void assertFilePartitionSpec(Table table, DataFile dataFile, int specId) {
        try (CloseableIterable tasks = table.newScan().planFiles();){
            Streams.stream((Iterable)tasks).map(ContentScanTask::file).filter(file -> file.path().equals(dataFile.path())).forEach(file -> Assert.assertEquals((long)specId, (long)file.specId()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void assertFilesPartitionSpec(Table table) {
        try (CloseableIterable tasks = table.newScan().planFiles();){
            Streams.stream((Iterable)tasks).map(ContentScanTask::file).forEach(file -> Assert.assertEquals((long)table.spec().specId(), (long)file.specId()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<Namespace> concat(List<Namespace> starting, Namespace ... additional) {
        ArrayList namespaces = Lists.newArrayList();
        namespaces.addAll(starting);
        namespaces.addAll(Arrays.asList(additional));
        return namespaces;
    }
}

