/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroTestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaConversions {
    @Test
    public void testPrimitiveTypes() {
        ArrayList primitives = Lists.newArrayList((Object[])new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)12), Types.BinaryType.get(), Types.DecimalType.of((int)9, (int)4)});
        ArrayList avroPrimitives = Lists.newArrayList((Object[])new org.apache.avro.Schema[]{org.apache.avro.Schema.create((Schema.Type)Schema.Type.BOOLEAN), org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT), org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG), org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT), org.apache.avro.Schema.create((Schema.Type)Schema.Type.DOUBLE), LogicalTypes.date().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)), LogicalTypes.timeMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG)), this.addAdjustToUtc(LogicalTypes.timestampMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG)), true), this.addAdjustToUtc(LogicalTypes.timestampMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG)), false), org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING), LogicalTypes.uuid().addToSchema(org.apache.avro.Schema.createFixed((String)"uuid_fixed", null, null, (int)16)), org.apache.avro.Schema.createFixed((String)"fixed_12", null, null, (int)12), org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES), LogicalTypes.decimal((int)9, (int)4).addToSchema(org.apache.avro.Schema.createFixed((String)"decimal_9_4", null, null, (int)4))});
        for (int i = 0; i < primitives.size(); ++i) {
            Type type = (Type)primitives.get(i);
            org.apache.avro.Schema avro = (org.apache.avro.Schema)avroPrimitives.get(i);
            Assert.assertEquals((String)("Avro schema to primitive: " + avro), (Object)type, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)avro));
            Assert.assertEquals((String)("Primitive to avro schema: " + type), (Object)avro, (Object)AvroSchemaUtil.convert((Type)type));
        }
    }

    @Test
    public void testAvroToIcebergTimestampTypeWithoutAdjustToUTC() {
        Types.TimestampType expectedIcebergType = Types.TimestampType.withoutZone();
        org.apache.avro.Schema avroType = LogicalTypes.timestampMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG));
        Assert.assertEquals((Object)expectedIcebergType, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)avroType));
    }

    private org.apache.avro.Schema addAdjustToUtc(org.apache.avro.Schema schema, boolean adjustToUTC) {
        schema.addProp("adjust-to-utc", (Object)adjustToUTC);
        return schema;
    }

    @Test
    public void testStructAndPrimitiveTypes() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)20, (String)"bool", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)21, (String)"int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)22, (String)"long", (Type)Types.LongType.get()), Types.NestedField.optional((int)23, (String)"float", (Type)Types.FloatType.get()), Types.NestedField.optional((int)24, (String)"double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)25, (String)"date", (Type)Types.DateType.get()), Types.NestedField.optional((int)27, (String)"time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)28, (String)"timestamptz", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)29, (String)"timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)30, (String)"string", (Type)Types.StringType.get()), Types.NestedField.optional((int)31, (String)"uuid", (Type)Types.UUIDType.get()), Types.NestedField.optional((int)32, (String)"fixed", (Type)Types.FixedType.ofLength((int)16)), Types.NestedField.optional((int)33, (String)"binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)34, (String)"decimal", (Type)Types.DecimalType.of((int)14, (int)2))});
        org.apache.avro.Schema schema = AvroTestHelpers.record("primitives", AvroTestHelpers.optionalField(20, "bool", org.apache.avro.Schema.create((Schema.Type)Schema.Type.BOOLEAN)), AvroTestHelpers.optionalField(21, "int", org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)), AvroTestHelpers.optionalField(22, "long", org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG)), AvroTestHelpers.optionalField(23, "float", org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT)), AvroTestHelpers.optionalField(24, "double", org.apache.avro.Schema.create((Schema.Type)Schema.Type.DOUBLE)), AvroTestHelpers.optionalField(25, "date", LogicalTypes.date().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))), AvroTestHelpers.optionalField(27, "time", LogicalTypes.timeMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG))), AvroTestHelpers.optionalField(28, "timestamptz", this.addAdjustToUtc(LogicalTypes.timestampMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG)), true)), AvroTestHelpers.optionalField(29, "timestamp", this.addAdjustToUtc(LogicalTypes.timestampMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG)), false)), AvroTestHelpers.optionalField(30, "string", org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)), AvroTestHelpers.optionalField(31, "uuid", LogicalTypes.uuid().addToSchema(org.apache.avro.Schema.createFixed((String)"uuid_fixed", null, null, (int)16))), AvroTestHelpers.optionalField(32, "fixed", org.apache.avro.Schema.createFixed((String)"fixed_16", null, null, (int)16)), AvroTestHelpers.optionalField(33, "binary", org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES)), AvroTestHelpers.optionalField(34, "decimal", LogicalTypes.decimal((int)14, (int)2).addToSchema(org.apache.avro.Schema.createFixed((String)"decimal_14_2", null, null, (int)6))));
        Assert.assertEquals((String)"Test conversion from Avro schema", (Object)struct, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)schema));
        Assert.assertEquals((String)"Test conversion to Avro schema", (Object)schema, (Object)AvroSchemaUtil.convert((Types.StructType)struct, (String)"primitives"));
    }

    @Test
    public void testList() {
        Types.ListType list = Types.ListType.ofRequired((int)34, (Type)Types.UUIDType.get());
        org.apache.avro.Schema schema = AvroTestHelpers.addElementId(34, (org.apache.avro.Schema)SchemaBuilder.array().items(LogicalTypes.uuid().addToSchema(org.apache.avro.Schema.createFixed((String)"uuid_fixed", null, null, (int)16))));
        Assert.assertEquals((String)"Avro schema to list", (Object)list, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)schema));
        Assert.assertEquals((String)"List to Avro schema", (Object)schema, (Object)AvroSchemaUtil.convert((Type)list));
    }

    @Test
    public void testListOfStructs() {
        Types.ListType list = Types.ListType.ofRequired((int)34, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)35, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)36, (String)"long", (Type)Types.FloatType.get())}));
        org.apache.avro.Schema schema = AvroTestHelpers.addElementId(34, (org.apache.avro.Schema)SchemaBuilder.array().items(AvroTestHelpers.record("r34", AvroTestHelpers.requiredField(35, "lat", org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT)), AvroTestHelpers.requiredField(36, "long", org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT)))));
        Assert.assertEquals((String)"Avro schema to list", (Object)list, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)schema));
        Assert.assertEquals((String)"List to Avro schema", (Object)schema, (Object)AvroSchemaUtil.convert((Type)list));
    }

    @Test
    public void testMapOfLongToBytes() {
        Types.MapType map = Types.MapType.ofRequired((int)33, (int)34, (Type)Types.LongType.get(), (Type)Types.BinaryType.get());
        org.apache.avro.Schema schema = AvroSchemaUtil.createMap((int)33, (org.apache.avro.Schema)org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG), (int)34, (org.apache.avro.Schema)org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES));
        Assert.assertEquals((String)"Avro schema to map", (Object)map, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)schema));
        Assert.assertEquals((String)"Map to Avro schema", (Object)schema, (Object)AvroSchemaUtil.convert((Type)map));
    }

    @Test
    public void testMapOfStringToBytes() {
        Types.MapType map = Types.MapType.ofRequired((int)33, (int)34, (Type)Types.StringType.get(), (Type)Types.BinaryType.get());
        org.apache.avro.Schema schema = AvroTestHelpers.addKeyId(33, AvroTestHelpers.addValueId(34, (org.apache.avro.Schema)SchemaBuilder.map().values(org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES))));
        Assert.assertEquals((String)"Avro schema to map", (Object)map, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)schema));
        Assert.assertEquals((String)"Map to Avro schema", (Object)schema, (Object)AvroSchemaUtil.convert((Type)map));
    }

    @Test
    public void testMapOfListToStructs() {
        Types.MapType map = Types.MapType.ofRequired((int)33, (int)34, (Type)Types.ListType.ofRequired((int)35, (Type)Types.IntegerType.get()), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)36, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)37, (String)"b", (Type)Types.IntegerType.get())}));
        org.apache.avro.Schema schema = AvroSchemaUtil.createMap((int)33, (org.apache.avro.Schema)AvroTestHelpers.addElementId(35, org.apache.avro.Schema.createArray((org.apache.avro.Schema)org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))), (int)34, (org.apache.avro.Schema)AvroTestHelpers.record("r34", AvroTestHelpers.requiredField(36, "a", org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)), AvroTestHelpers.optionalField(37, "b", org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))));
        Assert.assertEquals((String)"Avro schema to map", (Object)map, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)schema));
        Assert.assertEquals((String)"Map to Avro schema", (Object)schema, (Object)AvroSchemaUtil.convert((Type)map));
    }

    @Test
    public void testMapOfStringToStructs() {
        Types.MapType map = Types.MapType.ofRequired((int)33, (int)34, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)35, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)36, (String)"b", (Type)Types.IntegerType.get())}));
        org.apache.avro.Schema schema = AvroTestHelpers.addKeyId(33, AvroTestHelpers.addValueId(34, (org.apache.avro.Schema)SchemaBuilder.map().values(AvroTestHelpers.record("r34", AvroTestHelpers.requiredField(35, "a", org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)), AvroTestHelpers.optionalField(36, "b", org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))))));
        Assert.assertEquals((String)"Avro schema to map", (Object)map, (Object)AvroSchemaUtil.convert((org.apache.avro.Schema)schema));
        Assert.assertEquals((String)"Map to Avro schema", (Object)schema, (Object)AvroSchemaUtil.convert((Type)map));
    }

    @Test
    public void testComplexSchema() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"preferences", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"feature2", (Type)Types.BooleanType.get())})), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.FloatType.get())}))), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y", (Type)Types.LongType.get())}))), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        AvroSchemaUtil.convert((Schema)schema, (String)"newTableName").toString(true);
    }

    @Test
    public void testSpecialChars() {
        ArrayList names = Lists.newArrayList((Object[])new String[]{"9x", "x_", "a.b", "\u2603", "a#b"});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)((String)names.get(0)), (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)((String)names.get(1)), (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)((String)names.get(2)), (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)((String)names.get(3)), (Type)Types.IntegerType.get()), Types.NestedField.required((int)5, (String)((String)names.get(4)), (Type)Types.IntegerType.get())});
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        ArrayList sanitizedNames = Lists.newArrayList((Iterable)Iterables.transform((Iterable)avroSchema.getFields(), Schema.Field::name));
        ArrayList expectedSanitizedNames = Lists.newArrayList((Object[])new String[]{"_9x", "x_", "a_x2Eb", "_x2603", "a_x23b"});
        Assert.assertEquals((Object)expectedSanitizedNames, (Object)sanitizedNames);
        ArrayList origNames = Lists.newArrayList((Iterable)Iterables.transform((Iterable)avroSchema.getFields(), f -> f.getProp("iceberg-field-name")));
        ArrayList expectedOrigNames = Lists.newArrayList((Iterable)names);
        expectedOrigNames.set(1, null);
        Assert.assertEquals((Object)expectedOrigNames, (Object)origNames);
    }

    @Test
    public void testFieldDocsArePreserved() {
        ArrayList fieldDocs = Lists.newArrayList((Object[])new String[]{null, "iceberg originating field doc"});
        Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)((String)fieldDocs.get(0))), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get(), (String)((String)fieldDocs.get(1)))});
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)icebergSchema.asStruct());
        ArrayList avroFieldDocs = Lists.newArrayList((Iterable)Iterables.transform((Iterable)avroSchema.getFields(), Schema.Field::doc));
        Assert.assertEquals((Object)avroFieldDocs, (Object)fieldDocs);
        Schema origSchema = AvroSchemaUtil.toIceberg((org.apache.avro.Schema)avroSchema);
        ArrayList origFieldDocs = Lists.newArrayList((Iterable)Iterables.transform((Iterable)origSchema.columns(), Types.NestedField::doc));
        Assert.assertEquals((Object)origFieldDocs, (Object)fieldDocs);
    }
}

