/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class TestReadProjection {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    protected abstract GenericData.Record writeAndRead(String var1, Schema var2, Schema var3, GenericData.Record var4) throws IOException;

    @Test
    public void testFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)schema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("data", (Object)"test");
        GenericData.Record projected = this.writeAndRead("full_projection", schema, schema, record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        int cmp = Comparators.charSequences().compare("test", (CharSequence)projected.get("data"));
        Assert.assertTrue((String)"Should contain the correct data value", (cmp == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReorderedFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)schema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("data", (Object)"test");
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("full_projection", schema, reordered, record);
        Assert.assertEquals((String)"Should contain the correct 0 value", (Object)"test", (Object)projected.get(0).toString());
        Assert.assertEquals((String)"Should contain the correct 1 value", (Object)34L, (Object)projected.get(1));
    }

    @Test
    public void testReorderedProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)schema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("data", (Object)"test");
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"missing_1", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"missing_2", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("full_projection", schema, reordered, record);
        Assert.assertNull((String)"Should contain the correct 0 value", (Object)projected.get(0));
        Assert.assertEquals((String)"Should contain the correct 1 value", (Object)"test", (Object)projected.get(1).toString());
        Assert.assertNull((String)"Should contain the correct 2 value", (Object)projected.get(2));
    }

    @Test
    public void testEmptyProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)schema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("data", (Object)"test");
        GenericData.Record projected = this.writeAndRead("empty_projection", schema, schema.select(new String[0]), record);
        Assert.assertNotNull((String)"Should read a non-null record", (Object)projected);
        Assertions.assertThatThrownBy(() -> projected.get(0)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testBasicProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("data", (Object)"test");
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("basic_projection_id", writeSchema, idOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"data");
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        Schema dataOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        projected = this.writeAndRead("basic_projection_data", writeSchema, dataOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        int cmp = Comparators.charSequences().compare("test", (CharSequence)projected.get("data"));
        Assert.assertEquals((String)"Should contain the correct data value", (long)0L, (long)cmp);
    }

    @Test
    public void testRename() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("data", (Object)"test");
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"renamed", (Type)Types.StringType.get())});
        GenericData.Record projected = this.writeAndRead("project_and_rename", writeSchema, readSchema, record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        int cmp = Comparators.charSequences().compare("test", (CharSequence)projected.get("renamed"));
        Assert.assertEquals((String)"Should contain the correct data/renamed value", (long)0L, (long)cmp);
    }

    @Test
    public void testNestedStructProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record location = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("location").schema()));
        location.put("lat", (Object)Float.valueOf(52.995144f));
        location.put("long", (Object)Float.valueOf(-1.539054f));
        record.put("location", (Object)location);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("id_only", writeSchema, idOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"location");
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        Schema latOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("latitude_only", writeSchema, latOnly, record);
        GenericData.Record projectedLocation = (GenericData.Record)projected.get("location");
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertNotNull((String)"Should project location", (Object)projected.get("location"));
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedLocation, (String)"long");
        Assert.assertEquals((String)"Should project latitude", (float)52.995144f, (float)((Float)projectedLocation.get("lat")).floatValue(), (float)1.0E-6f);
        Schema longOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("longitude_only", writeSchema, longOnly, record);
        projectedLocation = (GenericData.Record)projected.get("location");
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertNotNull((String)"Should project location", (Object)projected.get("location"));
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedLocation, (String)"lat");
        Assert.assertEquals((String)"Should project longitude", (float)-1.539054f, (float)((Float)projectedLocation.get("long")).floatValue(), (float)1.0E-6f);
        Schema locationOnly = writeSchema.select(new String[]{"location"});
        projected = this.writeAndRead("location_only", writeSchema, locationOnly, record);
        projectedLocation = (GenericData.Record)projected.get("location");
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertNotNull((String)"Should project location", (Object)projected.get("location"));
        Assert.assertEquals((String)"Should project latitude", (float)52.995144f, (float)((Float)projectedLocation.get("lat")).floatValue(), (float)1.0E-6f);
        Assert.assertEquals((String)"Should project longitude", (float)-1.539054f, (float)((Float)projectedLocation.get("long")).floatValue(), (float)1.0E-6f);
    }

    @Test
    public void testMapProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"properties", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        ImmutableMap properties = ImmutableMap.of((Object)"a", (Object)"A", (Object)"b", (Object)"B");
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("properties", (Object)properties);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("id_only", writeSchema, idOnly, record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"properties");
        Schema keyOnly = writeSchema.select(new String[]{"properties.key"});
        projected = this.writeAndRead("key_only", writeSchema, keyOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertEquals((String)"Should project entire map", (Object)properties, this.toStringMap((Map)projected.get("properties")));
        Schema valueOnly = writeSchema.select(new String[]{"properties.value"});
        projected = this.writeAndRead("value_only", writeSchema, valueOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertEquals((String)"Should project entire map", (Object)properties, this.toStringMap((Map)projected.get("properties")));
        Schema mapOnly = writeSchema.select(new String[]{"properties"});
        projected = this.writeAndRead("map_only", writeSchema, mapOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertEquals((String)"Should project entire map", (Object)properties, this.toStringMap((Map)projected.get("properties")));
    }

    private Map<String, ?> toStringMap(Map<?, ?> map) {
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof CharSequence) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            stringMap.put(entry.getKey().toString(), entry.getValue());
        }
        return stringMap;
    }

    @Test
    public void testMapOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record l1 = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("locations").schema()).getValueType()));
        l1.put("lat", (Object)Float.valueOf(53.99281f));
        l1.put("long", (Object)Float.valueOf(-1.542616f));
        GenericData.Record l2 = new GenericData.Record(l1.getSchema());
        l2.put("lat", (Object)Float.valueOf(52.995144f));
        l2.put("long", (Object)Float.valueOf(-1.539054f));
        record.put("locations", (Object)ImmutableMap.of((Object)"L1", (Object)l1, (Object)"L2", (Object)l2));
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("id_only", writeSchema, idOnly, record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"locations");
        projected = this.writeAndRead("all_locations", writeSchema, writeSchema.select(new String[]{"locations"}), record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertEquals((String)"Should project locations map", (Object)record.get("locations"), this.toStringMap((Map)projected.get("locations")));
        projected = this.writeAndRead("lat_only", writeSchema, writeSchema.select(new String[]{"locations.lat"}), record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Map<String, ?> locations = this.toStringMap((Map)projected.get("locations"));
        Assert.assertNotNull((String)"Should project locations map", locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)Sets.newHashSet((Object[])new String[]{"L1", "L2"}), locations.keySet());
        GenericData.Record projectedL1 = (GenericData.Record)locations.get("L1");
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertEquals((String)"L1 should contain lat", (double)53.9928092956543, (double)((Float)projectedL1.get("lat")).floatValue(), (double)1.0E-6);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL1, (String)"long");
        GenericData.Record projectedL2 = (GenericData.Record)locations.get("L2");
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertEquals((String)"L2 should contain lat", (double)52.99514389038086, (double)((Float)projectedL2.get("lat")).floatValue(), (double)1.0E-6);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL2, (String)"y");
        projected = this.writeAndRead("long_only", writeSchema, writeSchema.select(new String[]{"locations.long"}), record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        locations = this.toStringMap((Map)projected.get("locations"));
        Assert.assertNotNull((String)"Should project locations map", locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)Sets.newHashSet((Object[])new String[]{"L1", "L2"}), locations.keySet());
        projectedL1 = (GenericData.Record)locations.get("L1");
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL1, (String)"lat");
        Assert.assertEquals((String)"L1 should contain long", (double)-1.542616f, (double)((Float)projectedL1.get("long")).floatValue(), (double)1.0E-6);
        projectedL2 = (GenericData.Record)locations.get("L2");
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL2, (String)"lat");
        Assert.assertEquals((String)"L2 should contain long", (double)-1.539054036140442, (double)((Float)projectedL2.get("long")).floatValue(), (double)1.0E-6);
        Schema latitiudeRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"latitude", (Type)Types.FloatType.get())})))});
        projected = this.writeAndRead("latitude_renamed", writeSchema, latitiudeRenamed, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        locations = this.toStringMap((Map)projected.get("locations"));
        Assert.assertNotNull((String)"Should project locations map", locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)Sets.newHashSet((Object[])new String[]{"L1", "L2"}), locations.keySet());
        projectedL1 = (GenericData.Record)locations.get("L1");
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertEquals((String)"L1 should contain latitude", (double)53.9928092956543, (double)((Float)projectedL1.get("latitude")).floatValue(), (double)1.0E-6);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL1, (String)"lat");
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL1, (String)"long");
        projectedL2 = (GenericData.Record)locations.get("L2");
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertEquals((String)"L2 should contain latitude", (double)52.99514389038086, (double)((Float)projectedL2.get("latitude")).floatValue(), (double)1.0E-6);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL2, (String)"lat");
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedL2, (String)"long");
    }

    @Test
    public void testListProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"values", (Type)Types.ListType.ofOptional((int)11, (Type)Types.LongType.get()))});
        ImmutableList values = ImmutableList.of((Object)56L, (Object)57L, (Object)58L);
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("values", (Object)values);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("id_only", writeSchema, idOnly, record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"values");
        Schema elementOnly = writeSchema.select(new String[]{"values.element"});
        projected = this.writeAndRead("element_only", writeSchema, elementOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertEquals((String)"Should project entire list", (Object)values, (Object)projected.get("values"));
        Schema listOnly = writeSchema.select(new String[]{"values"});
        projected = this.writeAndRead("list_only", writeSchema, listOnly, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertEquals((String)"Should project entire list", (Object)values, (Object)projected.get("values"));
    }

    @Test
    public void testListOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())})))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record p1 = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("points").schema()).getElementType()));
        p1.put("x", (Object)1);
        p1.put("y", (Object)2);
        GenericData.Record p2 = new GenericData.Record(p1.getSchema());
        p2.put("x", (Object)3);
        p2.put("y", null);
        record.put("points", (Object)ImmutableList.of((Object)p1, (Object)p2));
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        GenericData.Record projected = this.writeAndRead("id_only", writeSchema, idOnly, record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.get("id")));
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"points");
        projected = this.writeAndRead("all_points", writeSchema, writeSchema.select(new String[]{"points"}), record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertEquals((String)"Should project points list", (Object)record.get("points"), (Object)projected.get("points"));
        projected = this.writeAndRead("x_only", writeSchema, writeSchema.select(new String[]{"points.x"}), record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertNotNull((String)"Should project points list", (Object)projected.get("points"));
        List points = (List)projected.get("points");
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        GenericData.Record projectedP1 = (GenericData.Record)points.get(0);
        Assert.assertEquals((String)"Should project x", (long)1L, (long)((Integer)projectedP1.get("x")).intValue());
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP1, (String)"y");
        GenericData.Record projectedP2 = (GenericData.Record)points.get(1);
        Assert.assertEquals((String)"Should project x", (long)3L, (long)((Integer)projectedP2.get("x")).intValue());
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP2, (String)"y");
        projected = this.writeAndRead("y_only", writeSchema, writeSchema.select(new String[]{"points.y"}), record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertNotNull((String)"Should project points list", (Object)projected.get("points"));
        points = (List)projected.get("points");
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        projectedP1 = (GenericData.Record)points.get(0);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP1, (String)"x");
        Assert.assertEquals((String)"Should project y", (long)2L, (long)((Integer)projectedP1.get("y")).intValue());
        projectedP2 = (GenericData.Record)points.get(1);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP2, (String)"x");
        Assert.assertEquals((String)"Should project null y", null, (Object)projectedP2.get("y"));
        Schema yRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"z", (Type)Types.IntegerType.get())})))});
        projected = this.writeAndRead("y_renamed", writeSchema, yRenamed, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        Assert.assertNotNull((String)"Should project points list", (Object)projected.get("points"));
        points = (List)projected.get("points");
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        projectedP1 = (GenericData.Record)points.get(0);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP1, (String)"x");
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP1, (String)"y");
        Assert.assertEquals((String)"Should project z", (long)2L, (long)((Integer)projectedP1.get("z")).intValue());
        projectedP2 = (GenericData.Record)points.get(1);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP2, (String)"x");
        AssertHelpers.assertEmptyAvroField((GenericRecord)projectedP2, (String)"y");
        Assert.assertNull((String)"Should project null z", (Object)projectedP2.get("z"));
    }

    @Test
    public void testEmptyStructProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record location = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("location").schema()));
        location.put("lat", (Object)Float.valueOf(52.995144f));
        location.put("long", (Object)Float.valueOf(-1.539054f));
        record.put("location", (Object)location);
        Schema emptyStruct = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))});
        GenericData.Record projected = this.writeAndRead("empty_proj", writeSchema, emptyStruct, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        GenericData.Record result = (GenericData.Record)projected.get("location");
        Assert.assertEquals((String)"location should be in the 0th position", (Object)result, (Object)projected.get(0));
        Assert.assertNotNull((String)"Should contain an empty record", (Object)result);
        AssertHelpers.assertEmptyAvroField((GenericRecord)result, (String)"lat");
        AssertHelpers.assertEmptyAvroField((GenericRecord)result, (String)"long");
    }

    @Test
    public void testEmptyStructRequiredProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record location = new GenericData.Record(record.getSchema().getField("location").schema());
        location.put("lat", (Object)Float.valueOf(52.995144f));
        location.put("long", (Object)Float.valueOf(-1.539054f));
        record.put("location", (Object)location);
        Schema emptyStruct = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))});
        GenericData.Record projected = this.writeAndRead("empty_req_proj", writeSchema, emptyStruct, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        GenericData.Record result = (GenericData.Record)projected.get("location");
        Assert.assertEquals((String)"location should be in the 0th position", (Object)result, (Object)projected.get(0));
        Assert.assertNotNull((String)"Should contain an empty record", (Object)result);
        AssertHelpers.assertEmptyAvroField((GenericRecord)result, (String)"lat");
        AssertHelpers.assertEmptyAvroField((GenericRecord)result, (String)"long");
    }

    @Test
    public void testRequiredEmptyStructInRequiredStruct() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get()), Types.NestedField.required((int)4, (String)"empty", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record location = new GenericData.Record(record.getSchema().getField("location").schema());
        location.put("lat", (Object)Float.valueOf(52.995144f));
        location.put("long", (Object)Float.valueOf(-1.539054f));
        record.put("location", (Object)location);
        Schema emptyStruct = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"empty", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))});
        GenericData.Record projected = this.writeAndRead("req_empty_req_proj", writeSchema, emptyStruct, record);
        Assert.assertEquals((String)"Should project id", (Object)34L, (Object)projected.get("id"));
        GenericData.Record result = (GenericData.Record)projected.get("location");
        Assert.assertEquals((String)"location should be in the 1st position", (Object)result, (Object)projected.get(1));
        Assert.assertNotNull((String)"Should contain an empty record", (Object)result);
        AssertHelpers.assertEmptyAvroField((GenericRecord)result, (String)"lat");
        AssertHelpers.assertEmptyAvroField((GenericRecord)result, (String)"long");
        Assert.assertNotNull((String)"Should project empty", (Object)result.getSchema().getField("empty"));
        Assert.assertNotNull((String)"Empty should not be null", (Object)result.get("empty"));
        Assert.assertEquals((String)"Empty should be empty", (long)0L, (long)((GenericData.Record)result.get("empty")).getSchema().getFields().size());
    }

    @Test
    public void testEmptyNestedStructProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"outer", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.optional((int)2, (String)"inner", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"lon", (Type)Types.FloatType.get())}))}))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record outer = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("outer").schema()));
        GenericData.Record inner = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)outer.getSchema().getField("inner").schema()));
        inner.put("lon", (Object)Float.valueOf(32.14f));
        outer.put("lat", (Object)Float.valueOf(52.995144f));
        outer.put("inner", (Object)inner);
        record.put("outer", (Object)outer);
        Schema emptyStruct = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"outer", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"inner", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))});
        GenericData.Record projected = this.writeAndRead("nested_empty_proj", writeSchema, emptyStruct, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        GenericData.Record outerResult = (GenericData.Record)projected.get("outer");
        Assert.assertEquals((String)"Outer should be in the 0th position", (Object)outerResult, (Object)projected.get(0));
        Assert.assertNotNull((String)"Should contain the outer record", (Object)outerResult);
        AssertHelpers.assertEmptyAvroField((GenericRecord)outerResult, (String)"lat");
        GenericData.Record innerResult = (GenericData.Record)outerResult.get("inner");
        Assert.assertEquals((String)"Inner should be in the 0th position", (Object)innerResult, (Object)outerResult.get(0));
        Assert.assertNotNull((String)"Should contain the inner record", (Object)innerResult);
        AssertHelpers.assertEmptyAvroField((GenericRecord)innerResult, (String)"lon");
    }

    @Test
    public void testEmptyNestedStructRequiredProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"outer", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"inner", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"lon", (Type)Types.FloatType.get())}))}))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record outer = new GenericData.Record(record.getSchema().getField("outer").schema());
        GenericData.Record inner = new GenericData.Record(outer.getSchema().getField("inner").schema());
        inner.put("lon", (Object)Float.valueOf(32.14f));
        outer.put("lat", (Object)Float.valueOf(52.995144f));
        outer.put("inner", (Object)inner);
        record.put("outer", (Object)outer);
        Schema emptyStruct = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"outer", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"inner", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))});
        GenericData.Record projected = this.writeAndRead("nested_empty_req_proj", writeSchema, emptyStruct, record);
        AssertHelpers.assertEmptyAvroField((GenericRecord)projected, (String)"id");
        GenericData.Record outerResult = (GenericData.Record)projected.get("outer");
        Assert.assertEquals((String)"Outer should be in the 0th position", (Object)outerResult, (Object)projected.get(0));
        Assert.assertNotNull((String)"Should contain the outer record", (Object)outerResult);
        AssertHelpers.assertEmptyAvroField((GenericRecord)outerResult, (String)"lat");
        GenericData.Record innerResult = (GenericData.Record)outerResult.get("inner");
        Assert.assertEquals((String)"Inner should be in the 0th position", (Object)innerResult, (Object)outerResult.get(0));
        Assert.assertNotNull((String)"Should contain the inner record", (Object)innerResult);
        AssertHelpers.assertEmptyAvroField((GenericRecord)innerResult, (String)"lon");
    }
}

