/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroDataTest;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroTestHelpers;
import org.apache.iceberg.avro.RandomAvroData;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class TestGenericAvro
extends AvroDataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        ArrayList rows;
        List<GenericData.Record> expected = RandomAvroData.generate(schema, 100, 0L);
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        try (FileAppender writer = Avro.write((OutputFile)outputFile).schema(schema).named("test").build();){
            for (GenericData.Record rec : expected) {
                writer.add((Object)rec);
            }
        }
        Object object = null;
        try (AvroIterable reader = Avro.read((InputFile)outputFile.toInputFile()).project(schema).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        for (int i = 0; i < expected.size(); ++i) {
            AvroTestHelpers.assertEquals(schema.asStruct(), expected.get(i), (GenericData.Record)rows.get(i));
        }
    }
}

