/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.iceberg.avro.BuildAvroProjection;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestBuildAvroProjection {
    @Test
    public void projectArrayWithElementSchemaUnchanged() {
        Types.ListType icebergType = Types.ListType.ofRequired((int)0, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"int1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"string1", (Type)Types.StringType.get())}));
        Schema expected = (Schema)((SchemaBuilder.ArrayBuilder)SchemaBuilder.array().prop("element-id", "0")).items((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"elem").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1").prop("field-id", "2")).type().nullable().stringType().noDefault().endRecord());
        BuildAvroProjection testSubject = new BuildAvroProjection((Type)icebergType, Collections.emptyMap());
        Supplier<Schema> supplier = () -> ((Schema)expected).getElementType();
        Schema actual = testSubject.array(expected, supplier);
        Assert.assertEquals((String)"Array projection produced undesired array schema", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"Unexpected element ID discovered on the projected array schema", (long)0L, (long)Integer.valueOf(actual.getProp("element-id")).intValue());
    }

    @Test
    public void projectArrayWithExtraFieldInElementSchema() {
        Types.ListType icebergType = Types.ListType.ofRequired((int)0, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"int1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"string1", (Type)Types.StringType.get())}));
        Schema extraField = (Schema)((SchemaBuilder.ArrayBuilder)SchemaBuilder.array().prop("element-id", "0")).items((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"elem").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1").prop("field-id", "2")).type().nullable().stringType().noDefault().name("float1").prop("field-id", "3")).type().nullable().floatType().noDefault().endRecord());
        Schema expected = (Schema)((SchemaBuilder.ArrayBuilder)SchemaBuilder.array().prop("element-id", "0")).items((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"elem").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1").prop("field-id", "2")).type().nullable().stringType().noDefault().endRecord());
        BuildAvroProjection testSubject = new BuildAvroProjection((Type)icebergType, Collections.emptyMap());
        Supplier<Schema> supplier = () -> ((Schema)expected).getElementType();
        Schema actual = testSubject.array(extraField, supplier);
        Assert.assertEquals((String)"Array projection produced undesired array schema", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"Unexpected element ID discovered on the projected array schema", (long)0L, (long)Integer.valueOf(actual.getProp("element-id")).intValue());
    }

    @Test
    public void projectArrayWithLessFieldInElementSchema() {
        Types.ListType icebergType = Types.ListType.ofRequired((int)0, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"int1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"string1", (Type)Types.StringType.get())}));
        Schema lessField = (Schema)((SchemaBuilder.ArrayBuilder)SchemaBuilder.array().prop("element-id", "0")).items((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"elem").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().endRecord());
        Schema expected = (Schema)((SchemaBuilder.ArrayBuilder)SchemaBuilder.array().prop("element-id", "0")).items((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"elem").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1_r").prop("field-id", "2")).type().nullable().stringType().noDefault().endRecord());
        BuildAvroProjection testSubject = new BuildAvroProjection((Type)icebergType, Collections.emptyMap());
        Supplier<Schema> supplier = () -> ((Schema)expected).getElementType();
        Schema actual = testSubject.array(lessField, supplier);
        Assert.assertEquals((String)"Array projection produced undesired array schema", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"Unexpected element ID discovered on the projected array schema", (long)0L, (long)Integer.valueOf(actual.getProp("element-id")).intValue());
    }

    @Test
    public void projectMapWithValueSchemaUnchanged() {
        Types.MapType icebergType = Types.MapType.ofRequired((int)0, (int)1, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"int1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"string1", (Type)Types.StringType.get())}));
        Schema expected = (Schema)((SchemaBuilder.MapBuilder)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("key-id", "0")).prop("value-id", "1")).values((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"value").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1").prop("field-id", "2")).type().nullable().stringType().noDefault().endRecord());
        BuildAvroProjection testSubject = new BuildAvroProjection((Type)icebergType, Collections.emptyMap());
        Supplier<Schema> supplier = () -> ((Schema)expected).getValueType();
        Schema actual = testSubject.map(expected, supplier);
        Assert.assertEquals((String)"Map projection produced undesired map schema", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"Unexpected key ID discovered on the projected map schema", (long)0L, (long)Integer.valueOf(actual.getProp("key-id")).intValue());
        Assert.assertEquals((String)"Unexpected value ID discovered on the projected map schema", (long)1L, (long)Integer.valueOf(actual.getProp("value-id")).intValue());
    }

    @Test
    public void projectMapWithExtraFieldInValueSchema() {
        Types.MapType icebergType = Types.MapType.ofRequired((int)0, (int)1, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"int1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"string1", (Type)Types.StringType.get())}));
        Schema extraField = (Schema)((SchemaBuilder.MapBuilder)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("key-id", "0")).prop("value-id", "1")).values((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"value").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1").prop("field-id", "2")).type().nullable().stringType().noDefault().name("float1").prop("field-id", "3")).type().nullable().floatType().noDefault().endRecord());
        Schema expected = (Schema)((SchemaBuilder.MapBuilder)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("key-id", "0")).prop("value-id", "1")).values((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"value").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1").prop("field-id", "2")).type().nullable().stringType().noDefault().endRecord());
        BuildAvroProjection testSubject = new BuildAvroProjection((Type)icebergType, Collections.emptyMap());
        Supplier<Schema> supplier = () -> ((Schema)expected).getValueType();
        Schema actual = testSubject.map(extraField, supplier);
        Assert.assertEquals((String)"Map projection produced undesired map schema", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"Unexpected key ID discovered on the projected map schema", (long)0L, (long)Integer.valueOf(actual.getProp("key-id")).intValue());
        Assert.assertEquals((String)"Unexpected value ID discovered on the projected map schema", (long)1L, (long)Integer.valueOf(actual.getProp("value-id")).intValue());
    }

    @Test
    public void projectMapWithLessFieldInValueSchema() {
        Types.MapType icebergType = Types.MapType.ofRequired((int)0, (int)1, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"int1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"string1", (Type)Types.StringType.get())}));
        Schema lessField = (Schema)((SchemaBuilder.MapBuilder)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("key-id", "0")).prop("value-id", "1")).values((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"value").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().endRecord());
        Schema expected = (Schema)((SchemaBuilder.MapBuilder)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("key-id", "0")).prop("value-id", "1")).values((Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"value").namespace("unit.test")).fields().name("int1").prop("field-id", "1")).type().nullable().intType().noDefault().name("string1_r2").prop("field-id", "2")).type().nullable().stringType().noDefault().endRecord());
        BuildAvroProjection testSubject = new BuildAvroProjection((Type)icebergType, Collections.emptyMap());
        Supplier<Schema> supplier = () -> ((Schema)expected).getValueType();
        Schema actual = testSubject.map(lessField, supplier);
        Assert.assertEquals((String)"Map projection produced undesired map schema", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"Unexpected key ID discovered on the projected map schema", (long)0L, (long)Integer.valueOf(actual.getProp("key-id")).intValue());
        Assert.assertEquals((String)"Unexpected value ID discovered on the projected map schema", (long)1L, (long)Integer.valueOf(actual.getProp("value-id")).intValue());
    }
}

