/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.Collections;
import org.apache.avro.SchemaBuilder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.types.Type;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroSchemaProjection {
    @Test
    public void projectWithListSchemaChanged() {
        org.apache.avro.Schema currentAvroSchema = (org.apache.avro.Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("unit.test")).fields().name("f1").type().nullable().array().items((org.apache.avro.Schema)SchemaBuilder.record((String)"elem").fields().name("f11").type().nullable().intType().noDefault().endRecord())).noDefault().endRecord();
        org.apache.avro.Schema updatedAvroSchema = (org.apache.avro.Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("unit.test")).fields().name("f1").type().nullable().array().items((org.apache.avro.Schema)SchemaBuilder.record((String)"elem").fields().name("f11").type().nullable().intType().noDefault().name("f12").type().nullable().stringType().noDefault().endRecord())).noDefault().endRecord();
        Schema currentIcebergSchema = AvroSchemaUtil.toIceberg((org.apache.avro.Schema)currentAvroSchema);
        org.apache.avro.Schema idAllocatedUpdatedAvroSchema = AvroSchemaUtil.convert((Type)AvroSchemaUtil.toIceberg((org.apache.avro.Schema)updatedAvroSchema).asStruct());
        org.apache.avro.Schema projectedAvroSchema = AvroSchemaUtil.buildAvroProjection((org.apache.avro.Schema)idAllocatedUpdatedAvroSchema, (Schema)currentIcebergSchema, Collections.emptyMap());
        Assert.assertFalse((String)"Result of buildAvroProjection is missing some IDs", (boolean)AvroSchemaUtil.missingIds((org.apache.avro.Schema)projectedAvroSchema));
    }

    @Test
    public void projectWithMapSchemaChanged() {
        org.apache.avro.Schema currentAvroSchema = (org.apache.avro.Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("unit.test")).fields().name("f1").type().nullable().map().values((org.apache.avro.Schema)SchemaBuilder.record((String)"elem").fields().name("f11").type().nullable().intType().noDefault().endRecord())).noDefault().endRecord();
        org.apache.avro.Schema updatedAvroSchema = (org.apache.avro.Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("unit.test")).fields().name("f1").type().nullable().map().values((org.apache.avro.Schema)SchemaBuilder.record((String)"elem").fields().name("f11").type().nullable().intType().noDefault().name("f12").type().nullable().stringType().noDefault().endRecord())).noDefault().endRecord();
        Schema currentIcebergSchema = AvroSchemaUtil.toIceberg((org.apache.avro.Schema)currentAvroSchema);
        org.apache.avro.Schema idAllocatedUpdatedAvroSchema = AvroSchemaUtil.convert((Type)AvroSchemaUtil.toIceberg((org.apache.avro.Schema)updatedAvroSchema).asStruct());
        org.apache.avro.Schema projectedAvroSchema = AvroSchemaUtil.buildAvroProjection((org.apache.avro.Schema)idAllocatedUpdatedAvroSchema, (Schema)currentIcebergSchema, Collections.emptyMap());
        Assert.assertFalse((String)"Result of buildAvroProjection is missing some IDs", (boolean)AvroSchemaUtil.missingIds((org.apache.avro.Schema)projectedAvroSchema));
    }
}

