/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.TestReadProjection;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroReadProjection
extends TestReadProjection {
    @Override
    protected GenericData.Record writeAndRead(String desc, Schema writeSchema, Schema readSchema, GenericData.Record record) throws IOException {
        File file = this.temp.newFile(desc + ".avro");
        file.delete();
        try (FileAppender appender = Avro.write((OutputFile)Files.localOutput((File)file)).schema(writeSchema).build();){
            appender.add((Object)record);
        }
        AvroIterable records = Avro.read((InputFile)Files.localInput((File)file)).project(readSchema).build();
        return (GenericData.Record)Iterables.getOnlyElement((Iterable)records);
    }

    @Test
    public void testAvroArrayAsLogicalMap() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"map", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.LongType.get(), (Type)Types.ListType.ofRequired((int)1, (Type)Types.LongType.get())))});
        ImmutableList values1 = ImmutableList.of((Object)101L, (Object)102L);
        ImmutableList values2 = ImmutableList.of((Object)201L, (Object)202L, (Object)203L);
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("map", (Object)ImmutableMap.of((Object)100L, (Object)values1, (Object)200L, (Object)values2));
        GenericData.Record projected = this.writeAndRead("full_projection", writeSchema, writeSchema, record);
        Assert.assertEquals((String)"Should contain correct value list", (Object)values1, ((Map)projected.get("map")).get(100L));
        Assert.assertEquals((String)"Should contain correct value list", (Object)values2, ((Map)projected.get("map")).get(200L));
    }
}

