/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroTestHelpers;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroOptionsWithNonNullDefaults {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void writeAndValidateOptionWithNonNullDefaultsPruning() throws IOException {
        ArrayList rows;
        org.apache.avro.Schema writeSchema = org.apache.avro.Schema.createRecord((String)"root", null, null, (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("field", org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{org.apache.avro.Schema.createArray((org.apache.avro.Schema)org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)), org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL)}), null, (Object)ImmutableList.of())));
        GenericData.Record record1 = new GenericData.Record(writeSchema);
        record1.put("field", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3));
        GenericData.Record record2 = new GenericData.Record(writeSchema);
        record2.put("field", null);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            writer.create(writeSchema, testFile);
            writer.append((Object)record1);
            writer.append((Object)record2);
        }
        ImmutableList expected = ImmutableList.of((Object)record1, (Object)record2);
        Schema readIcebergSchema = AvroSchemaUtil.toIceberg((org.apache.avro.Schema)writeSchema);
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)testFile)).project(readIcebergSchema).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            AvroTestHelpers.assertEquals(readIcebergSchema.asStruct(), (GenericData.Record)expected.get(i), (GenericData.Record)rows.get(i));
        }
    }

    @Test
    public void writeAndValidateOptionWithNonNullDefaultsEvolution() throws IOException {
        ArrayList rows;
        org.apache.avro.Schema writeSchema = org.apache.avro.Schema.createRecord((String)"root", null, null, (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("field", org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT), org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL)}), null, (Object)-1)));
        GenericData.Record record1 = new GenericData.Record(writeSchema);
        record1.put("field", (Object)1);
        GenericData.Record record2 = new GenericData.Record(writeSchema);
        record2.put("field", null);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            writer.create(writeSchema, testFile);
            writer.append((Object)record1);
            writer.append((Object)record2);
        }
        org.apache.avro.Schema readSchema = org.apache.avro.Schema.createRecord((String)"root", null, null, (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("field", org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG), org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL)}), null, (Object)-1L)));
        GenericData.Record expectedRecord1 = new GenericData.Record(readSchema);
        expectedRecord1.put("field", (Object)1L);
        GenericData.Record expectedRecord2 = new GenericData.Record(readSchema);
        expectedRecord2.put("field", null);
        ImmutableList expected = ImmutableList.of((Object)expectedRecord1, (Object)expectedRecord2);
        Schema readIcebergSchema = AvroSchemaUtil.toIceberg((org.apache.avro.Schema)readSchema);
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)testFile)).project(readIcebergSchema).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            AvroTestHelpers.assertEquals(readIcebergSchema.asStruct(), (GenericData.Record)expected.get(i), (GenericData.Record)rows.get(i));
        }
    }
}

