/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.RemoveIds;
import org.apache.iceberg.avro.TestAvroReadProjection;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroNameMapping
extends TestAvroReadProjection {
    @Test
    public void testMapProjections() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"location", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.optional((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record location = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("location").schema()).getValueType()));
        location.put("lat", (Object)Float.valueOf(52.995144f));
        location.put("long", (Object)Float.valueOf(-1.539054f));
        record.put("location", (Object)ImmutableMap.of((Object)"l1", (Object)location));
        NameMapping nameMapping = MappingUtil.create((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())}));
        Schema readSchema = writeSchema;
        GenericData.Record projected = this.writeAndRead(writeSchema, readSchema, record, nameMapping);
        Assert.assertNotNull((String)"Field missing from table mapping is renamed", (Object)projected.getSchema().getField("location_r5"));
        Assert.assertNull((String)"location field should not be read", (Object)projected.get("location_r5"));
        Assert.assertEquals((Object)34L, (Object)projected.get("id"));
        nameMapping = MappingUtil.create((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"location", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())})))}));
        projected = this.writeAndRead(writeSchema, readSchema, record, nameMapping);
        GenericData.Record projectedL1 = (GenericData.Record)((Map)projected.get("location")).get("l1");
        Assert.assertNotNull((String)"Field missing from table mapping is renamed", (Object)projectedL1.getSchema().getField("long_r2"));
        Assert.assertNull((String)"location.value.long, should not be read", (Object)projectedL1.get("long_r2"));
    }

    @Test
    public void testComplexMapKeys() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)5, (String)"location", (Type)Types.MapType.ofRequired((int)6, (int)7, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"k1", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"k2", (Type)Types.StringType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.optional((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        org.apache.avro.Schema locationSchema = record.getSchema().getField("location").schema();
        GenericData.Record locationElement = new GenericData.Record(locationSchema.getElementType());
        GenericData.Record locationKey = new GenericData.Record(locationElement.getSchema().getField("key").schema());
        GenericData.Record locationValue = new GenericData.Record(locationElement.getSchema().getField("value").schema());
        locationKey.put("k1", (Object)"k1");
        locationKey.put("k2", (Object)"k2");
        locationValue.put("lat", (Object)Float.valueOf(52.995144f));
        locationValue.put("long", (Object)Float.valueOf(-1.539054f));
        locationElement.put("key", (Object)locationKey);
        locationElement.put("value", (Object)locationValue);
        record.put("location", (Object)ImmutableList.of((Object)locationElement));
        NameMapping nameMapping = MappingUtil.create((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)5, (String)"location", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"k1", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"k2", (Type)Types.StringType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())})))}));
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)5, (String)"location", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"k1", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"k2", (Type)Types.StringType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.optional((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericData.Record projected = this.writeAndRead(writeSchema, readSchema, record, nameMapping);
        Map projectedLocation = (Map)projected.get("location");
        GenericData.Record projectedKey = (GenericData.Record)projectedLocation.keySet().iterator().next();
        GenericData.Record projectedValue = (GenericData.Record)projectedLocation.values().iterator().next();
        Assert.assertEquals((long)0L, (long)Comparators.charSequences().compare("k1", (CharSequence)projectedKey.get("k1")));
        Assert.assertEquals((long)0L, (long)Comparators.charSequences().compare("k2", (CharSequence)projectedKey.get("k2")));
        Assert.assertEquals((Object)Float.valueOf(52.995144f), (Object)projectedValue.get("lat"));
        Assert.assertNotNull((Object)projectedValue.getSchema().getField("long_r2"));
        Assert.assertNull((Object)projectedValue.get("long_r2"));
    }

    @Test
    public void testMissingRequiredFields() {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("x", (Object)1);
        record.put("y", (Object)2);
        NameMapping nameMapping = MappingUtil.create((Schema)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())}));
        Schema readSchema = writeSchema;
        AssertHelpers.assertThrows((String)"Missing required field in nameMapping", IllegalArgumentException.class, (String)"Missing required field: x", () -> this.writeAndRead(writeSchema, readSchema, record, nameMapping));
    }

    @Test
    public void testArrayProjections() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)22, (String)"point", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())})))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        GenericData.Record pointRecord = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("point").schema()).getElementType()));
        pointRecord.put("x", (Object)1);
        pointRecord.put("y", (Object)2);
        record.put("point", (Object)ImmutableList.of((Object)pointRecord));
        NameMapping nameMapping = MappingUtil.create((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())}));
        Schema readSchema = writeSchema;
        GenericData.Record projected = this.writeAndRead(writeSchema, readSchema, record, nameMapping);
        Assert.assertNotNull((String)"Field missing from table mapping is renamed", (Object)projected.getSchema().getField("point_r22"));
        Assert.assertNull((String)"point field is not projected", (Object)projected.get("point_r22"));
        Assert.assertEquals((Object)34L, (Object)projected.get("id"));
        nameMapping = MappingUtil.create((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)22, (String)"point", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get())})))}));
        projected = this.writeAndRead(writeSchema, readSchema, record, nameMapping);
        GenericData.Record point = (GenericData.Record)((List)projected.get("point")).get(0);
        Assert.assertNotNull((String)"Field missing from table mapping is renamed", (Object)point.getSchema().getField("y_r18"));
        Assert.assertEquals((String)"point.x is projected", (Object)1, (Object)point.get("x"));
        Assert.assertNull((String)"point.y is not projected", (Object)point.get("y_r18"));
        Assert.assertEquals((Object)34L, (Object)projected.get("id"));
    }

    @Test
    public void testAliases() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get())})))});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        GenericData.Record pointRecord = new GenericData.Record(AvroSchemaUtil.fromOption((org.apache.avro.Schema)AvroSchemaUtil.fromOption((org.apache.avro.Schema)record.getSchema().getField("points").schema()).getElementType()));
        pointRecord.put("x", (Object)1);
        record.put("points", (Object)ImmutableList.of((Object)pointRecord));
        NameMapping nameMapping = NameMapping.of((MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)22, (String)"points", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)21, (String)"element", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)19, (Iterable)Lists.newArrayList((Object[])new String[]{"x"}))}))}))}));
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"y", (Type)Types.IntegerType.get())})))});
        GenericData.Record projected = this.writeAndRead(writeSchema, readSchema, record, nameMapping);
        Assert.assertEquals((String)"x is read as y", (Object)1, (Object)((GenericData.Record)((List)projected.get("points")).get(0)).get("y"));
        readSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"z", (Type)Types.IntegerType.get())})))});
        projected = this.writeAndRead(writeSchema, readSchema, record, nameMapping);
        Assert.assertEquals((String)"x is read as z", (Object)1, (Object)((GenericData.Record)((List)projected.get("points")).get(0)).get("z"));
    }

    @Test
    public void testInferredMapping() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericData.Record record = new GenericData.Record(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
        record.put("id", (Object)34L);
        record.put("data", (Object)"data");
        Schema readSchema = writeSchema;
        GenericData.Record projected = this.writeAndRead(writeSchema, readSchema, record, null);
        Assert.assertEquals((Object)record, (Object)projected);
    }

    @Override
    @Test
    public void testAvroArrayAsLogicalMap() {
    }

    @Override
    protected GenericData.Record writeAndRead(String desc, Schema writeSchema, Schema readSchema, GenericData.Record inputRecord) throws IOException {
        GenericData.Record record = super.writeAndRead(desc, writeSchema, readSchema, inputRecord);
        GenericData.Record projectedWithNameMapping = this.writeAndRead(writeSchema, readSchema, inputRecord, MappingUtil.create((Schema)writeSchema));
        Assert.assertEquals((Object)record, (Object)projectedWithNameMapping);
        return record;
    }

    private GenericData.Record writeAndRead(Schema writeSchema, Schema readSchema, GenericData.Record record, NameMapping nameMapping) throws IOException {
        File file = this.temp.newFile();
        org.apache.avro.Schema writeAvroSchema = RemoveIds.removeIds((Schema)writeSchema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(writeAvroSchema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(writeAvroSchema, file);
            dataFileWriter.append((Object)record);
        }
        AvroIterable records = Avro.read((InputFile)Files.localInput((File)file)).project(readSchema).withNameMapping(nameMapping).build();
        return (GenericData.Record)Iterables.getOnlyElement((Iterable)records);
    }
}

