/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroFileSplit {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final int NUM_RECORDS = 100000;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public List<Record> expected = null;
    public InputFile file = null;

    @Before
    public void writeDataFile() throws IOException {
        this.expected = Lists.newArrayList();
        OutputFile out = Files.localOutput((File)this.temp.newFile());
        try (FileAppender writer = Avro.write((OutputFile)out).set("write.avro.compression-codec", "uncompressed").createWriterFunc(DataWriter::create).schema(SCHEMA).overwrite().build();){
            GenericRecord record = GenericRecord.create((Schema)SCHEMA);
            for (long i = 0L; i < 100000L; ++i) {
                Record next = record.copy((Map)ImmutableMap.of((Object)"id", (Object)i, (Object)"data", (Object)UUID.randomUUID().toString()));
                this.expected.add(next);
                writer.add((Object)next);
            }
        }
        this.file = out.toInputFile();
    }

    @Test
    public void testSplitDataSkipping() throws IOException {
        int i;
        long end = this.file.getLength();
        long splitLocation = end / 2L;
        List<Record> firstHalf = this.readAvro(this.file, SCHEMA, 0L, splitLocation);
        Assert.assertNotEquals((String)"First split should not be empty", (long)0L, (long)firstHalf.size());
        List<Record> secondHalf = this.readAvro(this.file, SCHEMA, splitLocation + 1L, end - splitLocation - 1L);
        Assert.assertNotEquals((String)"Second split should not be empty", (long)0L, (long)secondHalf.size());
        Assert.assertEquals((String)"Total records should match expected", (long)this.expected.size(), (long)(firstHalf.size() + secondHalf.size()));
        for (i = 0; i < firstHalf.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), (Object)firstHalf.get(i));
        }
        for (i = 0; i < secondHalf.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(firstHalf.size() + i), (Object)secondHalf.get(i));
        }
    }

    @Test
    public void testPosField() throws IOException {
        Schema projection = new Schema(new Types.NestedField[]{(Types.NestedField)SCHEMA.columns().get(0), MetadataColumns.ROW_POSITION, (Types.NestedField)SCHEMA.columns().get(1)});
        List<Record> records = this.readAvro(this.file, projection, 0L, this.file.getLength());
        for (int i = 0; i < this.expected.size(); ++i) {
            Assert.assertEquals((String)"Field _pos should match", (Object)i, (Object)records.get(i).getField(MetadataColumns.ROW_POSITION.name()));
            Assert.assertEquals((String)"Field id should match", (Object)this.expected.get(i).getField("id"), (Object)records.get(i).getField("id"));
            Assert.assertEquals((String)"Field data should match", (Object)this.expected.get(i).getField("data"), (Object)records.get(i).getField("data"));
        }
    }

    @Test
    public void testPosFieldWithSplits() throws IOException {
        int i;
        Schema projection = new Schema(new Types.NestedField[]{(Types.NestedField)SCHEMA.columns().get(0), MetadataColumns.ROW_POSITION, (Types.NestedField)SCHEMA.columns().get(1)});
        long end = this.file.getLength();
        long splitLocation = end / 2L;
        List<Record> secondHalf = this.readAvro(this.file, projection, splitLocation + 1L, end - splitLocation - 1L);
        Assert.assertNotEquals((String)"Second split should not be empty", (long)0L, (long)secondHalf.size());
        List<Record> firstHalf = this.readAvro(this.file, projection, 0L, splitLocation);
        Assert.assertNotEquals((String)"First split should not be empty", (long)0L, (long)firstHalf.size());
        Assert.assertEquals((String)"Total records should match expected", (long)this.expected.size(), (long)(firstHalf.size() + secondHalf.size()));
        for (i = 0; i < firstHalf.size(); ++i) {
            Assert.assertEquals((String)"Field _pos should match", (Object)i, (Object)firstHalf.get(i).getField(MetadataColumns.ROW_POSITION.name()));
            Assert.assertEquals((String)"Field id should match", (Object)this.expected.get(i).getField("id"), (Object)firstHalf.get(i).getField("id"));
            Assert.assertEquals((String)"Field data should match", (Object)this.expected.get(i).getField("data"), (Object)firstHalf.get(i).getField("data"));
        }
        for (i = 0; i < secondHalf.size(); ++i) {
            Assert.assertEquals((String)"Field _pos should match", (Object)(firstHalf.size() + i), (Object)secondHalf.get(i).getField(MetadataColumns.ROW_POSITION.name()));
            Assert.assertEquals((String)"Field id should match", (Object)this.expected.get(firstHalf.size() + i).getField("id"), (Object)secondHalf.get(i).getField("id"));
            Assert.assertEquals((String)"Field data should match", (Object)this.expected.get(firstHalf.size() + i).getField("data"), (Object)secondHalf.get(i).getField("data"));
        }
    }

    @Test
    public void testPosWithEOFSplit() throws IOException {
        Schema projection = new Schema(new Types.NestedField[]{(Types.NestedField)SCHEMA.columns().get(0), MetadataColumns.ROW_POSITION, (Types.NestedField)SCHEMA.columns().get(1)});
        long end = this.file.getLength();
        List<Record> records = this.readAvro(this.file, projection, end - 10L, 10L);
        Assert.assertEquals((String)"Should not read any records", (long)0L, (long)records.size());
    }

    public List<Record> readAvro(InputFile in, Schema projection, long start, long length) throws IOException {
        try (AvroIterable reader = Avro.read((InputFile)in).createReaderFunc(DataReader::create).split(start, length).project(projection).build();){
            ArrayList arrayList = Lists.newArrayList((Iterable)reader);
            return arrayList;
        }
    }
}

