/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroDataTest;
import org.apache.iceberg.avro.AvroEncoderUtil;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.RandomAvroData;
import org.apache.iceberg.types.Types;
import org.junit.Assert;

public class TestAvroEncoderUtil
extends AvroDataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        List<GenericData.Record> expected = RandomAvroData.generate(schema, 100, 1990L);
        Map typeToSchema = AvroSchemaUtil.convertTypes((Types.StructType)schema.asStruct(), (String)"test");
        org.apache.avro.Schema avroSchema = (org.apache.avro.Schema)typeToSchema.get(schema.asStruct());
        for (GenericData.Record record : expected) {
            byte[] serializedData = AvroEncoderUtil.encode((Object)record, (org.apache.avro.Schema)avroSchema);
            GenericData.Record expectedRecord = (GenericData.Record)AvroEncoderUtil.decode((byte[])serializedData);
            Assert.assertEquals((Object)expectedRecord.toString(), (Object)record.toString());
            byte[] serializedData2 = AvroEncoderUtil.encode((Object)expectedRecord, (org.apache.avro.Schema)avroSchema);
            Assert.assertArrayEquals((byte[])serializedData2, (byte[])serializedData);
            expectedRecord = (GenericData.Record)AvroEncoderUtil.decode((byte[])serializedData2);
            Assert.assertEquals((Object)expectedRecord.toString(), (Object)record.toString());
        }
    }
}

