/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroDeleteWriters {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private List<Record> records;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Before
    public void createDeleteRecords() {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"data", (Object)"a")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)2L, (Object)"data", (Object)"b")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)3L, (Object)"data", (Object)"c")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)4L, (Object)"data", (Object)"d")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)5L, (Object)"data", (Object)"e")));
        this.records = builder.build();
    }

    @Test
    public void testEqualityDeleteWriter() throws IOException {
        ArrayList deletedRecords;
        EqualityDeleteWriter deleteWriter;
        InMemoryOutputFile out = new InMemoryOutputFile();
        try (EqualityDeleteWriter writer = deleteWriter = Avro.writeDeletes((OutputFile)out).createWriterFunc(DataWriter::create).overwrite().rowSchema(SCHEMA).withSpec(PartitionSpec.unpartitioned()).equalityFieldIds(new int[]{1}).buildEqualityWriter();){
            writer.write(this.records);
        }
        DeleteFile metadata = deleteWriter.toDeleteFile();
        Assert.assertEquals((String)"Format should be Avro", (Object)FileFormat.AVRO, (Object)metadata.format());
        Assert.assertEquals((String)"Should be equality deletes", (Object)FileContent.EQUALITY_DELETES, (Object)metadata.content());
        Assert.assertEquals((String)"Record count should be correct", (long)this.records.size(), (long)metadata.recordCount());
        Assert.assertEquals((String)"Partition should be empty", (long)0L, (long)metadata.partition().size());
        Assert.assertNull((String)"Key metadata should be null", (Object)metadata.keyMetadata());
        try (AvroIterable reader = Avro.read((InputFile)out.toInputFile()).project(SCHEMA).createReaderFunc(DataReader::create).build();){
            deletedRecords = Lists.newArrayList((Iterable)reader);
        }
        Assert.assertEquals((String)"Deleted records should match expected", this.records, (Object)deletedRecords);
    }

    @Test
    public void testPositionDeleteWriter() throws IOException {
        ArrayList deletedRecords;
        Schema deleteSchema = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS, Types.NestedField.optional((int)2147483544, (String)"row", (Type)SCHEMA.asStruct())});
        String deletePath = "s3://bucket/path/file.parquet";
        GenericRecord posDelete = GenericRecord.create((Schema)deleteSchema);
        ArrayList expectedDeleteRecords = Lists.newArrayList();
        InMemoryOutputFile out = new InMemoryOutputFile();
        PositionDeleteWriter deleteWriter = Avro.writeDeletes((OutputFile)out).createWriterFunc(DataWriter::create).overwrite().rowSchema(SCHEMA).withSpec(PartitionSpec.unpartitioned()).buildPositionWriter();
        PositionDelete positionDelete = PositionDelete.create();
        try (PositionDeleteWriter writer = deleteWriter;){
            for (int i = 0; i < this.records.size(); ++i) {
                int pos = i * 3 + 2;
                writer.write(positionDelete.set((CharSequence)deletePath, (long)pos, (Object)this.records.get(i)));
                expectedDeleteRecords.add(posDelete.copy((Map)ImmutableMap.of((Object)"file_path", (Object)deletePath, (Object)"pos", (Object)pos, (Object)"row", (Object)this.records.get(i))));
            }
        }
        DeleteFile metadata = deleteWriter.toDeleteFile();
        Assert.assertEquals((String)"Format should be Avro", (Object)FileFormat.AVRO, (Object)metadata.format());
        Assert.assertEquals((String)"Should be position deletes", (Object)FileContent.POSITION_DELETES, (Object)metadata.content());
        Assert.assertEquals((String)"Record count should be correct", (long)this.records.size(), (long)metadata.recordCount());
        Assert.assertEquals((String)"Partition should be empty", (long)0L, (long)metadata.partition().size());
        Assert.assertNull((String)"Key metadata should be null", (Object)metadata.keyMetadata());
        try (AvroIterable reader = Avro.read((InputFile)out.toInputFile()).project(deleteSchema).createReaderFunc(DataReader::create).build();){
            deletedRecords = Lists.newArrayList((Iterable)reader);
        }
        Assert.assertEquals((String)"Deleted records should match expected", (Object)expectedDeleteRecords, (Object)deletedRecords);
    }

    @Test
    public void testPositionDeleteWriterWithEmptyRow() throws IOException {
        ArrayList deletedRecords;
        File deleteFile = this.temp.newFile();
        Schema deleteSchema = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
        String deletePath = "s3://bucket/path/file.parquet";
        GenericRecord posDelete = GenericRecord.create((Schema)deleteSchema);
        ArrayList expectedDeleteRecords = Lists.newArrayList();
        OutputFile out = Files.localOutput((File)deleteFile);
        PositionDeleteWriter deleteWriter = Avro.writeDeletes((OutputFile)out).createWriterFunc(DataWriter::create).overwrite().withSpec(PartitionSpec.unpartitioned()).buildPositionWriter();
        PositionDelete positionDelete = PositionDelete.create();
        try (PositionDeleteWriter writer = deleteWriter;){
            for (int i = 0; i < this.records.size(); ++i) {
                int pos = i * 3 + 2;
                writer.write(positionDelete.set((CharSequence)deletePath, (long)pos, null));
                expectedDeleteRecords.add(posDelete.copy((Map)ImmutableMap.of((Object)"file_path", (Object)deletePath, (Object)"pos", (Object)pos)));
            }
        }
        DeleteFile metadata = deleteWriter.toDeleteFile();
        Assert.assertEquals((String)"Format should be Avro", (Object)FileFormat.AVRO, (Object)metadata.format());
        Assert.assertEquals((String)"Should be position deletes", (Object)FileContent.POSITION_DELETES, (Object)metadata.content());
        Assert.assertEquals((String)"Record count should be correct", (long)this.records.size(), (long)metadata.recordCount());
        Assert.assertEquals((String)"Partition should be empty", (long)0L, (long)metadata.partition().size());
        Assert.assertNull((String)"Key metadata should be null", (Object)metadata.keyMetadata());
        try (AvroIterable reader = Avro.read((InputFile)out.toInputFile()).project(deleteSchema).createReaderFunc(DataReader::create).build();){
            deletedRecords = Lists.newArrayList((Iterable)reader);
        }
        Assert.assertEquals((String)"Deleted records should match expected", (Object)expectedDeleteRecords, (Object)deletedRecords);
    }
}

