/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.RandomUtil;

public class RandomAvroData {
    private RandomAvroData() {
    }

    public static List<GenericData.Record> generate(Schema schema, int numRecords, long seed) {
        RandomDataGenerator generator = new RandomDataGenerator(schema, seed);
        ArrayList records = Lists.newArrayListWithExpectedSize((int)numRecords);
        for (int i = 0; i < numRecords; ++i) {
            records.add((GenericData.Record)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)generator));
        }
        return records;
    }

    private static class RandomDataGenerator
    extends TypeUtil.CustomOrderSchemaVisitor<Object> {
        private final Map<Type, org.apache.avro.Schema> typeToSchema;
        private final Random random;

        private RandomDataGenerator(Schema schema, long seed) {
            this.typeToSchema = AvroSchemaUtil.convertTypes((Types.StructType)schema.asStruct(), (String)"test");
            this.random = new Random(seed);
        }

        public GenericData.Record schema(Schema schema, Supplier<Object> structResult) {
            return (GenericData.Record)structResult.get();
        }

        public GenericData.Record struct(Types.StructType struct, Iterable<Object> fieldResults) {
            GenericData.Record rec = new GenericData.Record(this.typeToSchema.get(struct));
            ArrayList values = Lists.newArrayList(fieldResults);
            for (int i = 0; i < values.size(); ++i) {
                rec.put(i, values.get(i));
            }
            return rec;
        }

        public Object field(Types.NestedField field, Supplier<Object> fieldResult) {
            if (field.isOptional() && this.random.nextInt(20) == 1) {
                return null;
            }
            return fieldResult.get();
        }

        public Object list(Types.ListType list, Supplier<Object> elementResult) {
            int numElements = this.random.nextInt(20);
            ArrayList result = Lists.newArrayListWithExpectedSize((int)numElements);
            for (int i = 0; i < numElements; ++i) {
                if (list.isElementOptional() && this.random.nextInt(20) == 1) {
                    result.add(null);
                    continue;
                }
                result.add(elementResult.get());
            }
            return result;
        }

        public Object map(Types.MapType map, Supplier<Object> keyResult, Supplier<Object> valueResult) {
            int numEntries = this.random.nextInt(20);
            LinkedHashMap result = Maps.newLinkedHashMap();
            Supplier<Object> keyFunc = map.keyType() == Types.StringType.get() ? () -> keyResult.get().toString() : keyResult;
            HashSet keySet = Sets.newHashSet();
            for (int i = 0; i < numEntries; ++i) {
                Object key = keyFunc.get();
                while (keySet.contains(key)) {
                    key = keyFunc.get();
                }
                keySet.add(key);
                if (map.isValueOptional() && this.random.nextInt(20) == 1) {
                    result.put(key, null);
                    continue;
                }
                result.put(key, valueResult.get());
            }
            return result;
        }

        public Object primitive(Type.PrimitiveType primitive) {
            Object result = RandomUtil.generatePrimitive((Type.PrimitiveType)primitive, (Random)this.random);
            switch (primitive.typeId()) {
                case STRING: {
                    return new Utf8((String)result);
                }
                case FIXED: {
                    return new GenericData.Fixed(this.typeToSchema.get(primitive), (byte[])result);
                }
                case BINARY: {
                    return ByteBuffer.wrap((byte[])result);
                }
                case UUID: {
                    return UUID.nameUUIDFromBytes((byte[])result);
                }
            }
            return result;
        }
    }
}

