/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;

class AvroTestHelpers {
    private AvroTestHelpers() {
    }

    static Schema.Field optionalField(int id, String name, Schema schema) {
        return AvroTestHelpers.addId(id, new Schema.Field(name, AvroSchemaUtil.toOption((Schema)schema), null, (Object)JsonProperties.NULL_VALUE));
    }

    static Schema.Field requiredField(int id, String name, Schema schema) {
        return AvroTestHelpers.addId(id, new Schema.Field(name, schema, null, null));
    }

    static Schema record(String name, Schema.Field ... fields) {
        return Schema.createRecord((String)name, null, null, (boolean)false, Arrays.asList(fields));
    }

    static Schema.Field addId(int id, Schema.Field field) {
        field.addProp("field-id", (Object)id);
        return field;
    }

    static Schema addElementId(int id, Schema schema) {
        schema.addProp("element-id", (Object)id);
        return schema;
    }

    static Schema addKeyId(int id, Schema schema) {
        schema.addProp("key-id", (Object)id);
        return schema;
    }

    static Schema addValueId(int id, Schema schema) {
        schema.addProp("value-id", (Object)id);
        return schema;
    }

    static void assertEquals(Types.StructType struct, GenericData.Record expected, GenericData.Record actual) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            AvroTestHelpers.assertEquals(fieldType, expectedValue, actualValue);
        }
    }

    static void assertEquals(Types.ListType list, List<?> expected, List<?> actual) {
        Type elementType = list.elementType();
        Assert.assertEquals((String)"List size should match", (long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            AvroTestHelpers.assertEquals(elementType, expectedValue, actualValue);
        }
    }

    static void assertEquals(Types.MapType map, Map<?, ?> expected, Map<?, ?> actual) {
        Type valueType = map.valueType();
        Assert.assertEquals((String)"Map size should match", (long)expected.size(), (long)actual.size());
        for (Object expectedKey : expected.keySet()) {
            Object expectedValue = expected.get(expectedKey);
            Object actualValue = actual.get(expectedKey);
            AvroTestHelpers.assertEquals(valueType, expectedValue, actualValue);
        }
    }

    private static void assertEquals(Type type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case UUID: 
            case FIXED: 
            case BINARY: 
            case DECIMAL: {
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expected, (Object)actual);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a Record", new Object[0])).isInstanceOf(GenericData.Record.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a Record", new Object[0])).isInstanceOf(GenericData.Record.class);
                AvroTestHelpers.assertEquals(type.asStructType(), (GenericData.Record)expected, (GenericData.Record)actual);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a List", new Object[0])).isInstanceOf(List.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a List", new Object[0])).isInstanceOf(List.class);
                AvroTestHelpers.assertEquals(type.asListType(), (List)expected, (List)actual);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a Map", new Object[0])).isInstanceOf(Map.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a Map", new Object[0])).isInstanceOf(Map.class);
                AvroTestHelpers.assertEquals(type.asMapType(), (Map)expected, (Map)actual);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }
}

