/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class AvroDataTest {
    private static final Types.StructType SUPPORTED_PRIMITIVES = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.required((int)111, (String)"uuid", (Type)Types.UUIDType.get()), Types.NestedField.required((int)112, (String)"fixed", (Type)Types.FixedType.ofLength((int)7)), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10)), Types.NestedField.required((int)117, (String)"time", (Type)Types.TimeType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    protected abstract void writeAndValidate(Schema var1) throws IOException;

    @Test
    public void testSimpleStruct() throws IOException {
        this.writeAndValidate(new Schema(SUPPORTED_PRIMITIVES.fields()));
    }

    @Test
    public void testArray() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.ListType.ofOptional((int)2, (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testArrayOfStructs() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.ListType.ofOptional((int)2, (Type)SUPPORTED_PRIMITIVES))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testMap() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testNumericMapKey() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.LongType.get(), (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testComplexMapKey() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"s", (Type)Types.StringType.get())}), (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testMapOfStructs() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testMixedTypes() throws IOException {
        Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"list_of_maps", (Type)Types.ListType.ofOptional((int)2, (Type)Types.MapType.ofOptional((int)3, (int)4, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.optional((int)5, (String)"map_of_lists", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.ListType.ofOptional((int)8, (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)9, (String)"list_of_lists", (Type)Types.ListType.ofOptional((int)10, (Type)Types.ListType.ofOptional((int)11, (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)12, (String)"map_of_maps", (Type)Types.MapType.ofOptional((int)13, (int)14, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)15, (int)16, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)17, (String)"list_of_struct_of_nested_types", (Type)Types.ListType.ofOptional((int)19, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"m1", (Type)Types.MapType.ofOptional((int)21, (int)22, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.optional((int)23, (String)"l1", (Type)Types.ListType.ofRequired((int)24, (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.required((int)25, (String)"l2", (Type)Types.ListType.ofRequired((int)26, (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.optional((int)27, (String)"m2", (Type)Types.MapType.ofOptional((int)28, (int)29, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))})))});
        Schema schema = new Schema(TypeUtil.assignFreshIds((Type)structType, new AtomicInteger(0)::incrementAndGet).asStructType().fields());
        this.writeAndValidate(schema);
    }
}

