/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MockFileScanTask;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.actions.SortStrategy;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSortStrategy
extends TableTestBase {
    private static final long MB = 0x100000L;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{2};
    }

    @Override
    public void setupTable() throws Exception {
        super.setupTable();
        ((ReplaceSortOrder)this.table.replaceSortOrder().asc("data")).commit();
    }

    public TestSortStrategy(int formatVersion) {
        super(formatVersion);
    }

    private SortStrategy defaultSort() {
        return (SortStrategy)new TestSortStrategyImpl().options(Collections.emptyMap());
    }

    private List<FileScanTask> tasksForSortOrder(int sortOrderId, int ... fileSizesMB) {
        ImmutableList.Builder files = ImmutableList.builder();
        IntStream.of(fileSizesMB).forEach(length -> files.add((Object)MockFileScanTask.mockTask((long)length * 0x100000L, sortOrderId)));
        return files.build();
    }

    @Test
    public void testInvalidSortOrder() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.defaultSort().sortOrder(SortOrder.unsorted()).options(Collections.emptyMap())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set strategy sort order: unsorted");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Schema badSchema = new Schema((List)ImmutableList.of((Object)Types.NestedField.required((int)0, (String)"nonexistant", (Type)Types.IntegerType.get())));
            this.defaultSort().sortOrder(((SortOrder.Builder)SortOrder.builderFor((Schema)badSchema).asc("nonexistant")).build()).options(Collections.emptyMap());
        }).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Cannot find field 'nonexistant' in struct");
    }

    @Test
    public void testSelectAll() {
        ImmutableList invalid = ImmutableList.builder().addAll(this.tasksForSortOrder(-1, 500, 500, 500, 500)).addAll(this.tasksForSortOrder(this.table.sortOrder().orderId(), 10, 10, 2000, 10)).build();
        ImmutableList expected = ImmutableList.builder().addAll((Iterable)invalid).addAll(this.tasksForSortOrder(this.table.sortOrder().orderId(), 500, 490, 520)).build();
        RewriteStrategy strategy = this.defaultSort().options((Map)ImmutableMap.of((Object)"rewrite-all", (Object)"true"));
        ImmutableList actual = ImmutableList.copyOf((Iterable)strategy.selectFilesToRewrite((Iterable)expected));
        Assert.assertEquals((String)"Should mark all files for rewrite", (Object)expected, (Object)actual);
    }

    @Test
    public void testUseSizeOptions() {
        ImmutableList expected = ImmutableList.builder().addAll(this.tasksForSortOrder(this.table.sortOrder().orderId(), 498, 551)).build();
        ImmutableList fileScanTasks = ImmutableList.builder().addAll((Iterable)expected).addAll(this.tasksForSortOrder(this.table.sortOrder().orderId(), 500, 500)).build();
        RewriteStrategy strategy = this.defaultSort().options((Map)ImmutableMap.of((Object)"max-file-size-bytes", (Object)Long.toString(0x22600000L), (Object)"min-file-size-bytes", (Object)Long.toString(523239424L)));
        ImmutableList actual = ImmutableList.copyOf((Iterable)strategy.selectFilesToRewrite((Iterable)fileScanTasks));
        Assert.assertEquals((String)"Should mark files for rewrite with adjusted min and max size", (Object)expected, (Object)actual);
    }

    class TestSortStrategyImpl
    extends SortStrategy {
        TestSortStrategyImpl() {
        }

        public Table table() {
            return TestSortStrategy.this.table;
        }

        public Set<DataFile> rewriteFiles(List<FileScanTask> filesToRewrite) {
            throw new UnsupportedOperationException();
        }
    }
}

