/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.actions.BaseCommitService;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Tasks;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCommitService
extends TableTestBase {
    public TestCommitService() {
        super(1);
    }

    @Test
    public void testCommittedResultsCorrectly() {
        CustomCommitService commitService = new CustomCommitService((Table)this.table, 5, 10000);
        commitService.start();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        int numberOfFileGroups = 100;
        Tasks.range((int)numberOfFileGroups).executeWith(executorService).run(arg_0 -> ((CustomCommitService)commitService).offer(arg_0));
        commitService.close();
        HashSet expected = Sets.newHashSet((Iterator)IntStream.range(0, 100).iterator());
        HashSet actual = Sets.newHashSet((Iterable)commitService.results());
        Assertions.assertThat((Collection)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testAbortFileGroupsAfterTimeout() {
        CustomCommitService commitService = new CustomCommitService((Table)this.table, 5, 200);
        commitService.start();
        for (int i = 0; i < 4; ++i) {
            commitService.offer(i);
        }
        CustomCommitService spyCommitService = (CustomCommitService)((Object)Mockito.spy((Object)((Object)commitService)));
        ((CustomCommitService)((Object)Mockito.doReturn((Object)false).when((Object)spyCommitService))).canCreateCommitGroup();
        for (int i = 4; i < 8; ++i) {
            spyCommitService.offer(i);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CustomCommitService)commitService).close()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Timeout occurred when waiting for commits");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollInSameThread().untilAsserted(() -> Assertions.assertThat((boolean)commitService.completedRewritesAllCommitted()).isTrue());
        if (commitService.aborted.isEmpty()) {
            Assertions.assertThat((List)commitService.results()).isEqualTo((Object)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7));
        } else {
            Assertions.assertThat((List)commitService.results()).doesNotContainAnyElementsOf((Iterable)commitService.aborted);
            Assertions.assertThat((List)commitService.results()).isEqualTo((Object)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4));
            Assertions.assertThat((Collection)commitService.aborted).isEqualTo((Object)ImmutableSet.of((Object)5, (Object)6, (Object)7));
        }
    }

    private static class CustomCommitService
    extends BaseCommitService<Integer> {
        private final Set<Integer> aborted = Sets.newConcurrentHashSet();

        CustomCommitService(Table table, int rewritesPerCommit, int timeoutInSeconds) {
            super(table, rewritesPerCommit, (long)timeoutInSeconds);
        }

        protected void commitOrClean(Set<Integer> batch) {
            try {
                Thread.sleep(210L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        protected void abortFileGroup(Integer group) {
            this.aborted.add(group);
        }
    }
}

