/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MockFileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.actions.BinPackStrategy;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBinPackStrategy
extends TableTestBase {
    private static final long MB = 0x100000L;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{2};
    }

    public TestBinPackStrategy(int formatVersion) {
        super(formatVersion);
    }

    private List<FileScanTask> filesOfSize(long ... sizes) {
        return Arrays.stream(sizes).mapToObj(size -> new MockFileScanTask(size * 0x100000L)).collect(Collectors.toList());
    }

    private RewriteStrategy defaultBinPack() {
        return new TestBinPackStrategyImpl().options(Collections.emptyMap());
    }

    @Test
    public void testFilteringAllValid() {
        RewriteStrategy strategy = this.defaultBinPack();
        List<FileScanTask> testFiles = this.filesOfSize(100L, 100L, 100L, 100L, 1000L);
        ImmutableList filtered = ImmutableList.copyOf((Iterable)strategy.selectFilesToRewrite(testFiles));
        Assert.assertEquals((String)"No files should be removed from the set", testFiles, (Object)filtered);
    }

    @Test
    public void testFilteringRemoveInvalid() {
        RewriteStrategy strategy = this.defaultBinPack();
        List<FileScanTask> testFiles = this.filesOfSize(500L, 500L, 500L, 600L, 600L);
        ImmutableList filtered = ImmutableList.copyOf((Iterable)strategy.selectFilesToRewrite(testFiles));
        Assert.assertEquals((String)"All files should be removed from the set", Collections.emptyList(), (Object)filtered);
    }

    @Test
    public void testFilteringCustomMinMaxFileSize() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"max-file-size-bytes", (Object)Long.toString(0x22600000L), (Object)"min-file-size-bytes", (Object)Long.toString(513802240L)));
        List<FileScanTask> testFiles = this.filesOfSize(500L, 500L, 480L, 480L, 560L, 520L);
        List<FileScanTask> expectedFiles = this.filesOfSize(480L, 480L, 560L);
        ImmutableList filtered = ImmutableList.copyOf((Iterable)strategy.selectFilesToRewrite(testFiles));
        Assert.assertEquals((String)"Should remove files that exceed or are smaller than new bounds", expectedFiles, (Object)filtered);
    }

    @Test
    public void testFilteringWithDeletes() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"max-file-size-bytes", (Object)Long.toString(0x22600000L), (Object)"min-file-size-bytes", (Object)Long.toString(513802240L), (Object)"delete-file-threshold", (Object)Integer.toString(2)));
        List<FileScanTask> testFiles = this.filesOfSize(500L, 500L, 480L, 480L, 560L, 520L);
        testFiles.add((FileScanTask)MockFileScanTask.mockTaskWithDeletes(524288000L, 2));
        List<FileScanTask> expectedFiles = this.filesOfSize(480L, 480L, 560L, 500L);
        ImmutableList filtered = ImmutableList.copyOf((Iterable)strategy.selectFilesToRewrite(testFiles));
        Assert.assertEquals((String)"Should include file with deletes", expectedFiles, (Object)filtered);
    }

    @Test
    public void testGroupingMinInputFilesInvalid() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-input-files", (Object)Integer.toString(5)));
        List<FileScanTask> testFiles = this.filesOfSize(1L, 1L, 1L, 1L);
        Iterable grouped = strategy.planFileGroups(testFiles);
        Assert.assertEquals((String)"Should plan 0 groups, not enough input files", (long)0L, (long)Iterables.size((Iterable)grouped));
    }

    @Test
    public void testGroupingMinInputFilesAsOne() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-input-files", (Object)Integer.toString(1), (Object)"max-file-size-bytes", (Object)Long.toString(0x300000L), (Object)"target-file-size-bytes", (Object)Long.toString(0x200000L), (Object)"min-file-size-bytes", (Object)Long.toString(0x100000L), (Object)"delete-file-threshold", (Object)Integer.toString(2)));
        List<FileScanTask> testFiles1 = this.filesOfSize(1L);
        Iterable grouped1 = strategy.planFileGroups(testFiles1);
        Assert.assertEquals((String)"Should plan 0 groups, 1 file is too small but no deletes are present so rewriting is a NOOP", (long)0L, (long)Iterables.size((Iterable)grouped1));
        List<FileScanTask> testFiles2 = this.filesOfSize(4L);
        Iterable grouped2 = strategy.planFileGroups(testFiles2);
        Assert.assertEquals((String)"Should plan 1 group because the file present is larger than maxFileSize and can be split", (long)1L, (long)Iterables.size((Iterable)grouped2));
        ArrayList testFiles3 = Lists.newArrayList();
        testFiles3.add(MockFileScanTask.mockTaskWithDeletes(0x100000L, 2));
        Iterable grouped3 = strategy.planFileGroups((Iterable)testFiles3);
        Assert.assertEquals((String)"Should plan 1 group, the data file has delete files and can be re-written without deleted row", (long)1L, (long)Iterables.size((Iterable)grouped3));
    }

    @Test
    public void testGroupWithLargeFileMinInputFiles() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-input-files", (Object)Integer.toString(5)));
        List<FileScanTask> testFiles1 = this.filesOfSize(2000L);
        Iterable grouped1 = strategy.planFileGroups(testFiles1);
        Assert.assertEquals((String)"Should plan 1 group, not enough input files but the input file exceeds our maxand can be written into at least one new target-file-size files", (Object)ImmutableList.of(testFiles1), (Object)grouped1);
        List<FileScanTask> testFiles2 = this.filesOfSize(500L, 500L, 500L);
        Iterable grouped2 = strategy.planFileGroups(testFiles2);
        Assert.assertEquals((String)"Should plan 1 group, not enough input files but the sum of file sizes exceeds target-file-size and files within the group is greater than 1", (Object)ImmutableList.of(testFiles2), (Object)grouped2);
        List<FileScanTask> testFiles3 = this.filesOfSize(10L, 10L, 10L);
        Iterable grouped3 = strategy.planFileGroups(testFiles3);
        Assert.assertEquals((String)"Should plan 0 groups, not enough input files and the sum of file sizes does not exceeds target-file-size and files within the group is greater than 1", (Object)ImmutableList.of(), (Object)grouped3);
    }

    @Test
    public void testGroupingMinInputFilesValid() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-input-files", (Object)Integer.toString(5)));
        List<FileScanTask> testFiles = this.filesOfSize(1L, 1L, 1L, 1L, 1L);
        Iterable grouped = strategy.planFileGroups(testFiles);
        Assert.assertEquals((String)"Should plan 1 groups since there are enough input files", (Object)ImmutableList.of(testFiles), (Object)grouped);
    }

    @Test
    public void testGroupingWithDeletes() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-input-files", (Object)Integer.toString(5), (Object)"max-file-size-bytes", (Object)Long.toString(0x22600000L), (Object)"min-file-size-bytes", (Object)Long.toString(513802240L), (Object)"delete-file-threshold", (Object)Integer.toString(2)));
        ArrayList testFiles = Lists.newArrayList();
        testFiles.add(MockFileScanTask.mockTaskWithDeletes(524288000L, 2));
        Iterable grouped = strategy.planFileGroups((Iterable)testFiles);
        Assert.assertEquals((String)"Should plan 1 groups since there are enough input files", (Object)ImmutableList.of((Object)testFiles), (Object)grouped);
    }

    @Test
    public void testMaxGroupSize() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"max-file-group-size-bytes", (Object)Long.toString(1048576000L)));
        List<FileScanTask> testFiles = this.filesOfSize(300L, 300L, 300L, 300L, 300L, 300L);
        Iterable grouped = strategy.planFileGroups(testFiles);
        Assert.assertEquals((String)"Should plan 2 groups since there is enough data for two groups", (long)2L, (long)Iterables.size((Iterable)grouped));
    }

    @Test
    public void testNumOuputFiles() {
        BinPackStrategy strategy = (BinPackStrategy)this.defaultBinPack();
        long targetFileSize = strategy.targetFileSize();
        Assert.assertEquals((String)"Should keep remainder if the remainder is a valid size", (long)2L, (long)strategy.numOutputFiles(targetFileSize + 471859200L));
        Assert.assertEquals((String)"Should discard remainder file if the remainder is very small", (long)1L, (long)strategy.numOutputFiles(targetFileSize + 0x2800000L));
        Assert.assertEquals((String)"Should keep remainder file if it would change average file size greatly", (long)2L, (long)strategy.numOutputFiles((long)((double)targetFileSize + 0.4 * (double)targetFileSize)));
        Assert.assertEquals((String)"Should discard remainder if file is small and wouldn't change average that much", (long)200L, (long)strategy.numOutputFiles(200L * targetFileSize + 0xD00000L));
        Assert.assertEquals((String)"Should keep remainder if it's a valid size", (long)201L, (long)strategy.numOutputFiles(200L * targetFileSize + 523239424L));
        Assert.assertEquals((String)"Should not return 0 even for very small files", (long)1L, (long)strategy.numOutputFiles(1L));
    }

    @Test
    public void testInvalidOptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.defaultBinPack().options((Map)ImmutableMap.of((Object)"max-file-size-bytes", (Object)Long.toString(0x100000L)))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot set min-file-size-bytes greater than or equal to max-file-size-bytes");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-file-size-bytes", (Object)Long.toString(1048576000L)))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot set min-file-size-bytes greater than or equal to max-file-size-bytes");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-input-files", (Object)Long.toString(-5L)))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot set min-input-files is less than 1. All values less than 1 have the same effect as 1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.defaultBinPack().options((Map)ImmutableMap.of((Object)"delete-file-threshold", (Object)Long.toString(-5L)))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot set delete-file-threshold is less than 1. All values less than 1 have the same effect as 1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.defaultBinPack().options((Map)ImmutableMap.of((Object)"target-file-size-bytes", (Object)Long.toString(-5L)))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot set min-file-size-bytes to a negative number");
    }

    @Test
    public void testRewriteAllSelectFilesToRewrite() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"rewrite-all", (Object)"true"));
        List<FileScanTask> testFiles = this.filesOfSize(500L, 500L, 480L, 480L, 560L, 520L);
        List<FileScanTask> expectedFiles = this.filesOfSize(500L, 500L, 480L, 480L, 560L, 520L);
        ImmutableList filtered = ImmutableList.copyOf((Iterable)strategy.selectFilesToRewrite(testFiles));
        Assert.assertEquals((String)"Should rewrite all files", expectedFiles, (Object)filtered);
    }

    @Test
    public void testRewriteAllPlanFileGroups() {
        RewriteStrategy strategy = this.defaultBinPack().options((Map)ImmutableMap.of((Object)"min-input-files", (Object)Integer.toString(5), (Object)"rewrite-all", (Object)"true"));
        List<FileScanTask> testFiles = this.filesOfSize(1L, 1L, 1L, 1L);
        Iterable grouped = strategy.planFileGroups(testFiles);
        Assert.assertEquals((String)"Should plan 1 group to rewrite all files", (long)1L, (long)Iterables.size((Iterable)grouped));
    }

    class TestBinPackStrategyImpl
    extends BinPackStrategy {
        TestBinPackStrategyImpl() {
        }

        public Table table() {
            return TestBinPackStrategy.this.table;
        }

        public Set<DataFile> rewriteFiles(List<FileScanTask> filesToRewrite) {
            throw new UnsupportedOperationException();
        }
    }
}

