/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.Ticker;
import java.time.Duration;
import java.util.Optional;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;

public class TestableCachingCatalog
extends CachingCatalog {
    private final Duration cacheExpirationInterval;

    public static TestableCachingCatalog wrap(Catalog catalog, Duration expirationInterval, Ticker ticker) {
        return new TestableCachingCatalog(catalog, true, expirationInterval, ticker);
    }

    TestableCachingCatalog(Catalog catalog, boolean caseSensitive, Duration expirationInterval, Ticker ticker) {
        super(catalog, caseSensitive, expirationInterval.toMillis(), ticker);
        this.cacheExpirationInterval = expirationInterval;
    }

    public Cache<TableIdentifier, Table> cache() {
        this.tableCache.cleanUp();
        return this.tableCache;
    }

    public boolean isCacheExpirationEnabled() {
        return this.tableCache.policy().expireAfterAccess().isPresent() || this.tableCache.policy().expireAfterWrite().isPresent();
    }

    public Optional<Duration> ageOf(TableIdentifier identifier) {
        return ((Policy.Expiration)this.tableCache.policy().expireAfterAccess().get()).ageOf((Object)identifier);
    }

    public Optional<Duration> remainingAgeFor(TableIdentifier identifier) {
        return this.ageOf(identifier).map(this.cacheExpirationInterval::minus);
    }
}

