/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.exceptions.CherrypickAncestorCommitException;
import org.apache.iceberg.exceptions.DuplicateWAPCommitException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestWapWorkflow
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestWapWorkflow(int formatVersion) {
        super(formatVersion);
    }

    @Before
    public void setupTableProperties() {
        this.table.updateProperties().set("write.wap.enabled", "true").commit();
    }

    @Test
    public void testCherryPickOverwrite() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((OverwriteFiles)this.table.newOverwrite().deleteFile(FILE_A).addFile(FILE_B).stageOnly()).commit();
        this.validateTableFiles((Table)this.table, FILE_A);
        Snapshot overwrite = Streams.stream((Iterable)this.table.snapshots()).filter(snap -> "overwrite".equals(snap.operation())).findFirst().get();
        this.table.manageSnapshots().cherrypick(overwrite.snapshotId()).commit();
        this.validateTableFiles((Table)this.table, FILE_B);
    }

    @Test
    public void testCherryPickOverwriteFailsIfCurrentHasChanged() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((OverwriteFiles)this.table.newOverwrite().deleteFile(FILE_A).addFile(FILE_B).stageOnly()).commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        this.validateTableFiles((Table)this.table, FILE_A, FILE_C);
        Snapshot overwrite = Streams.stream((Iterable)this.table.snapshots()).filter(snap -> "overwrite".equals(snap.operation())).findFirst().get();
        AssertHelpers.assertThrows((String)"Should reject overwrite that is not a fast-forward commit", ValidationException.class, (String)"not append, dynamic overwrite, or fast-forward", () -> this.table.manageSnapshots().cherrypick(overwrite.snapshotId()).commit());
        this.validateTableFiles((Table)this.table, FILE_A, FILE_C);
    }

    @Test
    public void testCurrentSnapshotOperation() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        long firstSnapshotId = base.currentSnapshot().snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wapSnapshot = (Snapshot)base.snapshots().get(1);
        Assert.assertEquals((String)"Metadata should have both snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Snapshot should have wap id in summary", (Object)"123456789", wapSnapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        this.table.manageSnapshots().setCurrentSnapshot(wapSnapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current snapshot should be what we rolled back to", (long)wapSnapshot.snapshotId(), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Metadata should have both snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)2L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)2L, (long)base.snapshotLog().size());
    }

    @Test
    public void testSetCurrentSnapshotNoWAP() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Snapshot firstSnapshot = base.currentSnapshot();
        long firstSnapshotId = firstSnapshot.snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().setCurrentSnapshot(firstSnapshotId).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current snapshot should be what we rolled back to", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Metadata should have both snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)1L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)3L, (long)base.snapshotLog().size());
    }

    @Test
    public void testRollbackOnInvalidNonAncestor() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        long firstSnapshotId = base.currentSnapshot().snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wapSnapshot = (Snapshot)base.snapshots().get(1);
        Assert.assertEquals((String)"Metadata should have both snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Snapshot should have wap id in summary", (Object)"123456789", wapSnapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        AssertHelpers.assertThrows((String)"should fail on invalid snapshot", ValidationException.class, (String)"Cannot roll back to snapshot, not an ancestor of the current state: 2", () -> this.table.manageSnapshots().rollbackTo(wapSnapshot.snapshotId()).commit());
        base = this.readMetadata();
        Assert.assertEquals((String)"Current snapshot should be what we rolled back to", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Metadata should have both snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should contain manifests for one snapshot", (long)1L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
    }

    @Test
    public void testRollbackAndCherrypick() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Snapshot firstSnapshot = base.currentSnapshot();
        long firstSnapshotId = firstSnapshot.snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        base = this.readMetadata();
        Snapshot secondSnapshot = base.currentSnapshot();
        this.table.newAppend().appendFile(FILE_C).commit();
        base = this.readMetadata();
        Snapshot thirdSnapshot = base.currentSnapshot();
        this.table.manageSnapshots().rollbackTo(firstSnapshotId).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Should be at first snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should have all three snapshots in the system", (long)3L, (long)base.snapshots().size());
        this.table.manageSnapshots().cherrypick(thirdSnapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current state should be at third snapshot", (long)4L, (long)base.currentSnapshot().snapshotId());
        this.table.manageSnapshots().cherrypick(secondSnapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current state should be at second snapshot", (long)5L, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Count all snapshots", (long)5L, (long)base.snapshots().size());
    }

    @Test
    public void testRollbackToTime() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Snapshot firstSnapshot = base.currentSnapshot();
        long firstSnapshotId = firstSnapshot.snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        base = this.readMetadata();
        Snapshot secondSnapshot = base.currentSnapshot();
        this.table.newAppend().appendFile(FILE_C).commit();
        this.table.manageSnapshots().rollbackToTime(secondSnapshot.timestampMillis()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Should be at first snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should have all three snapshots in the system", (long)3L, (long)base.snapshots().size());
    }

    @Test
    public void testWithCherryPicking() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        long firstSnapshotId = base.currentSnapshot().snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wapSnapshot = (Snapshot)base.snapshots().get(1);
        Assert.assertEquals((String)"Should have both snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should have first wap id in summary", (Object)"123456789", wapSnapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        this.table.manageSnapshots().cherrypick(wapSnapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current snapshot should be fast-forwarded to wap snapshot", (long)wapSnapshot.snapshotId(), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should have two snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)2L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)2L, (long)base.snapshotLog().size());
    }

    @Test
    public void testWithTwoPhaseCherryPicking() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Snapshot parentSnapshot = base.currentSnapshot();
        long firstSnapshotId = parentSnapshot.snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_C).set("wap.id", "987654321")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wap1Snapshot = (Snapshot)base.snapshots().get(1);
        Snapshot wap2Snapshot = (Snapshot)base.snapshots().get(2);
        Assert.assertEquals((String)"Should have three snapshots", (long)3L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should have first wap id in summary", (Object)"123456789", wap1Snapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Should have second wap id in summary", (Object)"987654321", wap2Snapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Parent snapshot id should be same for first WAP snapshot", (long)firstSnapshotId, (long)wap1Snapshot.parentId());
        Assert.assertEquals((String)"Parent snapshot id should be same for second WAP snapshot", (long)firstSnapshotId, (long)wap2Snapshot.parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        parentSnapshot = base.currentSnapshot();
        this.table.manageSnapshots().cherrypick(wap1Snapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current snapshot should be set to one after wap snapshot", (long)(parentSnapshot.snapshotId() + 1L), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)2L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Parent snapshot id should change to latest snapshot before commit", (long)parentSnapshot.snapshotId(), (long)base.currentSnapshot().parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)2L, (long)base.snapshotLog().size());
        parentSnapshot = base.currentSnapshot();
        this.table.manageSnapshots().cherrypick(wap2Snapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current snapshot should be set to one after wap snapshot", (long)(parentSnapshot.snapshotId() + 1L + 1L), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)3L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Parent snapshot id should change to latest snapshot before commit", (long)parentSnapshot.snapshotId(), (long)base.currentSnapshot().parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)3L, (long)base.snapshotLog().size());
    }

    @Test
    public void testWithCommitsBetweenCherryPicking() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Snapshot parentSnapshot = base.currentSnapshot();
        long firstSnapshotId = parentSnapshot.snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_C).set("wap.id", "987654321")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wap1Snapshot = (Snapshot)base.snapshots().get(1);
        Snapshot wap2Snapshot = (Snapshot)base.snapshots().get(2);
        Assert.assertEquals((String)"Should have three snapshots", (long)3L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should have first wap id in summary", (Object)"123456789", wap1Snapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Should have second wap id in summary", (Object)"987654321", wap2Snapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Parent snapshot id should be same for first WAP snapshot", (long)firstSnapshotId, (long)wap1Snapshot.parentId());
        Assert.assertEquals((String)"Parent snapshot id should be same for second WAP snapshot", (long)firstSnapshotId, (long)wap2Snapshot.parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        parentSnapshot = base.currentSnapshot();
        this.table.newAppend().appendFile(FILE_D).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Should have four snapshots", (long)4L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Current snapshot should carry over the parent snapshot", (long)parentSnapshot.snapshotId(), (long)base.currentSnapshot().parentId());
        Assert.assertEquals((String)"Should contain manifests for two files", (long)2L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)2L, (long)base.snapshotLog().size());
        parentSnapshot = base.currentSnapshot();
        this.table.manageSnapshots().cherrypick(wap1Snapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Should have five snapshots", (long)5L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Current snapshot should be set to one after wap snapshot", (long)(parentSnapshot.snapshotId() + 1L), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should contain manifests for three files", (long)3L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Parent snapshot id should point to same snapshot", (long)parentSnapshot.snapshotId(), (long)base.currentSnapshot().parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)3L, (long)base.snapshotLog().size());
        parentSnapshot = base.currentSnapshot();
        this.table.manageSnapshots().cherrypick(wap2Snapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Should have all the snapshots", (long)6L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Current snapshot should be set to one after wap snapshot", (long)(parentSnapshot.snapshotId() + 1L), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should contain manifests for four files", (long)4L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Parent snapshot id should point to same snapshot", (long)parentSnapshot.snapshotId(), (long)base.currentSnapshot().parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)4L, (long)base.snapshotLog().size());
    }

    @Test
    public void testWithCherryPickingWithCommitRetry() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Snapshot parentSnapshot = base.currentSnapshot();
        long firstSnapshotId = parentSnapshot.snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wap1Snapshot = (Snapshot)base.snapshots().get(1);
        Assert.assertEquals((String)"Should have two snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should have first wap id in summary", (Object)"123456789", wap1Snapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Parent snapshot id should be same for first WAP snapshot", (long)firstSnapshotId, (long)wap1Snapshot.parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        base = this.readMetadata();
        parentSnapshot = base.currentSnapshot();
        this.table.ops().failCommits(3);
        this.table.manageSnapshots().cherrypick(wap1Snapshot.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Current snapshot should be set to one after wap snapshot", (long)(parentSnapshot.snapshotId() + 1L), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)2L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should not contain redundant append due to retry", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Parent snapshot id should change to latest snapshot before commit", (long)parentSnapshot.snapshotId(), (long)base.currentSnapshot().parentId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)2L, (long)base.snapshotLog().size());
    }

    @Test
    public void testCherrypickingAncestor() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        long firstSnapshotId = base.currentSnapshot().snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wapSnapshot = (Snapshot)base.snapshots().get(1);
        Assert.assertEquals((String)"Should have both snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should have first wap id in summary", (Object)"123456789", wapSnapshot.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        this.table.manageSnapshots().cherrypick(wapSnapshot.snapshotId()).commit();
        base = this.readMetadata();
        long wapPublishedId = this.table.currentSnapshot().snapshotId();
        Assert.assertEquals((String)"Current snapshot should be fast-forwarded to wap snapshot", (long)wapSnapshot.snapshotId(), (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Should have two snapshots", (long)2L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)2L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)2L, (long)base.snapshotLog().size());
        AssertHelpers.assertThrows((String)"should throw exception", CherrypickAncestorCommitException.class, (String)String.format("Cannot cherrypick snapshot %s: already an ancestor", 1), () -> this.table.manageSnapshots().cherrypick(firstSnapshotId).commit());
    }

    @Test
    public void testDuplicateCherrypick() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        long firstSnapshotId = base.currentSnapshot().snapshotId();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_C).set("wap.id", "123456789")).stageOnly()).commit();
        base = this.readMetadata();
        Snapshot wapSnapshot1 = (Snapshot)base.snapshots().get(1);
        Snapshot wapSnapshot2 = (Snapshot)base.snapshots().get(2);
        Assert.assertEquals((String)"Should have both snapshots", (long)3L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should have wap id in first wap snapshot summary", (Object)"123456789", wapSnapshot1.summary().get("wap.id"));
        Assert.assertEquals((String)"Should have wap id in second wap snapshot summary", (Object)"123456789", wapSnapshot2.summary().get("wap.id"));
        Assert.assertEquals((String)"Current snapshot should be first commit's snapshot", (long)firstSnapshotId, (long)base.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)1L, (long)base.snapshotLog().size());
        this.table.manageSnapshots().cherrypick(wapSnapshot1.snapshotId()).commit();
        base = this.readMetadata();
        Assert.assertEquals((String)"Should have three snapshots", (long)3L, (long)base.snapshots().size());
        Assert.assertEquals((String)"Should contain manifests for both files", (long)2L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should contain append from last commit", (long)1L, (long)Iterables.size((Iterable)base.currentSnapshot().addedDataFiles(this.table.io())));
        Assert.assertEquals((String)"Snapshot log should indicate number of snapshots committed", (long)2L, (long)base.snapshotLog().size());
        AssertHelpers.assertThrows((String)"should throw exception", DuplicateWAPCommitException.class, (String)String.format("Duplicate request to cherry pick wap id that was published already: %s", 123456789), () -> this.table.manageSnapshots().cherrypick(wapSnapshot2.snapshotId()).commit());
    }

    @Test
    public void testNonWapCherrypick() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        long firstSnapshotId = base.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        base = this.readMetadata();
        long secondSnapshotId = base.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_C).commit();
        base = this.readMetadata();
        long thirdSnapshotId = base.currentSnapshot().snapshotId();
        Assert.assertEquals((String)"Should be pointing to third snapshot", (long)thirdSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        this.table.manageSnapshots().commit();
        Assert.assertEquals((String)"Should still be pointing to third snapshot", (long)thirdSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        this.table.manageSnapshots().rollbackTo(secondSnapshotId).commit();
        Assert.assertEquals((String)"Should be pointing to second snapshot", (long)secondSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        this.table.manageSnapshots().cherrypick(thirdSnapshotId).commit();
        Assert.assertEquals((String)"Should be re-using wap snapshot after cherrypick", (long)3L, (long)this.table.currentSnapshot().snapshotId());
        AssertHelpers.assertThrows((String)"should not allow cherrypicking ancestor", CherrypickAncestorCommitException.class, (String)String.format("Cannot cherrypick snapshot %s: already an ancestor", 3), () -> this.table.manageSnapshots().cherrypick(thirdSnapshotId).commit());
        AssertHelpers.assertThrows((String)"should not allow double cherrypick", CherrypickAncestorCommitException.class, (String)String.format("Cannot cherrypick snapshot %s: already an ancestor", firstSnapshotId), () -> this.table.manageSnapshots().cherrypick(firstSnapshotId).commit());
    }
}

