/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;

public class TestV1ToV2RowDeltaDelete
extends TableTestBase {
    static final DeleteFile FILE_A_POS_1 = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a-pos-deletes.parquet").withFileSizeInBytes(10L).withPartition(FILE_A.partition()).withRecordCount(1L).build();
    static final DeleteFile FILE_A_EQ_1 = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-a-eq-deletes.parquet").withFileSizeInBytes(10L).withPartition(FILE_A.partition()).withRecordCount(1L).build();

    public TestV1ToV2RowDeltaDelete() {
        super(1);
    }

    private void verifyManifestSequenceNumber(ManifestFile mf, long sequenceNum, long minSequenceNum) {
        Assert.assertEquals((String)("sequence number should be " + sequenceNum), (long)mf.sequenceNumber(), (long)sequenceNum);
        Assert.assertEquals((String)("min sequence number should be " + minSequenceNum), (long)mf.minSequenceNumber(), (long)minSequenceNum);
    }

    @Test
    public void testPartitionedTableWithPartitionEqDeletes() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C).commit();
        List dataManifests = this.table.currentSnapshot().dataManifests(this.table.io());
        List deleteManifests = this.table.currentSnapshot().deleteManifests(this.table.io());
        Assert.assertEquals((String)"Should have one data manifest file", (long)1L, (long)dataManifests.size());
        Assert.assertEquals((String)"Should have zero delete manifest file", (long)0L, (long)deleteManifests.size());
        ManifestFile dataManifest = (ManifestFile)dataManifests.get(0);
        this.verifyManifestSequenceNumber(dataManifest, 0L, 0L);
        TableOperations ops = this.table.operations();
        TableMetadata base = ops.current();
        ops.commit(base, base.upgradeToFormatVersion(2));
        this.table.newRowDelta().addDeletes(FILE_A_EQ_1).commit();
        dataManifests = this.table.currentSnapshot().dataManifests(ops.io());
        deleteManifests = this.table.currentSnapshot().deleteManifests(ops.io());
        Assert.assertEquals((String)"Should have one data manifest file", (long)1L, (long)dataManifests.size());
        Assert.assertEquals((String)"Should have one delete manifest file", (long)1L, (long)deleteManifests.size());
        Assert.assertEquals((Object)dataManifest, dataManifests.get(0));
        ManifestFile deleteManifest = (ManifestFile)deleteManifests.get(0);
        this.verifyManifestSequenceNumber(deleteManifest, 1L, 1L);
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have three task", (long)3L, (long)tasks.size());
        Optional<FileScanTask> task = tasks.stream().filter(t -> ((DataFile)t.file()).path().equals(FILE_A.path())).findFirst();
        Assert.assertTrue((boolean)task.isPresent());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.get().deletes().size());
        Assert.assertEquals((String)"Should have only pos delete file", (Object)FILE_A_EQ_1.path(), (Object)((DeleteFile)task.get().deletes().get(0)).path());
        this.table.newDelete().deleteFile(FILE_B).commit();
        dataManifests = this.table.currentSnapshot().dataManifests(ops.io());
        deleteManifests = this.table.currentSnapshot().deleteManifests(ops.io());
        Assert.assertEquals((String)"Should have one data manifest file", (long)1L, (long)dataManifests.size());
        Assert.assertEquals((String)"Should have one delete manifest file", (long)1L, (long)deleteManifests.size());
        ManifestFile dataManifest2 = (ManifestFile)dataManifests.get(0);
        this.verifyManifestSequenceNumber(dataManifest2, 2L, 0L);
        Assert.assertNotEquals((Object)dataManifest, (Object)dataManifest2);
        Assert.assertEquals((Object)deleteManifest, deleteManifests.get(0));
        tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have two task", (long)2L, (long)tasks.size());
        task = tasks.stream().filter(t -> ((DataFile)t.file()).path().equals(FILE_A.path())).findFirst();
        Assert.assertTrue((boolean)task.isPresent());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.get().deletes().size());
        this.table.newDelete().deleteFile(FILE_C).commit();
        dataManifests = this.table.currentSnapshot().dataManifests(ops.io());
        deleteManifests = this.table.currentSnapshot().deleteManifests(ops.io());
        Assert.assertEquals((String)"Should have one data manifest file", (long)1L, (long)dataManifests.size());
        Assert.assertEquals((String)"Should have one delete manifest file", (long)1L, (long)deleteManifests.size());
        ManifestFile dataManifest3 = (ManifestFile)dataManifests.get(0);
        this.verifyManifestSequenceNumber(dataManifest3, 3L, 0L);
        Assert.assertNotEquals((Object)dataManifest2, (Object)dataManifest3);
        Assert.assertEquals((Object)deleteManifest, deleteManifests.get(0));
        tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        task = tasks.stream().filter(t -> ((DataFile)t.file()).path().equals(FILE_A.path())).findFirst();
        Assert.assertTrue((boolean)task.isPresent());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.get().deletes().size());
    }

    @Test
    public void testPartitionedTableWithUnrelatedPartitionDeletes() {
        this.table.newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        TableOperations ops = this.table.operations();
        TableMetadata base = ops.current();
        ops.commit(base, base.upgradeToFormatVersion(2));
        this.table.newRowDelta().addDeletes(FILE_A_POS_1).addDeletes(FILE_A_EQ_1).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have three task", (long)3L, (long)tasks.size());
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_B.path(), (Object)((DataFile)((FileScanTask)tasks.get(0)).file()).path());
        Assert.assertEquals((String)"Should have zero associated delete file", (long)0L, (long)((FileScanTask)tasks.get(0)).deletes().size());
        this.table.newDelete().deleteFile(FILE_B).commit();
        tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have two task", (long)2L, (long)tasks.size());
        Assert.assertEquals((String)"Should have zero associated delete file", (long)0L, (long)((FileScanTask)tasks.get(0)).deletes().size());
        this.table.newDelete().deleteFile(FILE_C).commit();
        tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        Assert.assertEquals((String)"Should have zero associated delete file", (long)0L, (long)((FileScanTask)tasks.get(0)).deletes().size());
    }

    @Test
    public void testPartitionedTableWithExistingDeleteFile() {
        this.table.updateProperties().set("commit.manifest-merge.enabled", "false").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        TableOperations ops = this.table.operations();
        TableMetadata base = ops.current();
        ops.commit(base, base.upgradeToFormatVersion(2));
        this.table.newRowDelta().addDeletes(FILE_A_EQ_1).commit();
        this.table.newRowDelta().addDeletes(FILE_A_POS_1).commit();
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").set("commit.manifest-merge.enabled", "true").commit();
        Assert.assertEquals((String)"Should have two delete manifests", (long)2L, (long)this.table.currentSnapshot().deleteManifests(this.table.io()).size());
        this.table.newAppend().appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Should have one delete manifest", (long)1L, (long)this.table.currentSnapshot().deleteManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should have zero added delete file", (long)0L, (long)((ManifestFile)this.table.currentSnapshot().deleteManifests(this.table.io()).get(0)).addedFilesCount().intValue());
        Assert.assertEquals((String)"Should have zero deleted delete file", (long)0L, (long)((ManifestFile)this.table.currentSnapshot().deleteManifests(this.table.io()).get(0)).deletedFilesCount().intValue());
        Assert.assertEquals((String)"Should have two existing delete files", (long)2L, (long)((ManifestFile)this.table.currentSnapshot().deleteManifests(this.table.io()).get(0)).existingFilesCount().intValue());
        ArrayList tasks = Lists.newArrayList((Iterator)((TableScan)this.table.newScan().filter((Expression)Expressions.equal((UnboundTerm)Expressions.bucket((String)"data", (int)16), (Object)0))).planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have two associated delete files", (long)2L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have expected delete files", (Object)Sets.newHashSet((Object[])new CharSequence[]{FILE_A_EQ_1.path(), FILE_A_POS_1.path()}), (Object)Sets.newHashSet((Iterable)Iterables.transform((Iterable)task.deletes(), ContentFile::path)));
    }

    @Test
    public void testSequenceNumbersInUpgradedTables() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot appendSnapshot = this.table.currentSnapshot();
        this.validateManifest((ManifestFile)appendSnapshot.dataManifests(this.table.io()).get(0), TestV1ToV2RowDeltaDelete.dataSeqs(0L, 0L), TestV1ToV2RowDeltaDelete.fileSeqs(0L, 0L), TestV1ToV2RowDeltaDelete.ids(appendSnapshot.snapshotId(), appendSnapshot.snapshotId()), TestV1ToV2RowDeltaDelete.files(FILE_A, FILE_B), TestV1ToV2RowDeltaDelete.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.table.updateProperties().set("format-version", "2").commit();
        this.V1Assert.disable();
        this.V2Assert.enable();
        this.table.newRowDelta().addDeletes(FILE_A_DELETES).commit();
        Snapshot deltaSnapshot = this.table.currentSnapshot();
        this.validateManifest((ManifestFile)deltaSnapshot.dataManifests(this.table.io()).get(0), TestV1ToV2RowDeltaDelete.dataSeqs(0L, 0L), TestV1ToV2RowDeltaDelete.fileSeqs(0L, 0L), TestV1ToV2RowDeltaDelete.ids(appendSnapshot.snapshotId(), appendSnapshot.snapshotId()), TestV1ToV2RowDeltaDelete.files(FILE_A, FILE_B), TestV1ToV2RowDeltaDelete.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.validateDeleteManifest((ManifestFile)deltaSnapshot.deleteManifests(this.table.io()).get(0), TestV1ToV2RowDeltaDelete.dataSeqs(1L), TestV1ToV2RowDeltaDelete.fileSeqs(1L), TestV1ToV2RowDeltaDelete.ids(deltaSnapshot.snapshotId()), TestV1ToV2RowDeltaDelete.files(FILE_A_DELETES), TestV1ToV2RowDeltaDelete.statuses(ManifestEntry.Status.ADDED));
        this.table.newDelete().deleteFile(FILE_B).commit();
        Snapshot deleteSnapshot = this.table.currentSnapshot();
        this.validateManifest((ManifestFile)deleteSnapshot.dataManifests(this.table.io()).get(0), TestV1ToV2RowDeltaDelete.dataSeqs(0L, 0L), TestV1ToV2RowDeltaDelete.fileSeqs(0L, 0L), TestV1ToV2RowDeltaDelete.ids(appendSnapshot.snapshotId(), deleteSnapshot.snapshotId()), TestV1ToV2RowDeltaDelete.files(FILE_A, FILE_B), TestV1ToV2RowDeltaDelete.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.DELETED));
        this.validateDeleteManifest((ManifestFile)deleteSnapshot.deleteManifests(this.table.io()).get(0), TestV1ToV2RowDeltaDelete.dataSeqs(1L), TestV1ToV2RowDeltaDelete.fileSeqs(1L), TestV1ToV2RowDeltaDelete.ids(deltaSnapshot.snapshotId()), TestV1ToV2RowDeltaDelete.files(FILE_A_DELETES), TestV1ToV2RowDeltaDelete.statuses(ManifestEntry.Status.ADDED));
    }
}

