/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseUpdatePartitionSpec;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestUpdatePartitionSpec
extends TableTestBase {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"category", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"data", (Type)Types.StringType.get())});
    private static final PartitionSpec UNPARTITIONED = PartitionSpec.builderFor((Schema)SCHEMA).build();
    private static final PartitionSpec PARTITIONED = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").bucket("id", 16, "shard").build();

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestUpdatePartitionSpec(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testAddIdentityByName() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField("category").apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddIdentityByTerm() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.ref((String)"category")).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddYear() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.year((String)"ts")).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).year("ts").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddMonth() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.month((String)"ts")).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).month("ts").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddDay() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.day((String)"ts")).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddHour() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.hour((String)"ts")).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).hour("ts").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddBucket() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.bucket((String)"id", (int)16)).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).bucket("id", 16, "id_bucket_16").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddTruncate() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.truncate((String)"data", (int)4)).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).truncate("data", 4, "data_trunc_4").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddNamedPartition() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField("shard", (Term)Expressions.bucket((String)"id", (int)16)).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).bucket("id", 16, "shard").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddToExisting() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField((Term)Expressions.truncate((String)"data", (int)4)).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").bucket("id", 16, "shard").truncate("data", 4, "data_trunc_4").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testMultipleAdds() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField("category").addField((Term)Expressions.day((String)"ts")).addField("shard", (Term)Expressions.bucket((String)"id", (int)16)).addField("prefix", (Term)Expressions.truncate((String)"data", (int)4)).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").bucket("id", 16, "shard").truncate("data", 4, "prefix").build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testAddHourToDay() {
        PartitionSpec byDay = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.day((String)"ts")).apply();
        PartitionSpec byHour = new BaseUpdatePartitionSpec(this.formatVersion, byDay).addField((Term)Expressions.hour((String)"ts")).apply();
        Assert.assertEquals((String)"Should have a day and an hour time field", (Object)ImmutableList.of((Object)new PartitionField(2, 1000, "ts_day", Transforms.day()), (Object)new PartitionField(2, 1001, "ts_hour", Transforms.hour())), (Object)byHour.fields());
    }

    @Test
    public void testAddMultipleBuckets() {
        PartitionSpec bucket16 = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.bucket((String)"id", (int)16)).apply();
        PartitionSpec bucket8 = new BaseUpdatePartitionSpec(this.formatVersion, bucket16).addField((Term)Expressions.bucket((String)"id", (int)8)).apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).bucket("id", 16, "id_bucket_16").bucket("id", 8, "id_bucket_8").build();
        Assert.assertEquals((String)"Should have a day and an hour time field", (Object)expected, (Object)bucket8);
    }

    @Test
    public void testRemoveIdentityByName() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField("category").apply();
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)SCHEMA).alwaysNull("category", "category").day("ts").bucket("id", 16, "shard").build();
        this.V1Assert.assertEquals("Should match expected spec", v1Expected, updated);
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).add(TestUpdatePartitionSpec.id("ts"), 1001, "ts_day", Transforms.day()).add(TestUpdatePartitionSpec.id("id"), 1002, "shard", Transforms.bucket((int)16)).build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testRemoveBucketByName() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField("shard").apply();
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").alwaysNull("id", "shard").build();
        this.V1Assert.assertEquals("Should match expected spec", v1Expected, updated);
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).add(TestUpdatePartitionSpec.id("category"), 1000, "category", Transforms.identity()).add(TestUpdatePartitionSpec.id("ts"), 1001, "ts_day", Transforms.day()).build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testRemoveIdentityByEquivalent() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField((Term)Expressions.ref((String)"category")).apply();
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)SCHEMA).alwaysNull("category", "category").day("ts").bucket("id", 16, "shard").build();
        this.V1Assert.assertEquals("Should match expected spec", v1Expected, updated);
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).add(TestUpdatePartitionSpec.id("ts"), 1001, "ts_day", Transforms.day()).add(TestUpdatePartitionSpec.id("id"), 1002, "shard", Transforms.bucket((int)16)).build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testRemoveDayByEquivalent() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField((Term)Expressions.day((String)"ts")).apply();
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").alwaysNull("ts", "ts_day").bucket("id", 16, "shard").build();
        this.V1Assert.assertEquals("Should match expected spec", v1Expected, updated);
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).add(TestUpdatePartitionSpec.id("category"), 1000, "category", Transforms.identity()).add(TestUpdatePartitionSpec.id("id"), 1002, "shard", Transforms.bucket((int)16)).build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testRemoveBucketByEquivalent() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField((Term)Expressions.bucket((String)"id", (int)16)).apply();
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").alwaysNull("id", "shard").build();
        this.V1Assert.assertEquals("Should match expected spec", v1Expected, updated);
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testRename() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).renameField("shard", "id_bucket").apply();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").bucket("id", 16).build();
        Assert.assertEquals((String)"Should match expected spec", (Object)expected, (Object)updated);
    }

    @Test
    public void testMultipleChanges() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).renameField("shard", "id_bucket").removeField((Term)Expressions.day((String)"ts")).addField("prefix", (Term)Expressions.truncate((String)"data", (int)4)).apply();
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").alwaysNull("ts", "ts_day").bucket("id", 16).truncate("data", 4, "prefix").build();
        this.V1Assert.assertEquals("Should match expected spec", v1Expected, updated);
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).add(TestUpdatePartitionSpec.id("category"), 1000, "category", Transforms.identity()).add(TestUpdatePartitionSpec.id("id"), 1002, "id_bucket", Transforms.bucket((int)16)).add(TestUpdatePartitionSpec.id("data"), 1003, "prefix", Transforms.truncate((int)4)).build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testAddDeletedName() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField((Term)Expressions.bucket((String)"id", (int)16)).apply();
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").alwaysNull("id", "shard").build();
        this.V1Assert.assertEquals("Should match expected spec", v1Expected, updated);
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testRemoveNewlyAddedFieldByName() {
        AssertHelpers.assertThrows((String)"Should fail trying to remove unknown field", IllegalArgumentException.class, (String)"Cannot delete newly added field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField("prefix", (Term)Expressions.truncate((String)"data", (int)4)).removeField("prefix"));
    }

    @Test
    public void testRemoveNewlyAddedFieldByTransform() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot delete newly added field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField("prefix", (Term)Expressions.truncate((String)"data", (int)4)).removeField((Term)Expressions.truncate((String)"data", (int)4)));
    }

    @Test
    public void testAddAlreadyAddedFieldByTransform() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add duplicate partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField("prefix", (Term)Expressions.truncate((String)"data", (int)4)).addField((Term)Expressions.truncate((String)"data", (int)4)));
    }

    @Test
    public void testAddAlreadyAddedFieldByName() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add duplicate partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField("prefix", (Term)Expressions.truncate((String)"data", (int)4)).addField("prefix", (Term)Expressions.truncate((String)"data", (int)6)));
    }

    @Test
    public void testAddRedundantTimePartition() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add redundant partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField((Term)Expressions.day((String)"ts")).addField((Term)Expressions.hour((String)"ts")));
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add redundant partition", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField((Term)Expressions.hour((String)"ts")).addField((Term)Expressions.month((String)"ts")));
    }

    @Test
    public void testNoEffectAddDeletedSameFieldWithSameName() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField("shard").addField("shard", (Term)Expressions.bucket((String)"id", (int)16)).apply();
        Assert.assertEquals((Object)PARTITIONED, (Object)updated);
        updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField("shard").addField((Term)Expressions.bucket((String)"id", (int)16)).apply();
        Assert.assertEquals((Object)PARTITIONED, (Object)updated);
    }

    @Test
    public void testGenerateNewSpecAddDeletedSameFieldWithDifferentName() {
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField("shard").addField("new_shard", (Term)Expressions.bucket((String)"id", (int)16)).apply();
        Assert.assertEquals((String)"Should match expected field size", (long)3L, (long)updated.fields().size());
        Assert.assertEquals((String)"Should match expected field name", (Object)"category", (Object)((PartitionField)updated.fields().get(0)).name());
        Assert.assertEquals((String)"Should match expected field name", (Object)"ts_day", (Object)((PartitionField)updated.fields().get(1)).name());
        Assert.assertEquals((String)"Should match expected field name", (Object)"new_shard", (Object)((PartitionField)updated.fields().get(2)).name());
        Assert.assertEquals((String)"Should match expected field transform", (Object)"identity", (Object)((PartitionField)updated.fields().get(0)).transform().toString());
        Assert.assertEquals((String)"Should match expected field transform", (Object)"day", (Object)((PartitionField)updated.fields().get(1)).transform().toString());
        Assert.assertEquals((String)"Should match expected field transform", (Object)"bucket[16]", (Object)((PartitionField)updated.fields().get(2)).transform().toString());
    }

    @Test
    public void testAddDuplicateByName() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add duplicate partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField("category"));
    }

    @Test
    public void testAddDuplicateByRef() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add duplicate partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField((Term)Expressions.ref((String)"category")));
    }

    @Test
    public void testAddDuplicateTransform() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add duplicate partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField((Term)Expressions.bucket((String)"id", (int)16)));
    }

    @Test
    public void testAddNamedDuplicate() {
        AssertHelpers.assertThrows((String)"Should fail adding a duplicate field", IllegalArgumentException.class, (String)"Cannot add duplicate partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField("b16", (Term)Expressions.bucket((String)"id", (int)16)));
    }

    @Test
    public void testRemoveUnknownFieldByName() {
        AssertHelpers.assertThrows((String)"Should fail trying to remove unknown field", IllegalArgumentException.class, (String)"Cannot find partition field to remove", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField("moon"));
    }

    @Test
    public void testRemoveUnknownFieldByEquivalent() {
        AssertHelpers.assertThrows((String)"Should fail trying to remove unknown field", IllegalArgumentException.class, (String)"Cannot find partition field to remove", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField((Term)Expressions.hour((String)"ts")));
    }

    @Test
    public void testRenameUnknownField() {
        AssertHelpers.assertThrows((String)"Should fail trying to rename an unknown field", IllegalArgumentException.class, (String)"Cannot find partition field to rename", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).renameField("shake", "seal"));
    }

    @Test
    public void testRenameAfterAdd() {
        AssertHelpers.assertThrows((String)"Should fail trying to rename an added field", IllegalArgumentException.class, (String)"Cannot rename newly added partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).addField("data_trunc", (Term)Expressions.truncate((String)"data", (int)4)).renameField("data_trunc", "prefix"));
    }

    @Test
    public void testDeleteAndRename() {
        AssertHelpers.assertThrows((String)"Should fail trying to rename a deleted field", IllegalArgumentException.class, (String)"Cannot rename and delete partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).renameField("shard", "id_bucket").removeField((Term)Expressions.bucket((String)"id", (int)16)));
    }

    @Test
    public void testRenameAndDelete() {
        AssertHelpers.assertThrows((String)"Should fail trying to delete a renamed field", IllegalArgumentException.class, (String)"Cannot delete and rename partition field", () -> new BaseUpdatePartitionSpec(this.formatVersion, PARTITIONED).removeField((Term)Expressions.bucket((String)"id", (int)16)).renameField("shard", "id_bucket"));
    }

    @Test
    public void testRemoveAndAddMultiTimes() {
        PartitionSpec addFirstTime = new BaseUpdatePartitionSpec(this.formatVersion, UNPARTITIONED).addField("ts_date", (Term)Expressions.day((String)"ts")).apply();
        PartitionSpec removeFirstTime = new BaseUpdatePartitionSpec(this.formatVersion, addFirstTime).removeField((Term)Expressions.day((String)"ts")).apply();
        PartitionSpec addSecondTime = new BaseUpdatePartitionSpec(this.formatVersion, removeFirstTime).addField("ts_date", (Term)Expressions.day((String)"ts")).apply();
        PartitionSpec removeSecondTime = new BaseUpdatePartitionSpec(this.formatVersion, addSecondTime).removeField((Term)Expressions.day((String)"ts")).apply();
        PartitionSpec addThirdTime = new BaseUpdatePartitionSpec(this.formatVersion, removeSecondTime).addField((Term)Expressions.month((String)"ts")).apply();
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, addThirdTime).renameField("ts_month", "ts_date").apply();
        if (this.formatVersion == 1) {
            Assert.assertEquals((String)"Should match expected spec field size", (long)3L, (long)updated.fields().size());
            Assert.assertTrue((String)"Should match expected field name", (boolean)((PartitionField)updated.fields().get(0)).name().matches("^ts_date(?:_\\d+)+$"));
            Assert.assertTrue((String)"Should match expected field name", (boolean)((PartitionField)updated.fields().get(1)).name().matches("^ts_date_(?:\\d+)+$"));
            Assert.assertEquals((String)"Should match expected field name", (Object)"ts_date", (Object)((PartitionField)updated.fields().get(2)).name());
            Assert.assertEquals((String)"Should match expected field transform", (Object)"void", (Object)((PartitionField)updated.fields().get(0)).transform().toString());
            Assert.assertEquals((String)"Should match expected field transform", (Object)"void", (Object)((PartitionField)updated.fields().get(1)).transform().toString());
            Assert.assertEquals((String)"Should match expected field transform", (Object)"month", (Object)((PartitionField)updated.fields().get(2)).transform().toString());
        }
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)SCHEMA).month("ts", "ts_date").build();
        this.V2Assert.assertEquals("Should match expected spec", v2Expected, updated);
    }

    @Test
    public void testRemoveAndUpdateWithDifferentTransformation() {
        PartitionSpec expected = PartitionSpec.builderFor((Schema)SCHEMA).month("ts", "ts_transformed").build();
        PartitionSpec updated = new BaseUpdatePartitionSpec(this.formatVersion, expected).removeField("ts_transformed").addField("ts_transformed", (Term)Expressions.day((String)"ts")).apply();
        if (this.formatVersion == 1) {
            Assert.assertEquals((String)"Should match expected spec field size", (long)2L, (long)updated.fields().size());
            Assert.assertEquals((String)"Should match expected field name", (Object)"ts_transformed_1000", (Object)((PartitionField)updated.fields().get(0)).name());
            Assert.assertEquals((String)"Should match expected field name", (Object)"ts_transformed", (Object)((PartitionField)updated.fields().get(1)).name());
            Assert.assertEquals((String)"Should match expected field transform", (Object)"void", (Object)((PartitionField)updated.fields().get(0)).transform().toString());
            Assert.assertEquals((String)"Should match expected field transform", (Object)"day", (Object)((PartitionField)updated.fields().get(1)).transform().toString());
        } else {
            Assert.assertEquals((String)"Should match expected spec field size", (long)1L, (long)updated.fields().size());
            Assert.assertEquals((String)"Should match expected field name", (Object)"ts_transformed", (Object)((PartitionField)updated.fields().get(0)).name());
            Assert.assertEquals((String)"Should match expected field transform", (Object)"day", (Object)((PartitionField)updated.fields().get(0)).transform().toString());
        }
    }

    private static int id(String name) {
        return SCHEMA.findField(name).fieldId();
    }
}

