/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTransaction
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestTransaction(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testEmptyTransaction() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        txn.commitTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
    }

    @Test
    public void testSingleOperationTransaction() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after txn create", (long)0L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertSame((String)"Base metadata should not change when an append is committed", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after append", (long)0L, (long)this.version().intValue());
        txn.commitTransaction();
        this.validateSnapshot(base.currentSnapshot(), this.readMetadata().currentSnapshot(), FILE_A, FILE_B);
        Assert.assertEquals((String)"Table should be on version 1 after commit", (long)1L, (long)this.version().intValue());
    }

    @Test
    public void testMultipleOperationTransaction() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        this.table.newAppend().appendFile(FILE_C).commit();
        List initialHistory = this.table.history();
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after txn create", (long)1L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after txn create", (long)1L, (long)this.version().intValue());
        Snapshot appendSnapshot = txn.table().currentSnapshot();
        txn.newDelete().deleteFile(FILE_A).commit();
        Snapshot deleteSnapshot = txn.table().currentSnapshot();
        Assert.assertSame((String)"Base metadata should not change when an append is committed", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after append", (long)1L, (long)this.version().intValue());
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 2 after commit", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Table should have two manifest after commit", (long)2L, (long)this.readMetadata().currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Table snapshot should be the delete snapshot", (Object)deleteSnapshot, (Object)this.readMetadata().currentSnapshot());
        TestTransaction.validateManifestEntries((ManifestFile)this.readMetadata().currentSnapshot().allManifests(this.table.io()).get(0), TestTransaction.ids(deleteSnapshot.snapshotId(), appendSnapshot.snapshotId()), TestTransaction.files(FILE_A, FILE_B), TestTransaction.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Assert.assertEquals((String)"Table should have a snapshot for each operation", (long)3L, (long)this.readMetadata().snapshots().size());
        TestTransaction.validateManifestEntries((ManifestFile)((Snapshot)this.readMetadata().snapshots().get(1)).allManifests(this.table.io()).get(0), TestTransaction.ids(appendSnapshot.snapshotId(), appendSnapshot.snapshotId()), TestTransaction.files(FILE_A, FILE_B), TestTransaction.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Assertions.assertThat((List)this.table.history()).containsAll((Iterable)initialHistory);
    }

    @Test
    public void testMultipleOperationTransactionFromTable() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after txn create", (long)0L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after txn create", (long)0L, (long)this.version().intValue());
        Snapshot appendSnapshot = txn.table().currentSnapshot();
        txn.table().newDelete().deleteFile(FILE_A).commit();
        Snapshot deleteSnapshot = txn.table().currentSnapshot();
        Assert.assertSame((String)"Base metadata should not change when an append is committed", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after append", (long)0L, (long)this.version().intValue());
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 1 after commit", (long)1L, (long)this.version().intValue());
        Assert.assertEquals((String)"Table should have one manifest after commit", (long)1L, (long)this.readMetadata().currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertEquals((String)"Table snapshot should be the delete snapshot", (Object)deleteSnapshot, (Object)this.readMetadata().currentSnapshot());
        TestTransaction.validateManifestEntries((ManifestFile)this.readMetadata().currentSnapshot().allManifests(this.table.io()).get(0), TestTransaction.ids(deleteSnapshot.snapshotId(), appendSnapshot.snapshotId()), TestTransaction.files(FILE_A, FILE_B), TestTransaction.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Assert.assertEquals((String)"Table should have a snapshot for each operation", (long)2L, (long)this.readMetadata().snapshots().size());
        TestTransaction.validateManifestEntries((ManifestFile)((Snapshot)this.readMetadata().snapshots().get(0)).allManifests(this.table.io()).get(0), TestTransaction.ids(appendSnapshot.snapshotId(), appendSnapshot.snapshotId()), TestTransaction.files(FILE_A, FILE_B), TestTransaction.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testDetectsUncommittedChange() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after txn create", (long)0L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B);
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after txn create", (long)0L, (long)this.version().intValue());
        AssertHelpers.assertThrows((String)"Should reject commit when last operation has not committed", IllegalStateException.class, (String)"Cannot create new DeleteFiles: last operation has not committed", () -> ((Transaction)txn).newDelete());
    }

    @Test
    public void testDetectsUncommittedChangeOnCommit() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after txn create", (long)0L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B);
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 0 after txn create", (long)0L, (long)this.version().intValue());
        AssertHelpers.assertThrows((String)"Should reject commit when last operation has not committed", IllegalStateException.class, (String)"Cannot commit transaction: last operation has not committed", () -> ((Transaction)txn).commitTransaction());
    }

    @Test
    public void testTransactionConflict() {
        this.table.updateProperties().set("commit.retry.num-retries", "0").commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after txn create", (long)1L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after append", (long)1L, (long)this.version().intValue());
        this.table.ops().failCommits(1);
        AssertHelpers.assertThrows((String)"Transaction commit should fail", CommitFailedException.class, (String)"Injected failure", () -> ((Transaction)txn).commitTransaction());
    }

    @Test
    public void testTransactionRetry() {
        this.table.updateProperties().set("commit.retry.num-retries", "1").commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after txn create", (long)1L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        HashSet appendManifests = Sets.newHashSet((Iterable)txn.table().currentSnapshot().allManifests(this.table.io()));
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after append", (long)1L, (long)this.version().intValue());
        this.table.ops().failCommits(1);
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 2 after commit", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Should reuse manifests from initial append commit", (Object)appendManifests, (Object)Sets.newHashSet((Iterable)this.table.currentSnapshot().allManifests(this.table.io())));
    }

    @Test
    public void testTransactionRetryMergeAppend() {
        this.table.updateProperties().set("commit.retry.num-retries", "1").commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after txn create", (long)1L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        HashSet appendManifests = Sets.newHashSet((Iterable)txn.table().currentSnapshot().allManifests(this.table.io()));
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after append", (long)1L, (long)this.version().intValue());
        this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        Assert.assertEquals((String)"Table should be on version 2 after real append", (long)2L, (long)this.version().intValue());
        HashSet conflictAppendManifests = Sets.newHashSet((Iterable)this.table.currentSnapshot().allManifests(this.table.io()));
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 3 after commit", (long)3L, (long)this.version().intValue());
        HashSet expectedManifests = Sets.newHashSet();
        expectedManifests.addAll(appendManifests);
        expectedManifests.addAll(conflictAppendManifests);
        Assert.assertEquals((String)"Should reuse manifests from initial append commit and conflicting append", (Object)expectedManifests, (Object)Sets.newHashSet((Iterable)this.table.currentSnapshot().allManifests(this.table.io())));
    }

    @Test
    public void testMultipleUpdateTransactionRetryMergeCleanup() {
        this.table.updateProperties().set("commit.retry.num-retries", "1").set("commit.manifest.min-count-to-merge", "0").commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after txn create", (long)1L, (long)this.version().intValue());
        txn.updateProperties().set("test-property", "test-value").commit();
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Append should create one manifest", (long)1L, (long)txn.table().currentSnapshot().allManifests(this.table.io()).size());
        ManifestFile appendManifest = (ManifestFile)txn.table().currentSnapshot().allManifests(this.table.io()).get(0);
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after append", (long)1L, (long)this.version().intValue());
        this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        Assert.assertEquals((String)"Table should be on version 2 after real append", (long)2L, (long)this.version().intValue());
        HashSet conflictAppendManifests = Sets.newHashSet((Iterable)this.table.currentSnapshot().allManifests(this.table.io()));
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 3 after commit", (long)3L, (long)this.version().intValue());
        HashSet previousManifests = Sets.newHashSet();
        previousManifests.add(appendManifest);
        previousManifests.addAll(conflictAppendManifests);
        Assert.assertEquals((String)"Should merge both commit manifests into a single manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertFalse((String)"Should merge both commit manifests into a new manifest", (boolean)previousManifests.contains(this.table.currentSnapshot().allManifests(this.table.io()).get(0)));
        Assert.assertFalse((String)"Append manifest should be deleted", (boolean)new File(appendManifest.path()).exists());
    }

    @Test
    public void testTransactionRetrySchemaUpdate() {
        this.table.updateProperties().set("commit.retry.num-retries", "1").commit();
        Transaction txn = this.table.newTransaction();
        txn.updateSchema().addColumn("new-column", (Type)Types.IntegerType.get()).commit();
        int schemaId = txn.table().schema().schemaId();
        this.table.updateSchema().addColumn("another-column", (Type)Types.IntegerType.get()).commit();
        int conflictingSchemaId = this.table.schema().schemaId();
        Assert.assertEquals((String)"Both schema IDs should be the same in order to cause a conflict", (long)conflictingSchemaId, (long)schemaId);
        AssertHelpers.assertThrows((String)"Should fail due to conflicting transaction even after retry", CommitFailedException.class, (String)"Table metadata refresh is required", () -> ((Transaction)txn).commitTransaction());
    }

    @Test
    public void testTransactionRetryMergeCleanup() {
        this.table.updateProperties().set("commit.retry.num-retries", "1").set("commit.manifest.min-count-to-merge", "0").commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after txn create", (long)1L, (long)this.version().intValue());
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Append should create one manifest", (long)1L, (long)txn.table().currentSnapshot().allManifests(this.table.io()).size());
        ManifestFile appendManifest = (ManifestFile)txn.table().currentSnapshot().allManifests(this.table.io()).get(0);
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 1 after append", (long)1L, (long)this.version().intValue());
        this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        Assert.assertEquals((String)"Table should be on version 2 after real append", (long)2L, (long)this.version().intValue());
        HashSet conflictAppendManifests = Sets.newHashSet((Iterable)this.table.currentSnapshot().allManifests(this.table.io()));
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 3 after commit", (long)3L, (long)this.version().intValue());
        HashSet previousManifests = Sets.newHashSet();
        previousManifests.add(appendManifest);
        previousManifests.addAll(conflictAppendManifests);
        Assert.assertEquals((String)"Should merge both commit manifests into a single manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        Assert.assertFalse((String)"Should merge both commit manifests into a new manifest", (boolean)previousManifests.contains(this.table.currentSnapshot().allManifests(this.table.io()).get(0)));
        Assert.assertFalse((String)"Append manifest should be deleted", (boolean)new File(appendManifest.path()).exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionRetryAndAppendManifests() throws Exception {
        this.table.updateProperties().set("commit.retry.num-retries", "1").set("commit.manifest.min-count-to-merge", "0").commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Table should be on version 2 after append", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Append should create one manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        ManifestFile v1manifest = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        TableMetadata base = this.readMetadata();
        OutputFile manifestLocation = Files.localOutput((String)("/tmp/" + UUID.randomUUID().toString() + ".avro"));
        try (ManifestWriter writer = ManifestFiles.write((PartitionSpec)this.table.spec(), (OutputFile)manifestLocation);){
            writer.add((ContentFile)FILE_D);
        }
        Transaction txn = this.table.newTransaction();
        txn.newAppend().appendManifest(writer.toManifestFile()).commit();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 2 after txn create", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Append should have one merged manifest", (long)1L, (long)txn.table().currentSnapshot().allManifests(this.table.io()).size());
        ManifestFile mergedManifest = (ManifestFile)txn.table().currentSnapshot().allManifests(this.table.io()).get(0);
        String copiedAppendManifest = (String)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)Iterables.transform(this.listManifestFiles(), File::getPath), path -> !v1manifest.path().contains((CharSequence)path) && !mergedManifest.path().contains((CharSequence)path)));
        Assert.assertTrue((String)"Transaction should hijack the delete of the original copied manifest", (boolean)((BaseTransaction)txn).deletedFiles().contains(copiedAppendManifest));
        Assert.assertTrue((String)"Copied append manifest should not be deleted yet", (boolean)new File(copiedAppendManifest).exists());
        this.table.newAppend().appendFile(FILE_C).commit();
        Assert.assertEquals((String)"Table should be on version 3 after real append", (long)3L, (long)this.version().intValue());
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 4 after commit", (long)4L, (long)this.version().intValue());
        Assert.assertTrue((String)"Transaction should hijack the delete of the original copied manifest", (boolean)((BaseTransaction)txn).deletedFiles().contains(copiedAppendManifest));
        Assert.assertFalse((String)"Append manifest should be deleted", (boolean)new File(copiedAppendManifest).exists());
        Assert.assertTrue((String)"Transaction should hijack the delete of the first merged manifest", (boolean)((BaseTransaction)txn).deletedFiles().contains(mergedManifest.path()));
        Assert.assertFalse((String)"Append manifest should be deleted", (boolean)new File(mergedManifest.path()).exists());
        Assert.assertEquals((String)"Should merge all commit manifests into a single manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
    }

    @Test
    public void testTransactionRetryAndAppendManifestsWithSnapshotIdInheritance() throws Exception {
        this.table.updateProperties().set("commit.retry.num-retries", "1").set("commit.manifest.min-count-to-merge", "0").set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Table should be on version 2 after append", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Append should create one manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        ManifestFile appendManifest = this.writeManifestWithName("input.m0", FILE_D);
        txn.newAppend().appendManifest(appendManifest).commit();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 2 after txn create", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Append should have one merged manifest", (long)1L, (long)txn.table().currentSnapshot().allManifests(this.table.io()).size());
        ManifestFile mergedManifest = (ManifestFile)txn.table().currentSnapshot().allManifests(this.table.io()).get(0);
        this.table.newAppend().appendFile(FILE_C).commit();
        Assert.assertEquals((String)"Table should be on version 3 after real append", (long)3L, (long)this.version().intValue());
        txn.commitTransaction();
        Assert.assertEquals((String)"Table should be on version 4 after commit", (long)4L, (long)this.version().intValue());
        Assert.assertTrue((String)"Transaction should hijack the delete of the original append manifest", (boolean)((BaseTransaction)txn).deletedFiles().contains(appendManifest.path()));
        Assert.assertFalse((String)"Append manifest should be deleted", (boolean)new File(appendManifest.path()).exists());
        Assert.assertTrue((String)"Transaction should hijack the delete of the first merged manifest", (boolean)((BaseTransaction)txn).deletedFiles().contains(mergedManifest.path()));
        Assert.assertFalse((String)"Merged append manifest should be deleted", (boolean)new File(mergedManifest.path()).exists());
        Assert.assertEquals((String)"Should merge all commit manifests into a single manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
    }

    @Test
    public void testTransactionNoCustomDeleteFunc() {
        AssertHelpers.assertThrows((String)"Should fail setting a custom delete function with a transaction", IllegalArgumentException.class, (String)"Cannot set delete callback more than once", () -> (AppendFiles)this.table.newTransaction().newAppend().appendFile(FILE_A).appendFile(FILE_B).deleteWith(file -> {}));
    }

    @Test
    public void testTransactionFastAppends() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "0").commit();
        Transaction txn = this.table.newTransaction();
        txn.newFastAppend().appendFile(FILE_A).commit();
        txn.newFastAppend().appendFile(FILE_B).commit();
        txn.commitTransaction();
        List manifests = this.table.currentSnapshot().allManifests(this.table.io());
        Assert.assertEquals((String)"Expected 2 manifests", (long)2L, (long)manifests.size());
    }

    @Test
    public void testTransactionRewriteManifestsAppendedDirectly() throws IOException {
        TestTables.TestTable table = this.load();
        table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").set("commit.manifest.min-count-to-merge", "0").commit();
        table.newFastAppend().appendFile(FILE_A).commit();
        long firstSnapshotId = table.currentSnapshot().snapshotId();
        table.newFastAppend().appendFile(FILE_B).commit();
        long secondSnapshotId = table.currentSnapshot().snapshotId();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests after 2 appends", (long)2L, (long)manifests.size());
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshotId, FILE_A), this.manifestEntry(ManifestEntry.Status.EXISTING, secondSnapshotId, FILE_B));
        Transaction txn = table.newTransaction();
        txn.rewriteManifests().deleteManifest((ManifestFile)manifests.get(0)).deleteManifest((ManifestFile)manifests.get(1)).addManifest(newManifest).commit();
        txn.newAppend().appendFile(FILE_C).commit();
        txn.commitTransaction();
        long finalSnapshotId = table.currentSnapshot().snapshotId();
        long finalSnapshotTimestamp = System.currentTimeMillis();
        Assert.assertTrue((String)"Append manifest should not be deleted", (boolean)new File(newManifest.path()).exists());
        List finalManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 final manifest", (long)1L, (long)finalManifests.size());
        TestTransaction.validateManifestEntries((ManifestFile)finalManifests.get(0), TestTransaction.ids(finalSnapshotId, firstSnapshotId, secondSnapshotId), TestTransaction.files(FILE_C, FILE_A, FILE_B), TestTransaction.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        table.expireSnapshots().expireOlderThan(finalSnapshotTimestamp + 1L).retainLast(1).commit();
        Assert.assertFalse((String)"Append manifest should be deleted on expiry", (boolean)new File(newManifest.path()).exists());
    }

    @Test
    public void testSimpleTransactionNotDeletingMetadataOnUnknownSate() throws IOException {
        TestTables.TestTable table = TestTables.tableWithCommitSucceedButStateUnknown(this.tableDir, "test");
        Transaction transaction = table.newTransaction();
        transaction.newAppend().appendFile(FILE_A).commit();
        AssertHelpers.assertThrows((String)"Transaction commit should fail with CommitStateUnknownException", CommitStateUnknownException.class, (String)"datacenter on fire", () -> transaction.commitTransaction());
        Snapshot current = table.currentSnapshot();
        List manifests = current.allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifest file", (long)1L, (long)manifests.size());
        Assert.assertTrue((String)"Manifest file should exist", (boolean)new File(((ManifestFile)manifests.get(0)).path()).exists());
        Assert.assertEquals((String)"Should have 2 files in metadata", (long)2L, (long)TestTransaction.countAllMetadataFiles(this.tableDir));
    }
}

