/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTimestampPartitions
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestTimestampPartitions(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testPartitionAppend() throws IOException {
        Schema dateSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"timestamp", (Type)Types.TimestampType.withoutZone())});
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)dateSchema).day("timestamp", "date").build();
        DataFile dataFile = DataFiles.builder((PartitionSpec)partitionSpec).withPath("/path/to/data-1.parquet").withFileSizeInBytes(0L).withRecordCount(0L).withPartitionPath("date=2018-06-08").build();
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        this.table = TestTables.create(tableDir, "test_date_partition", dateSchema, partitionSpec, this.formatVersion);
        this.table.newAppend().appendFile(dataFile).commit();
        long id = this.table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)this.table.currentSnapshot().allManifests(this.table.io()).size(), (long)1L);
        TestTimestampPartitions.validateManifestEntries((ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0), TestTimestampPartitions.ids(id), TestTimestampPartitions.files(dataFile), TestTimestampPartitions.statuses(ManifestEntry.Status.ADDED));
    }
}

