/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Files;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class TestTables {
    private static final Map<String, TableMetadata> METADATA = Maps.newHashMap();
    private static final Map<String, Integer> VERSIONS = Maps.newHashMap();

    private TestTables() {
    }

    private static TestTable upgrade(File temp, String name, int newFormatVersion) {
        TestTable table = TestTables.load(temp, name);
        TestTableOperations ops = table.ops();
        TableMetadata base = ops.current();
        ops.commit(base, ops.current().upgradeToFormatVersion(newFormatVersion));
        return table;
    }

    public static TestTable create(File temp, String name, Schema schema, PartitionSpec spec, int formatVersion) {
        return TestTables.create(temp, name, schema, spec, SortOrder.unsorted(), formatVersion);
    }

    public static TestTable create(File temp, String name, Schema schema, PartitionSpec spec, SortOrder sortOrder, int formatVersion) {
        TestTableOperations ops = new TestTableOperations(name, temp);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table %s already exists at location: %s", new Object[]{name, temp});
        }
        ops.commit(null, TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (SortOrder)sortOrder, (String)temp.toString(), (Map)ImmutableMap.of(), (int)formatVersion));
        return new TestTable(ops, name);
    }

    public static TestTable create(File temp, String name, Schema schema, PartitionSpec spec, SortOrder sortOrder, int formatVersion, MetricsReporter reporter) {
        TestTableOperations ops = new TestTableOperations(name, temp);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table %s already exists at location: %s", new Object[]{name, temp});
        }
        ops.commit(null, TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (SortOrder)sortOrder, (String)temp.toString(), (Map)ImmutableMap.of(), (int)formatVersion));
        return new TestTable(ops, name, reporter);
    }

    public static Transaction beginCreate(File temp, String name, Schema schema, PartitionSpec spec) {
        return TestTables.beginCreate(temp, name, schema, spec, SortOrder.unsorted());
    }

    public static Transaction beginCreate(File temp, String name, Schema schema, PartitionSpec spec, SortOrder sortOrder) {
        TestTableOperations ops = new TestTableOperations(name, temp);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table %s already exists at location: %s", new Object[]{name, temp});
        }
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (SortOrder)sortOrder, (String)temp.toString(), (Map)ImmutableMap.of(), (int)1);
        return Transactions.createTableTransaction((String)name, (TableOperations)ops, (TableMetadata)metadata);
    }

    public static Transaction beginReplace(File temp, String name, Schema schema, PartitionSpec spec) {
        return TestTables.beginReplace(temp, name, schema, spec, SortOrder.unsorted(), (Map<String, String>)ImmutableMap.of(), new TestTableOperations(name, temp));
    }

    public static Transaction beginReplace(File temp, String name, Schema schema, PartitionSpec spec, SortOrder sortOrder, Map<String, String> properties) {
        return TestTables.beginReplace(temp, name, schema, spec, sortOrder, properties, new TestTableOperations(name, temp));
    }

    public static Transaction beginReplace(File temp, String name, Schema schema, PartitionSpec spec, SortOrder sortOrder, Map<String, String> properties, TestTableOperations ops) {
        TableMetadata current = ops.current();
        if (current != null) {
            TableMetadata metadata = current.buildReplacement(schema, spec, sortOrder, current.location(), properties);
            return Transactions.replaceTableTransaction((String)name, (TableOperations)ops, (TableMetadata)metadata);
        }
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (SortOrder)sortOrder, (String)temp.toString(), properties);
        return Transactions.createTableTransaction((String)name, (TableOperations)ops, (TableMetadata)metadata);
    }

    public static TestTable load(File temp, String name) {
        TestTableOperations ops = new TestTableOperations(name, temp);
        return new TestTable(ops, name);
    }

    public static TestTable tableWithCommitSucceedButStateUnknown(File temp, String name) {
        TestTableOperations ops = TestTables.opsWithCommitSucceedButStateUnknown(temp, name);
        return new TestTable(ops, name);
    }

    public static TestTableOperations opsWithCommitSucceedButStateUnknown(File temp, String name) {
        return new TestTableOperations(name, temp){

            @Override
            public void commit(TableMetadata base, TableMetadata updatedMetadata) {
                super.commit(base, updatedMetadata);
                throw new CommitStateUnknownException((Throwable)new RuntimeException("datacenter on fire"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTables() {
        Map<String, TableMetadata> map = METADATA;
        synchronized (map) {
            METADATA.clear();
            VERSIONS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TableMetadata readMetadata(String tableName) {
        Map<String, TableMetadata> map = METADATA;
        synchronized (map) {
            return METADATA.get(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer metadataVersion(String tableName) {
        Map<String, TableMetadata> map = METADATA;
        synchronized (map) {
            return VERSIONS.get(tableName);
        }
    }

    static class LocalFileIO
    implements FileIO {
        LocalFileIO() {
        }

        public InputFile newInputFile(String path) {
            return Files.localInput((String)path);
        }

        public OutputFile newOutputFile(String path) {
            return Files.localOutput((String)path);
        }

        public void deleteFile(String path) {
            if (!new File(path).delete()) {
                throw new RuntimeIOException("Failed to delete file: " + path, new Object[0]);
            }
        }
    }

    public static class TestTableOperations
    implements TableOperations {
        private final String tableName;
        private final File metadata;
        private TableMetadata current = null;
        private long lastSnapshotId = 0L;
        private int failCommits = 0;

        public TestTableOperations(String tableName, File location) {
            this.tableName = tableName;
            this.metadata = new File(location, "metadata");
            this.metadata.mkdirs();
            this.refresh();
            if (this.current != null) {
                for (Snapshot snap : this.current.snapshots()) {
                    this.lastSnapshotId = Math.max(this.lastSnapshotId, snap.snapshotId());
                }
            } else {
                this.lastSnapshotId = 0L;
            }
        }

        void failCommits(int numFailures) {
            this.failCommits = numFailures;
        }

        public TableMetadata current() {
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TableMetadata refresh() {
            Map map = METADATA;
            synchronized (map) {
                this.current = (TableMetadata)METADATA.get(this.tableName);
            }
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(TableMetadata base, TableMetadata updatedMetadata) {
            if (base != this.current) {
                throw new CommitFailedException("Cannot commit changes based on stale metadata", new Object[0]);
            }
            Map map = METADATA;
            synchronized (map) {
                this.refresh();
                if (base == this.current) {
                    if (this.failCommits > 0) {
                        --this.failCommits;
                        throw new CommitFailedException("Injected failure", new Object[0]);
                    }
                } else {
                    throw new CommitFailedException("Commit failed: table was updated at %d", new Object[]{this.current.lastUpdatedMillis()});
                }
                Integer version = (Integer)VERSIONS.get(this.tableName);
                this.current = TableMetadata.buildFrom((TableMetadata)updatedMetadata).discardChanges().build();
                VERSIONS.put(this.tableName, version == null ? 0 : version + 1);
                METADATA.put(this.tableName, this.current);
            }
        }

        public FileIO io() {
            return new LocalFileIO();
        }

        public LocationProvider locationProvider() {
            Preconditions.checkNotNull((Object)this.current, (Object)"Current metadata should not be null when locationProvider is called");
            return LocationProviders.locationsFor((String)this.current.location(), (Map)this.current.properties());
        }

        public String metadataFileLocation(String fileName) {
            return new File(this.metadata, fileName).getAbsolutePath();
        }

        public long newSnapshotId() {
            long nextSnapshotId;
            this.lastSnapshotId = nextSnapshotId = this.lastSnapshotId + 1L;
            return nextSnapshotId;
        }
    }

    public static class TestTable
    extends BaseTable {
        private final TestTableOperations ops;

        private TestTable(TestTableOperations ops, String name) {
            super((TableOperations)ops, name);
            this.ops = ops;
        }

        private TestTable(TestTableOperations ops, String name, MetricsReporter reporter) {
            super((TableOperations)ops, name, reporter);
            this.ops = ops;
        }

        TestTableOperations ops() {
            return this.ops;
        }
    }
}

