/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTableUpdatePartitionSpec
extends TableTestBase {
    @Parameterized.Parameters
    public static Object[][] parameters() {
        return new Object[][]{{1}, {2}};
    }

    public TestTableUpdatePartitionSpec(int formatVersion) {
        super(formatVersion);
    }

    @Before
    public void verifyInitialSpec() {
        PartitionSpec initialSpec = PartitionSpec.builderFor((Schema)this.table.schema()).bucket("data", 16).build();
        Assert.assertEquals((String)"Should use the expected initial spec", (Object)initialSpec, (Object)this.table.spec());
        Assert.assertEquals((long)1000L, (long)this.table.spec().lastAssignedFieldId());
        Assert.assertEquals((long)0L, (long)this.table.spec().specId());
    }

    @Test
    public void testCommitUpdatedSpec() {
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"id", (int)8)).commit();
        PartitionSpec evolvedSpec = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).bucket("data", 16).bucket("id", 8, "id_bucket_8").build();
        Assert.assertEquals((String)"Should append a partition field to the spec", (Object)evolvedSpec, (Object)this.table.spec());
        Assert.assertEquals((long)1001L, (long)this.table.spec().lastAssignedFieldId());
        this.table.updateSpec().removeField("id_bucket_8").removeField("data_bucket").addField((Term)Expressions.truncate((String)"data", (int)8)).commit();
        this.V1Assert.assertEquals("Should soft delete id and data buckets", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(2).alwaysNull("data", "data_bucket").alwaysNull("id", "id_bucket_8").truncate("data", 8, "data_trunc_8").build(), this.table.spec());
        this.V2Assert.assertEquals("Should hard delete id and data buckets", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(2).add(2, 1002, "data_trunc_8", Transforms.truncate((int)8)).build(), this.table.spec());
        Assert.assertEquals((long)1002L, (long)this.table.spec().lastAssignedFieldId());
    }

    @Test
    public void testNoopCommit() {
        TableMetadata current = this.table.ops().current();
        int currentVersion = TestTables.metadataVersion("test");
        this.table.updateSpec().commit();
        TableMetadata updated = this.table.ops().current();
        Integer updatedVersion = TestTables.metadataVersion("test");
        Assert.assertEquals((Object)current, (Object)updated);
        Assert.assertEquals((long)(++currentVersion), (long)updatedVersion.intValue());
        this.table.updateSpec().renameField("data_bucket", "data_bucket").commit();
        updated = this.table.ops().current();
        updatedVersion = TestTables.metadataVersion("test");
        Assert.assertEquals((Object)current, (Object)updated);
        Assert.assertEquals((long)(++currentVersion), (long)updatedVersion.intValue());
    }

    @Test
    public void testRenameField() {
        this.table.updateSpec().renameField("data_bucket", "data_partition").addField((Term)Expressions.bucket((String)"id", (int)8)).commit();
        PartitionSpec evolvedSpec = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).bucket("data", 16, "data_partition").bucket("id", 8, "id_bucket_8").build();
        Assert.assertEquals((String)"should match evolved spec", (Object)evolvedSpec, (Object)this.table.spec());
        Assert.assertEquals((long)1001L, (long)this.table.spec().lastAssignedFieldId());
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"id", (int)4)).renameField("data_partition", "data_bucket").commit();
        evolvedSpec = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(2).bucket("data", 16, "data_bucket").bucket("id", 8, "id_bucket_8").truncate("id", 4, "id_trunc_4").build();
        Assert.assertEquals((String)"should match evolved spec", (Object)evolvedSpec, (Object)this.table.spec());
        Assert.assertEquals((long)1002L, (long)this.table.spec().lastAssignedFieldId());
    }

    @Test
    public void testRenameOnlyEvolution() {
        this.table.updateSpec().renameField("data_bucket", "data_partition").commit();
        PartitionSpec evolvedSpec = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).bucket("data", 16, "data_partition").build();
        Assert.assertEquals((String)"should match evolved spec", (Object)evolvedSpec, (Object)this.table.spec());
        Assert.assertEquals((long)1000L, (long)this.table.spec().lastAssignedFieldId());
    }

    @Test
    public void testRemoveAndAddField() {
        this.table.updateSpec().removeField("data_bucket").addField((Term)Expressions.bucket((String)"id", (int)8)).commit();
        this.V1Assert.assertEquals("Should soft delete data bucket", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).alwaysNull("data", "data_bucket").bucket("id", 8, "id_bucket_8").build(), this.table.spec());
        this.V2Assert.assertEquals("Should hard delete data bucket", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).add(1, 1001, "id_bucket_8", Transforms.bucket((int)8)).build(), this.table.spec());
        Assert.assertEquals((long)1001L, (long)this.table.spec().lastAssignedFieldId());
    }

    @Test
    public void testRemoveAndAddYearField() {
        this.table.updateSchema().addColumn("year_field", (Type)Types.DateType.get()).commit();
        this.table.updateSpec().addField((Term)Expressions.year((String)"year_field")).commit();
        PartitionSpec evolvedSpec = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).bucket("data", 16).year("year_field").build();
        Assert.assertEquals((String)"should match evolved spec", (Object)evolvedSpec, (Object)this.table.spec());
        Assert.assertEquals((long)1001L, (long)this.table.spec().lastAssignedFieldId());
        this.table.updateSpec().removeField("year_field_year").addField((Term)Expressions.year((String)"year_field")).commit();
        this.V1Assert.assertEquals("Should soft delete id and data buckets", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).bucket("data", 16).year("year_field").build(), this.table.spec());
        this.V2Assert.assertEquals("Should remove and then add a year field", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).bucket("data", 16).add(3, 1001, "year_field_year", Transforms.year()).build(), this.table.spec());
        Assert.assertEquals((long)1001L, (long)this.table.spec().lastAssignedFieldId());
    }

    @Test
    public void testAddAndRemoveField() {
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)6)).removeField("data_bucket").commit();
        this.V1Assert.assertEquals("Should remove and then add a bucket field", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).alwaysNull("data", "data_bucket").bucket("data", 6, "data_bucket_6").build(), this.table.spec());
        this.V2Assert.assertEquals("Should remove and then add a bucket field", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).add(2, 1001, "data_bucket_6", Transforms.bucket((int)6)).build(), this.table.spec());
        Assert.assertEquals((long)1001L, (long)this.table.spec().lastAssignedFieldId());
    }

    @Test
    public void testAddAfterLastFieldRemoved() {
        this.table.updateSpec().removeField("data_bucket").commit();
        this.V1Assert.assertEquals("Should add a new id bucket", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).alwaysNull("data", "data_bucket").build(), this.table.spec());
        this.V1Assert.assertEquals("Should match the last assigned field id", 1000, this.table.spec().lastAssignedFieldId());
        this.V2Assert.assertEquals("Should add a new id bucket", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).build(), this.table.spec());
        this.V2Assert.assertEquals("Should match the last assigned field id", 999, this.table.spec().lastAssignedFieldId());
        Assert.assertEquals((long)1000L, (long)this.table.ops().current().lastAssignedPartitionId());
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"id", (int)8)).commit();
        this.V1Assert.assertEquals("Should add a new id bucket", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(2).alwaysNull("data", "data_bucket").bucket("id", 8, "id_bucket_8").build(), this.table.spec());
        this.V2Assert.assertEquals("Should add a new id bucket", PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(2).add(1, 1001, "id_bucket_8", Transforms.bucket((int)8)).build(), this.table.spec());
        Assert.assertEquals((long)1001L, (long)this.table.spec().lastAssignedFieldId());
        Assert.assertEquals((long)1001L, (long)this.table.ops().current().lastAssignedPartitionId());
    }
}

