/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTableMetadataSerialization
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestTableMetadataSerialization(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testSerialization() throws Exception {
        TableMetadata result;
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        TableMetadata meta = this.table.ops().current();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream writer = new ObjectOutputStream(out);){
            writer.writeObject(meta);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try (ObjectInputStream reader = new ObjectInputStream(in);){
            result = (TableMetadata)reader.readObject();
        }
        Assert.assertEquals((String)"Metadata file location should match", (Object)meta.metadataFileLocation(), (Object)result.metadataFileLocation());
        Assert.assertEquals((String)"UUID should match", (Object)meta.uuid(), (Object)result.uuid());
        Assert.assertEquals((String)"Location should match", (Object)meta.location(), (Object)result.location());
        Assert.assertEquals((String)"Last updated should match", (long)meta.lastUpdatedMillis(), (long)result.lastUpdatedMillis());
        Assert.assertEquals((String)"Last column id", (long)meta.lastColumnId(), (long)result.lastColumnId());
        Assert.assertEquals((String)"Schema should match", (Object)meta.schema().asStruct(), (Object)result.schema().asStruct());
        TestHelpers.assertSameSchemaList((List)meta.schemas(), (List)result.schemas());
        Assert.assertEquals((String)"Current schema id should match", (long)meta.currentSchemaId(), (long)result.currentSchemaId());
        Assert.assertEquals((String)"Spec should match", (long)meta.defaultSpecId(), (long)result.defaultSpecId());
        Assert.assertEquals((String)"Spec list should match", (Object)meta.specs(), (Object)result.specs());
        Assert.assertEquals((String)"Properties should match", (Object)meta.properties(), (Object)result.properties());
        Assert.assertEquals((String)"Current snapshot ID should match", (long)meta.currentSnapshot().snapshotId(), (long)result.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Snapshots should match", (Object)Lists.transform((List)meta.snapshots(), Snapshot::snapshotId), (Object)Lists.transform((List)result.snapshots(), Snapshot::snapshotId));
        Assert.assertEquals((String)"History should match", (Object)meta.snapshotLog(), (Object)result.snapshotLog());
    }
}

