/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.Files;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.LocalTableOperations;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotParser;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestTableMetadata {
    private static final String TEST_LOCATION = "s3://bucket/test/location";
    private static final Schema TEST_SCHEMA = new Schema(7, new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.LongType.get(), (String)"comment"), Types.NestedField.required((int)3, (String)"z", (Type)Types.LongType.get())});
    private static final long SEQ_NO = 34L;
    private static final int LAST_ASSIGNED_COLUMN_ID = 3;
    private static final PartitionSpec SPEC_5 = PartitionSpec.builderFor((Schema)TEST_SCHEMA).withSpecId(5).build();
    private static final SortOrder SORT_ORDER_3 = ((SortOrder.Builder)SortOrder.builderFor((Schema)TEST_SCHEMA).withOrderId(3).asc("y", NullOrder.NULLS_FIRST)).desc((Term)Expressions.bucket((String)"z", (int)4), NullOrder.NULLS_LAST).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public TableOperations ops = new LocalTableOperations(this.temp);

    @Test
    public void testJsonConversion() throws Exception {
        long previousSnapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(previousSnapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot previousSnapshot = new BaseSnapshot(0L, previousSnapshotId, null, previousSnapshotId, null, null, null, manifestList);
        long currentSnapshotId = System.currentTimeMillis();
        manifestList = this.createManifestListWithManifestFile(currentSnapshotId, previousSnapshotId, "file:/tmp/manifest2.avro");
        BaseSnapshot currentSnapshot = new BaseSnapshot(0L, currentSnapshotId, Long.valueOf(previousSnapshotId), currentSnapshotId, null, null, Integer.valueOf(7), manifestList);
        ImmutableList snapshotLog = ImmutableList.builder().add((Object)new TableMetadata.SnapshotLogEntry(previousSnapshot.timestampMillis(), previousSnapshot.snapshotId())).add((Object)new TableMetadata.SnapshotLogEntry(currentSnapshot.timestampMillis(), currentSnapshot.snapshotId())).build();
        Schema schema = new Schema(6, new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        ImmutableMap refs = ImmutableMap.of((Object)"main", (Object)SnapshotRef.branchBuilder((long)currentSnapshotId).build(), (Object)"previous", (Object)SnapshotRef.tagBuilder((long)previousSnapshotId).build(), (Object)"test", (Object)SnapshotRef.branchBuilder((long)previousSnapshotId).build());
        ImmutableList statisticsFiles = ImmutableList.of((Object)new GenericStatisticsFile(11L, "/some/stats/file.puffin", 100L, 42L, (List)ImmutableList.of((Object)new GenericBlobMetadata("some-stats", 11L, 2L, (List)ImmutableList.of((Object)4), (Map)ImmutableMap.of()))));
        TableMetadata expected = new TableMetadata(null, 2, UUID.randomUUID().toString(), TEST_LOCATION, 34L, System.currentTimeMillis(), 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA, (Object)schema), 5, (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of((Object)"property", (Object)"value"), currentSnapshotId, Arrays.asList(previousSnapshot, currentSnapshot), null, (List)snapshotLog, (List)ImmutableList.of(), (Map)refs, (List)statisticsFiles, (List)ImmutableList.of());
        String asJson = TableMetadataParser.toJson((TableMetadata)expected);
        TableMetadata metadata = TableMetadataParser.fromJson((String)asJson);
        Assert.assertEquals((String)"Format version should match", (long)expected.formatVersion(), (long)metadata.formatVersion());
        Assert.assertEquals((String)"Table UUID should match", (Object)expected.uuid(), (Object)metadata.uuid());
        Assert.assertEquals((String)"Table location should match", (Object)expected.location(), (Object)metadata.location());
        Assert.assertEquals((String)"Last sequence number should match", (long)expected.lastSequenceNumber(), (long)metadata.lastSequenceNumber());
        Assert.assertEquals((String)"Last column ID should match", (long)expected.lastColumnId(), (long)metadata.lastColumnId());
        Assert.assertEquals((String)"Current schema id should match", (long)expected.currentSchemaId(), (long)metadata.currentSchemaId());
        TestHelpers.assertSameSchemaList((List)expected.schemas(), (List)metadata.schemas());
        Assert.assertEquals((String)"Partition spec should match", (Object)expected.spec().toString(), (Object)metadata.spec().toString());
        Assert.assertEquals((String)"Default spec ID should match", (long)expected.defaultSpecId(), (long)metadata.defaultSpecId());
        Assert.assertEquals((String)"PartitionSpec map should match", (Object)expected.specs(), (Object)metadata.specs());
        Assert.assertEquals((String)"lastAssignedFieldId across all PartitionSpecs should match", (long)expected.spec().lastAssignedFieldId(), (long)metadata.lastAssignedPartitionId());
        Assert.assertEquals((String)"Default sort ID should match", (long)expected.defaultSortOrderId(), (long)metadata.defaultSortOrderId());
        Assert.assertEquals((String)"Sort order should match", (Object)expected.sortOrder(), (Object)metadata.sortOrder());
        Assert.assertEquals((String)"Sort order map should match", (Object)expected.sortOrders(), (Object)metadata.sortOrders());
        Assert.assertEquals((String)"Properties should match", (Object)expected.properties(), (Object)metadata.properties());
        Assert.assertEquals((String)"Snapshot logs should match", (Object)expected.snapshotLog(), (Object)metadata.snapshotLog());
        Assert.assertEquals((String)"Current snapshot ID should match", (long)currentSnapshotId, (long)metadata.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Parent snapshot ID should match", (Object)previousSnapshotId, (Object)metadata.currentSnapshot().parentId());
        Assert.assertEquals((String)"Current snapshot files should match", (Object)currentSnapshot.allManifests(this.ops.io()), (Object)metadata.currentSnapshot().allManifests(this.ops.io()));
        Assert.assertEquals((String)"Schema ID for current snapshot should match", (Object)7, (Object)metadata.currentSnapshot().schemaId());
        Assert.assertEquals((String)"Previous snapshot ID should match", (long)previousSnapshotId, (long)metadata.snapshot(previousSnapshotId).snapshotId());
        Assert.assertEquals((String)"Previous snapshot files should match", (Object)previousSnapshot.allManifests(this.ops.io()), (Object)metadata.snapshot(previousSnapshotId).allManifests(this.ops.io()));
        Assert.assertNull((String)"Previous snapshot's schema ID should be null", (Object)metadata.snapshot(previousSnapshotId).schemaId());
        Assert.assertEquals((String)"Statistics files should match", (Object)statisticsFiles, (Object)metadata.statisticsFiles());
        Assert.assertEquals((String)"Refs map should match", (Object)refs, (Object)metadata.refs());
    }

    @Test
    public void testBackwardCompat() throws Exception {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)TEST_SCHEMA).identity("x").withSpecId(6).build();
        SortOrder sortOrder = SortOrder.unsorted();
        Schema schema = new Schema(0, TEST_SCHEMA.columns());
        long previousSnapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(previousSnapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot previousSnapshot = new BaseSnapshot(0L, previousSnapshotId, null, previousSnapshotId, null, null, null, manifestList);
        long currentSnapshotId = System.currentTimeMillis();
        manifestList = this.createManifestListWithManifestFile(currentSnapshotId, previousSnapshotId, "file:/tmp/manifest2.avro");
        BaseSnapshot currentSnapshot = new BaseSnapshot(0L, currentSnapshotId, Long.valueOf(previousSnapshotId), currentSnapshotId, null, null, null, manifestList);
        TableMetadata expected = new TableMetadata(null, 1, null, TEST_LOCATION, 0L, System.currentTimeMillis(), 3, 0, (List)ImmutableList.of((Object)schema), 6, (List)ImmutableList.of((Object)spec), spec.lastAssignedFieldId(), 1, (List)ImmutableList.of((Object)sortOrder), (Map)ImmutableMap.of((Object)"property", (Object)"value"), currentSnapshotId, Arrays.asList(previousSnapshot, currentSnapshot), null, (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
        String asJson = TestTableMetadata.toJsonWithoutSpecAndSchemaList(expected);
        TableMetadata metadata = TableMetadataParser.fromJson((String)asJson);
        Assert.assertEquals((String)"Format version should match", (long)expected.formatVersion(), (long)metadata.formatVersion());
        Assert.assertNull((String)"Table UUID should not be assigned", (Object)metadata.uuid());
        Assert.assertEquals((String)"Table location should match", (Object)expected.location(), (Object)metadata.location());
        Assert.assertEquals((String)"Last sequence number should default to 0", (long)expected.lastSequenceNumber(), (long)metadata.lastSequenceNumber());
        Assert.assertEquals((String)"Last column ID should match", (long)expected.lastColumnId(), (long)metadata.lastColumnId());
        Assert.assertEquals((String)"Current schema ID should be default to TableMetadata.INITIAL_SCHEMA_ID", (long)0L, (long)metadata.currentSchemaId());
        Assert.assertEquals((String)"Schemas size should match", (long)1L, (long)metadata.schemas().size());
        Assert.assertEquals((String)"Schemas should contain the schema", (Object)((Schema)metadata.schemas().get(0)).asStruct(), (Object)schema.asStruct());
        Assert.assertEquals((String)"Partition spec should be the default", (Object)expected.spec().toString(), (Object)metadata.spec().toString());
        Assert.assertEquals((String)"Default spec ID should default to TableMetadata.INITIAL_SPEC_ID", (long)0L, (long)metadata.defaultSpecId());
        Assert.assertEquals((String)"PartitionSpec should contain the spec", (long)1L, (long)metadata.specs().size());
        Assert.assertTrue((String)"PartitionSpec should contain the spec", (boolean)((PartitionSpec)metadata.specs().get(0)).compatibleWith(spec));
        Assert.assertEquals((String)"PartitionSpec should have ID TableMetadata.INITIAL_SPEC_ID", (long)0L, (long)((PartitionSpec)metadata.specs().get(0)).specId());
        Assert.assertEquals((String)"lastAssignedFieldId across all PartitionSpecs should match", (long)expected.spec().lastAssignedFieldId(), (long)metadata.lastAssignedPartitionId());
        Assert.assertEquals((String)"Properties should match", (Object)expected.properties(), (Object)metadata.properties());
        Assert.assertEquals((String)"Snapshot logs should match", (Object)expected.snapshotLog(), (Object)metadata.snapshotLog());
        Assert.assertEquals((String)"Current snapshot ID should match", (long)currentSnapshotId, (long)metadata.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Parent snapshot ID should match", (Object)previousSnapshotId, (Object)metadata.currentSnapshot().parentId());
        Assert.assertEquals((String)"Current snapshot files should match", (Object)currentSnapshot.allManifests(this.ops.io()), (Object)metadata.currentSnapshot().allManifests(this.ops.io()));
        Assert.assertNull((String)"Current snapshot's schema ID should be null", (Object)metadata.currentSnapshot().schemaId());
        Assert.assertEquals((String)"Previous snapshot ID should match", (long)previousSnapshotId, (long)metadata.snapshot(previousSnapshotId).snapshotId());
        Assert.assertEquals((String)"Previous snapshot files should match", (Object)previousSnapshot.allManifests(this.ops.io()), (Object)metadata.snapshot(previousSnapshotId).allManifests(this.ops.io()));
        Assert.assertEquals((String)"Snapshot logs should match", (Object)expected.previousFiles(), (Object)metadata.previousFiles());
        Assert.assertNull((String)"Previous snapshot's schema ID should be null", (Object)metadata.snapshot(previousSnapshotId).schemaId());
    }

    @Test
    public void testInvalidMainBranch() throws IOException {
        long previousSnapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(previousSnapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot previousSnapshot = new BaseSnapshot(0L, previousSnapshotId, null, previousSnapshotId, null, null, null, manifestList);
        long currentSnapshotId = System.currentTimeMillis();
        manifestList = this.createManifestListWithManifestFile(currentSnapshotId, previousSnapshotId, "file:/tmp/manifest2.avro");
        BaseSnapshot currentSnapshot = new BaseSnapshot(0L, currentSnapshotId, Long.valueOf(previousSnapshotId), currentSnapshotId, null, null, Integer.valueOf(7), manifestList);
        ImmutableList snapshotLog = ImmutableList.builder().add((Object)new TableMetadata.SnapshotLogEntry(previousSnapshot.timestampMillis(), previousSnapshot.snapshotId())).add((Object)new TableMetadata.SnapshotLogEntry(currentSnapshot.timestampMillis(), currentSnapshot.snapshotId())).build();
        Schema schema = new Schema(6, new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        ImmutableMap refs = ImmutableMap.of((Object)"main", (Object)SnapshotRef.branchBuilder((long)previousSnapshotId).build());
        AssertHelpers.assertThrows((String)"Should fail if main branch snapshot ID does not match currentSnapshotId", IllegalArgumentException.class, (String)"Current snapshot ID does not match main branch", () -> TestTableMetadata.lambda$testInvalidMainBranch$0(schema, currentSnapshotId, (Snapshot)previousSnapshot, (Snapshot)currentSnapshot, (List)snapshotLog, (Map)refs));
    }

    @Test
    public void testMainWithoutCurrent() throws IOException {
        long snapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(snapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot snapshot = new BaseSnapshot(0L, snapshotId, null, snapshotId, null, null, null, manifestList);
        Schema schema = new Schema(6, new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        ImmutableMap refs = ImmutableMap.of((Object)"main", (Object)SnapshotRef.branchBuilder((long)snapshotId).build());
        AssertHelpers.assertThrows((String)"Should fail if main branch snapshot ID does not match currentSnapshotId", IllegalArgumentException.class, (String)"Current snapshot is not set, but main branch exists", () -> TestTableMetadata.lambda$testMainWithoutCurrent$1(schema, (Snapshot)snapshot, (Map)refs));
    }

    @Test
    public void testBranchSnapshotMissing() {
        long snapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        Schema schema = new Schema(6, new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        ImmutableMap refs = ImmutableMap.of((Object)"main", (Object)SnapshotRef.branchBuilder((long)snapshotId).build());
        AssertHelpers.assertThrows((String)"Should fail if main branch snapshot ID does not match currentSnapshotId", IllegalArgumentException.class, (String)"does not exist in the existing snapshots list", () -> TestTableMetadata.lambda$testBranchSnapshotMissing$2(schema, (Map)refs));
    }

    private static String toJsonWithoutSpecAndSchemaList(TableMetadata metadata) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            generator.writeStartObject();
            generator.writeNumberField("format-version", 1);
            generator.writeStringField("location", metadata.location());
            generator.writeNumberField("last-updated-ms", metadata.lastUpdatedMillis());
            generator.writeNumberField("last-column-id", metadata.lastColumnId());
            generator.writeFieldName("schema");
            SchemaParser.toJson((Type)metadata.schema().asStruct(), (JsonGenerator)generator);
            generator.writeFieldName("partition-spec");
            PartitionSpecParser.toJsonFields((PartitionSpec)metadata.spec(), (JsonGenerator)generator);
            JsonUtil.writeStringMap((String)"properties", (Map)metadata.properties(), (JsonGenerator)generator);
            generator.writeNumberField("current-snapshot-id", metadata.currentSnapshot() != null ? metadata.currentSnapshot().snapshotId() : -1L);
            generator.writeArrayFieldStart("snapshots");
            for (Snapshot snapshot : metadata.snapshots()) {
                SnapshotParser.toJson((Snapshot)snapshot, (JsonGenerator)generator);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to write json for: %s", metadata), e);
        }
        return writer.toString();
    }

    @Test
    public void testJsonWithPreviousMetadataLog() throws Exception {
        long previousSnapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(previousSnapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot previousSnapshot = new BaseSnapshot(0L, previousSnapshotId, null, previousSnapshotId, null, null, null, manifestList);
        long currentSnapshotId = System.currentTimeMillis();
        manifestList = this.createManifestListWithManifestFile(currentSnapshotId, previousSnapshotId, "file:/tmp/manifest2.avro");
        BaseSnapshot currentSnapshot = new BaseSnapshot(0L, currentSnapshotId, Long.valueOf(previousSnapshotId), currentSnapshotId, null, null, null, manifestList);
        ArrayList reversedSnapshotLog = Lists.newArrayList();
        long currentTimestamp = System.currentTimeMillis();
        ArrayList previousMetadataLog = Lists.newArrayList();
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp, "/tmp/000001-" + UUID.randomUUID().toString() + ".metadata.json"));
        TableMetadata base = new TableMetadata(null, 1, UUID.randomUUID().toString(), TEST_LOCATION, 0L, System.currentTimeMillis(), 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA), 5, (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of((Object)"property", (Object)"value"), currentSnapshotId, Arrays.asList(previousSnapshot, currentSnapshot), null, (List)reversedSnapshotLog, (List)ImmutableList.copyOf((Collection)previousMetadataLog), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
        String asJson = TableMetadataParser.toJson((TableMetadata)base);
        TableMetadata metadataFromJson = TableMetadataParser.fromJson((String)asJson);
        Assert.assertEquals((String)"Metadata logs should match", (Object)previousMetadataLog, (Object)metadataFromJson.previousFiles());
    }

    @Test
    public void testAddPreviousMetadataRemoveNone() throws IOException {
        long previousSnapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(previousSnapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot previousSnapshot = new BaseSnapshot(0L, previousSnapshotId, null, previousSnapshotId, null, null, null, manifestList);
        long currentSnapshotId = System.currentTimeMillis();
        manifestList = this.createManifestListWithManifestFile(currentSnapshotId, previousSnapshotId, "file:/tmp/manifest2.avro");
        BaseSnapshot currentSnapshot = new BaseSnapshot(0L, currentSnapshotId, Long.valueOf(previousSnapshotId), currentSnapshotId, null, null, null, manifestList);
        ArrayList reversedSnapshotLog = Lists.newArrayList();
        reversedSnapshotLog.add(new TableMetadata.SnapshotLogEntry(previousSnapshot.timestampMillis(), previousSnapshotId));
        reversedSnapshotLog.add(new TableMetadata.SnapshotLogEntry(currentSnapshot.timestampMillis(), currentSnapshotId));
        long currentTimestamp = System.currentTimeMillis();
        ArrayList previousMetadataLog = Lists.newArrayList();
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 100L, "/tmp/000001-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 90L, "/tmp/000002-" + UUID.randomUUID().toString() + ".metadata.json"));
        TableMetadata.MetadataLogEntry latestPreviousMetadata = new TableMetadata.MetadataLogEntry(currentTimestamp - 80L, "/tmp/000003-" + UUID.randomUUID().toString() + ".metadata.json");
        TableMetadata base = new TableMetadata(latestPreviousMetadata.file(), 1, UUID.randomUUID().toString(), TEST_LOCATION, 0L, currentTimestamp - 80L, 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA), 5, (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of((Object)"property", (Object)"value"), currentSnapshotId, Arrays.asList(previousSnapshot, currentSnapshot), null, (List)reversedSnapshotLog, (List)ImmutableList.copyOf((Collection)previousMetadataLog), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
        previousMetadataLog.add(latestPreviousMetadata);
        TableMetadata metadata = base.replaceProperties((Map)ImmutableMap.of((Object)"write.metadata.previous-versions-max", (Object)"5"));
        HashSet removedPreviousMetadata = Sets.newHashSet((Iterable)base.previousFiles());
        removedPreviousMetadata.removeAll(metadata.previousFiles());
        Assert.assertEquals((String)"Metadata logs should match", (Object)previousMetadataLog, (Object)metadata.previousFiles());
        Assert.assertEquals((String)"Removed Metadata logs should be empty", (long)0L, (long)removedPreviousMetadata.size());
    }

    @Test
    public void testAddPreviousMetadataRemoveOne() throws IOException {
        long previousSnapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(previousSnapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot previousSnapshot = new BaseSnapshot(0L, previousSnapshotId, null, previousSnapshotId, null, null, null, manifestList);
        long currentSnapshotId = System.currentTimeMillis();
        manifestList = this.createManifestListWithManifestFile(currentSnapshotId, previousSnapshotId, "file:/tmp/manifest2.avro");
        BaseSnapshot currentSnapshot = new BaseSnapshot(0L, currentSnapshotId, Long.valueOf(previousSnapshotId), currentSnapshotId, null, null, null, manifestList);
        ArrayList reversedSnapshotLog = Lists.newArrayList();
        reversedSnapshotLog.add(new TableMetadata.SnapshotLogEntry(previousSnapshot.timestampMillis(), previousSnapshotId));
        reversedSnapshotLog.add(new TableMetadata.SnapshotLogEntry(currentSnapshot.timestampMillis(), currentSnapshotId));
        long currentTimestamp = System.currentTimeMillis();
        ArrayList previousMetadataLog = Lists.newArrayList();
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 100L, "/tmp/000001-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 90L, "/tmp/000002-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 80L, "/tmp/000003-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 70L, "/tmp/000004-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 60L, "/tmp/000005-" + UUID.randomUUID().toString() + ".metadata.json"));
        TableMetadata.MetadataLogEntry latestPreviousMetadata = new TableMetadata.MetadataLogEntry(currentTimestamp - 50L, "/tmp/000006-" + UUID.randomUUID().toString() + ".metadata.json");
        TableMetadata base = new TableMetadata(latestPreviousMetadata.file(), 1, UUID.randomUUID().toString(), TEST_LOCATION, 0L, currentTimestamp - 50L, 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA), 5, (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of((Object)"property", (Object)"value"), currentSnapshotId, Arrays.asList(previousSnapshot, currentSnapshot), null, (List)reversedSnapshotLog, (List)ImmutableList.copyOf((Collection)previousMetadataLog), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
        previousMetadataLog.add(latestPreviousMetadata);
        TableMetadata metadata = base.replaceProperties((Map)ImmutableMap.of((Object)"write.metadata.previous-versions-max", (Object)"5"));
        TreeSet removedPreviousMetadata = Sets.newTreeSet(Comparator.comparingLong(TableMetadata.MetadataLogEntry::timestampMillis));
        removedPreviousMetadata.addAll(base.previousFiles());
        removedPreviousMetadata.removeAll(metadata.previousFiles());
        Assert.assertEquals((String)"Metadata logs should match", previousMetadataLog.subList(1, 6), (Object)metadata.previousFiles());
        Assert.assertEquals((String)"Removed Metadata logs should contain 1", previousMetadataLog.subList(0, 1), (Object)ImmutableList.copyOf((Collection)removedPreviousMetadata));
    }

    @Test
    public void testAddPreviousMetadataRemoveMultiple() throws IOException {
        long previousSnapshotId = System.currentTimeMillis() - (long)new Random(1234L).nextInt(3600);
        String manifestList = this.createManifestListWithManifestFile(previousSnapshotId, null, "file:/tmp/manifest1.avro");
        BaseSnapshot previousSnapshot = new BaseSnapshot(0L, previousSnapshotId, null, previousSnapshotId, null, null, null, manifestList);
        long currentSnapshotId = System.currentTimeMillis();
        manifestList = this.createManifestListWithManifestFile(currentSnapshotId, previousSnapshotId, "file:/tmp/manifest2.avro");
        BaseSnapshot currentSnapshot = new BaseSnapshot(0L, currentSnapshotId, Long.valueOf(previousSnapshotId), currentSnapshotId, null, null, null, manifestList);
        ArrayList reversedSnapshotLog = Lists.newArrayList();
        reversedSnapshotLog.add(new TableMetadata.SnapshotLogEntry(previousSnapshot.timestampMillis(), previousSnapshotId));
        reversedSnapshotLog.add(new TableMetadata.SnapshotLogEntry(currentSnapshot.timestampMillis(), currentSnapshotId));
        long currentTimestamp = System.currentTimeMillis();
        ArrayList previousMetadataLog = Lists.newArrayList();
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 100L, "/tmp/000001-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 90L, "/tmp/000002-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 80L, "/tmp/000003-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 70L, "/tmp/000004-" + UUID.randomUUID().toString() + ".metadata.json"));
        previousMetadataLog.add(new TableMetadata.MetadataLogEntry(currentTimestamp - 60L, "/tmp/000005-" + UUID.randomUUID().toString() + ".metadata.json"));
        TableMetadata.MetadataLogEntry latestPreviousMetadata = new TableMetadata.MetadataLogEntry(currentTimestamp - 50L, "/tmp/000006-" + UUID.randomUUID().toString() + ".metadata.json");
        TableMetadata base = new TableMetadata(latestPreviousMetadata.file(), 1, UUID.randomUUID().toString(), TEST_LOCATION, 0L, currentTimestamp - 50L, 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA), SPEC_5.specId(), (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), SortOrder.unsorted().orderId(), (List)ImmutableList.of((Object)SortOrder.unsorted()), (Map)ImmutableMap.of((Object)"property", (Object)"value"), currentSnapshotId, Arrays.asList(previousSnapshot, currentSnapshot), null, (List)reversedSnapshotLog, (List)ImmutableList.copyOf((Collection)previousMetadataLog), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
        previousMetadataLog.add(latestPreviousMetadata);
        TableMetadata metadata = base.replaceProperties((Map)ImmutableMap.of((Object)"write.metadata.previous-versions-max", (Object)"2"));
        TreeSet removedPreviousMetadata = Sets.newTreeSet(Comparator.comparingLong(TableMetadata.MetadataLogEntry::timestampMillis));
        removedPreviousMetadata.addAll(base.previousFiles());
        removedPreviousMetadata.removeAll(metadata.previousFiles());
        Assert.assertEquals((String)"Metadata logs should match", previousMetadataLog.subList(4, 6), (Object)metadata.previousFiles());
        Assert.assertEquals((String)"Removed Metadata logs should contain 4", previousMetadataLog.subList(0, 4), (Object)ImmutableList.copyOf((Collection)removedPreviousMetadata));
    }

    @Test
    public void testV2UUIDValidation() {
        AssertHelpers.assertThrows((String)"Should reject v2 metadata without a UUID", IllegalArgumentException.class, (String)"UUID is required in format v2", () -> new TableMetadata(null, 2, null, TEST_LOCATION, 34L, System.currentTimeMillis(), 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA), SPEC_5.specId(), (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of(), -1L, (List)ImmutableList.of(), null, (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of()));
    }

    @Test
    public void testVersionValidation() {
        int unsupportedVersion = 3;
        AssertHelpers.assertThrows((String)"Should reject unsupported metadata", IllegalArgumentException.class, (String)("Unsupported format version: v" + unsupportedVersion), () -> new TableMetadata(null, unsupportedVersion, null, TEST_LOCATION, 34L, System.currentTimeMillis(), 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA), SPEC_5.specId(), (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of(), -1L, (List)ImmutableList.of(), null, (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of()));
    }

    @Test
    public void testParserVersionValidation() throws Exception {
        String supportedVersion1 = this.readTableMetadataInputFile("TableMetadataV1Valid.json");
        TableMetadata parsed1 = TableMetadataParser.fromJson((String)supportedVersion1);
        Assert.assertNotNull((String)"Should successfully read supported metadata version", (Object)parsed1);
        String supportedVersion2 = this.readTableMetadataInputFile("TableMetadataV2Valid.json");
        TableMetadata parsed2 = TableMetadataParser.fromJson((String)supportedVersion2);
        Assert.assertNotNull((String)"Should successfully read supported metadata version", (Object)parsed2);
        String unsupportedVersion = this.readTableMetadataInputFile("TableMetadataUnsupportedVersion.json");
        AssertHelpers.assertThrows((String)"Should not read unsupported metadata", IllegalArgumentException.class, (String)"Cannot read unsupported version", () -> TableMetadataParser.fromJson((String)unsupportedVersion));
    }

    @Test
    public void testParserV2PartitionSpecsValidation() throws Exception {
        String unsupportedVersion = this.readTableMetadataInputFile("TableMetadataV2MissingPartitionSpecs.json");
        AssertHelpers.assertThrows((String)"Should reject v2 metadata without partition specs", IllegalArgumentException.class, (String)"partition-specs must exist in format v2", () -> TableMetadataParser.fromJson((String)unsupportedVersion));
    }

    @Test
    public void testParserV2LastAssignedFieldIdValidation() throws Exception {
        String unsupportedVersion = this.readTableMetadataInputFile("TableMetadataV2MissingLastPartitionId.json");
        AssertHelpers.assertThrows((String)"Should reject v2 metadata without last assigned partition field id", IllegalArgumentException.class, (String)"last-partition-id must exist in format v2", () -> TableMetadataParser.fromJson((String)unsupportedVersion));
    }

    @Test
    public void testParserV2SortOrderValidation() throws Exception {
        String unsupportedVersion = this.readTableMetadataInputFile("TableMetadataV2MissingSortOrder.json");
        AssertHelpers.assertThrows((String)"Should reject v2 metadata without sort order", IllegalArgumentException.class, (String)"sort-orders must exist in format v2", () -> TableMetadataParser.fromJson((String)unsupportedVersion));
    }

    @Test
    public void testParserV2CurrentSchemaIdValidation() throws Exception {
        String unsupported = this.readTableMetadataInputFile("TableMetadataV2CurrentSchemaNotFound.json");
        AssertHelpers.assertThrows((String)"Should reject v2 metadata without valid schema id", IllegalArgumentException.class, (String)"Cannot find schema with current-schema-id=2 from schemas", () -> TableMetadataParser.fromJson((String)unsupported));
    }

    @Test
    public void testParserV2SchemasValidation() throws Exception {
        String unsupported = this.readTableMetadataInputFile("TableMetadataV2MissingSchemas.json");
        AssertHelpers.assertThrows((String)"Should reject v2 metadata without schemas", IllegalArgumentException.class, (String)"schemas must exist in format v2", () -> TableMetadataParser.fromJson((String)unsupported));
    }

    private String readTableMetadataInputFile(String fileName) throws Exception {
        Path path = Paths.get(this.getClass().getClassLoader().getResource(fileName).toURI());
        return String.join((CharSequence)"", java.nio.file.Files.readAllLines(path));
    }

    @Test
    public void testNewTableMetadataReassignmentAllIds() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"y", (Type)Types.LongType.get()), Types.NestedField.required((int)5, (String)"z", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).withSpecId(5).add(3, 1005, "x_partition", Transforms.bucket((int)4)).add(5, 1003, "z_partition", Transforms.bucket((int)8)).build();
        String location = "file://tmp/db/table";
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (String)location, (Map)ImmutableMap.of());
        PartitionSpec expected = PartitionSpec.builderFor((Schema)metadata.schema()).withSpecId(0).add(1, 1000, "x_partition", Transforms.bucket((int)4)).add(3, 1001, "z_partition", Transforms.bucket((int)8)).build();
        Assert.assertEquals((Object)expected, (Object)metadata.spec());
    }

    @Test
    public void testInvalidUpdatePartitionSpecForV1Table() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).withSpecId(5).add(1, 1005, "x_partition", Transforms.bucket((int)4)).build();
        String location = "file://tmp/db/table";
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), (String)location, (Map)ImmutableMap.of());
        AssertHelpers.assertThrows((String)"Should fail to update an invalid partition spec", ValidationException.class, (String)"Spec does not use sequential IDs that are required in v1", () -> metadata.updatePartitionSpec(spec));
    }

    @Test
    public void testBuildReplacementForV1Table() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).withSpecId(0).identity("x").identity("y").build();
        String location = "file://tmp/db/table";
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (SortOrder)SortOrder.unsorted(), (String)location, (Map)ImmutableMap.of(), (int)1);
        Assert.assertEquals((Object)spec, (Object)metadata.spec());
        Schema updatedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"z", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"y", (Type)Types.LongType.get())});
        PartitionSpec updatedSpec = PartitionSpec.builderFor((Schema)updatedSchema).withSpecId(0).bucket("z", 8).identity("x").build();
        TableMetadata updated = metadata.buildReplacement(updatedSchema, updatedSpec, SortOrder.unsorted(), location, (Map)ImmutableMap.of());
        PartitionSpec expected = PartitionSpec.builderFor((Schema)updated.schema()).withSpecId(1).add(1, 1000, "x", Transforms.identity()).add(2, 1001, "y", Transforms.alwaysNull()).add(3, 1002, "z_bucket", Transforms.bucket((int)8)).build();
        Assert.assertEquals((String)"Should reassign the partition field IDs and reuse any existing IDs for equivalent fields", (Object)expected, (Object)updated.spec());
    }

    @Test
    public void testBuildReplacementForV2Table() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).withSpecId(0).identity("x").identity("y").build();
        String location = "file://tmp/db/table";
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (SortOrder)SortOrder.unsorted(), (String)location, (Map)ImmutableMap.of(), (int)2);
        Assert.assertEquals((Object)spec, (Object)metadata.spec());
        Schema updatedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"z", (Type)Types.StringType.get())});
        PartitionSpec updatedSpec = PartitionSpec.builderFor((Schema)updatedSchema).withSpecId(0).bucket("z", 8).identity("x").build();
        TableMetadata updated = metadata.buildReplacement(updatedSchema, updatedSpec, SortOrder.unsorted(), location, (Map)ImmutableMap.of());
        PartitionSpec expected = PartitionSpec.builderFor((Schema)updated.schema()).withSpecId(1).add(3, 1002, "z_bucket", Transforms.bucket((int)8)).add(1, 1000, "x", Transforms.identity()).build();
        Assert.assertEquals((String)"Should reassign the partition field IDs and reuse any existing IDs for equivalent fields", (Object)expected, (Object)updated.spec());
    }

    @Test
    public void testSortOrder() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of());
        Assert.assertTrue((String)"Should default to unsorted order", (boolean)meta.sortOrder().isUnsorted());
        Assert.assertSame((String)"Should detect identical unsorted order", (Object)meta, (Object)meta.replaceSortOrder(SortOrder.unsorted()));
    }

    @Test
    public void testUpdateSortOrder() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("x")).build();
        TableMetadata sortedByX = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)order, null, (Map)ImmutableMap.of());
        Assert.assertEquals((String)"Should have 1 sort order", (long)1L, (long)sortedByX.sortOrders().size());
        Assert.assertEquals((String)"Should use orderId 1", (long)1L, (long)sortedByX.sortOrder().orderId());
        Assert.assertEquals((String)"Should be sorted by one field", (long)1L, (long)sortedByX.sortOrder().fields().size());
        Assert.assertEquals((String)"Should use the table's field ids", (long)1L, (long)((SortField)sortedByX.sortOrder().fields().get(0)).sourceId());
        Assert.assertEquals((String)"Should be ascending", (Object)SortDirection.ASC, (Object)((SortField)sortedByX.sortOrder().fields().get(0)).direction());
        Assert.assertEquals((String)"Should be nulls first", (Object)NullOrder.NULLS_FIRST, (Object)((SortField)sortedByX.sortOrder().fields().get(0)).nullOrder());
        SortOrder newOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)sortedByX.schema()).asc("x")).build();
        TableMetadata alsoSortedByX = sortedByX.replaceSortOrder(newOrder);
        Assert.assertSame((String)"Should detect current sortOrder and not update", (Object)alsoSortedByX, (Object)sortedByX);
        TableMetadata unsorted = alsoSortedByX.replaceSortOrder(SortOrder.unsorted());
        Assert.assertEquals((String)"Should have 2 sort orders", (long)2L, (long)unsorted.sortOrders().size());
        Assert.assertEquals((String)"Should use orderId 0", (long)0L, (long)unsorted.sortOrder().orderId());
        Assert.assertTrue((String)"Should be unsorted", (boolean)unsorted.sortOrder().isUnsorted());
        TableMetadata sortedByXDesc = unsorted.replaceSortOrder(((SortOrder.Builder)SortOrder.builderFor((Schema)unsorted.schema()).desc("x")).build());
        Assert.assertEquals((String)"Should have 3 sort orders", (long)3L, (long)sortedByXDesc.sortOrders().size());
        Assert.assertEquals((String)"Should use orderId 2", (long)2L, (long)sortedByXDesc.sortOrder().orderId());
        Assert.assertEquals((String)"Should be sorted by one field", (long)1L, (long)sortedByXDesc.sortOrder().fields().size());
        Assert.assertEquals((String)"Should use the table's field ids", (long)1L, (long)((SortField)sortedByXDesc.sortOrder().fields().get(0)).sourceId());
        Assert.assertEquals((String)"Should be ascending", (Object)SortDirection.DESC, (Object)((SortField)sortedByXDesc.sortOrder().fields().get(0)).direction());
        Assert.assertEquals((String)"Should be nulls first", (Object)NullOrder.NULLS_FIRST, (Object)((SortField)sortedByX.sortOrder().fields().get(0)).nullOrder());
    }

    @Test
    public void testStatistics() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of());
        Assert.assertEquals((String)"Should default to no statistics files", (Object)ImmutableList.of(), (Object)meta.statisticsFiles());
    }

    @Test
    public void testSetStatistics() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of());
        TableMetadata withStatistics = TableMetadata.buildFrom((TableMetadata)meta).setStatistics(43L, (StatisticsFile)new GenericStatisticsFile(43L, "/some/path/to/stats/file", 128L, 27L, (List)ImmutableList.of())).build();
        ((ListAssert)Assertions.assertThat((List)withStatistics.statisticsFiles()).as("There should be one statistics file registered", new Object[0])).hasSize(1);
        StatisticsFile statisticsFile = (StatisticsFile)Iterables.getOnlyElement((Iterable)withStatistics.statisticsFiles());
        Assert.assertEquals((String)"Statistics file snapshot", (long)43L, (long)statisticsFile.snapshotId());
        Assert.assertEquals((String)"Statistics file path", (Object)"/some/path/to/stats/file", (Object)statisticsFile.path());
        TableMetadata withStatisticsReplaced = TableMetadata.buildFrom((TableMetadata)withStatistics).setStatistics(43L, (StatisticsFile)new GenericStatisticsFile(43L, "/some/path/to/stats/file2", 128L, 27L, (List)ImmutableList.of())).build();
        ((ListAssert)Assertions.assertThat((List)withStatisticsReplaced.statisticsFiles()).as("There should be one statistics file registered", new Object[0])).hasSize(1);
        statisticsFile = (StatisticsFile)Iterables.getOnlyElement((Iterable)withStatisticsReplaced.statisticsFiles());
        Assert.assertEquals((String)"Statistics file snapshot", (long)43L, (long)statisticsFile.snapshotId());
        Assert.assertEquals((String)"Statistics file path", (Object)"/some/path/to/stats/file2", (Object)statisticsFile.path());
    }

    @Test
    public void testRemoveStatistics() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.buildFrom((TableMetadata)TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of())).setStatistics(43L, (StatisticsFile)new GenericStatisticsFile(43L, "/some/path/to/stats/file", 128L, 27L, (List)ImmutableList.of())).setStatistics(44L, (StatisticsFile)new GenericStatisticsFile(44L, "/some/path/to/stats/file2", 128L, 27L, (List)ImmutableList.of())).build();
        Assert.assertSame((String)"Should detect no statistics to remove", (Object)meta, (Object)TableMetadata.buildFrom((TableMetadata)meta).removeStatistics(42L).build());
        TableMetadata withOneRemoved = TableMetadata.buildFrom((TableMetadata)meta).removeStatistics(43L).build();
        ((ListAssert)Assertions.assertThat((List)withOneRemoved.statisticsFiles()).as("There should be one statistics file retained", new Object[0])).hasSize(1);
        StatisticsFile statisticsFile = (StatisticsFile)Iterables.getOnlyElement((Iterable)withOneRemoved.statisticsFiles());
        Assert.assertEquals((String)"Statistics file snapshot", (long)44L, (long)statisticsFile.snapshotId());
        Assert.assertEquals((String)"Statistics file path", (Object)"/some/path/to/stats/file2", (Object)statisticsFile.path());
    }

    @Test
    public void testParseSchemaIdentifierFields() throws Exception {
        String data = this.readTableMetadataInputFile("TableMetadataV2Valid.json");
        TableMetadata parsed = TableMetadataParser.fromJson((String)data);
        Assert.assertEquals((Object)Sets.newHashSet(), (Object)((Schema)parsed.schemasById().get(0)).identifierFieldIds());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Integer[]{1, 2}), (Object)((Schema)parsed.schemasById().get(1)).identifierFieldIds());
    }

    @Test
    public void testParseMinimal() throws Exception {
        String data = this.readTableMetadataInputFile("TableMetadataV2ValidMinimal.json");
        TableMetadata parsed = TableMetadataParser.fromJson((String)data);
        Assertions.assertThat((List)parsed.snapshots()).isEmpty();
        Assertions.assertThat((List)parsed.snapshotLog()).isEmpty();
        Assertions.assertThat((Map)parsed.properties()).isEmpty();
        Assertions.assertThat((List)parsed.previousFiles()).isEmpty();
    }

    @Test
    public void testUpdateSchemaIdentifierFields() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of());
        Schema newSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.StringType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        TableMetadata newMeta = meta.updateSchema(newSchema, 1);
        Assert.assertEquals((long)2L, (long)newMeta.schemas().size());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Integer[]{1}), (Object)newMeta.schema().identifierFieldIds());
    }

    @Test
    public void testUpdateSchema() {
        Schema schema = new Schema(0, new Types.NestedField[]{Types.NestedField.required((int)1, (String)"y", (Type)Types.LongType.get(), (String)"comment")});
        TableMetadata freshTable = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of());
        Assert.assertEquals((String)"Should use TableMetadata.INITIAL_SCHEMA_ID for current schema id", (long)0L, (long)freshTable.currentSchemaId());
        TestHelpers.assertSameSchemaList((List)ImmutableList.of((Object)schema), (List)freshTable.schemas());
        Assert.assertEquals((String)"Should have expected schema upon return", (Object)schema.asStruct(), (Object)freshTable.schema().asStruct());
        Assert.assertEquals((String)"Should return expected last column id", (long)1L, (long)freshTable.lastColumnId());
        Schema schema2 = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"y", (Type)Types.LongType.get(), (String)"comment"), Types.NestedField.required((int)2, (String)"x", (Type)Types.StringType.get())});
        TableMetadata twoSchemasTable = freshTable.updateSchema(schema2, 2);
        Assert.assertEquals((String)"Should have current schema id as 1", (long)1L, (long)twoSchemasTable.currentSchemaId());
        TestHelpers.assertSameSchemaList((List)ImmutableList.of((Object)schema, (Object)new Schema(1, schema2.columns())), (List)twoSchemasTable.schemas());
        Assert.assertEquals((String)"Should have expected schema upon return", (Object)schema2.asStruct(), (Object)twoSchemasTable.schema().asStruct());
        Assert.assertEquals((String)"Should return expected last column id", (long)2L, (long)twoSchemasTable.lastColumnId());
        Schema sameSchema2 = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"y", (Type)Types.LongType.get(), (String)"comment"), Types.NestedField.required((int)2, (String)"x", (Type)Types.StringType.get())});
        TableMetadata sameSchemaTable = twoSchemasTable.updateSchema(sameSchema2, 2);
        Assert.assertSame((String)"Should return same table metadata", (Object)twoSchemasTable, (Object)sameSchemaTable);
        TableMetadata differentColumnIdTable = sameSchemaTable.updateSchema(sameSchema2, 3);
        Assert.assertEquals((String)"Should have current schema id as 1", (long)1L, (long)differentColumnIdTable.currentSchemaId());
        TestHelpers.assertSameSchemaList((List)ImmutableList.of((Object)schema, (Object)new Schema(1, schema2.columns())), (List)differentColumnIdTable.schemas());
        Assert.assertEquals((String)"Should have expected schema upon return", (Object)schema2.asStruct(), (Object)differentColumnIdTable.schema().asStruct());
        Assert.assertEquals((String)"Should return expected last column id", (long)3L, (long)differentColumnIdTable.lastColumnId());
        TableMetadata revertSchemaTable = differentColumnIdTable.updateSchema(schema, 3);
        Assert.assertEquals((String)"Should have current schema id as 0", (long)0L, (long)revertSchemaTable.currentSchemaId());
        TestHelpers.assertSameSchemaList((List)ImmutableList.of((Object)schema, (Object)new Schema(1, schema2.columns())), (List)revertSchemaTable.schemas());
        Assert.assertEquals((String)"Should have expected schema upon return", (Object)schema.asStruct(), (Object)revertSchemaTable.schema().asStruct());
        Assert.assertEquals((String)"Should return expected last column id", (long)3L, (long)revertSchemaTable.lastColumnId());
        Schema schema3 = new Schema(new Types.NestedField[]{Types.NestedField.required((int)2, (String)"y", (Type)Types.LongType.get(), (String)"comment"), Types.NestedField.required((int)4, (String)"x", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"z", (Type)Types.IntegerType.get())});
        TableMetadata threeSchemaTable = revertSchemaTable.updateSchema(schema3, 6);
        Assert.assertEquals((String)"Should have current schema id as 2", (long)2L, (long)threeSchemaTable.currentSchemaId());
        TestHelpers.assertSameSchemaList((List)ImmutableList.of((Object)schema, (Object)new Schema(1, schema2.columns()), (Object)new Schema(2, schema3.columns())), (List)threeSchemaTable.schemas());
        Assert.assertEquals((String)"Should have expected schema upon return", (Object)schema3.asStruct(), (Object)threeSchemaTable.schema().asStruct());
        Assert.assertEquals((String)"Should return expected last column id", (long)6L, (long)threeSchemaTable.lastColumnId());
    }

    @Test
    public void testCreateV2MetadataThroughTableProperty() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of((Object)"format-version", (Object)"2", (Object)"key", (Object)"val"));
        Assert.assertEquals((String)"format version should be configured based on the format-version key", (long)2L, (long)meta.formatVersion());
        Assert.assertEquals((String)"should not contain format-version in properties", (Object)ImmutableMap.of((Object)"key", (Object)"val", (Object)"write.merge.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName(), (Object)"write.update.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName(), (Object)"write.delete.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName()), (Object)meta.properties());
    }

    @Test
    public void testReplaceV1MetadataToV2ThroughTableProperty() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of((Object)"format-version", (Object)"1", (Object)"key", (Object)"val"));
        meta = meta.buildReplacement(meta.schema(), meta.spec(), meta.sortOrder(), meta.location(), (Map)ImmutableMap.of((Object)"format-version", (Object)"2", (Object)"key2", (Object)"val2"));
        Assert.assertEquals((String)"format version should be configured based on the format-version key", (long)2L, (long)meta.formatVersion());
        Assert.assertEquals((String)"should not contain format-version but should contain old and new properties", (Object)ImmutableMap.of((Object)"key", (Object)"val", (Object)"key2", (Object)"val2", (Object)"write.merge.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName(), (Object)"write.update.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName(), (Object)"write.delete.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName()), (Object)meta.properties());
    }

    @Test
    public void testUpgradeV1MetadataToV2ThroughTableProperty() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (Map)ImmutableMap.of((Object)"format-version", (Object)"1", (Object)"key", (Object)"val"));
        meta = meta.replaceProperties((Map)ImmutableMap.of((Object)"format-version", (Object)"2", (Object)"key2", (Object)"val2"));
        Assert.assertEquals((String)"format version should be configured based on the format-version key", (long)2L, (long)meta.formatVersion());
        Assert.assertEquals((String)"should not contain format-version but should contain new properties", (Object)ImmutableMap.of((Object)"key2", (Object)"val2", (Object)"write.merge.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName(), (Object)"write.update.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName(), (Object)"write.delete.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName()), (Object)meta.properties());
    }

    @Test
    public void testParseStatisticsFiles() throws Exception {
        String data = this.readTableMetadataInputFile("TableMetadataStatisticsFiles.json");
        TableMetadata parsed = TableMetadataParser.fromJson((String)data);
        ((ListAssert)Assertions.assertThat((List)parsed.statisticsFiles()).as("parsed statistics files", new Object[0])).hasSize(1);
        Assert.assertEquals((String)"parsed statistics file", (Object)new GenericStatisticsFile(3055729675574597004L, "s3://a/b/stats.puffin", 413L, 42L, (List)ImmutableList.of((Object)new GenericBlobMetadata("ndv", 3055729675574597004L, 1L, (List)ImmutableList.of((Object)1), (Map)ImmutableMap.of()))), (Object)Iterables.getOnlyElement((Iterable)parsed.statisticsFiles()));
    }

    @Test
    public void testNoReservedPropertyForTableMetadataCreation() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.StringType.get())});
        AssertHelpers.assertThrows((String)"should not allow reserved table property when creating table metadata", IllegalArgumentException.class, (String)"Table properties should not contain reserved properties, but got {format-version=1}", () -> TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (String)"/tmp", (Map)ImmutableMap.of((Object)"format-version", (Object)"1"), (int)1));
        AssertHelpers.assertThrows((String)"should not allow reserved table property when creating table metadata", IllegalArgumentException.class, (String)"Table properties should not contain reserved properties, but got {uuid=uuid}", () -> TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)PartitionSpec.unpartitioned(), null, (String)"/tmp", (Map)ImmutableMap.of((Object)"uuid", (Object)"uuid"), (int)1));
    }

    @Test
    public void testNoTrailingLocationSlash() {
        String locationWithSlash = "/with_trailing_slash/";
        String locationWithoutSlash = "/with_trailing_slash";
        TableMetadata meta = TableMetadata.newTableMetadata((Schema)TEST_SCHEMA, (PartitionSpec)SPEC_5, (SortOrder)SORT_ORDER_3, (String)locationWithSlash, Collections.emptyMap());
        Assert.assertEquals((String)"Metadata should never return a location ending in a slash", (Object)locationWithoutSlash, (Object)meta.location());
    }

    private String createManifestListWithManifestFile(long snapshotId, Long parentSnapshotId, String manifestFile) throws IOException {
        File manifestList = this.temp.newFile("manifests" + UUID.randomUUID());
        manifestList.deleteOnExit();
        try (ManifestListWriter writer = ManifestLists.write((int)1, (OutputFile)Files.localOutput((File)manifestList), (long)snapshotId, (Long)parentSnapshotId, (long)0L);){
            writer.addAll((Iterable)ImmutableList.of((Object)new GenericManifestFile(Files.localInput((String)manifestFile), SPEC_5.specId())));
        }
        return Files.localInput((File)manifestList).location();
    }

    private static /* synthetic */ Object lambda$testBranchSnapshotMissing$2(Schema schema, Map refs) throws Exception {
        return new TableMetadata(null, 2, UUID.randomUUID().toString(), TEST_LOCATION, 34L, System.currentTimeMillis(), 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA, (Object)schema), 5, (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of((Object)"property", (Object)"value"), -1L, (List)ImmutableList.of(), null, (List)ImmutableList.of(), (List)ImmutableList.of(), refs, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    private static /* synthetic */ Object lambda$testMainWithoutCurrent$1(Schema schema, Snapshot snapshot, Map refs) throws Exception {
        return new TableMetadata(null, 2, UUID.randomUUID().toString(), TEST_LOCATION, 34L, System.currentTimeMillis(), 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA, (Object)schema), 5, (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of((Object)"property", (Object)"value"), -1L, (List)ImmutableList.of((Object)snapshot), null, (List)ImmutableList.of(), (List)ImmutableList.of(), refs, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    private static /* synthetic */ Object lambda$testInvalidMainBranch$0(Schema schema, long currentSnapshotId, Snapshot previousSnapshot, Snapshot currentSnapshot, List snapshotLog, Map refs) throws Exception {
        return new TableMetadata(null, 2, UUID.randomUUID().toString(), TEST_LOCATION, 34L, System.currentTimeMillis(), 3, 7, (List)ImmutableList.of((Object)TEST_SCHEMA, (Object)schema), 5, (List)ImmutableList.of((Object)SPEC_5), SPEC_5.lastAssignedFieldId(), 3, (List)ImmutableList.of((Object)SORT_ORDER_3), (Map)ImmutableMap.of((Object)"property", (Object)"value"), currentSnapshotId, Arrays.asList(previousSnapshot, currentSnapshot), null, snapshotLog, (List)ImmutableList.of(), refs, (List)ImmutableList.of(), (List)ImmutableList.of());
    }
}

