/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SplitPositionDeletesScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSplitPlanning
extends TableTestBase {
    private static final Configuration CONF = new Configuration();
    private static final HadoopTables TABLES = new HadoopTables(CONF);
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Table table = null;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSplitPlanning(int formatVersion) {
        super(formatVersion);
    }

    @Override
    @Before
    public void setupTable() throws IOException {
        File tableDir = this.temp.newFolder();
        String tableLocation = tableDir.toURI().toString();
        this.table = TABLES.create(SCHEMA, tableLocation);
        this.table.updateProperties().set("read.split.target-size", String.valueOf(0x8000000)).set("read.split.open-file-cost", String.valueOf(0x400000)).set("read.split.planning-lookback", String.valueOf(Integer.MAX_VALUE)).commit();
    }

    @Test
    public void testBasicSplitPlanning() {
        List<DataFile> files128Mb = this.newFiles(4, 0x8000000L);
        this.appendFiles(files128Mb);
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.table.newScan().planTasks()));
        List<DataFile> files32Mb = this.newFiles(16, 0x2000000L);
        this.appendFiles(files32Mb);
        Assert.assertEquals((long)8L, (long)Iterables.size((Iterable)this.table.newScan().planTasks()));
    }

    @Test
    public void testSplitPlanningWithSmallFiles() {
        List<DataFile> files60Mb = this.newFiles(50, 0x3C00000L);
        List<DataFile> files5Kb = this.newFiles(370, 5120L);
        Iterable files = Iterables.concat(files60Mb, files5Kb);
        this.appendFiles(files);
        Assert.assertEquals((long)35L, (long)Iterables.size((Iterable)this.table.newScan().planTasks()));
    }

    @Test
    public void testSplitPlanningWithNoMinWeight() {
        this.table.updateProperties().set("read.split.open-file-cost", "0").commit();
        List<DataFile> files60Mb = this.newFiles(2, 0x3C00000L);
        List<DataFile> files5Kb = this.newFiles(100, 5120L);
        Iterable files = Iterables.concat(files60Mb, files5Kb);
        this.appendFiles(files);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.table.newScan().planTasks()));
    }

    @Test
    public void testSplitPlanningWithOverridenSize() {
        List<DataFile> files128Mb = this.newFiles(4, 0x8000000L);
        this.appendFiles(files128Mb);
        TableScan scan = (TableScan)this.table.newScan().option("read.split.target-size", String.valueOf(0x10000000L));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testSplitPlanningWithOverriddenSizeForMetadataJsonFile() {
        List<DataFile> files8Mb = this.newFiles(32, 0x800000L, FileFormat.METADATA);
        this.appendFiles(files8Mb);
        TableScan scan = (TableScan)this.table.newScan().option("read.split.target-size", String.valueOf(0x1000000L));
        Assert.assertEquals((long)16L, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testSplitPlanningWithOverriddenSizeForLargeMetadataJsonFile() {
        List<DataFile> files128Mb = this.newFiles(4, 0x8000000L, FileFormat.METADATA);
        this.appendFiles(files128Mb);
        TableScan scan = (TableScan)this.table.newScan().option("read.split.target-size", String.valueOf(0x800000L));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testSplitPlanningWithOverridenLookback() {
        List<DataFile> files120Mb = this.newFiles(1, 0x7800000L);
        List<DataFile> file128Mb = this.newFiles(1, 0x8000000L);
        Iterable files = Iterables.concat(files120Mb, file128Mb);
        this.appendFiles(files);
        TableScan scan = (TableScan)this.table.newScan().option("read.split.planning-lookback", "1");
        CloseableIterable tasks = scan.planTasks();
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)tasks));
        CombinedScanTask combinedScanTask = (CombinedScanTask)tasks.iterator().next();
        FileScanTask task = (FileScanTask)combinedScanTask.files().iterator().next();
        Assert.assertEquals((long)0x8000000L, (long)task.length());
    }

    @Test
    public void testSplitPlanningWithOverridenOpenCostSize() {
        List<DataFile> files16Mb = this.newFiles(16, 0x1000000L);
        this.appendFiles(files16Mb);
        TableScan scan = (TableScan)this.table.newScan().option("read.split.open-file-cost", String.valueOf(0x2000000L));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testSplitPlanningWithNegativeValues() {
        AssertHelpers.assertThrows((String)"User provided split size should be validated", IllegalArgumentException.class, (String)"Split size must be > 0: -10", () -> ((TableScan)this.table.newScan().option("read.split.target-size", String.valueOf(-10))).planTasks());
        AssertHelpers.assertThrows((String)"User provided split planning lookback should be validated", IllegalArgumentException.class, (String)"Split planning lookback must be > 0: -10", () -> ((TableScan)this.table.newScan().option("read.split.planning-lookback", String.valueOf(-10))).planTasks());
        AssertHelpers.assertThrows((String)"User provided split open file cost should be validated", IllegalArgumentException.class, (String)"File open cost must be >= 0: -10", () -> ((TableScan)this.table.newScan().option("read.split.open-file-cost", String.valueOf(-10))).planTasks());
    }

    @Test
    public void testSplitPlanningWithOffsets() {
        List<DataFile> files16Mb = this.newFiles(16, 0x1000000L, 2);
        this.appendFiles(files16Mb);
        TableScan scan = (TableScan)this.table.newScan().option("read.split.target-size", String.valueOf(0xA00000L));
        Assert.assertEquals((String)"We should get one task per row group", (long)32L, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testSplitPlanningWithOffsetsUnableToSplit() {
        List<DataFile> files16Mb = this.newFiles(16, 0x1000000L, 2);
        this.appendFiles(files16Mb);
        TableScan scan = (TableScan)((TableScan)this.table.newScan().option("read.split.open-file-cost", String.valueOf(0))).option("read.split.target-size", String.valueOf(0x400000L));
        Assert.assertEquals((String)"We should still only get 2 tasks per file", (long)32L, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testBasicSplitPlanningDeleteFiles() {
        this.table.updateProperties().set("format-version", "2").commit();
        List<DeleteFile> files128Mb = this.newDeleteFiles(4, 0x8000000L);
        this.appendDeleteFiles(files128Mb);
        PositionDeletesTable posDeletesTable = new PositionDeletesTable(this.table);
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)posDeletesTable.newBatchScan().planTasks()));
        List<DeleteFile> files32Mb = this.newDeleteFiles(16, 0x2000000L);
        this.appendDeleteFiles(files32Mb);
        Assert.assertEquals((long)8L, (long)Iterables.size((Iterable)posDeletesTable.newBatchScan().planTasks()));
    }

    @Test
    public void testBasicSplitPlanningDeleteFilesWithSplitOffsets() {
        this.table.updateProperties().set("format-version", "2").commit();
        List<DeleteFile> files128Mb = this.newDeleteFiles(4, 0x8000000L, 8L);
        this.appendDeleteFiles(files128Mb);
        PositionDeletesTable posDeletesTable = new PositionDeletesTable(this.table);
        try (CloseableIterable groups = ((BatchScan)posDeletesTable.newBatchScan().option("read.split.target-size", String.valueOf(0x4000000L))).planTasks();){
            int totalTaskGroups = 0;
            for (ScanTaskGroup group : groups) {
                int tasksPerGroup = 0;
                long previousOffset = -1L;
                for (ScanTask task : group.tasks()) {
                    ++tasksPerGroup;
                    Assert.assertTrue((boolean)(task instanceof SplitPositionDeletesScanTask));
                    SplitPositionDeletesScanTask splitPosDelTask = (SplitPositionDeletesScanTask)task;
                    if (previousOffset != -1L) {
                        Assert.assertEquals((long)splitPosDelTask.start(), (long)previousOffset);
                    }
                    previousOffset = splitPosDelTask.start() + splitPosDelTask.length();
                }
                Assert.assertEquals((String)"Should have 1 task as result of task merge", (long)1L, (long)tasksPerGroup);
                ++totalTaskGroups;
            }
            Assert.assertEquals((long)8L, (long)totalTaskGroups);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendFiles(Iterable<DataFile> files) {
        AppendFiles appendFiles = this.table.newAppend();
        files.forEach(arg_0 -> ((AppendFiles)appendFiles).appendFile(arg_0));
        appendFiles.commit();
    }

    private List<DataFile> newFiles(int numFiles, long sizeInBytes) {
        return this.newFiles(numFiles, sizeInBytes, FileFormat.PARQUET, 1);
    }

    private List<DataFile> newFiles(int numFiles, long sizeInBytes, int numOffset) {
        return this.newFiles(numFiles, sizeInBytes, FileFormat.PARQUET, numOffset);
    }

    private List<DataFile> newFiles(int numFiles, long sizeInBytes, FileFormat fileFormat) {
        return this.newFiles(numFiles, sizeInBytes, fileFormat, 1);
    }

    private List<DataFile> newFiles(int numFiles, long sizeInBytes, FileFormat fileFormat, int numOffset) {
        ArrayList files = Lists.newArrayList();
        for (int fileNum = 0; fileNum < numFiles; ++fileNum) {
            files.add(this.newFile(sizeInBytes, fileFormat, numOffset));
        }
        return files;
    }

    private DataFile newFile(long sizeInBytes, FileFormat fileFormat, int numOffsets) {
        String fileName = UUID.randomUUID().toString();
        DataFiles.Builder builder = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(fileFormat.addExtension(fileName)).withFileSizeInBytes(sizeInBytes).withRecordCount(2L);
        if (numOffsets > 1) {
            long stepSize = sizeInBytes / (long)numOffsets;
            List offsets = LongStream.range(0L, numOffsets).map(i -> i * stepSize).boxed().collect(Collectors.toList());
            builder.withSplitOffsets(offsets);
        }
        return builder.build();
    }

    private void appendDeleteFiles(List<DeleteFile> files) {
        RowDelta rowDelta = this.table.newRowDelta();
        files.forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
    }

    private List<DeleteFile> newDeleteFiles(int numFiles, long sizeInBytes) {
        return this.newDeleteFiles(numFiles, sizeInBytes, FileFormat.PARQUET, 1L);
    }

    private List<DeleteFile> newDeleteFiles(int numFiles, long sizeInBytes, long numOffsets) {
        return this.newDeleteFiles(numFiles, sizeInBytes, FileFormat.PARQUET, numOffsets);
    }

    private List<DeleteFile> newDeleteFiles(int numFiles, long sizeInBytes, FileFormat fileFormat, long numOffsets) {
        ArrayList files = Lists.newArrayList();
        for (int fileNum = 0; fileNum < numFiles; ++fileNum) {
            files.add(this.newDeleteFile(sizeInBytes, fileFormat, numOffsets));
        }
        return files;
    }

    private DeleteFile newDeleteFile(long sizeInBytes, FileFormat fileFormat, long numOffsets) {
        String fileName = UUID.randomUUID().toString();
        FileMetadata.Builder builder = FileMetadata.deleteFileBuilder((PartitionSpec)PartitionSpec.unpartitioned()).ofPositionDeletes().withPath(fileFormat.addExtension(fileName)).withFileSizeInBytes(sizeInBytes).withRecordCount(2L);
        if (numOffsets > 1L) {
            long stepSize = sizeInBytes / numOffsets;
            List offsets = LongStream.range(0L, numOffsets).map(i -> i * stepSize).boxed().collect(Collectors.toList());
            builder.withSplitOffsets(offsets);
        }
        return builder.build();
    }
}

