/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.transforms.UnknownTransform;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestSortOrderParser
extends TableTestBase {
    public TestSortOrderParser() {
        super(1);
    }

    @Test
    public void testUnknownTransforms() {
        String jsonString = "{\n  \"order-id\" : 10,\n  \"fields\" : [ {\n    \"transform\" : \"custom_transform\",\n    \"source-id\" : 2,\n    \"direction\" : \"desc\",\n    \"null-order\" : \"nulls-first\"\n  } ]\n}";
        SortOrder order = SortOrderParser.fromJson((Schema)this.table.schema(), (String)jsonString);
        Assert.assertEquals((long)10L, (long)order.orderId());
        Assert.assertEquals((long)1L, (long)order.fields().size());
        Assertions.assertThat((Object)((SortField)order.fields().get(0)).transform()).isInstanceOf(UnknownTransform.class);
        Assert.assertEquals((Object)"custom_transform", (Object)((SortField)order.fields().get(0)).transform().toString());
        Assert.assertEquals((long)2L, (long)((SortField)order.fields().get(0)).sourceId());
        Assert.assertEquals((Object)SortDirection.DESC, (Object)((SortField)order.fields().get(0)).direction());
        Assert.assertEquals((Object)NullOrder.NULLS_FIRST, (Object)((SortField)order.fields().get(0)).nullOrder());
    }

    @Test
    public void invalidSortDirection() {
        String jsonString = "{\n  \"order-id\" : 10,\n  \"fields\" : [ {\n    \"transform\" : \"custom_transform\",\n    \"source-id\" : 2,\n    \"direction\" : \"invalid\",\n    \"null-order\" : \"nulls-first\"\n  } ]\n}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SortOrderParser.fromJson((Schema)this.table.schema(), (String)jsonString)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid sort direction: invalid");
    }
}

