/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SortOrderUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSortOrder {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)40, (String)"d", (Type)Types.DateType.get()), Types.NestedField.required((int)41, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)12, (String)"s", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"b", (Type)Types.ListType.ofOptional((int)3, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)19, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)20, (String)"s", (Type)Types.StringType.get())})))})), Types.NestedField.required((int)30, (String)"ext", (Type)Types.StringType.get()), Types.NestedField.required((int)42, (String)"Ext1", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File tableDir = null;
    private final int formatVersion;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSortOrder(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    @Before
    public void setupTableDir() throws IOException {
        this.tableDir = this.temp.newFolder();
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    @Test
    public void testSortOrderBuilder() {
        Assert.assertEquals((String)"Should be able to build unsorted order", (Object)SortOrder.unsorted(), (Object)SortOrder.builderFor((Schema)SCHEMA).withOrderId(0).build());
        AssertHelpers.assertThrows((String)"Should not allow sort orders ID 0", IllegalArgumentException.class, (String)"order ID 0 is reserved for unsorted order", () -> ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("data")).withOrderId(0).build());
        AssertHelpers.assertThrows((String)"Should not allow unsorted orders with arbitrary IDs", IllegalArgumentException.class, (String)"order ID must be 0", () -> SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).build());
    }

    @Test
    public void testDefaultOrder() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, this.formatVersion);
        Assert.assertEquals((String)"Expected 1 sort order", (long)1L, (long)table.sortOrders().size());
        SortOrder actualOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)0L, (long)actualOrder.orderId());
        Assert.assertTrue((String)"Order must unsorted", (boolean)actualOrder.isUnsorted());
    }

    @Test
    public void testFreshIds() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).withSpecId(5).identity("data").build();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("s.id", NullOrder.NULLS_LAST)).desc((Term)Expressions.truncate((String)"data", (int)10), NullOrder.NULLS_FIRST).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, order, this.formatVersion);
        Assert.assertEquals((String)"Expected 1 sort order", (long)1L, (long)table.sortOrders().size());
        Assert.assertTrue((String)"Order ID must be fresh", (boolean)table.sortOrders().containsKey(1));
        SortOrder actualOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must be fresh", (long)1L, (long)actualOrder.orderId());
        Assert.assertEquals((String)"Order must have 2 fields", (long)2L, (long)actualOrder.fields().size());
        Assert.assertEquals((String)"Field id must be fresh", (long)8L, (long)((SortField)actualOrder.fields().get(0)).sourceId());
        Assert.assertEquals((String)"Field id must be fresh", (long)2L, (long)((SortField)actualOrder.fields().get(1)).sourceId());
    }

    @Test
    public void testCompatibleOrders() {
        SortOrder order1 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(9).asc("s.id", NullOrder.NULLS_LAST)).build();
        SortOrder order2 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("s.id", NullOrder.NULLS_LAST)).desc((Term)Expressions.truncate((String)"data", (int)10), NullOrder.NULLS_FIRST).build();
        SortOrder order3 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(11).asc("s.id", NullOrder.NULLS_LAST)).desc((Term)Expressions.truncate((String)"data", (int)10), NullOrder.NULLS_LAST).build();
        SortOrder order4 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(11).asc("s.id", NullOrder.NULLS_LAST)).asc((Term)Expressions.truncate((String)"data", (int)10), NullOrder.NULLS_FIRST).build();
        SortOrder order5 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(11).desc("s.id", NullOrder.NULLS_LAST)).build();
        Assert.assertTrue((boolean)SortOrder.unsorted().satisfies(SortOrder.unsorted()));
        Assert.assertFalse((boolean)SortOrder.unsorted().satisfies(order1));
        Assert.assertFalse((boolean)SortOrder.unsorted().satisfies(order2));
        Assert.assertFalse((boolean)SortOrder.unsorted().satisfies(order3));
        Assert.assertFalse((boolean)SortOrder.unsorted().satisfies(order4));
        Assert.assertFalse((boolean)SortOrder.unsorted().satisfies(order5));
        Assert.assertTrue((boolean)order1.satisfies(SortOrder.unsorted()));
        Assert.assertTrue((boolean)order2.satisfies(SortOrder.unsorted()));
        Assert.assertTrue((boolean)order3.satisfies(SortOrder.unsorted()));
        Assert.assertTrue((boolean)order4.satisfies(SortOrder.unsorted()));
        Assert.assertTrue((boolean)order5.satisfies(SortOrder.unsorted()));
        Assert.assertFalse((boolean)order1.satisfies(order5));
        Assert.assertTrue((boolean)order2.satisfies(order1));
        Assert.assertFalse((boolean)order2.satisfies(order5));
        Assert.assertFalse((boolean)order2.satisfies(order3));
        Assert.assertFalse((boolean)order2.satisfies(order4));
        Assert.assertFalse((boolean)order1.satisfies(order2));
    }

    @Test
    public void testSatisfiesTruncateFieldOrder() {
        SortOrder id = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("data", NullOrder.NULLS_LAST)).build();
        SortOrder truncate4 = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.truncate((String)"data", (int)4), NullOrder.NULLS_LAST).build();
        SortOrder truncate2 = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.truncate((String)"data", (int)2), NullOrder.NULLS_LAST).build();
        Assert.assertTrue((boolean)id.satisfies(truncate2));
        Assert.assertTrue((boolean)id.satisfies(truncate4));
        Assert.assertFalse((boolean)truncate2.satisfies(id));
        Assert.assertFalse((boolean)truncate4.satisfies(id));
        Assert.assertTrue((boolean)truncate4.satisfies(truncate2));
        Assert.assertFalse((boolean)truncate2.satisfies(truncate4));
    }

    @Test
    public void testSatisfiesDateFieldOrder() {
        SortOrder id = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("d", NullOrder.NULLS_LAST)).build();
        SortOrder year = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.year((String)"d"), NullOrder.NULLS_LAST).build();
        SortOrder month = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.month((String)"d"), NullOrder.NULLS_LAST).build();
        SortOrder day = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.day((String)"d"), NullOrder.NULLS_LAST).build();
        Assert.assertTrue((boolean)id.satisfies(year));
        Assert.assertTrue((boolean)id.satisfies(month));
        Assert.assertTrue((boolean)id.satisfies(day));
        Assert.assertFalse((boolean)year.satisfies(id));
        Assert.assertFalse((boolean)month.satisfies(id));
        Assert.assertFalse((boolean)day.satisfies(id));
        Assert.assertTrue((boolean)day.satisfies(year));
        Assert.assertTrue((boolean)day.satisfies(month));
        Assert.assertTrue((boolean)month.satisfies(year));
        Assert.assertFalse((boolean)month.satisfies(day));
        Assert.assertFalse((boolean)year.satisfies(day));
        Assert.assertFalse((boolean)year.satisfies(month));
    }

    @Test
    public void testSatisfiesTimestampFieldOrder() {
        SortOrder id = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("ts", NullOrder.NULLS_LAST)).build();
        SortOrder year = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.year((String)"ts"), NullOrder.NULLS_LAST).build();
        SortOrder month = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.month((String)"ts"), NullOrder.NULLS_LAST).build();
        SortOrder day = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.day((String)"ts"), NullOrder.NULLS_LAST).build();
        SortOrder hour = SortOrder.builderFor((Schema)SCHEMA).asc((Term)Expressions.hour((String)"ts"), NullOrder.NULLS_LAST).build();
        Assert.assertTrue((boolean)id.satisfies(year));
        Assert.assertTrue((boolean)id.satisfies(month));
        Assert.assertTrue((boolean)id.satisfies(day));
        Assert.assertTrue((boolean)id.satisfies(hour));
        Assert.assertFalse((boolean)year.satisfies(id));
        Assert.assertFalse((boolean)month.satisfies(id));
        Assert.assertFalse((boolean)day.satisfies(id));
        Assert.assertFalse((boolean)hour.satisfies(id));
        Assert.assertTrue((boolean)hour.satisfies(year));
        Assert.assertTrue((boolean)hour.satisfies(month));
        Assert.assertTrue((boolean)hour.satisfies(day));
        Assert.assertTrue((boolean)day.satisfies(year));
        Assert.assertTrue((boolean)day.satisfies(month));
        Assert.assertFalse((boolean)day.satisfies(hour));
        Assert.assertTrue((boolean)month.satisfies(year));
        Assert.assertFalse((boolean)month.satisfies(day));
        Assert.assertFalse((boolean)month.satisfies(hour));
        Assert.assertFalse((boolean)year.satisfies(day));
        Assert.assertFalse((boolean)year.satisfies(month));
        Assert.assertFalse((boolean)year.satisfies(hour));
    }

    @Test
    public void testSameOrder() {
        SortOrder order1 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(9).asc("s.id", NullOrder.NULLS_LAST)).build();
        SortOrder order2 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("s.id", NullOrder.NULLS_LAST)).build();
        Assert.assertNotEquals((String)"Orders must not be equal", (Object)order1, (Object)order2);
        Assert.assertTrue((String)"Orders must be equivalent", (boolean)order1.sameOrder(order2));
        Assert.assertTrue((String)"Orders must be equivalent", (boolean)order2.sameOrder(order1));
    }

    @Test
    public void testSchemaEvolutionWithSortOrder() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("s.id")).desc((Term)Expressions.truncate((String)"data", (int)10))).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, order, this.formatVersion);
        table.updateSchema().renameColumn("s.id", "s.id2").commit();
        SortOrder actualOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)1L, (long)actualOrder.orderId());
        Assert.assertEquals((String)"Order must have 2 fields", (long)2L, (long)actualOrder.fields().size());
        Assert.assertEquals((String)"Field id must match", (long)8L, (long)((SortField)actualOrder.fields().get(0)).sourceId());
        Assert.assertEquals((String)"Field id must match", (long)2L, (long)((SortField)actualOrder.fields().get(1)).sourceId());
    }

    @Test
    public void testColumnDropWithSortOrder() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, this.formatVersion);
        int initialColSize = table.schema().columns().size();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("data")).commit();
        table.updateSchema().deleteColumn("id").commit();
        SortOrder actualOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)2L, (long)actualOrder.orderId());
        Assert.assertEquals((String)"Schema must have one less column", (long)(initialColSize - 1), (long)table.schema().columns().size());
        TableMetadataParser.fromJson((String)TableMetadataParser.toJson((TableMetadata)table.ops().current()));
    }

    @Test
    public void testIncompatibleSchemaEvolutionWithSortOrder() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("s.id")).desc((Term)Expressions.truncate((String)"data", (int)10))).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, order, this.formatVersion);
        AssertHelpers.assertThrows((String)"Should reject deletion of sort columns", ValidationException.class, (String)"Cannot find source column", () -> table.updateSchema().deleteColumn("s.id").commit());
    }

    @Test
    public void testEmptySortOrder() {
        SortOrder order = SortOrder.builderFor((Schema)SCHEMA).build();
        Assert.assertEquals((String)"Order must be unsorted", (Object)SortOrder.unsorted(), (Object)order);
    }

    @Test
    public void testSortedColumnNames() {
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("s.id")).desc((Term)Expressions.truncate((String)"data", (int)10))).build();
        Set sortedCols = SortOrderUtil.orderPreservingSortedColumns((SortOrder)order);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"s.id", (Object)"data"), (Object)sortedCols);
    }

    @Test
    public void testPreservingOrderSortedColumnNames() {
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc((Term)Expressions.bucket((String)"s.id", (int)5))).desc((Term)Expressions.truncate((String)"data", (int)10))).build();
        Set sortedCols = SortOrderUtil.orderPreservingSortedColumns((SortOrder)order);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"data"), (Object)sortedCols);
    }

    @Test
    public void testCaseSensitiveSortedColumnNames() {
        String fieldName = "ext1";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).caseSensitive(true).withOrderId(10).asc(fieldName)).build()).isInstanceOf(ValidationException.class)).hasMessageContaining(String.format("Cannot find field '%s' in struct", fieldName));
        SortOrder ext1 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).caseSensitive(false).withOrderId(10).asc("ext1")).build();
        SortField sortField = (SortField)ext1.fields().get(0);
        Assert.assertEquals((long)sortField.sourceId(), (long)SCHEMA.findField("Ext1").fieldId());
    }
}

