/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.TableTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSnapshotSummary
extends TableTestBase {
    public TestSnapshotSummary(int formatVersion) {
        super(formatVersion);
    }

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    @Test
    public void testFileSizeSummary() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Map summary = this.table.currentSnapshot().summary();
        Assert.assertEquals((Object)"10", summary.get("added-files-size"));
        Assert.assertNull(summary.get("removed-files-size"));
        Assert.assertEquals((Object)"10", summary.get("total-files-size"));
        this.table.newAppend().appendFile(FILE_B).commit();
        summary = this.table.currentSnapshot().summary();
        Assert.assertEquals((Object)"10", summary.get("added-files-size"));
        Assert.assertNull(summary.get("removed-files-size"));
        Assert.assertEquals((Object)"20", summary.get("total-files-size"));
        this.table.newOverwrite().deleteFile(FILE_A).deleteFile(FILE_B).addFile(FILE_C).addFile(FILE_D).addFile(FILE_D).commit();
        summary = this.table.currentSnapshot().summary();
        Assert.assertEquals((Object)"30", summary.get("added-files-size"));
        Assert.assertEquals((Object)"20", summary.get("removed-files-size"));
        Assert.assertEquals((Object)"30", summary.get("total-files-size"));
        this.table.newDelete().deleteFile(FILE_C).deleteFile(FILE_D).commit();
        summary = this.table.currentSnapshot().summary();
        Assert.assertNull(summary.get("added-files-size"));
        Assert.assertEquals((Object)"20", summary.get("removed-files-size"));
        Assert.assertEquals((Object)"10", summary.get("total-files-size"));
    }

    @Test
    public void testFileSizeSummaryWithDeletes() {
        if (this.formatVersion == 1) {
            return;
        }
        this.table.newRowDelta().addDeletes(FILE_A_DELETES).addDeletes(FILE_A2_DELETES).commit();
        this.table.refresh();
        Map summary = this.table.currentSnapshot().summary();
        Assert.assertEquals((Object)"1", summary.get("added-equality-delete-files"));
        Assert.assertEquals((Object)"1", summary.get("added-position-delete-files"));
    }
}

