/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSnapshotSelection
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSnapshotSelection(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testSnapshotSelectionById() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Table should have two snapshots", (long)2L, (long)Iterables.size((Iterable)this.table.snapshots()));
        this.validateSnapshot(null, this.table.snapshot(firstSnapshot.snapshotId()), FILE_A);
        this.validateSnapshot(firstSnapshot, this.table.snapshot(secondSnapshot.snapshotId()), FILE_B);
    }

    @Test
    public void testSnapshotStatsForAddedFiles() {
        DataFile fileWithStats = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-with-stats.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(10L).withMetrics(new Metrics(Long.valueOf(3L), null, (Map)ImmutableMap.of((Object)1, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)this.longToBuffer(20L)), (Map)ImmutableMap.of((Object)1, (Object)this.longToBuffer(22L)))).build();
        this.table.newFastAppend().appendFile(fileWithStats).commit();
        Snapshot snapshot = this.table.currentSnapshot();
        Iterable addedFiles = snapshot.addedDataFiles(this.table.io());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)addedFiles));
        DataFile dataFile = (DataFile)Iterables.getOnlyElement((Iterable)addedFiles);
        Assert.assertNotNull((String)"Value counts should be not null", (Object)dataFile.valueCounts());
        Assert.assertNotNull((String)"Null value counts should be not null", (Object)dataFile.nullValueCounts());
        Assert.assertNotNull((String)"Lower bounds should be not null", (Object)dataFile.lowerBounds());
        Assert.assertNotNull((String)"Upper bounds should be not null", (Object)dataFile.upperBounds());
    }

    private ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }
}

