/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotRefParser;
import org.junit.Assert;
import org.junit.Test;

public class TestSnapshotRefParser {
    @Test
    public void testTagToJsonDefault() {
        String json = "{\"snapshot-id\":1,\"type\":\"tag\"}";
        SnapshotRef ref = SnapshotRef.tagBuilder((long)1L).build();
        Assert.assertEquals((String)"Should be able to serialize default tag", (Object)json, (Object)SnapshotRefParser.toJson((SnapshotRef)ref));
    }

    @Test
    public void testTagToJsonAllFields() {
        String json = "{\"snapshot-id\":1,\"type\":\"tag\",\"max-ref-age-ms\":1}";
        SnapshotRef ref = SnapshotRef.tagBuilder((long)1L).maxRefAgeMs(Long.valueOf(1L)).build();
        Assert.assertEquals((String)"Should be able to serialize tag with all fields", (Object)json, (Object)SnapshotRefParser.toJson((SnapshotRef)ref));
    }

    @Test
    public void testBranchToJsonDefault() {
        String json = "{\"snapshot-id\":1,\"type\":\"branch\"}";
        SnapshotRef ref = SnapshotRef.branchBuilder((long)1L).build();
        Assert.assertEquals((String)"Should be able to serialize default branch", (Object)json, (Object)SnapshotRefParser.toJson((SnapshotRef)ref));
    }

    @Test
    public void testBranchToJsonAllFields() {
        String json = "{\"snapshot-id\":1,\"type\":\"branch\",\"min-snapshots-to-keep\":2,\"max-snapshot-age-ms\":3,\"max-ref-age-ms\":4}";
        SnapshotRef ref = SnapshotRef.branchBuilder((long)1L).minSnapshotsToKeep(Integer.valueOf(2)).maxSnapshotAgeMs(Long.valueOf(3L)).maxRefAgeMs(Long.valueOf(4L)).build();
        Assert.assertEquals((String)"Should be able to serialize branch with all fields", (Object)json, (Object)SnapshotRefParser.toJson((SnapshotRef)ref));
    }

    @Test
    public void testTagFromJsonDefault() {
        String json = "{\"snapshot-id\":1,\"type\":\"tag\"}";
        SnapshotRef ref = SnapshotRef.tagBuilder((long)1L).build();
        Assert.assertEquals((String)"Should be able to deserialize default tag", (Object)ref, (Object)SnapshotRefParser.fromJson((String)json));
    }

    @Test
    public void testTagFromJsonAllFields() {
        String json = "{\"snapshot-id\":1,\"type\":\"tag\",\"max-ref-age-ms\":1}";
        SnapshotRef ref = SnapshotRef.tagBuilder((long)1L).maxRefAgeMs(Long.valueOf(1L)).build();
        Assert.assertEquals((String)"Should be able to deserialize tag with all fields", (Object)ref, (Object)SnapshotRefParser.fromJson((String)json));
    }

    @Test
    public void testBranchFromJsonDefault() {
        String json = "{\"snapshot-id\":1,\"type\":\"branch\"}";
        SnapshotRef ref = SnapshotRef.branchBuilder((long)1L).build();
        Assert.assertEquals((String)"Should be able to deserialize default branch", (Object)ref, (Object)SnapshotRefParser.fromJson((String)json));
    }

    @Test
    public void testBranchFromJsonAllFields() {
        String json = "{\"snapshot-id\":1,\"type\":\"branch\",\"min-snapshots-to-keep\":2,\"max-snapshot-age-ms\":3,\"max-ref-age-ms\":4}";
        SnapshotRef ref = SnapshotRef.branchBuilder((long)1L).minSnapshotsToKeep(Integer.valueOf(2)).maxSnapshotAgeMs(Long.valueOf(3L)).maxRefAgeMs(Long.valueOf(4L)).build();
        Assert.assertEquals((String)"Should be able to deserialize branch with all fields", (Object)ref, (Object)SnapshotRefParser.fromJson((String)json));
    }

    @Test
    public void testFailParsingWhenNullOrEmptyJson() {
        String nullJson = null;
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize null JSON string", IllegalArgumentException.class, (String)"Cannot parse snapshot ref from invalid JSON", () -> SnapshotRefParser.fromJson((String)nullJson));
        String emptyJson = "";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize empty JSON string", IllegalArgumentException.class, (String)"Cannot parse snapshot ref from invalid JSON", () -> SnapshotRefParser.fromJson((String)emptyJson));
    }

    @Test
    public void testFailParsingWhenMissingRequiredFields() {
        String refMissingType = "{\"snapshot-id\":1}";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize ref with missing type", IllegalArgumentException.class, (String)"Cannot parse missing string", () -> SnapshotRefParser.fromJson((String)refMissingType));
        String refMissingSnapshotId = "{\"type\":\"branch\"}";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize ref with missing snapshot id", IllegalArgumentException.class, (String)"Cannot parse missing long", () -> SnapshotRefParser.fromJson((String)refMissingSnapshotId));
    }

    @Test
    public void testFailWhenFieldsHaveInvalidValues() {
        String invalidSnapshotId = "{\"snapshot-id\":\"invalid-snapshot-id\",\"type\":\"not-a-valid-tag-type\"}";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize ref with invalid snapshot id", IllegalArgumentException.class, (String)"Cannot parse to a long value: snapshot-id: \"invalid-snapshot-id\"", () -> SnapshotRefParser.fromJson((String)invalidSnapshotId));
        String invalidTagType = "{\"snapshot-id\":1,\"type\":\"not-a-valid-tag-type\"}";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize ref with invalid tag", IllegalArgumentException.class, (String)"Invalid snapshot ref type: not-a-valid-tag-type", () -> SnapshotRefParser.fromJson((String)invalidTagType));
        String invalidRefAge = "{\"snapshot-id\":1,\"type\":\"tag\",\"max-ref-age-ms\":\"not-a-valid-value\"}";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize ref with invalid ref age", IllegalArgumentException.class, (String)"Cannot parse to a long value: max-ref-age-ms: \"not-a-valid-value\"", () -> SnapshotRefParser.fromJson((String)invalidRefAge));
        String invalidSnapshotsToKeep = "{\"snapshot-id\":1,\"type\":\"branch\", \"min-snapshots-to-keep\":\"invalid-number\"}";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize ref with missing snapshot id", IllegalArgumentException.class, (String)"Cannot parse to an integer value: min-snapshots-to-keep: \"invalid-number\"", () -> SnapshotRefParser.fromJson((String)invalidSnapshotsToKeep));
        String invalidMaxSnapshotAge = "{\"snapshot-id\":1,\"type\":\"branch\", \"max-snapshot-age-ms\":\"invalid-age\"}";
        AssertHelpers.assertThrows((String)"SnapshotRefParser should fail to deserialize ref with missing snapshot id", IllegalArgumentException.class, (String)"Cannot parse to a long value: max-snapshot-age-ms: \"invalid-age\"", () -> SnapshotRefParser.fromJson((String)invalidMaxSnapshotAge));
    }
}

